/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.IOException;
import net.jangaroo.jooc.AnalyzeContext;
import net.jangaroo.jooc.AstNode;
import net.jangaroo.jooc.Expr;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.KeywordStatement;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.Statement;

class IfStatement
extends KeywordStatement {
    Expr cond;
    Statement ifTrue;
    JooSymbol symElse;
    Statement ifFalse;

    public IfStatement(JooSymbol symIf, Expr cond, Statement ifTrue) {
        this(symIf, cond, ifTrue, null, null);
    }

    public IfStatement(JooSymbol symIf, Expr cond, Statement ifTrue, JooSymbol symElse, Statement ifFalse) {
        super(symIf);
        this.cond = cond;
        this.ifTrue = ifTrue;
        this.symElse = symElse;
        this.ifFalse = ifFalse;
    }

    public void scope(Scope scope) {
        this.cond.scope(scope);
        this.ifTrue.scope(scope);
        if (this.ifFalse != null) {
            this.ifFalse.scope(scope);
        }
    }

    public AstNode analyze(AstNode parentNode, AnalyzeContext context) {
        super.analyze(parentNode, context);
        this.cond = this.cond.analyze(this, context);
        this.ifTrue.analyze(this, context);
        if (this.ifFalse != null) {
            this.ifFalse.analyze(this, context);
        }
        return this;
    }

    protected void generateJsCode(JsWriter out) throws IOException {
        super.generateJsCode(out);
        this.cond.generateCode(out);
        this.ifTrue.generateCode(out);
        if (this.symElse != null) {
            out.writeSymbol(this.symElse);
            this.ifFalse.generateCode(out);
        }
    }
}

