/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.IOException;
import net.jangaroo.jooc.AnalyzeContext;
import net.jangaroo.jooc.AstNode;
import net.jangaroo.jooc.Expr;
import net.jangaroo.jooc.Ide;
import net.jangaroo.jooc.IdeDeclaration;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.PostfixOpExpr;
import net.jangaroo.jooc.Scope;

class DotExpr
extends PostfixOpExpr {
    Ide ide;

    public DotExpr(Expr expr, JooSymbol symDot, Ide ide) {
        super(symDot, expr);
        this.ide = ide;
    }

    public Ide getIde() {
        return this.ide;
    }

    public void scope(Scope scope) {
        super.scope(scope);
        this.ide.scope(scope);
    }

    public Expr analyze(AstNode parentNode, AnalyzeContext context) {
        super.analyze(parentNode, context);
        IdeDeclaration qualiferType = this.arg.getType();
        if (qualiferType != null) {
            IdeDeclaration memberDeclaration = this.arg.getType().resolvePropertyDeclaration(this.ide.getName());
            if (memberDeclaration != null && memberDeclaration.isStatic()) {
                throw Jooc.error(this.ide.ide, "static member used in dynamic context");
            }
            this.setType(memberDeclaration);
        }
        return this;
    }

    protected void generateJsCode(JsWriter out) throws IOException {
        this.arg.generateCode(out);
        Ide.writeMemberAccess(Ide.resolveMember(this.arg.getType(), this.ide), this.op, this.ide, true, out);
    }

    public /* synthetic */ AstNode analyze(AstNode x0, AnalyzeContext x1) {
        return this.analyze(x0, x1);
    }
}

