/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java_cup.runtime.Symbol;
import net.jangaroo.jooc.AnalyzeContext;
import net.jangaroo.jooc.AstNode;
import net.jangaroo.jooc.CompilationUnit;
import net.jangaroo.jooc.CompileLog;
import net.jangaroo.jooc.DeclarationScope;
import net.jangaroo.jooc.Ide;
import net.jangaroo.jooc.IdeDeclaration;
import net.jangaroo.jooc.ImportDirective;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.PredefinedTypeDeclaration;
import net.jangaroo.jooc.Scanner;
import net.jangaroo.jooc.ScannerBase;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.StdOutCompileLog;
import net.jangaroo.jooc.VariableDeclaration;
import net.jangaroo.jooc.backend.AbstractCompilationUnitSinkFactory;
import net.jangaroo.jooc.backend.CompilationUnitSinkFactory;
import net.jangaroo.jooc.backend.MergedOutputCompilationUnitSinkFactory;
import net.jangaroo.jooc.backend.SingleFileCompilationUnitSinkFactory;
import net.jangaroo.jooc.config.JoocCommandLineParser;
import net.jangaroo.jooc.config.JoocConfiguration;
import net.jangaroo.jooc.input.FileInputSource;
import net.jangaroo.jooc.input.InputSource;
import net.jangaroo.jooc.input.PathInputSource;
import net.jangaroo.jooc.parser;
import net.jangaroo.utils.BOMStripperInputStream;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jooc {
    private static final String COMPILER_VERSION_KEY = "jooc.compiler.version";
    private final String RUNTIME_VERSION_KEY = "jooc.runtime.version";
    static final String JOO_API_IN_JAR_DIRECTORY_PREFIX = "META-INF/joo-api/";
    public static final int RESULT_CODE_OK = 0;
    public static final int RESULT_CODE_COMPILATION_FAILED = 1;
    public static final int RESULT_CODE_INTERNAL_COMPILER_ERROR = 2;
    public static final int RESULT_CODE_UNRECOGNIZED_OPTION = 3;
    public static final int RESULT_CODE_MISSING_OPTION_ARGUMENT = 4;
    public static final String AS_SUFFIX_NO_DOT = "as";
    public static final String AS_SUFFIX = ".as";
    public static final String INPUT_FILE_SUFFIX = ".as";
    public static final String OUTPUT_FILE_SUFFIX = ".js";
    public static final String CLASS_LOADER_NAME = "classLoader";
    public static final String CLASS_LOADER_PACKAGE_NAME = "joo";
    public static final String CLASS_LOADER_FULLY_QUALIFIED_NAME = "joo.classLoader";
    private JoocConfiguration config;
    private static ThreadLocal<CompileLog> logHolder;
    private CompileLog log;
    private List<File> canoncicalSourcePath = new ArrayList<File>();
    private List<CompilationUnit> compileQueue = new ArrayList<CompilationUnit>();
    private Map<String, CompilationUnit> compilationUnitsByQName = new LinkedHashMap<String, CompilationUnit>();
    private InputSource sourcePathInputSource;
    private InputSource classPathInputSource;
    private final Scope globalScope = new DeclarationScope(null, null);
    private final IdeDeclaration voidDeclaration = Jooc.declareType(this.globalScope, "void");
    private final IdeDeclaration anyDeclaration = Jooc.declareType(this.globalScope, "*");
    private ResourceBundle joocProperties;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$net$jangaroo$jooc$Jooc;

    public Jooc() {
        this(new StdOutCompileLog());
    }

    public Jooc(CompileLog log) {
        this.log = log;
        this.joocProperties = ResourceBundle.getBundle("net.jangaroo.jooc.jooc");
        if (!$assertionsDisabled && this.joocProperties == null) {
            throw new AssertionError();
        }
    }

    public IdeDeclaration getAnyDeclaration() {
        return this.anyDeclaration;
    }

    public IdeDeclaration getVoidDeclaration() {
        return this.voidDeclaration;
    }

    public int run(JoocConfiguration config) {
        try {
            return this.run1(config);
        }
        catch (CompilerError e) {
            if (e.symbol != null) {
                this.log.error(e.symbol, e.getMessage());
            } else {
                this.log.error(e.getMessage());
            }
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 2;
        }
    }

    private int run1(JoocConfiguration config) {
        logHolder.set(this.log);
        this.config = config;
        this.buildGlobalScope();
        for (File sourceDir : config.getSourcePath()) {
            try {
                this.canoncicalSourcePath.add(sourceDir.getCanonicalFile());
            }
            catch (IOException e) {
                throw new CompilerError(new StringBuffer().append("Cannot canonicalize source path dir: ").append(sourceDir.getAbsolutePath()).toString());
            }
        }
        try {
            this.sourcePathInputSource = PathInputSource.fromFiles(this.canoncicalSourcePath, new String[]{""});
            this.classPathInputSource = PathInputSource.fromFiles(config.getClassPath(), new String[]{"", JOO_API_IN_JAR_DIRECTORY_PREFIX});
            for (File sourceFile : config.getSourceFiles()) {
                this.processSource(sourceFile);
            }
            CompilationUnitSinkFactory codeSinkFactory = this.createSinkFactory(config, false);
            CompilationUnitSinkFactory apiSinkFactory = null;
            if (config.isGenerateApi()) {
                apiSinkFactory = this.createSinkFactory(config, true);
            }
            for (CompilationUnit unit : this.compileQueue) {
                unit.analyze(null, new AnalyzeContext(config));
                unit.writeOutput(codeSinkFactory, config.isVerbose());
                if (!config.isGenerateApi()) continue;
                unit.writeOutput(apiSinkFactory, config.isVerbose());
            }
        }
        catch (IOException e) {
            throw new CompilerError("IO Exception occurred", e);
        }
        int result = this.log.hasErrors() ? 1 : 0;
        logHolder.remove();
        return result;
    }

    private void buildGlobalScope() {
        Jooc.declareValues(this.globalScope, new String[]{"this"});
    }

    private static IdeDeclaration declareType(Scope scope, String identifier) {
        PredefinedTypeDeclaration decl = new PredefinedTypeDeclaration(identifier);
        decl.scope(scope);
        return decl;
    }

    private static void declareValues(Scope scope, String[] identifiers) {
        for (String identifier : identifiers) {
            Ide ide = new Ide(new JooSymbol(identifier));
            VariableDeclaration decl = new VariableDeclaration(new JooSymbol("var"), ide, null, null);
            ((IdeDeclaration)decl).scope(scope);
        }
    }

    private CompilationUnitSinkFactory createSinkFactory(JoocConfiguration config, boolean generateActionScriptApi) {
        AbstractCompilationUnitSinkFactory codeSinkFactory;
        if (!generateActionScriptApi && config.isMergeOutput()) {
            codeSinkFactory = new MergedOutputCompilationUnitSinkFactory(config, config.getOutputFile());
        } else {
            File outputDirectory = generateActionScriptApi ? config.getApiOutputDirectory() : config.getOutputDirectory();
            String suffix = generateActionScriptApi ? ".as" : OUTPUT_FILE_SUFFIX;
            codeSinkFactory = new SingleFileCompilationUnitSinkFactory(config, outputDirectory, generateActionScriptApi, suffix);
        }
        return codeSinkFactory;
    }

    public String getVersion() {
        return this.joocProperties.getString(COMPILER_VERSION_KEY);
    }

    public String getRuntimeVersion() {
        return this.joocProperties.getString("jooc.runtime.version");
    }

    public static String getResultCodeDescription(int resultCode) {
        switch (resultCode) {
            case 0: {
                return "ok";
            }
            case 1: {
                return "compilation failed";
            }
            case 2: {
                return "internal compiler error";
            }
            case 3: {
                return "unrecognized option";
            }
            case 4: {
                return "missing option argument";
            }
        }
        return "unknown result code";
    }

    public static CompilerError error(String msg) {
        return new CompilerError(msg);
    }

    static CompilerError error(JooSymbol symbol, String msg) {
        return new CompilerError(symbol, msg);
    }

    public static CompilerError error(AstNode node, String msg) {
        return Jooc.error(node.getSymbol(), msg);
    }

    public static CompilerError error(String msg, Throwable t) {
        return new CompilerError(msg, t);
    }

    public static void warning(JooSymbol symbol, String msg) {
        logHolder.get().warning(symbol, msg);
    }

    public static void warning(String msg) {
        logHolder.get().warning(msg);
    }

    protected CompilationUnit importSource(InputSource source) {
        CompilationUnit unit = this.parse(source);
        if (unit != null) {
            unit.scope(this.globalScope);
            String prefix = unit.getPackageDeclaration().getQualifiedNameStr();
            if (!prefix.isEmpty()) {
                prefix = new StringBuffer().append(prefix).append(".").toString();
            }
            String qname = new StringBuffer().append(prefix).append(unit.getPrimaryDeclaration().getIde().getName()).toString();
            this.checkValidFileName(qname, unit, source);
            this.compilationUnitsByQName.put(qname, unit);
        }
        return unit;
    }

    private String buildSourceFileName(InputSource inputSource, String qname) {
        return new StringBuffer().append(qname.replace('.', inputSource.getFileSeparatorChar())).append(".as").toString();
    }

    private File findSourceDir(File file) throws IOException {
        File canonicalFile = file.getCanonicalFile();
        for (File sourceDir : this.canoncicalSourcePath) {
            if (!this.isParent(sourceDir, canonicalFile)) continue;
            return sourceDir;
        }
        return null;
    }

    private boolean isParent(File dir, File file) throws IOException {
        for (File parent = file.getParentFile(); parent != null; parent = parent.getParentFile()) {
            if (!parent.equals(dir)) continue;
            return true;
        }
        return false;
    }

    protected void processSource(File file) throws IOException {
        if (file.isDirectory()) {
            throw Jooc.error(new StringBuffer().append("Input file is a directory: ").append(file.getAbsolutePath()).toString());
        }
        CompilationUnit unit = this.importSource(new FileInputSource(this.findSourceDir(file), file));
        if (unit != null) {
            this.compileQueue.add(unit);
        }
    }

    public IdeDeclaration resolveImport(ImportDirective importDirective) {
        String qname = importDirective.getQualifiedName();
        CompilationUnit compilationUnit = this.compilationUnitsByQName.get(qname);
        if (compilationUnit == null) {
            InputSource source = this.findSource(qname);
            if (source == null) {
                throw Jooc.error(importDirective.getSymbol(), new StringBuffer().append("cannot find source for ").append(qname).toString());
            }
            compilationUnit = this.importSource(source);
        }
        if (compilationUnit == null) {
            throw Jooc.error(new StringBuffer().append("unable to resolve import of ").append(qname).toString());
        }
        return compilationUnit.getPrimaryDeclaration();
    }

    private InputSource findSource(String qname) {
        InputSource result = this.sourcePathInputSource.getChild(this.getInputSourceFileName(qname, this.sourcePathInputSource, ".as"));
        if (result == null) {
            result = this.classPathInputSource.getChild(this.getInputSourceFileName(qname, this.classPathInputSource, ".as"));
        }
        return result;
    }

    private String getInputSourceFileName(String qname, InputSource is, String extension) {
        return new StringBuffer().append(qname.replace('.', is.getFileSeparatorChar())).append(extension).toString();
    }

    private void checkValidFileName(String qname, CompilationUnit unit, InputSource source) {
        String expectedPath;
        String path = source.getRelativePath();
        if (path != null && !(expectedPath = this.buildSourceFileName(source, qname)).equals(path)) {
            Jooc.warning(unit.getSymbol(), String.format("expected '%s' as the file name for %s, found: '%s'. -sourcepath not set (correctly)?", expectedPath, qname, path));
        }
    }

    public List<String> getPackageIdes(String packageName) {
        ArrayList<String> result = new ArrayList<String>(10);
        this.addPackageFolderSymbols(result, packageName, this.sourcePathInputSource);
        this.addPackageFolderSymbols(result, packageName, this.classPathInputSource);
        return result;
    }

    private void addPackageFolderSymbols(List<String> result, String packageName, InputSource path) {
        this.addPackageFolderSymbols(path.getChild(this.getInputSourceFileName(packageName, path, "")), result);
    }

    private void addPackageFolderSymbols(InputSource folder, List<String> list) {
        if (folder != null) {
            List<InputSource> childList = folder.list();
            for (InputSource child : childList) {
                if (child.isDirectory() || !child.getName().endsWith(".as")) continue;
                list.add(Jooc.nameWithoutExtension(child));
            }
        }
    }

    private static String nameWithoutExtension(InputSource input) {
        String name = input.getName();
        int lastDot = name.lastIndexOf(46);
        return lastDot >= 0 ? name.substring(0, lastDot) : name;
    }

    public JoocConfiguration getConfig() {
        return this.config;
    }

    protected CompilationUnit parse(InputSource in) {
        Scanner s;
        if (!in.getName().endsWith(".as")) {
            throw Jooc.error(new StringBuffer().append("Input file must end with '.as': ").append(in.getName()).toString());
        }
        if (this.config.isVerbose()) {
            System.out.println(new StringBuffer().append("Parsing ").append(in.getPath()).toString());
        }
        try {
            s = new Scanner(new InputStreamReader((InputStream)new BOMStripperInputStream(in.getInputStream()), "UTF-8"));
        }
        catch (IOException e) {
            throw new CompilerError(new StringBuffer().append("Cannot read input file: ").append(in.getPath()).toString());
        }
        s.setInputSource(in);
        parser p = new parser(s);
        p.setCompileLog(this.log);
        p.setSemicolonInsertionMode(this.config.getSemicolonInsertionMode());
        try {
            Symbol tree = p.parse();
            CompilationUnit unit = (CompilationUnit)tree.value;
            unit.setCompiler(this);
            unit.setSource(in);
            return unit;
        }
        catch (ScannerBase.ScanError se) {
            this.log.error(se.sym, se.getMessage());
            return null;
        }
        catch (parser.FatalSyntaxError e) {
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void printVersion() {
        String pkgName = "net.jangaroo.jooc";
        Package pkg = Package.getPackage(pkgName);
        String specTitle = pkg.getSpecificationTitle();
        if (specTitle == null) {
            System.out.println(new StringBuffer().append("cannot retrieve package version information for ").append(pkgName).toString());
            return;
        }
        String specVendor = pkg.getSpecificationVendor();
        String specVersion = pkg.getSpecificationVersion();
        String implTitle = pkg.getImplementationTitle();
        String implVersion = pkg.getImplementationVersion();
        System.out.println(new StringBuffer().append(specTitle).append(" version ").append(specVersion).toString());
        System.out.println(new StringBuffer().append(implTitle).append(" (build ").append(implVersion).append(")").toString());
        System.out.println(specVendor);
    }

    public int run(String[] argv) {
        block3: {
            try {
                JoocCommandLineParser commandLineParser = new JoocCommandLineParser();
                this.config = commandLineParser.parse(argv);
                if (this.config == null) break block3;
                if (this.config.isVersion()) {
                    this.printVersion();
                    break block3;
                }
                return this.run(this.config);
            }
            catch (JoocCommandLineParser.CommandLineParseException e) {
                System.out.println(e.getMessage());
                return e.getExitCode();
            }
        }
        return 0;
    }

    public static void main(String[] argv) {
        Jooc compiler = new Jooc();
        int result = compiler.run(argv);
        if (result != 0) {
            System.exit(result);
        }
    }

    static {
        Class<?> clazz = class$net$jangaroo$jooc$Jooc;
        if (clazz == null) {
            clazz = class$net$jangaroo$jooc$Jooc = new Jooc[0].getClass().getComponentType();
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        logHolder = new ThreadLocal();
    }

    static class CompilerError
    extends RuntimeException {
        private JooSymbol symbol = null;

        CompilerError(String msg) {
            super(msg);
        }

        CompilerError(String msg, Throwable rootCause) {
            super(msg, rootCause);
        }

        CompilerError(JooSymbol symbol, String msg) {
            super(msg);
            this.symbol = symbol;
        }
    }
}

