/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.IOException;
import net.jangaroo.jooc.AnalyzeContext;
import net.jangaroo.jooc.AstNode;
import net.jangaroo.jooc.BlockStatement;
import net.jangaroo.jooc.ClassDeclaration;
import net.jangaroo.jooc.CodeGenerator;
import net.jangaroo.jooc.FunctionExpr;
import net.jangaroo.jooc.GetterSetterPair;
import net.jangaroo.jooc.Ide;
import net.jangaroo.jooc.IdeDeclaration;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.NodeImplBase;
import net.jangaroo.jooc.Parameter;
import net.jangaroo.jooc.Parameters;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.Statement;
import net.jangaroo.jooc.Type;
import net.jangaroo.jooc.TypeRelation;
import net.jangaroo.jooc.TypedIdeDeclaration;

public class FunctionDeclaration
extends TypedIdeDeclaration {
    private JooSymbol symFunction;
    private JooSymbol symGetOrSet;
    private JooSymbol lParen;
    private Parameters params;
    private JooSymbol rParen;
    private Statement optBody;
    boolean isConstructor = false;
    boolean isClassMember = false;
    boolean containsSuperConstructorCall = false;
    private static final int defaultAllowedMethodModifers = 3839;

    public Parameters getParams() {
        return this.params;
    }

    public FunctionDeclaration(JooSymbol[] modifiers, JooSymbol symFunction, Ide ide, JooSymbol lParen, Parameters params, JooSymbol rParen, TypeRelation optTypeRelation, Statement optBody) {
        this(modifiers, symFunction, null, ide, lParen, params, rParen, optTypeRelation, optBody);
    }

    public FunctionDeclaration(JooSymbol[] modifiers, JooSymbol symFunction, JooSymbol symGetOrSet, Ide ide, JooSymbol lParen, Parameters params, JooSymbol rParen, TypeRelation optTypeRelation, Statement optBody) {
        super(modifiers, 3839, ide, optTypeRelation);
        this.symFunction = symFunction;
        this.symGetOrSet = symGetOrSet;
        if (this.isGetterOrSetter() && !this.isGetter() && !this.isSetter()) {
            throw Jooc.error(symGetOrSet, "Expected 'get' or 'set'.");
        }
        this.lParen = lParen;
        this.params = params;
        this.rParen = rParen;
        this.optBody = optBody;
    }

    public boolean isClassMember() {
        return this.isClassMember;
    }

    public void setIsClassMember(boolean classMember) {
        this.isClassMember = classMember;
    }

    public boolean overrides() {
        return (this.getModifiers() & 0x80) != 0;
    }

    public boolean isMethod() {
        return this.isClassMember();
    }

    public boolean isGetterOrSetter() {
        return this.symGetOrSet != null;
    }

    public boolean isGetter() {
        return this.isGetterOrSetter() && "get".equals(this.symGetOrSet.getText());
    }

    public boolean isSetter() {
        return this.isGetterOrSetter() && "set".equals(this.symGetOrSet.getText());
    }

    public final boolean isConstructor() {
        return this.isConstructor;
    }

    public boolean containsSuperConstructorCall() {
        return this.containsSuperConstructorCall;
    }

    public void setContainsSuperConstructorCall(boolean containsSuperConstructorCallStatement) {
        this.containsSuperConstructorCall = containsSuperConstructorCallStatement;
    }

    public boolean isAbstract() {
        return this.classDeclaration != null && this.classDeclaration.isInterface() || super.isAbstract();
    }

    public Statement getBody() {
        return this.optBody;
    }

    public void scope(Scope scope) {
        final ClassDeclaration classDeclaration = scope.getClassDeclaration();
        Ide oldIde = this.ide;
        if (classDeclaration != null && this.ide.getName().equals(classDeclaration.getName())) {
            this.isConstructor = true;
            classDeclaration.setConstructor(this);
            this.allowedModifiers = 1551;
            this.computeModifiers();
            this.ide = null;
        }
        super.scope(scope);
        this.ide = oldIde;
        if (this.overrides() && this.isAbstract()) {
            throw Jooc.error(this, "overriding methods are not allowed to be declared abstract");
        }
        if (this.isAbstract()) {
            if (classDeclaration == null) {
                throw Jooc.error(this, "package-scoped function " + this.getName() + " must not be abstract.");
            }
            if (!classDeclaration.isAbstract()) {
                throw Jooc.error(this, classDeclaration.getName() + "is not declared abstract");
            }
            if (this.optBody instanceof BlockStatement) {
                throw Jooc.error(this, "abstract method must not be implemented");
            }
        }
        if (this.isNative() && this.optBody instanceof BlockStatement) {
            throw Jooc.error(this, "native method must not be implemented");
        }
        if (!(this.isAbstract() || this.isNative() || this.optBody instanceof BlockStatement)) {
            throw Jooc.error(this, "method must either be implemented or declared abstract or native");
        }
        this.withNewDeclarationScope(this, scope, new NodeImplBase.Scoped(){

            public void run(Scope scope) {
                if (!FunctionDeclaration.this.isStatic()) {
                    ClassDeclaration currentClass = scope.getClassDeclaration();
                    if (classDeclaration != null) {
                        Type thisType = currentClass.getThisType();
                        new Parameter(null, new Ide("this"), new TypeRelation(null, thisType), null).scope(scope);
                        Type superType = currentClass.getSuperType();
                        if (superType != null) {
                            new Parameter(null, new Ide("super"), new TypeRelation(null, superType), null).scope(scope);
                        }
                    }
                }
                new Parameter(null, FunctionExpr.ARGUMENTS_IDE, null, null).scope(scope);
                FunctionDeclaration.this.withNewDeclarationScope(FunctionDeclaration.this, scope, new NodeImplBase.Scoped(){

                    public void run(Scope scope) {
                        if (FunctionDeclaration.this.params != null) {
                            FunctionDeclaration.this.params.scope(scope);
                        }
                        if (FunctionDeclaration.this.optTypeRelation != null) {
                            FunctionDeclaration.this.optTypeRelation.scope(scope);
                        }
                        if (FunctionDeclaration.this.optBody != null) {
                            FunctionDeclaration.this.optBody.scope(scope);
                        }
                    }
                });
            }
        });
        if (this.containsSuperConstructorCall()) {
            BlockStatement block = (BlockStatement)this.optBody;
            block.checkSuperConstructorCall();
        }
    }

    public AstNode analyze(AstNode parentNode, AnalyzeContext context) {
        super.analyze(parentNode, context);
        if (this.params != null) {
            this.params.analyze(this, context);
        }
        if (this.optTypeRelation != null) {
            this.optTypeRelation.analyze(this, context);
        }
        if (this.optBody != null) {
            this.optBody.analyze(this, context);
        }
        return this;
    }

    void handleDuplicateDeclaration(Scope scope, AstNode oldNode) {
        FunctionDeclaration other;
        if (this.isGetterOrSetter() && oldNode instanceof FunctionDeclaration && (other = (FunctionDeclaration)oldNode).isGetterOrSetter() && this.isGetter() != other.isGetter()) {
            GetterSetterPair setterPair = new GetterSetterPair(this.isGetter() ? this : other, this.isSetter() ? this : other);
            setterPair.scope(scope);
            return;
        }
        super.handleDuplicateDeclaration(scope, oldNode);
    }

    protected void generateAsApiCode(JsWriter out) throws IOException {
        if (!this.isPrivate()) {
            this.writeModifiers(out);
            if (!this.isNative()) {
                out.writeSymbolWhitespace(this.symFunction);
                out.writeToken("native");
                out.writeSymbol(this.symFunction, false);
            } else {
                out.writeSymbol(this.symFunction);
            }
            if (this.symGetOrSet != null) {
                out.writeSymbol(this.symGetOrSet);
            }
            this.ide.generateCode(out);
            out.writeSymbol(this.lParen);
            if (this.params != null) {
                this.params.generateCode(out);
            }
            out.writeSymbol(this.rParen);
            if (this.optTypeRelation != null) {
                this.optTypeRelation.generateCode(out);
            }
            out.writeToken(";");
        }
    }

    protected void generateJsCode(JsWriter out) throws IOException {
        boolean isAbstract = this.isAbstract();
        if (isAbstract) {
            out.beginComment();
            this.writeModifiers(out);
            out.writeSymbol(this.symFunction);
            this.ide.generateCode(out);
        } else {
            out.beginString();
            this.writeModifiers(out);
            out.writeSymbol(this.symFunction);
            if (this.isGetterOrSetter()) {
                out.writeSymbol(this.symGetOrSet);
            }
            this.ide.generateCode(out);
            out.endString();
            if (this.isNative()) {
                out.beginComment();
            } else {
                out.write(",");
                out.writeToken("function");
                if (out.getKeepSource()) {
                    String methodName = this.ide.getName();
                    if (this.isConstructor) {
                        out.writeToken(methodName + "$");
                    } else if (this.symGetOrSet != null) {
                        out.writeToken(methodName + "$" + this.symGetOrSet.getText());
                    } else {
                        out.writeToken(methodName);
                    }
                }
            }
        }
        out.writeSymbol(this.lParen);
        if (this.params != null) {
            this.params.generateCode(out);
            if (this.optBody instanceof BlockStatement) {
                ((BlockStatement)this.optBody).addBlockStartCodeGenerator(this.params.getParameterInitializerCodeGenerator());
            }
        }
        out.writeSymbol(this.rParen);
        if (this.optTypeRelation != null) {
            this.optTypeRelation.generateCode(out);
        }
        if (this.isConstructor && !this.containsSuperConstructorCall() && this.optBody instanceof BlockStatement) {
            ((BlockStatement)this.optBody).addBlockStartCodeGenerator(new SuperCallCodeGenerator(this.classDeclaration));
        }
        if (this.optBody != null) {
            this.optBody.generateCode(out);
        }
        if (this.isAbstract() || this.isNative()) {
            out.endComment();
        }
        out.write(44);
    }

    public IdeDeclaration resolveDeclaration() {
        return this.isConstructor() ? this.getClassDeclaration() : super.resolveDeclaration();
    }

    private static class SuperCallCodeGenerator
    implements CodeGenerator {
        private ClassDeclaration classDeclaration;

        public SuperCallCodeGenerator(ClassDeclaration classDeclaration) {
            this.classDeclaration = classDeclaration;
        }

        public void generateCode(JsWriter out) throws IOException {
            out.writeToken("this.super$" + this.classDeclaration.getInheritanceLevel() + "()");
            this.classDeclaration.generateFieldInitCode(out);
            out.writeToken(";");
        }
    }
}

