/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.jangaroo.jooc.AbstractVariableDeclaration;
import net.jangaroo.jooc.AnalyzeContext;
import net.jangaroo.jooc.AstNode;
import net.jangaroo.jooc.Debug;
import net.jangaroo.jooc.Ide;
import net.jangaroo.jooc.IdeDeclaration;
import net.jangaroo.jooc.Initializer;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.TypeRelation;

public class FieldDeclaration
extends AbstractVariableDeclaration {
    private boolean isClassMember = false;
    private static final Map<String, String> DEFAULT_VALUE_BY_TYPE = new HashMap<String, String>(10);

    public FieldDeclaration(JooSymbol[] modifiers, JooSymbol symConstOrVar, Ide ide, TypeRelation optTypeRelation, Initializer optInitializer, FieldDeclaration optNextFieldDeclaration, JooSymbol optSymSemicolon) {
        super(modifiers, 543, symConstOrVar, ide, optTypeRelation, optInitializer, optNextFieldDeclaration, optSymSemicolon);
        if (optSymSemicolon != null && optNextFieldDeclaration != null) {
            optNextFieldDeclaration.setInheritedModifiers(modifiers);
        }
    }

    protected void setInheritedModifiers(JooSymbol[] modifiers) {
        super.setInheritedModifiers(modifiers);
        if (this.optNextVariableDeclaration != null) {
            this.optNextVariableDeclaration.setInheritedModifiers(modifiers);
        }
    }

    public boolean isField() {
        return true;
    }

    public boolean isConst() {
        return this.optSymConstOrVar != null && "const".equals(this.optSymConstOrVar.getText()) && (this.optInitializer == null || this.optInitializer.value.isCompileTimeConstant());
    }

    public void setIsClassMember(boolean b) {
        this.isClassMember = b;
        FieldDeclaration nextField = (FieldDeclaration)this.optNextVariableDeclaration;
        if (nextField != null) {
            nextField.setIsClassMember(b);
        }
    }

    public boolean isClassMember() {
        return this.isClassMember;
    }

    public AstNode analyze(AstNode parentNode, AnalyzeContext context) {
        super.analyze(parentNode, context);
        if (!this.isStatic() && this.optInitializer != null && !this.optInitializer.value.isCompileTimeConstant()) {
            this.getClassDeclaration().addFieldWithInitializer(this);
        }
        return this;
    }

    protected void generateAsApiCode(JsWriter out) throws IOException {
        super.generateAsApiCode(out);
    }

    protected void generateStartCode(JsWriter out) throws IOException {
        out.beginString();
        this.writeModifiers(out);
        if (this.optSymConstOrVar != null) {
            out.writeSymbol(this.optSymConstOrVar);
        }
        out.endString();
        out.write(",{");
    }

    protected void generateInitializerCode(JsWriter out) throws IOException {
        if (this.optInitializer != null) {
            out.writeSymbolWhitespace(this.optInitializer.symEq);
            out.write(58);
            boolean isCompileTimeConstant = this.optInitializer.value.isCompileTimeConstant();
            if (!isCompileTimeConstant) {
                out.writeToken("function(){return(");
            }
            this.optInitializer.value.generateCode(out);
            if (!isCompileTimeConstant) {
                out.writeToken(");}");
            }
        } else {
            String typeName = this.optTypeRelation == null ? "*" : this.optTypeRelation.getType().getSymbol().getText();
            String emptyValue = DEFAULT_VALUE_BY_TYPE.get(typeName);
            if (emptyValue == null) {
                emptyValue = "null";
            }
            out.write(":" + emptyValue);
        }
    }

    protected void generateEndCode(JsWriter out) throws IOException {
        if (!this.hasPreviousVariableDeclaration()) {
            out.write(125);
            Debug.assertTrue(this.optSymSemicolon != null, "optSymSemicolon != null");
            out.writeSymbolWhitespace(this.optSymSemicolon);
            out.writeToken(",");
        }
    }

    public void generateInitCode(JsWriter out) throws IOException {
        String accessCode = "this." + this.getName() + (this.isPrivate() ? "$" + this.classDeclaration.getInheritanceLevel() : "");
        out.write(";" + accessCode + "=" + accessCode + "()");
    }

    public /* synthetic */ IdeDeclaration resolveDeclaration() {
        return super.resolveDeclaration();
    }

    public /* synthetic */ void scope(Scope x0) {
        super.scope(x0);
    }

    static {
        DEFAULT_VALUE_BY_TYPE.put("Boolean", "false");
        DEFAULT_VALUE_BY_TYPE.put("int", "0");
        DEFAULT_VALUE_BY_TYPE.put("Number", "NaN");
        DEFAULT_VALUE_BY_TYPE.put("uint", "0");
        DEFAULT_VALUE_BY_TYPE.put("*", "undefined");
    }
}

