/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import net.jangaroo.jooc.CompileLog;
import net.jangaroo.jooc.JooSymbol;

public class StdOutCompileLog
implements CompileLog {
    protected boolean errors = false;
    protected boolean warnings = false;

    public void error(JooSymbol sym2, String msg) {
        this.error(this.formatError(sym2.getFileName(), sym2.getLine(), sym2.getColumn(), "Error", msg));
    }

    public void error(String msg) {
        System.out.println(msg);
        this.errors = true;
    }

    public void warning(JooSymbol sym2, String msg) {
        this.warning(this.formatError(sym2.getFileName(), sym2.getLine(), sym2.getColumn(), "Warning", msg));
    }

    public void warning(String msg) {
        System.out.println(msg);
        this.warnings = true;
    }

    public boolean hasErrors() {
        return this.errors;
    }

    String formatError(String fileName, int line, int column, String debugLevel, String message) {
        StringBuffer m = new StringBuffer();
        m.append(fileName + "(" + line + "): ");
        m.append(debugLevel);
        m.append(": ");
        m.append("in column " + column + ": ");
        m.append(message);
        return m.toString();
    }
}

