/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.IOException;
import net.jangaroo.jooc.AnalyzeContext;
import net.jangaroo.jooc.ApplyExpr;
import net.jangaroo.jooc.AssertStatement;
import net.jangaroo.jooc.AstNode;
import net.jangaroo.jooc.CommaSeparatedList;
import net.jangaroo.jooc.Debug;
import net.jangaroo.jooc.Expr;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.ParenthesizedExpr;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.Statement;

class SemicolonTerminatedStatement
extends Statement {
    AstNode optStatement;
    JooSymbol optSymSemicolon;

    SemicolonTerminatedStatement(JooSymbol optSymSemicolon) {
        this(null, optSymSemicolon);
    }

    SemicolonTerminatedStatement(AstNode optStatement, JooSymbol optSymSemicolon) {
        Debug.assertTrue(optStatement != null || optSymSemicolon != null, "Both statement and semicolon not specified in SemicolonTerminatedStatement.");
        this.optStatement = optStatement;
        this.optSymSemicolon = optSymSemicolon;
    }

    public void scope(Scope scope) {
        if (this.optStatement != null) {
            this.optStatement.scope(scope);
        }
    }

    protected void generateStatementCode(JsWriter out) throws IOException {
        if (this.optStatement != null) {
            this.optStatement.generateCode(out);
        }
    }

    protected void generateJsCode(JsWriter out) throws IOException {
        this.generateStatementCode(out);
        if (this.optSymSemicolon != null) {
            out.writeSymbol(this.optSymSemicolon);
        }
    }

    public AstNode analyze(AstNode parentNode, AnalyzeContext context) {
        if (this.optStatement instanceof ApplyExpr && this.optSymSemicolon != null) {
            ApplyExpr applyExpr = (ApplyExpr)this.optStatement;
            JooSymbol funSymbol = applyExpr.fun.getSymbol();
            if ("assert".equals(funSymbol.getText())) {
                ParenthesizedExpr<CommaSeparatedList<Expr>> args = applyExpr.args;
                CommaSeparatedList params = (CommaSeparatedList)args.expr;
                if (params != null && params.tail == null) {
                    AssertStatement assertStatement = new AssertStatement(funSymbol, args.lParen, (Expr)params.head, args.rParen, this.optSymSemicolon);
                    assertStatement.analyze(parentNode, context);
                    return assertStatement;
                }
            }
        }
        super.analyze(parentNode, context);
        if (this.optStatement != null) {
            this.optStatement = this.optStatement.analyze(this, context);
        }
        return this;
    }

    public JooSymbol getSymbol() {
        return this.optSymSemicolon == null ? this.optStatement.getSymbol() : this.optSymSemicolon;
    }
}

