/*
 * Copyright 2008 CoreMedia AG
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, 
 * software distributed under the License is distributed on an "AS
 * IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either 
 * express or implied. See the License for the specific language 
 * governing permissions and limitations under the License.
 */

package net.jangaroo.jooc;


/**
 * @author Andreas Gawecki
 */
abstract class UnaryOpExpr extends OpExpr {

  Expr arg;

  public UnaryOpExpr(JooSymbol op, Expr arg) {
    super(op);
    this.arg = arg;
  }

  @Override
  public void scope(final Scope scope) {
    arg.scope(scope);
  }

  public Expr analyze(AstNode parentNode, AnalyzeContext context) {
    super.analyze(parentNode, context);
    arg = arg.analyze(this, context);
    return this;
  }

  boolean isCompileTimeConstant() {
    return arg.isCompileTimeConstant();
  }
}
