/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.config;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.jangaroo.jooc.config.DebugMode;
import net.jangaroo.jooc.config.JoocOptions;
import net.jangaroo.jooc.config.NamespaceConfiguration;
import net.jangaroo.jooc.config.NamespacesHandler;
import net.jangaroo.jooc.config.ParserOptions;
import net.jangaroo.jooc.config.PublicApiViolationsMode;
import net.jangaroo.jooc.config.SemicolonInsertionMode;
import net.jangaroo.utils.FileLocations;
import org.kohsuke.args4j.Option;

public class JoocConfiguration
extends FileLocations
implements JoocOptions,
ParserOptions {
    private SemicolonInsertionMode semicolonInsertionMode = SemicolonInsertionMode.WARN;
    private DebugMode debugMode;
    private boolean help;
    private boolean version;
    private boolean verbose;
    private boolean enableAssertions;
    private PublicApiViolationsMode publicApiViolationsMode = PublicApiViolationsMode.WARN;
    private boolean excludeClassByDefault = false;
    private boolean allowDuplicateLocalVariables;
    private File apiOutputDirectory;
    private boolean mergeOutput = false;
    private String outputFileName;
    private boolean generateSourceMaps = false;
    private List<NamespaceConfiguration> namespaces = new ArrayList<NamespaceConfiguration>();

    @Override
    public SemicolonInsertionMode getSemicolonInsertionMode() {
        return this.semicolonInsertionMode;
    }

    @Option(name="-autosemicolon", usage="automatic semicolon insertion mode, possible modes: error, warn (default), quirk (no warnings)")
    public void setSemicolonInsertionMode(SemicolonInsertionMode semicolonInsertionMode) {
        this.semicolonInsertionMode = semicolonInsertionMode;
    }

    public boolean isMergeOutput() {
        return this.mergeOutput;
    }

    public void setMergeOutput(boolean mergeOutput) {
        this.mergeOutput = mergeOutput;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public void setOutputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    public File getOutputFile() {
        return new File(this.outputFileName);
    }

    @Override
    public DebugMode getDebugMode() {
        return this.debugMode;
    }

    @Option(name="-g", usage="generate debuggable output (possible modes: source, lines, none)")
    public void setDebugMode(DebugMode debugMode) {
        this.debugMode = debugMode;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Option(name="-v", aliases={"--verbose"}, usage="be extra verbose")
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public boolean isGenerateApi() {
        return this.apiOutputDirectory != null;
    }

    @Override
    public PublicApiViolationsMode getPublicApiViolationsMode() {
        return this.publicApiViolationsMode;
    }

    @Option(name="-pav", aliases={"--publicApiViolations"}, usage="Severity of public API violations, i.e. using classes that are annotated with [ExcludeClass]: error, warn, allow")
    public void setPublicApiViolationsMode(PublicApiViolationsMode warnPublicApiViolations) {
        this.publicApiViolationsMode = warnPublicApiViolations;
    }

    @Override
    public boolean isExcludeClassByDefault() {
        return this.excludeClassByDefault;
    }

    @Option(name="-ec", aliases={"--excludeClassByDefault"}, usage="Whether to add an [ExcludeClass] annotation to a class whenever no [PublicApi] annotation is present; defaults to false")
    public void setExcludeClassByDefault(boolean excludeClassByDefault) {
        this.excludeClassByDefault = excludeClassByDefault;
    }

    public boolean isHelp() {
        return this.help;
    }

    @Option(name="-h", aliases={"--help"}, usage="print this message")
    public void setHelp(boolean help) {
        this.help = help;
    }

    public boolean isVersion() {
        return this.version;
    }

    @Option(name="-version", usage="print version information and exit")
    public void setVersion(boolean version) {
        this.version = version;
    }

    @Override
    public boolean isEnableAssertions() {
        return this.enableAssertions;
    }

    @Option(name="-ea", aliases={"--enableassertions"}, usage="enable assertions")
    public void setEnableAssertions(boolean enableAssertions) {
        this.enableAssertions = enableAssertions;
    }

    public boolean isAllowDuplicateLocalVariables() {
        return this.allowDuplicateLocalVariables;
    }

    @Option(name="-ad", aliases={"--allowduplicatelocalvariables"}, usage="allow multiple declarations of local variables")
    public void setAllowDuplicateLocalVariables(boolean allowDuplicateLocalVariables) {
        this.allowDuplicateLocalVariables = allowDuplicateLocalVariables;
    }

    @Option(name="-sm", aliases={"--generatesourcemaps"}, usage="generate JavaScript source maps")
    public void setGenerateSourceMaps(boolean generateSourceMaps) {
        this.generateSourceMaps = generateSourceMaps;
    }

    @Override
    public boolean isGenerateSourceMaps() {
        return this.generateSourceMaps;
    }

    public File getApiOutputDirectory() {
        return this.apiOutputDirectory;
    }

    @Option(name="-api", aliases={"--apiDir"}, usage="destination directory where to generate ActionScript API stubs")
    public void setApiOutputDirectory(File apiOutputDirectory) {
        this.apiOutputDirectory = apiOutputDirectory;
    }

    public List<NamespaceConfiguration> getNamespaces() {
        return Collections.unmodifiableList(this.namespaces);
    }

    @Option(name="-namespace", handler=NamespacesHandler.class, usage="namespace of the component library defined in the given manifest file")
    public void setNamespaces(List<NamespaceConfiguration> namespaces) {
        this.namespaces = new ArrayList<NamespaceConfiguration>(namespaces);
    }

    public void addNamespaces(List<NamespaceConfiguration> namespaces) {
        this.namespaces.addAll(namespaces);
    }
}

