/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.jangaroo.jooc.config.JoocConfiguration;
import net.jangaroo.jooc.config.NamespaceConfiguration;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CompilerConfigParser {
    private JoocConfiguration joocConfiguration;

    public CompilerConfigParser(JoocConfiguration joocConfiguration) {
        this.joocConfiguration = joocConfiguration;
    }

    public void parse(InputStream compilerConfig) {
        try {
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            saxFactory.setNamespaceAware(true);
            SAXParser parser = saxFactory.newSAXParser();
            CompilerConfigSaxHandler handler = new CompilerConfigSaxHandler();
            parser.parse(compilerConfig, (DefaultHandler)handler);
            this.joocConfiguration.addNamespaces(handler.getNamespaces());
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("a default dom builder should be provided", e);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class CompilerConfigSaxHandler
    extends DefaultHandler {
        private List<NamespaceConfiguration> namespaces = new ArrayList<NamespaceConfiguration>();
        private String lastElement;
        private NamespaceConfiguration namespace;

        private CompilerConfigSaxHandler() {
        }

        @Override
        public void startElement(String elementNamespace, String localName, String qName, Attributes attributes) throws SAXException {
            this.lastElement = localName;
            if ("namespace".equals(localName)) {
                this.namespace = new NamespaceConfiguration();
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.namespace != null) {
                String value = new String(ch, start, length);
                if ("uri".equals(this.lastElement)) {
                    this.namespace.setUri(value);
                } else if ("manifest".equals(this.lastElement)) {
                    this.namespace.setManifest(value);
                }
            }
        }

        @Override
        public void endElement(String elementNamespace, String localName, String qName) throws SAXException {
            this.lastElement = null;
            if ("namespace".equals(localName)) {
                this.namespaces.add(this.namespace);
                this.namespace = null;
            }
        }

        public List<NamespaceConfiguration> getNamespaces() {
            return this.namespaces;
        }
    }
}

