/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.extxml.mojo;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.jangaroo.extxml.file.SrcFileScanner;
import net.jangaroo.extxml.generation.JooClassGenerator;
import net.jangaroo.extxml.generation.XsdGenerator;
import net.jangaroo.extxml.model.ComponentSuite;
import net.jangaroo.extxml.xml.XsdScanner;
import net.jangaroo.utils.log.Log;
import net.jangaroo.utils.log.LogHandler;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

public abstract class AbstractExtXmlMojo
extends AbstractMojo {
    private MavenProject project;
    private File[] importedXsds;
    MavenProjectHelper projectHelper;
    protected String xsd;
    protected File generatedResourcesDirectory;

    public abstract String getNamespace();

    public abstract String getNamespacePrefix();

    public abstract String getXsd();

    public abstract File getSourceDirectory();

    public abstract File getGeneratedSourcesDirectory();

    public abstract File getGeneratedResourcesDirectory();

    public File[] getImportedXsds() {
        return this.importedXsds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        File generatedResourcesDirectory;
        File generatedSourcesDirectory = this.getGeneratedSourcesDirectory();
        if (!generatedSourcesDirectory.exists()) {
            this.getLog().info((CharSequence)("generating sources into: " + generatedSourcesDirectory.getPath()));
            this.getLog().debug((CharSequence)("created " + generatedSourcesDirectory.mkdirs()));
        }
        if (!(generatedResourcesDirectory = this.getGeneratedResourcesDirectory()).exists()) {
            this.getLog().info((CharSequence)("generating resources into: " + generatedResourcesDirectory.getPath()));
            this.getLog().debug((CharSequence)("created " + generatedResourcesDirectory.mkdirs()));
        }
        MavenLogHandler errorHandler = new MavenLogHandler();
        Log.setLogHandler((LogHandler)errorHandler);
        ComponentSuite suite = new ComponentSuite(this.getNamespace(), this.getNamespacePrefix(), this.getSourceDirectory(), generatedSourcesDirectory);
        XsdScanner xsdScanner = new XsdScanner();
        if (this.getImportedXsds() != null) {
            for (File importedXsd : this.getImportedXsds()) {
                try {
                    suite.addImportedComponentSuite(xsdScanner.scan((InputStream)new FileInputStream(importedXsd)));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error while xsd scanning", (Exception)e);
                }
            }
        }
        Set dependencies = this.project.getDependencyArtifacts();
        for (Artifact dependency : dependencies) {
            if (dependency.isOptional() || !"jangaroo".equals(dependency.getType()) || dependency.getFile() == null || !dependency.getFile().getName().endsWith(".jar")) continue;
            ZipFile zipArtifact = null;
            try {
                try {
                    zipArtifact = new ZipFile(dependency.getFile(), 1);
                    Enumeration<? extends ZipEntry> entries = zipArtifact.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry zipEntry = entries.nextElement();
                        if (zipEntry.isDirectory() || !zipEntry.getName().endsWith(".xsd")) continue;
                        this.getLog().info((CharSequence)String.format("Loading %s from %s", zipEntry.getName(), dependency.getFile().getAbsolutePath()));
                        BufferedInputStream stream = new BufferedInputStream(zipArtifact.getInputStream(zipEntry));
                        suite.addImportedComponentSuite(xsdScanner.scan((InputStream)stream));
                    }
                }
                finally {
                    if (zipArtifact == null) continue;
                    zipArtifact.close();
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error while xsd scanning", (Exception)e);
            }
        }
        SrcFileScanner fileScanner = new SrcFileScanner(suite);
        try {
            fileScanner.scan();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while file scanning", (Exception)e);
        }
        JooClassGenerator generator = new JooClassGenerator(suite);
        generator.generateClasses();
        if (errorHandler.lastException != null) {
            throw new MojoExecutionException(errorHandler.exceptionMsg, errorHandler.lastException);
        }
        StringBuffer errorsMsgs = new StringBuffer();
        for (String msg : errorHandler.errors) {
            errorsMsgs.append(msg);
            errorsMsgs.append("\n");
        }
        if (errorsMsgs.length() != 0) {
            throw new MojoFailureException(errorsMsgs.toString());
        }
        for (String msg : errorHandler.warnings) {
            this.getLog().warn((CharSequence)msg);
        }
        if (!suite.getComponentClasses().isEmpty()) {
            Writer out = null;
            try {
                try {
                    File xsdFile = new File(generatedResourcesDirectory, this.getXsd());
                    out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(xsdFile), "UTF-8"));
                    new XsdGenerator(suite).generateXsd(out);
                    out.close();
                    this.projectHelper.attachArtifact(this.project, "xsd", xsdFile);
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error while generating XML schema", (Exception)e);
            }
        }
        this.project.addCompileSourceRoot(generatedSourcesDirectory.getPath());
    }

    class MavenLogHandler
    implements LogHandler {
        ArrayList<String> errors = new ArrayList();
        ArrayList<String> warnings = new ArrayList();
        Exception lastException;
        String exceptionMsg;
        File currentFile;

        MavenLogHandler() {
        }

        public void setCurrentFile(File file) {
            this.currentFile = file;
        }

        public void error(String message, int lineNumber, int columnNumber) {
            this.errors.add(String.format("ERROR in %s, line %s, column %s: %s", this.currentFile, lineNumber, columnNumber, message));
        }

        public void error(String message, Exception exception) {
            this.exceptionMsg = message;
            if (this.currentFile != null) {
                this.exceptionMsg = this.exceptionMsg + String.format(" in file: %s", this.currentFile);
            }
            this.lastException = exception;
        }

        public void error(String message) {
            this.errors.add(message);
        }

        public void warning(String message) {
            this.warnings.add(message);
        }

        public void warning(String message, int lineNumber, int columnNumber) {
            this.warnings.add(String.format("WARNING in %s, line %s, column %s: %s", this.currentFile, lineNumber, columnNumber, message));
        }

        public void info(String message) {
            AbstractExtXmlMojo.this.getLog().info((CharSequence)message);
        }

        public void debug(String message) {
            AbstractExtXmlMojo.this.getLog().debug((CharSequence)message);
        }
    }
}

