/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.tools;

import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.MutableDataSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.jangaroo.exml.tools.ExtAsApi;
import net.jangaroo.exml.tools.ExtJsApi;
import net.jangaroo.jooc.backend.ActionScriptCodeGeneratingModelVisitor;
import net.jangaroo.jooc.backend.JsCodeGenerator;
import net.jangaroo.jooc.model.AbstractAnnotatedModel;
import net.jangaroo.jooc.model.AnnotationModel;
import net.jangaroo.jooc.model.AnnotationPropertyModel;
import net.jangaroo.jooc.model.ClassModel;
import net.jangaroo.jooc.model.CompilationUnitModel;
import net.jangaroo.jooc.model.CompilationUnitModelRegistry;
import net.jangaroo.jooc.model.FieldModel;
import net.jangaroo.jooc.model.MemberModel;
import net.jangaroo.jooc.model.MethodModel;
import net.jangaroo.jooc.model.MethodType;
import net.jangaroo.jooc.model.ModelVisitor;
import net.jangaroo.jooc.model.NamedModel;
import net.jangaroo.jooc.model.ParamModel;
import net.jangaroo.jooc.model.PropertyModel;
import net.jangaroo.jooc.model.ReturnModel;
import net.jangaroo.jooc.model.TypedModel;
import net.jangaroo.utils.AS3Type;
import net.jangaroo.utils.CompilerUtils;

public class ExtAsApiGenerator {
    private static final Pattern SINGLETON_CLASS_NAME_PATTERN = Pattern.compile("^S[A-Z]");
    private static final String LINK_PATTERN_STR = "\\{@link(\\s+)([^\\s}]*)(?:\\s+([^}]*))?\\s*}";
    private static final Pattern LINK_PATTERN = Pattern.compile("\\{@link(\\s+)([^\\s}]*)(?:\\s+([^}]*))?\\s*}");
    private static final Pattern INLINE_TAG_OR_LINK_PATTERN = Pattern.compile("<(/?)(code|i)>|\\{@link(\\s+)([^\\s}]*)(?:\\s+([^}]*))?\\s*}");
    private static final Pattern TYPED_ARRAY_PATTERN = Pattern.compile("([a-zA-Z0-9._$<>]+)\\[]");
    private static final String REQUIRED_CONFIG_TEXT = "<b>This is a required setting</b>. ";
    private static final String PRIVATE_CLASS_TEXT = "<b>NOTE: This is a private utility class for internal use by the framework. Don't rely on its existence.</b>\n\n";
    private static ExtJsApi extJsApi;
    private static Set<ExtJsApi.ExtClass> extClasses;
    private static CompilationUnitModelRegistry compilationUnitModelRegistry;
    private static Set<String> interfaces;
    private static final List<String> NON_COMPILE_TIME_CONSTANT_INITIALIZERS;
    private static ExtAsApi referenceApi;
    private static boolean generateEventClasses;
    private static boolean generateForMxml;
    private static Properties jsAsNameMappingProperties;
    private static Properties jsConfigClassNameMappingProperties;
    private static Properties eventWordsProperties;
    private static final String EXT_3_4_EVENT = "ext.IEventObject";
    private static String EXT_EVENT;
    private static final Set<String> invalidJsDocReferences;
    private static Map<String, Map<String, String>> aliasGroupToAliasToClass;

    public static void main(String[] args) throws IOException {
        String extVersion = args[0];
        File srcFile = new File(args[1]);
        File outputDir = new File(args[2] + "/joo");
        File configDir = new File(args[2] + "/config");
        referenceApi = new ExtAsApi(ExtAsApiGenerator.loadProperties(configDir, "net/jangaroo/exml/tools/ext-js-3.4-6.0-name-mapping.properties"), "2.0.14", "2.0.13");
        EXT_EVENT = referenceApi.getMappedQName(EXT_3_4_EVENT);
        if (EXT_EVENT == null) {
            EXT_EVENT = EXT_3_4_EVENT;
        }
        generateEventClasses = args.length <= 3 || Boolean.valueOf(args[3]) != false;
        generateForMxml = args.length <= 4 ? false : Boolean.valueOf(args[4]);
        jsAsNameMappingProperties = ExtAsApiGenerator.loadProperties(configDir, "net/jangaroo/exml/tools/js-as-name-mapping.properties");
        jsConfigClassNameMappingProperties = ExtAsApiGenerator.loadProperties(configDir, "net/jangaroo/exml/tools/js-config-name-mapping.properties");
        eventWordsProperties = ExtAsApiGenerator.loadProperties(configDir, "net/jangaroo/exml/tools/event-words.properties");
        if (srcFile.exists()) {
            compilationUnitModelRegistry = new CompilationUnitModelRegistry();
            interfaces = new HashSet<String>();
            extJsApi = new ExtJsApi(extVersion, srcFile);
            extClasses = new HashSet<ExtJsApi.ExtClass>(extJsApi.getExtClasses());
            ExtAsApiGenerator.removePrivateApiClasses();
            Set<ExtJsApi.ExtClass> mixins = extJsApi.getMixins();
            for (ExtJsApi.ExtClass mixin : mixins) {
                String mixinName = ExtAsApiGenerator.getActionScriptName(mixin);
                if (mixinName == null || mixinName.isEmpty()) continue;
                interfaces.add(mixinName);
            }
            interfaces.remove("ext.util.Observable");
            interfaces.remove("ext.dom.Element");
            interfaces.remove("ext.Base");
            interfaces.remove("Object");
            interfaces.add("ext.EventObjectImpl");
            for (ExtJsApi.ExtClass extClass : extClasses) {
                ExtAsApiGenerator.generateClassModel(extClass);
            }
            compilationUnitModelRegistry.complementOverrides();
            ExtAsApiGenerator.adaptToReferenceApi();
            compilationUnitModelRegistry.complementOverrides();
            compilationUnitModelRegistry.complementImports();
            ExtAsApiGenerator.annotateBindableConfigProperties();
            if (!outputDir.exists()) {
                System.err.println("No output directory specified, skipping code generation.");
                return;
            }
            for (CompilationUnitModel compilationUnitModel : compilationUnitModelRegistry.getCompilationUnitModels()) {
                ExtAsApiGenerator.generateActionScriptCode(compilationUnitModel, outputDir);
            }
        }
        ExtAsApiGenerator.generateManifest(outputDir);
        if (!invalidJsDocReferences.isEmpty()) {
            ArrayList<String> sortedInvalidJsDocReferences = new ArrayList<String>(invalidJsDocReferences);
            Collections.sort(sortedInvalidJsDocReferences);
            System.out.println("************ Invalid JSDoc References *****************");
            for (String invalidJsDocReference : sortedInvalidJsDocReferences) {
                ExtJsApi.ExtClass extClass = extJsApi.getExtClass(invalidJsDocReference);
                System.out.println(invalidJsDocReference + (extClass == null ? " (unknown)" : ("private".equals(extClass.access) ? " (private)" : " (not mapped)")));
            }
            System.out.println("************ END Invalid JSDoc References *****************");
        }
    }

    private static Properties loadProperties(File configDir, String configFile) throws IOException {
        Properties properties = new Properties();
        properties.load(new BufferedReader(new FileReader(new File(configDir, configFile))));
        return properties;
    }

    private static void generateManifest(File outputDir) throws FileNotFoundException, UnsupportedEncodingException {
        File outputFile = new File(outputDir, "manifest.xml");
        System.out.printf("Creating manifest file %s...%n", outputFile.getPath());
        PrintStream out = new PrintStream((OutputStream)new FileOutputStream(outputFile), true, "UTF-8");
        out.println("<?xml version=\"1.0\"?>");
        out.println("<componentPackage>");
        for (String aliasGroup : aliasGroupToAliasToClass.keySet()) {
            String previousId = "";
            for (Map.Entry<String, String> aliasToClass : aliasGroupToAliasToClass.get(aliasGroup).entrySet()) {
                String id;
                String alias = aliasToClass.getKey();
                String classQName = aliasToClass.getValue();
                previousId = id = ExtAsApiGenerator.computeId(alias, classQName + previousId);
                if (!"widget".equals(aliasGroup)) {
                    id = aliasGroup + "_" + id;
                }
                out.printf("  <component id=\"%s\" class=\"%s\"/>%n", id, classQName);
            }
        }
        out.println("</componentPackage>");
        out.close();
    }

    private static String computeId(String alias, String classQName) {
        int dotPos = alias.indexOf(46);
        if (dotPos != -1) {
            return ExtAsApiGenerator.computeId(alias.substring(dotPos + 1), classQName) + ExtAsApiGenerator.capitalize(alias.substring(0, dotPos));
        }
        alias = alias.replaceAll("-", "");
        String className = CompilerUtils.className((String)classQName);
        String[] words = className.split("(?<!^)(?=[A-Z])");
        int index = 0;
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            int wordIndex = alias.indexOf(word.toLowerCase(), index);
            if (wordIndex == -1) continue;
            result.append(ExtAsApiGenerator.capitalize(alias.substring(index, wordIndex)));
            result.append(word);
            index = wordIndex + word.length();
        }
        result.append(ExtAsApiGenerator.capitalize(alias.substring(index)));
        return result.toString();
    }

    private static void adaptToReferenceApi() {
        System.err.printf("Class\tremoved\tchanged\tsame%n", new Object[0]);
        for (CompilationUnitModel compilationUnitModel : compilationUnitModelRegistry.getCompilationUnitModels()) {
            String qName = compilationUnitModel.getQName();
            NamedModel primaryDeclaration = compilationUnitModel.getPrimaryDeclaration();
            if (primaryDeclaration instanceof FieldModel) {
                String singletonType = ((FieldModel)primaryDeclaration).getType();
                compilationUnitModel = compilationUnitModelRegistry.resolveCompilationUnit(singletonType);
                CompilationUnitModel singletonReference = ExtAsApiGenerator.getReferenceDeclaration(qName);
                if (singletonReference == null || !(singletonReference.getPrimaryDeclaration() instanceof FieldModel)) continue;
                qName = CompilerUtils.qName((String)CompilerUtils.packageName((String)qName), (String)((FieldModel)singletonReference.getPrimaryDeclaration()).getType());
            }
            if (!(primaryDeclaration instanceof ClassModel)) continue;
            for (CompilationUnitModel referenceClass : ExtAsApiGenerator.getReferenceDeclarations(qName)) {
                if (!(referenceClass.getPrimaryDeclaration() instanceof ClassModel)) continue;
                ExtAsApiGenerator.adaptToReferenceApi(compilationUnitModel, referenceClass);
            }
        }
    }

    private static void adaptToReferenceApi(CompilationUnitModel compilationUnitModel, CompilationUnitModel referenceCompilationUnitModel) {
        ClassModel referenceClassModel = referenceCompilationUnitModel.getClassModel();
        int removedCount = 0;
        int changedCount = 0;
        for (MemberModel member : referenceClassModel.getMembers()) {
            MemberModel newMember = ExtAsApiGenerator.findMemberModel(compilationUnitModel, member);
            if (newMember == null) {
                if (member.equals((Object)referenceClassModel.getConstructor())) continue;
                ++removedCount;
                continue;
            }
            ExtAsApiGenerator.adaptNamespaceToReferenceApi(newMember, member);
            boolean changed = ExtAsApiGenerator.adaptTypeToReferenceApi(referenceCompilationUnitModel, (TypedModel)newMember, (TypedModel)member);
            if (member instanceof MethodModel) {
                Iterator iterator = ((MethodModel)member).getParams().iterator();
                Iterator newIterator = ((MethodModel)newMember).getParams().iterator();
                while (iterator.hasNext() && newIterator.hasNext()) {
                    ParamModel param = (ParamModel)iterator.next();
                    ParamModel newParam = (ParamModel)newIterator.next();
                    changed |= ExtAsApiGenerator.adaptTypeToReferenceApi(referenceCompilationUnitModel, (TypedModel)newParam, (TypedModel)param);
                }
                if (iterator.hasNext() || newIterator.hasNext()) {
                    changed = true;
                }
            }
            if (!changed) continue;
            ++changedCount;
        }
        int sameCount = referenceClassModel.getMembers().size() - changedCount - removedCount;
        System.err.printf("%s\t%d\t%d\t%d%n", compilationUnitModel.getQName(), removedCount, changedCount, sameCount);
    }

    private static boolean adaptTypeToReferenceApi(CompilationUnitModel referenceCompilationUnitModel, TypedModel newMember, TypedModel member) {
        String oldType = referenceApi.resolveQualifiedName(referenceCompilationUnitModel, member.getType());
        String newType = newMember.getType();
        if (oldType != null && !oldType.equals(newType) && ExtAsApiGenerator.shouldCorrect(newMember, oldType, newType)) {
            newMember.setType(oldType);
            return true;
        }
        return false;
    }

    private static void adaptNamespaceToReferenceApi(MemberModel newMember, MemberModel member) {
        String oldNamespace = member.getNamespace();
        String newNamespace = newMember.getNamespace();
        if (oldNamespace != null && !oldNamespace.equals(newNamespace)) {
            newMember.setNamespace(oldNamespace);
        }
    }

    private static boolean shouldCorrect(TypedModel newMember, String oldType, String newType) {
        return newType == null || "void".equals(newType) || "*".equals(newType) || "void".equals(oldType) && (!(newMember instanceof MethodModel) || ExtAsApiGenerator.returnsThis((MethodModel)newMember)) || "Object".equals(newType) && "*".equals(oldType) || EXT_EVENT.equals(oldType) && newType.contains("Event") || "Function".equals(newType) && "Class".equals(oldType);
    }

    private static boolean returnsThis(MethodModel newMember) {
        ReturnModel returnModel = newMember.getReturnModel();
        return returnModel != null && returnModel.getType() != null && returnModel.getType().contains(".") && returnModel.getAsdoc() != null && returnModel.getAsdoc().toLowerCase().startsWith("this");
    }

    private static MemberModel findMemberModel(CompilationUnitModel compilationUnitModel, MemberModel referenceMemberModel) {
        CompilationUnitModel superclass;
        MemberModel memberModel;
        ClassModel classModel = compilationUnitModel.getClassModel();
        String referenceMemberName = referenceApi.getMappedMemberName(compilationUnitModel, referenceMemberModel.getName());
        Object object = memberModel = referenceMemberModel instanceof MethodModel ? classModel.getMethod(referenceMemberModel.isStatic(), ((MethodModel)referenceMemberModel).getMethodType(), referenceMemberName) : classModel.getMember(referenceMemberModel.isStatic(), referenceMemberName);
        if (memberModel == null && (superclass = compilationUnitModelRegistry.getSuperclassCompilationUnit(classModel)) != null) {
            return ExtAsApiGenerator.findMemberModel(superclass, referenceMemberModel);
        }
        return memberModel;
    }

    private static void generateClassModel(ExtJsApi.ExtClass extClass) {
        String extClassName = ExtAsApiGenerator.getActionScriptName(extClass);
        if (extClassName == null || extClassName.isEmpty()) {
            return;
        }
        CompilationUnitModel extAsClassUnit = ExtAsApiGenerator.createClassModel(ExtAsApiGenerator.convertType(extClass.name));
        ClassModel extAsClass = extAsClassUnit.getClassModel();
        System.out.printf("Generating AS3 API model %s for %s...%n", extAsClassUnit.getQName(), extClassName);
        extAsClass.setAsdoc(ExtAsApiGenerator.toAsDoc(extClass, ExtAsApiGenerator.getThisClassName(extAsClass, extClass), extClass.name));
        ExtAsApiGenerator.addDeprecation(extClass.deprecatedMessage, extClass.deprecatedVersion, (AbstractAnnotatedModel)extAsClass);
        CompilationUnitModel extAsInterfaceUnit = null;
        if (interfaces.contains(extClassName)) {
            String superInterface;
            extAsInterfaceUnit = ExtAsApiGenerator.createClassModel(ExtAsApiGenerator.convertToInterface(extClassName));
            System.out.printf("Generating AS3 API model %s for %s...%n", extAsInterfaceUnit.getQName(), extClassName);
            ClassModel extAsInterface = (ClassModel)extAsInterfaceUnit.getPrimaryDeclaration();
            extAsInterface.setInterface(true);
            extAsInterface.setAsdoc(ExtAsApiGenerator.toAsDoc(extClass, ExtAsApiGenerator.getThisClassName(extAsInterface, extClass), extClass.name) + "\n * @see " + extClassName);
            if (extClass.extends_ != null && (superInterface = ExtAsApiGenerator.convertToInterface(ExtAsApiGenerator.getActionScriptName(extClass.extends_))) != null) {
                extAsInterface.addInterface(superInterface);
            }
        }
        AnnotationModel nativeAnnotation = ExtAsApiGenerator.createNativeAnnotation(extClass.name);
        if (ExtJsApi.isSingleton(extClass)) {
            extAsClass.addAnnotation(ExtAsApiGenerator.createNativeAnnotation(null));
            FieldModel singleton = new FieldModel(CompilerUtils.className((String)extAsClass.getName().substring(1)), extAsClassUnit.getQName());
            singleton.setConst(true);
            singleton.setValue("new " + extAsClassUnit.getQName());
            singleton.addAnnotation(nativeAnnotation);
            singleton.setAsdoc(extAsClass.getAsdoc());
            CompilationUnitModel singletonUnit = new CompilationUnitModel(extAsClassUnit.getPackage(), (NamedModel)singleton);
            compilationUnitModelRegistry.register(singletonUnit);
            extAsClass.setAsdoc(String.format("%s%n<p>Type of singleton %s.</p>%n@see %s %s", extAsClass.getAsdoc(), singleton.getName(), CompilerUtils.qName((String)extAsClassUnit.getPackage(), (String)("#" + singleton.getName())), singletonUnit.getQName()));
        } else {
            extAsClass.addAnnotation(nativeAnnotation);
        }
        if (extAsInterfaceUnit != null) {
            extAsInterfaceUnit.getClassModel().addAnnotation(new AnnotationModel("Mixin", new AnnotationPropertyModel[]{new AnnotationPropertyModel(null, CompilerUtils.quote((String)extClassName))}));
        }
        extAsClass.setSuperclass(ExtAsApiGenerator.convertType(extClass.extends_));
        if (extAsInterfaceUnit != null) {
            extAsClass.addInterface(extAsInterfaceUnit.getQName());
        }
        for (String mixin : extClass.mixins) {
            ExtJsApi.ExtClass extMixinClass = extJsApi.getExtClass(mixin);
            if (extMixinClass == null) continue;
            String superInterface = ExtAsApiGenerator.convertToInterface(ExtAsApiGenerator.getActionScriptName(extMixinClass));
            if (superInterface == null) {
                ExtAsApiGenerator.addNonStaticMembers(extMixinClass, extAsClassUnit);
                continue;
            }
            ExtAsApiGenerator.addNonStaticMembers(extMixinClass, true, extAsClassUnit);
            extAsClass.addInterface(superInterface);
            if (extAsInterfaceUnit == null) continue;
            extAsInterfaceUnit.getClassModel().addInterface(superInterface);
        }
        if (extAsInterfaceUnit != null) {
            ExtAsApiGenerator.addNonStaticMembers(extClass, extAsInterfaceUnit);
        } else {
            ExtAsApiGenerator.addFields(extAsClass, extJsApi.filterByOwner(false, true, extClass, "static-properties", ExtJsApi.Property.class), extClass);
            ExtAsApiGenerator.addMethods(extAsClass, extClass, extJsApi.filterByOwner(false, true, extClass, "static-methods", ExtJsApi.Method.class));
        }
        ExtAsApiGenerator.addNonStaticMembers(extClass, extAsClassUnit);
        if (ExtAsApiGenerator.getConfigClassQName(extClass) != null) {
            ExtAsApiGenerator.addConfigConstructor(extAsClassUnit);
        }
        if (extClass.alias != null) {
            for (String alias : extClass.alias.split(",")) {
                int dotIndex = alias.indexOf(46);
                String aliasGroup = alias.substring(0, dotIndex);
                Map aliasMapping = aliasGroupToAliasToClass.computeIfAbsent(aliasGroup, k -> new TreeMap());
                aliasMapping.put(alias.substring(dotIndex + 1), extAsClassUnit.getQName());
            }
        }
    }

    private static void addConfigConstructor(CompilationUnitModel extAsClassUnit) {
        ClassModel extAsClass = extAsClassUnit.getClassModel();
        MethodModel targetClassConstructor = extAsClass.getConstructor();
        if (targetClassConstructor == null) {
            targetClassConstructor = extAsClass.createConstructor();
            targetClassConstructor.addParam(new ParamModel("config", extAsClassUnit.getQName(), "null", "@inheritDoc"));
        } else {
            for (ParamModel param : targetClassConstructor.getParams()) {
                if (!"config".equals(param.getName())) continue;
                param.setType(extAsClass.getName());
                param.setOptional(true);
                break;
            }
        }
    }

    private static String getConfigClassQName(ExtJsApi.ExtClass extClass) {
        String extClassName = extClass.name;
        String alias = jsConfigClassNameMappingProperties.getProperty(extClassName);
        if (alias == null) {
            return null;
        }
        String configClassQName = CompilerUtils.qName((String)"ext.config", (String)alias);
        System.err.println("********* derived config class name " + configClassQName + " from Ext class " + extClassName + " with alias " + alias);
        return configClassQName;
    }

    private static String getPreferredAlias(Map.Entry<String, List<String>> aliases) {
        String alias = aliases.getValue().get(aliases.getValue().size() - 1);
        if (aliases.getValue().size() > 1) {
            if ("box".equals(alias)) {
                alias = aliases.getValue().get(0);
            }
            System.err.println("***### multiple aliases: " + aliases.getValue() + ", choosing " + alias);
        }
        return alias;
    }

    private static AnnotationModel createNativeAnnotation(String nativeName) {
        AnnotationModel nativeAnnotation = new AnnotationModel("Native");
        if (nativeName != null) {
            nativeAnnotation.addProperty(new AnnotationPropertyModel(null, CompilerUtils.quote((String)nativeName)));
            nativeAnnotation.addProperty(new AnnotationPropertyModel("require", null));
        }
        return nativeAnnotation;
    }

    private static CompilationUnitModel createClassModel(String qName) {
        CompilationUnitModel oldCompilationUnitModel = compilationUnitModelRegistry.resolveCompilationUnit(qName);
        if (oldCompilationUnitModel != null) {
            System.err.println("[WARN] Redefining class " + qName);
            return oldCompilationUnitModel;
        }
        CompilationUnitModel compilationUnitModel = new CompilationUnitModel(null, (NamedModel)new ClassModel());
        compilationUnitModel.setQName(qName);
        compilationUnitModelRegistry.register(compilationUnitModel);
        return compilationUnitModel;
    }

    private static void addNonStaticMembers(ExtJsApi.ExtClass extClass, CompilationUnitModel extAsClassUnit) {
        ExtAsApiGenerator.addNonStaticMembers(extClass, false, extAsClassUnit);
    }

    private static void addNonStaticMembers(ExtJsApi.ExtClass extClass, boolean isMixin, CompilationUnitModel extAsClassUnit) {
        ClassModel extAsClass = extAsClassUnit.getClassModel();
        if (!extAsClass.isInterface()) {
            ExtAsApiGenerator.addEvents(extAsClass, extAsClassUnit, extJsApi.filterByOwner(isMixin, false, false, extClass, "events", ExtJsApi.Event.class), extClass.name);
        }
        ExtAsApiGenerator.addProperties(extAsClass, extClass, extJsApi.filterByOwner(isMixin, extAsClass.isInterface(), false, extClass, "properties", ExtJsApi.Property.class), false);
        ExtAsApiGenerator.addMethods(extAsClass, extClass, extJsApi.filterByOwner(isMixin, extAsClass.isInterface(), false, extClass, "methods", ExtJsApi.Method.class));
        ExtAsApiGenerator.addProperties(extAsClass, extClass, extJsApi.filterByOwner(false, extAsClass.isInterface(), false, extClass, "configs", ExtJsApi.Property.class), true);
    }

    private static void generateActionScriptCode(CompilationUnitModel extAsClass, File outputDir) throws IOException {
        File outputFile = CompilerUtils.fileFromQName((String)extAsClass.getQName(), (File)outputDir, (String)".as");
        outputFile.getParentFile().mkdirs();
        System.out.printf("Generating AS3 API for %s into %s ...\n", extAsClass.getQName(), outputFile.getCanonicalPath());
        extAsClass.visit((ModelVisitor)new ActionScriptCodeGeneratingModelVisitor((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8")));
    }

    private static void addDeprecation(String deprecatedMessage, String deprecatedVersion, AbstractAnnotatedModel model) {
        if (deprecatedMessage != null) {
            AnnotationModel deprecated = new AnnotationModel("Deprecated");
            if (!deprecatedMessage.matches("\\s*")) {
                String value;
                String name;
                Matcher replacementMatcher = LINK_PATTERN.matcher(deprecatedMessage);
                if (replacementMatcher.find()) {
                    name = "replacement";
                    String reference = replacementMatcher.group(2);
                    String[] parts = reference.split("[#!-]");
                    value = parts.length > 1 ? parts[parts.length - 1] : ExtAsApiGenerator.convertType(parts[0]);
                } else {
                    name = "message";
                    value = deprecatedMessage.replace("<p>", "").replace("</p>", "");
                }
                deprecated.addProperty(new AnnotationPropertyModel(name, CompilerUtils.quote((String)value, (boolean)false)));
            }
            if (deprecatedVersion != null && !deprecatedVersion.matches("\\s*")) {
                deprecated.addProperty(new AnnotationPropertyModel("since", deprecatedVersion.startsWith("\"") ? deprecatedVersion : CompilerUtils.quote((String)deprecatedVersion)));
            }
            model.addAnnotation(deprecated);
        }
    }

    private static void addEvents(ClassModel classModel, CompilationUnitModel compilationUnitModel, List<ExtJsApi.Event> events, String thisJsClassName) {
        for (ExtJsApi.Event event : events) {
            String asdoc;
            String eventName = ExtAsApiGenerator.toCamelCase(event.name);
            AnnotationModel annotationModel = new AnnotationModel("Event", new AnnotationPropertyModel[]{new AnnotationPropertyModel("name", "'on" + eventName + "'")});
            if (!generateEventClasses) {
                asdoc = ExtAsApiGenerator.toAsDoc(event, "", thisJsClassName);
            } else {
                String eventTypeQName = ExtAsApiGenerator.generateEventClass(compilationUnitModel, event, thisJsClassName);
                annotationModel.addProperty(new AnnotationPropertyModel("type", "'" + eventTypeQName + "'"));
                String eventReference = String.format("%s.%s", eventTypeQName, ExtAsApiGenerator.toConstantName(event.name));
                asdoc = "@see " + eventReference + "\n@eventType " + eventReference;
            }
            annotationModel.setAsdoc(asdoc);
            classModel.addAnnotation(annotationModel);
        }
    }

    public static String capitalize(String name) {
        return name == null || name.length() == 0 ? name : Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    private static String generateEventClass(CompilationUnitModel eventClientClass, ExtJsApi.Event event, String thisJsClassName) {
        String eventTypeNamePrefix = eventClientClass.getPrimaryDeclaration().getName();
        if (SINGLETON_CLASS_NAME_PATTERN.matcher(eventTypeNamePrefix).find()) {
            eventTypeNamePrefix = eventTypeNamePrefix.substring(1);
        }
        StringBuilder eventTypeQNameBuilder = new StringBuilder().append(eventClientClass.getPackage()).append(".events.").append(eventTypeNamePrefix);
        String eventClientClassQName = eventClientClass.getQName();
        for (int i = 0; i < event.items.size(); ++i) {
            ExtJsApi.Var param = event.items.get(i);
            if (!(param instanceof ExtJsApi.Param)) continue;
            String asType = ExtAsApiGenerator.convertType(param.type);
            if ("this".equals(param.name) || i <= 0 && eventClientClassQName.equals(asType)) continue;
            eventTypeQNameBuilder.append("_").append(param.name);
        }
        eventTypeQNameBuilder.append("Event");
        String eventTypeQName = eventTypeQNameBuilder.toString();
        String eventName = ExtAsApiGenerator.toCamelCase(event.name);
        CompilationUnitModel eventType = compilationUnitModelRegistry.resolveCompilationUnit(eventTypeQName);
        if (eventType == null) {
            eventType = ExtAsApiGenerator.createClassModel(eventTypeQName);
            ClassModel extAsClass = eventType.getClassModel();
            extAsClass.addAnnotation(new AnnotationModel("Rename", new AnnotationPropertyModel[]{new AnnotationPropertyModel(null, "\"" + ExtAsApiGenerator.capitalize(eventTypeQName) + "\"")}));
            extAsClass.setSuperclass("net.jangaroo.ext.FlExtEvent");
            MethodModel constructorModel = extAsClass.createConstructor();
            constructorModel.addParam(new ParamModel("type", "String"));
            constructorModel.addParam(new ParamModel("arguments", "Array"));
            constructorModel.setBody("super(type, arguments);");
            StringBuilder parameterSequence = new StringBuilder("[");
            for (ExtJsApi.Var param : event.items) {
                if (!(param instanceof ExtJsApi.Param)) continue;
                String parameterName = ExtAsApiGenerator.convertName(param.name);
                parameterSequence.append(CompilerUtils.quote((String)parameterName)).append(", ");
                MethodModel property = new MethodModel(MethodType.GET, parameterName, ExtAsApiGenerator.convertType(param.type));
                property.addAnnotation(ExtAsApiGenerator.createArrayElementTypeAnnotation(param.type));
                property.setAsdoc(ExtAsApiGenerator.toAsDoc(param, eventClientClassQName, thisJsClassName));
                extAsClass.addMember((MemberModel)property);
            }
            parameterSequence.append(CompilerUtils.quote((String)"eOpts")).append("]");
            FieldModel parameterSequenceConstant = new FieldModel("__PARAMETER_SEQUENCE__", "Array", parameterSequence.toString());
            parameterSequenceConstant.setStatic(true);
            parameterSequenceConstant.setConst(true);
            extAsClass.addMember((MemberModel)parameterSequenceConstant);
        }
        FieldModel eventNameConstant = new FieldModel(ExtAsApiGenerator.toConstantName(event.name), "String", CompilerUtils.quote((String)("on" + eventName)));
        eventNameConstant.setStatic(true);
        eventNameConstant.setConst(true);
        eventNameConstant.setAsdoc(String.format("%s%n@see %s%n@eventType %s", ExtAsApiGenerator.toAsDoc(event, eventClientClassQName, thisJsClassName), eventClientClass.getQName(), "on" + eventName));
        eventType.getClassModel().addMember((MemberModel)eventNameConstant);
        return eventTypeQName;
    }

    private static String toCamelCase(String eventName) {
        if (!eventName.toLowerCase().equals(eventName)) {
            return eventName;
        }
        StringBuilder camelCaseName = new StringBuilder();
        for (String word : ExtAsApiGenerator.splitIntoWords(eventName)) {
            camelCaseName.append(ExtAsApiGenerator.capitalize(word));
        }
        assert (camelCaseName.toString().toLowerCase().equals(eventName));
        return camelCaseName.toString();
    }

    private static String toConstantName(String eventName) {
        StringBuilder constantName = new StringBuilder();
        for (String word : ExtAsApiGenerator.splitIntoWords(eventName.toLowerCase())) {
            constantName.append(word.toUpperCase()).append('_');
        }
        constantName.setLength(constantName.length() - 1);
        return constantName.toString();
    }

    private static List<String> splitIntoWords(String mergedWords) {
        ArrayList<String> words = new ArrayList<String>();
        String remaining = mergedWords;
        while (!remaining.isEmpty()) {
            String candidate = "";
            for (Object keyObject : eventWordsProperties.keySet()) {
                String key = (String)keyObject;
                if (key.length() <= candidate.length() || !remaining.startsWith(key)) continue;
                candidate = key;
            }
            if (candidate.isEmpty()) {
                System.err.printf("No word found in dictionary for %s's suffix '%s'.%n", mergedWords, remaining);
                candidate = remaining;
            }
            words.add(candidate);
            remaining = remaining.substring(candidate.length());
        }
        return words;
    }

    private static void addFields(ClassModel classModel, List<? extends ExtJsApi.Member> fields, ExtJsApi.ExtClass extClass) {
        for (ExtJsApi.Member member : fields) {
            PropertyModel fieldModel = new PropertyModel(ExtAsApiGenerator.convertName(member.name), ExtAsApiGenerator.convertType(member.type));
            ExtAsApiGenerator.setVisibility((MemberModel)fieldModel, member);
            ExtAsApiGenerator.setStatic((MemberModel)fieldModel, member);
            fieldModel.addGetter().setAsdoc(ExtAsApiGenerator.toAsDoc(member, extClass.singleton ? classModel.getName() : "", extClass.name));
            if (!ExtJsApi.isConst(member)) {
                fieldModel.addSetter().setAsdoc("@private");
            }
            fieldModel.addAnnotation(ExtAsApiGenerator.createArrayElementTypeAnnotation(member.type));
            ExtAsApiGenerator.addDeprecation(member.deprecatedMessage, member.deprecatedVersion, (AbstractAnnotatedModel)fieldModel);
            classModel.addMember((MemberModel)fieldModel);
        }
    }

    private static void addProperties(ClassModel classModel, ExtJsApi.ExtClass extClass, List<? extends ExtJsApi.Member> properties, boolean isConfig) {
        for (ExtJsApi.Member member : properties) {
            MemberModel priorMember;
            boolean isStatic = !extClass.singleton && extJsApi.isStatic(member);
            String name = ExtAsApiGenerator.convertName(member.name);
            String type = ExtAsApiGenerator.convertType(member.type);
            String asDoc = ExtAsApiGenerator.toAsDoc(member, extClass.singleton ? classModel.getName() : "", extClass.name);
            if (type == null || "*".equals(type) || "Object".equals(type)) {
                String string = "cls".equals(member.name) ? "String" : ("useBodyElement".equals(member.name) ? "Boolean" : (type = "items".equals(member.name) || "plugins".equals(member.name) ? "Array" : type));
            }
            if ((priorMember = classModel.getMember(isStatic, name)) != null) {
                String priorMemberType = priorMember.isMethod() && !priorMember.isAccessor() ? "Function" : priorMember.getType();
                if (!priorMemberType.equals(type)) {
                    System.err.println("Duplicate member " + member.name + (isConfig ? " (config)" : "") + " in class " + classModel.getName() + " with deviating type " + type + " instead of " + priorMemberType + ".");
                }
                if ("Array".equals(type) && priorMemberType.contains("Collection")) {
                    String newName = (name.endsWith("s") ? name.substring(0, name.length() - 1) : name) + "Collection";
                    System.out.println("Renaming member " + priorMember.getName() + " to " + newName + " in class " + classModel.getName() + " to avoid name clash with config.");
                    priorMember.setName(newName);
                } else if ("Function".equals(priorMemberType)) {
                    name = name + "_";
                    System.out.println("Renaming config " + member.name + " to " + name + " in class " + classModel.getName() + " to avoid name clash with method.");
                } else {
                    type = priorMemberType;
                    asDoc = priorMember.isProperty() ? ((PropertyModel)priorMember).getGetter().getAsdoc() : priorMember.getAsdoc();
                    System.out.println("Merging member " + priorMember.getName() + " and config " + member.name + " in class " + classModel.getName() + " to avoid name clash.");
                    classModel.removeMember(priorMember);
                }
            }
            PropertyModel propertyModel = new PropertyModel(name, type);
            if (generateForMxml && "items".equals(member.name)) {
                propertyModel.addAnnotation(new AnnotationModel("DefaultProperty"));
            }
            AnnotationModel arrayElementTypeAnnotation = ExtAsApiGenerator.createArrayElementTypeAnnotation(member.type);
            propertyModel.addAnnotation(arrayElementTypeAnnotation);
            propertyModel.setAsdoc(asDoc);
            ExtAsApiGenerator.addDeprecation(member.deprecatedMessage, member.deprecatedVersion, (AbstractAnnotatedModel)propertyModel);
            ExtAsApiGenerator.setVisibility((MemberModel)propertyModel, member);
            propertyModel.setStatic(isStatic);
            MethodModel getter = propertyModel.addGetter();
            AnnotationModel extConfigAnnotation = null;
            boolean isAccessor = Boolean.TRUE.equals(member.accessor);
            if (isConfig) {
                extConfigAnnotation = new AnnotationModel("ExtConfig");
                if (!name.equals(member.name)) {
                    extConfigAnnotation.addProperty(new AnnotationPropertyModel(null, CompilerUtils.quote((String)member.name)));
                }
                getter.addAnnotation(extConfigAnnotation);
                if (isAccessor) {
                    getter.addAnnotation(new AnnotationModel("Bindable"));
                }
            }
            if (isAccessor) {
                MethodModel getMethod = new MethodModel("get" + ExtAsApiGenerator.capitalize(member.name), type);
                getMethod.addAnnotation(arrayElementTypeAnnotation);
                getMethod.setAsdoc("Returns the value of <code>" + name + "</code>.\n@see #" + name);
                ExtAsApiGenerator.addDeprecation(member.deprecatedMessage, member.deprecatedVersion, (AbstractAnnotatedModel)getMethod);
                classModel.addMember((MemberModel)getMethod);
            }
            if (!extJsApi.isReadOnly(member)) {
                boolean isWriteOnlyAccessor;
                MethodModel setter = propertyModel.addSetter();
                if (classModel.isInterface()) {
                    setter.setAsdoc(null);
                }
                boolean bl = isWriteOnlyAccessor = isAccessor || "w".equals(member.accessor);
                if (extConfigAnnotation != null) {
                    setter.addAnnotation(extConfigAnnotation);
                    if (isWriteOnlyAccessor) {
                        setter.addAnnotation(new AnnotationModel("Bindable"));
                    }
                }
                if (isWriteOnlyAccessor) {
                    ParamModel setMethodParam = new ParamModel(name, type);
                    MethodModel setMethod = new MethodModel("set" + ExtAsApiGenerator.capitalize(member.name), "void", new ParamModel[]{setMethodParam});
                    setMethod.setAsdoc("Sets the value of <code>" + name + "</code>.\n@see #" + name);
                    setMethodParam.setAsdoc("The new value.");
                    ExtAsApiGenerator.addDeprecation(member.deprecatedMessage, member.deprecatedVersion, (AbstractAnnotatedModel)setMethod);
                    classModel.addMember((MemberModel)setMethod);
                }
            }
            classModel.addMember((MemberModel)propertyModel);
        }
    }

    private static void addMethods(ClassModel classModel, ExtJsApi.ExtClass extClass, List<ExtJsApi.Method> methods) {
        for (ExtJsApi.Method method : methods) {
            MethodModel methodModel;
            ExtJsApi.Return return_;
            String methodName = method.name;
            if (methodName == null || methodName.length() == 0) {
                System.err.printf("methods name missing for method #%d in class %s", methods.indexOf(method) + 1, classModel.getName());
                continue;
            }
            if (classModel.getMember(methodName) != null) continue;
            boolean isConstructor = methodName.equals("constructor");
            String thisClassName = ExtAsApiGenerator.getThisClassName(classModel, extClass);
            method = ExtAsApiGenerator.getDelegateTag(method, thisClassName);
            List methodItems = method.items;
            List<ExtJsApi.Return> returns = ExtAsApiGenerator.filterByType(methodItems, ExtJsApi.Return.class);
            ExtJsApi.Return return_2 = return_ = returns.isEmpty() ? null : returns.get(0);
            MethodModel methodModel2 = isConstructor ? new MethodModel(classModel.getName(), null) : (methodModel = new MethodModel(ExtAsApiGenerator.convertName(methodName), return_ == null ? "void" : ExtAsApiGenerator.convertType(return_.type)));
            if (return_ != null) {
                methodModel.addAnnotation(ExtAsApiGenerator.createArrayElementTypeAnnotation(return_.type));
            }
            methodModel.setAsdoc(ExtAsApiGenerator.toAsDoc(method, thisClassName, extClass.name));
            if (return_ != null) {
                methodModel.getReturnModel().setAsdoc(ExtAsApiGenerator.toAsDoc(return_, thisClassName, extClass.name));
            }
            ExtAsApiGenerator.setVisibility((MemberModel)methodModel, method);
            if (!extClass.singleton) {
                ExtAsApiGenerator.setStatic((MemberModel)methodModel, method);
            }
            ExtAsApiGenerator.addDeprecation(method.deprecatedMessage, method.deprecatedVersion, (AbstractAnnotatedModel)methodModel);
            List<ExtJsApi.Param> params = ExtAsApiGenerator.filterByType(methodItems, ExtJsApi.Param.class);
            ExtAsApiGenerator.makeUndocumentedTrailingParametersOptional(params);
            for (ExtJsApi.Param param : params) {
                if ("private".equals(param.access)) continue;
                String paramName = param.name == null ? "param" + (methodItems.indexOf(param) + 1) : ExtAsApiGenerator.convertName(param.name);
                ParamModel paramModel = new ParamModel(paramName, ExtAsApiGenerator.convertType(param.type));
                paramModel.setAsdoc(ExtAsApiGenerator.toAsDoc(param, false, thisClassName, extClass.name));
                ExtAsApiGenerator.setDefaultValue(paramModel, param);
                paramModel.setRest(param == params.get(params.size() - 1) && param.type.contains("..."));
                methodModel.addParam(paramModel);
            }
            try {
                classModel.addMember((MemberModel)methodModel);
            }
            catch (IllegalArgumentException e) {
                System.err.println("while adding method " + methodModel + ": " + e);
            }
        }
    }

    private static void makeUndocumentedTrailingParametersOptional(List<ExtJsApi.Param> params) {
        ExtJsApi.Param firstParam;
        if (params.size() > 1 && !ExtAsApiGenerator.isUndocumented(firstParam = params.get(0))) {
            ExtJsApi.Param param;
            for (int i = params.size() - 1; i > 0 && ExtAsApiGenerator.isUndocumented(param = params.get(i)); --i) {
                param.optional = true;
            }
        }
    }

    private static boolean isUndocumented(ExtJsApi.Param param) {
        return param.value == null && !param.optional && param.text.isEmpty() && param.type.isEmpty();
    }

    private static <S, T> List<S> filterByType(List<T> methodItems, Class<S> filterType) {
        return methodItems.stream().filter(filterType::isInstance).map(filterType::cast).collect(Collectors.toList());
    }

    private static String getThisClassName(ClassModel classModel, ExtJsApi.ExtClass extClass) {
        return extClass.singleton ? classModel.getName() : (classModel.isInterface() ? ExtAsApiGenerator.getActionScriptName(extClass) : "");
    }

    private static void setVisibility(MemberModel memberModel, ExtJsApi.Member member) {
        memberModel.setNamespace(extJsApi.isProtected(member) ? "protected" : "public");
    }

    private static void setStatic(MemberModel memberModel, ExtJsApi.Member member) {
        memberModel.setStatic(extJsApi.isStatic(member));
    }

    private static <T extends ExtJsApi.Tag> T getDelegateTag(T tag, String thisClassName) {
        if (tag.text.isEmpty() && tag.inheritdoc != null && !"true".equals(tag.inheritdoc)) {
            String reference = tag.inheritdoc;
            Object delegateTag = extJsApi.resolve(reference, thisClassName, tag.getClass());
            if (delegateTag != null) {
                System.out.println("+*+*+*+* Found 'inheritdoc' in " + thisClassName + "#" + tag.name + ": Dispatching to #" + ((ExtJsApi.Tag)delegateTag).name);
                return (T)delegateTag;
            }
            System.out.println("+*+*+*+* Could not resolve 'inheritdoc' " + tag.inheritdoc + ", ignoring.");
        }
        return tag;
    }

    private static String toAsDoc(ExtJsApi.Tag tag, String thisClassName, String thisJsClassName) {
        return ExtAsApiGenerator.toAsDoc(tag, true, thisClassName, thisJsClassName);
    }

    private static String toAsDoc(ExtJsApi.Tag tag, boolean isTopLevelProperty, String thisClassName, String thisJsClassName) {
        boolean isSubTag;
        List<ExtJsApi.Var> subParams;
        String value;
        StringBuilder asDoc = new StringBuilder();
        if (tag instanceof ExtJsApi.Method && ((ExtJsApi.Method)tag).template) {
            asDoc.append("\n<p class=\"template-method\"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>");
        }
        if ((tag instanceof ExtJsApi.Param || isTopLevelProperty && tag instanceof ExtJsApi.Var) && (value = ExtAsApiGenerator.getDefaultValue((ExtJsApi.Var)tag)) != null) {
            asDoc.append("\n@default ").append(value.replace("*", "&#42;"));
        }
        if (tag instanceof ExtJsApi.Member && ((ExtJsApi.Member)tag).since != null) {
            asDoc.append("\n@since ").append(((ExtJsApi.Member)tag).since);
        }
        if (tag instanceof ExtJsApi.Var && !(tag instanceof ExtJsApi.Method) && !(subParams = ((ExtJsApi.Var)tag).items).isEmpty()) {
            asDoc.append("\n<ul>");
            for (ExtJsApi.Var property : subParams) {
                asDoc.append("\n<li>");
                asDoc.append("<code>").append(property.name);
                String propertyType = ExtAsApiGenerator.convertType(property.type);
                if (propertyType != null && !"*".equals(propertyType)) {
                    asDoc.append(":").append(propertyType);
                }
                asDoc.append("</code>");
                String defaultValue = ExtAsApiGenerator.getDefaultValue(property);
                if (defaultValue != null) {
                    asDoc.append(" (default = <code>").append(defaultValue).append("</code>)");
                } else if (property instanceof ExtJsApi.Property && !((ExtJsApi.Property)property).required) {
                    asDoc.append(" (optional)");
                }
                String propertyAsDoc = ExtAsApiGenerator.toAsDoc(property, false, thisClassName, thisJsClassName);
                if (!propertyAsDoc.trim().isEmpty()) {
                    asDoc.append(" \u2014\n").append(propertyAsDoc).append("\n");
                }
                asDoc.append("</li>");
            }
            asDoc.append("\n</ul>");
        }
        if (tag instanceof ExtJsApi.ExtClass || tag instanceof ExtJsApi.Member && isTopLevelProperty) {
            String jsReference = thisJsClassName + ".html";
            if (tag instanceof ExtJsApi.Member) {
                jsReference = jsReference + String.format("#%s%s-%s", ((ExtJsApi.Member)tag).static_ ? "static-" : "", tag.$type, tag.name);
            }
            asDoc.append("\n@see " + ExtAsApiGenerator.getSenchaDocsBaseUrl()).append(jsReference).append(" Original Ext JS documentation of '").append(tag.name).append("'");
        }
        String result = asDoc.toString();
        if (tag instanceof ExtJsApi.Param) {
            result = result.replaceAll("\n+", "\n");
        }
        String mainAsDoc = tag.text;
        if (isTopLevelProperty && tag instanceof ExtJsApi.Property && ((ExtJsApi.Property)tag).required && !mainAsDoc.startsWith(REQUIRED_CONFIG_TEXT)) {
            mainAsDoc = REQUIRED_CONFIG_TEXT + mainAsDoc;
        } else if (tag instanceof ExtJsApi.ExtClass && "private".equals(tag.access)) {
            mainAsDoc = PRIVATE_CLASS_TEXT + mainAsDoc;
        }
        mainAsDoc = ExtAsApiGenerator.toAsDoc(mainAsDoc, thisClassName, thisJsClassName);
        boolean bl = isSubTag = !isTopLevelProperty || tag instanceof ExtJsApi.Param || tag instanceof ExtJsApi.Return;
        if (!isSubTag) {
            mainAsDoc = ExtAsApiGenerator.fixMissingFullStop(mainAsDoc);
        }
        return mainAsDoc + result;
    }

    private static String getDefaultValue(ExtJsApi.Var var) {
        String value = var.value;
        if (value != null) {
            value = value.replaceAll("(^|\\s)`([^`]+)`", "$1$2");
            String defaultValue = AS3Type.getDefaultValue((String)ExtAsApiGenerator.convertType(var.type));
            if (("null".equals(defaultValue) || "undefined".equals(defaultValue)) && defaultValue.equals(value)) {
                value = null;
            }
        }
        return value;
    }

    private static String getSenchaDocsBaseUrl() {
        return "https://docs.sencha.com/extjs/" + extJsApi.getVersion() + "/classic/";
    }

    private static String replaceTagSequence(String tagSequence, String replacementSequence, String doc) {
        String[] openAndCloseTags = ExtAsApiGenerator.openAndCloseTags(tagSequence.split(","));
        String[] openAndCloseTagsReplacement = ExtAsApiGenerator.openAndCloseTags(replacementSequence.split(","));
        return doc.replace(openAndCloseTags[0], openAndCloseTagsReplacement[0]).replace(openAndCloseTags[1], openAndCloseTagsReplacement[1]);
    }

    private static String[] openAndCloseTags(String[] tagSequence) {
        StringBuilder openTags = new StringBuilder();
        StringBuilder closeTags = new StringBuilder();
        for (String tag : tagSequence) {
            openTags.append("<" + tag + ">");
            closeTags.insert(0, "</" + tag + ">");
        }
        return new String[]{openTags.toString(), closeTags.toString()};
    }

    private static String toAsDoc(String doc, String thisClassName, String thisJsClassName) {
        int closingBracePos;
        int endTagPos;
        doc = doc.replaceAll("\\{@link\n(#.*})", "{@link $1\n");
        doc = doc.replaceAll(" *@example( preview)?\n", "@example\n\n");
        doc = doc.replaceAll("(&#[0-9]+)([^0-9;])", "$1;$2");
        doc = ExtAsApiGenerator.markdownToHtml(doc);
        doc = doc.replace("*", "&#42;");
        doc = doc.replace("&quot;", "\"");
        doc = doc.replace("<pre><code>", "<pre>\n").replace("</code></pre>", "</pre>");
        doc = doc.replace("<p>@example</p>", "<p><b>Example:</b></p>");
        doc = ExtAsApiGenerator.resolveRelativeLinks(doc);
        doc = ExtAsApiGenerator.replaceTagSequence("h1", "p,b", doc);
        doc = ExtAsApiGenerator.replaceTagSequence("h2", "p,b,i", doc);
        doc = ExtAsApiGenerator.replaceTagSequence("h3", "p,i", doc);
        doc = ExtAsApiGenerator.replaceTagSequence("h4", "p,i", doc);
        doc = ExtAsApiGenerator.processLinkTags(doc, thisClassName, thisJsClassName);
        String asDoc = doc.replaceAll("</?locale>", "");
        if ((asDoc = asDoc.trim()).startsWith("<p>") && (endTagPos = (asDoc = asDoc.substring(3)).indexOf("</p>")) != -1) {
            asDoc = asDoc.substring(0, endTagPos) + asDoc.substring(endTagPos + 4);
        }
        if (asDoc.startsWith("{") && (closingBracePos = asDoc.indexOf("} ")) != -1) {
            asDoc = asDoc.substring(closingBracePos + 2);
        }
        asDoc = asDoc.replaceAll("(<img[^>]*[^/])>", "$1/>");
        return asDoc;
    }

    private static String resolveRelativeLinks(String doc) {
        Matcher aHrefMatcher = Pattern.compile("(<a href=\")([^\"]+)").matcher(doc);
        StringBuffer result = new StringBuffer();
        String senchaDocsBaseUrl = ExtAsApiGenerator.getSenchaDocsBaseUrl();
        while (aHrefMatcher.find()) {
            String replacement = "$1$2";
            String url = aHrefMatcher.group(2);
            if (!url.startsWith("http")) {
                String href;
                try {
                    href = URI.create(senchaDocsBaseUrl).resolve(url).toString();
                }
                catch (IllegalArgumentException e) {
                    href = senchaDocsBaseUrl + url;
                }
                replacement = "$1" + href;
            }
            aHrefMatcher.appendReplacement(result, replacement);
        }
        aHrefMatcher.appendTail(result);
        return result.toString();
    }

    private static String fixMissingFullStop(String doc) {
        Matcher paragraphEndMatcher;
        if (!doc.isEmpty() && (paragraphEndMatcher = Pattern.compile("\\.|\n<pre|\n<p|\n<ul|\n<ol|\n<table").matcher(doc)).find(1)) {
            int start = paragraphEndMatcher.start();
            String match = paragraphEndMatcher.group();
            if (!match.equals(".")) {
                Matcher semicolonMatcher = Pattern.compile(";(\\s).").matcher(doc.substring(0, start));
                if (semicolonMatcher.find()) {
                    int semicolonPos = semicolonMatcher.start();
                    return doc.substring(0, semicolonPos) + "." + semicolonMatcher.group(1) + Character.toUpperCase(doc.charAt(semicolonPos + 2)) + doc.substring(semicolonPos + 3);
                }
                int beforeStart = start - 1;
                boolean isColon = doc.charAt(beforeStart) == ':';
                return doc.substring(0, isColon ? beforeStart : start) + (isColon || !"\n<p".equals(match) ? "..." : ".") + doc.substring(start);
            }
        }
        return doc;
    }

    private static String processLinkTags(String doc, String thisClassName, String thisJsClassName) {
        Matcher linkMatcher = INLINE_TAG_OR_LINK_PATTERN.matcher(doc);
        StringBuffer newDoc = new StringBuffer();
        LinkedHashSet<String> sees = new LinkedHashSet<String>();
        boolean insideCode = false;
        boolean insideEmphasised = false;
        while (linkMatcher.find()) {
            boolean renderLinkText;
            String codeTag = linkMatcher.group(2);
            if (codeTag != null) {
                boolean startTag = linkMatcher.group(1).isEmpty();
                switch (codeTag) {
                    case "code": {
                        insideCode = startTag;
                        break;
                    }
                    case "i": {
                        insideEmphasised = startTag;
                    }
                }
                linkMatcher.appendReplacement(newDoc, linkMatcher.group());
                continue;
            }
            String link = linkMatcher.group(4);
            String linkText = linkMatcher.group(5);
            if (linkText == null) {
                linkText = "";
            }
            JSDocReference jsDocReference = new JSDocReference(link);
            if (jsDocReference.url != null) {
                if (!jsDocReference.url.startsWith("http")) {
                    System.out.println("*** suspicious reference in {@link}: '" + jsDocReference.url + "'");
                }
            } else if (jsDocReference.getAsDocClassName("") == null) {
                invalidJsDocReferences.add(jsDocReference.jsClassName);
            }
            JSDocReference jsDocReferenceFromText = new JSDocReference(linkText);
            jsDocReference.merge(jsDocReferenceFromText);
            if (!jsDocReference.memberName.isEmpty() && jsDocReference.memberType.isEmpty()) {
                ExtJsApi.Member resolvedMember = extJsApi.resolve(jsDocReference.toString(), thisJsClassName, ExtJsApi.Member.class);
                if (resolvedMember == null) {
                    System.out.println("##### cannot resolve JSDoc reference " + jsDocReference.toString());
                } else {
                    jsDocReference.memberType = resolvedMember.$type;
                }
            }
            String rewrittenLink = jsDocReference.toAsString(true);
            boolean addThisClass = "".equals(jsDocReference.jsClassName) && !"".equals(thisClassName);
            String realLink = jsDocReference.toAsString(false);
            String see = (addThisClass ? thisClassName : "") + realLink;
            if (!realLink.equals(rewrittenLink)) {
                see = see + " " + rewrittenLink;
            }
            sees.add(see);
            String replacement = ExtAsApiGenerator.prettyPrintLinks(rewrittenLink);
            replacement = "\u2192" + (insideCode ? replacement : ExtAsApiGenerator.html("code", replacement));
            boolean bl = renderLinkText = !linkText.isEmpty() && (insideEmphasised || !jsDocReference.linkTextRephrasesLink(linkText));
            if (renderLinkText) {
                linkText = ExtAsApiGenerator.prettyPrintLinks(linkText);
                replacement = (insideEmphasised || insideCode ? linkText : ExtAsApiGenerator.html("i", linkText)) + " (" + replacement + ")";
            }
            replacement = replacement.replace("$", "\\$");
            linkMatcher.appendReplacement(newDoc, replacement);
        }
        linkMatcher.appendTail(newDoc);
        int lastIndex = newDoc.length() - 1;
        if (lastIndex >= 0 && newDoc.charAt(lastIndex) == '\n') {
            newDoc.setLength(lastIndex);
        }
        for (String see : sees) {
            newDoc.append("\n@see ").append(see);
        }
        doc = newDoc.toString();
        return doc;
    }

    private static String prettyPrintLinks(String link) {
        return link.replaceAll("(\\s|^)#", "$1").replace('#', '.');
    }

    private static String html(String tag, String text) {
        return MessageFormat.format("<{0}>{1}</{0}>", tag, text);
    }

    private static String markdownToHtml(String doc) {
        MutableDataSet options = new MutableDataSet();
        options.set(Parser.EXTENSIONS, Arrays.asList(TablesExtension.create()));
        options.set(HtmlRenderer.FORMAT_FLAGS, (Object)7);
        options.set(Parser.HEADING_NO_ATX_SPACE, (Object)true);
        options.set(HtmlRenderer.EMPHASIS_STYLE_HTML_OPEN, (Object)"<i>");
        options.set(HtmlRenderer.EMPHASIS_STYLE_HTML_CLOSE, (Object)"</i>");
        options.set(HtmlRenderer.STRONG_EMPHASIS_STYLE_HTML_OPEN, (Object)"<b>");
        options.set(HtmlRenderer.STRONG_EMPHASIS_STYLE_HTML_CLOSE, (Object)"</b>");
        Parser parser = Parser.builder((DataHolder)options).build();
        HtmlRenderer renderer = HtmlRenderer.builder((DataHolder)options).build();
        Document document = parser.parse(doc);
        return renderer.render((Node)document);
    }

    private static void setDefaultValue(ParamModel paramModel, ExtJsApi.Param param) {
        String defaultValue = param.value;
        if (defaultValue != null && NON_COMPILE_TIME_CONSTANT_INITIALIZERS.contains(defaultValue)) {
            paramModel.setAsdoc("(Default " + defaultValue + ") " + paramModel.getAsdoc());
            defaultValue = null;
            param.optional = true;
        }
        if (defaultValue == null && param.optional) {
            defaultValue = AS3Type.getDefaultValue((String)paramModel.getType());
        }
        if (defaultValue != null && "String".equals(param.type) && !defaultValue.equals("null") && !defaultValue.startsWith("'") && !defaultValue.startsWith("\"")) {
            defaultValue = CompilerUtils.quote((String)defaultValue);
        }
        paramModel.setValue(defaultValue);
    }

    private static String convertName(String name) {
        return "is".equals(name = ExtAsApiGenerator.replaceSeparatorByCamelCase(name, '-')) ? "matches" : ("class".equals(name) ? "cls" : ("this".equals(name) ? "source" : ("new".equals(name) ? "new_" : ("default".equals(name) ? "default_" : ("catch".equals(name) ? "catch_" : ("override".equals(name) ? "override_" : ("include".equals(name) ? "include_" : name)))))));
    }

    private static String replaceSeparatorByCamelCase(String string, char separator) {
        int separatorPos;
        while ((separatorPos = string.indexOf(separator)) != -1) {
            string = string.substring(0, separatorPos) + string.substring(separatorPos + 1, separatorPos + 2).toUpperCase() + string.substring(separatorPos + 2);
        }
        return string;
    }

    private static String convertToInterface(String className) {
        if (className == null || className.isEmpty() || !interfaces.contains(className)) {
            return null;
        }
        String interfaceName = "I" + CompilerUtils.className((String)className);
        if (interfaceName.endsWith("Impl")) {
            interfaceName = interfaceName.substring(0, interfaceName.length() - 4);
        }
        return CompilerUtils.qName((String)CompilerUtils.packageName((String)className), (String)interfaceName);
    }

    private static String convertType(String extType) {
        if (extType == null) {
            return null;
        }
        if ("undefined".equals(extType) || "null".equals(extType)) {
            return "void";
        }
        if ("number".equals(extType) || "boolean".equals(extType) || "string".equals(extType)) {
            return ExtAsApiGenerator.capitalize(extType);
        }
        if ("HTMLElement".equals(extType) || "Event".equals(extType) || "XMLHttpRequest".equals(extType)) {
            return "js." + extType;
        }
        if ("google.maps.Map".equals(extType) || "CSSStyleSheet".equals(extType) || "CSSStyleRule".equals(extType)) {
            return "Object";
        }
        if (extType.startsWith("Ext.enums.") || extType.matches("(['\"].*['\"]/)*['\"].*['\"]")) {
            return "String";
        }
        if (extType.contains("...")) {
            return null;
        }
        if (TYPED_ARRAY_PATTERN.matcher(extType).matches()) {
            return "Array";
        }
        if (!extType.matches("[a-zA-Z0-9._$<>]+") || "Mixed".equals(extType)) {
            return "*";
        }
        if (JsCodeGenerator.PRIMITIVES.contains(extType)) {
            return extType;
        }
        ExtJsApi.ExtClass extClass = extJsApi.getExtClass(extType);
        if (extClass == null) {
            System.err.println("Warning: No Ext class '" + extType + "' found, falling back to Object");
            return "Object";
        }
        String qName = ExtAsApiGenerator.getActionScriptName(extClass);
        if (qName == null || qName.isEmpty()) {
            return ExtAsApiGenerator.convertType(extClass.extends_);
        }
        if (ExtJsApi.isSingleton(extClass)) {
            qName = CompilerUtils.qName((String)CompilerUtils.packageName((String)qName), (String)("S" + CompilerUtils.className((String)qName)));
        }
        return qName;
    }

    private static AnnotationModel createArrayElementTypeAnnotation(String extType) {
        String arrayElementType;
        Matcher matcher;
        if (extType != null && (matcher = TYPED_ARRAY_PATTERN.matcher(extType)).matches() && !"*".equals(arrayElementType = ExtAsApiGenerator.convertType(matcher.group(1))) && !"Object".equals(arrayElementType)) {
            return new AnnotationModel("ArrayElementType", new AnnotationPropertyModel[]{new AnnotationPropertyModel(null, CompilerUtils.quote((String)arrayElementType))});
        }
        return null;
    }

    private static void removePrivateApiClasses() {
        HashSet<ExtJsApi.ExtClass> privateClasses = new HashSet<ExtJsApi.ExtClass>();
        for (ExtJsApi.ExtClass extClass : extClasses) {
            ExtAsApiGenerator.replaceMixin(extClass, "Ext.util.Observable", "Ext.mixin.Observable");
            ExtAsApiGenerator.replaceMixinByExtends(extClass, "Ext.dom.Element");
            String actionScriptName = ExtAsApiGenerator.getActionScriptName(extClass);
            if (actionScriptName != null && !actionScriptName.isEmpty() || !"private".equals(extClass.access) && !JsCodeGenerator.PRIMITIVES.contains(extClass.name) && !extClass.name.startsWith("Ext.enums.")) continue;
            privateClasses.add(extClass);
        }
        for (ExtJsApi.ExtClass extClass : extClasses) {
            if (privateClasses.contains(extClass)) continue;
            ExtAsApiGenerator.markPublic(privateClasses, extClass.name);
        }
        extClasses.removeAll(privateClasses);
        ArrayList<String> missingMappings = new ArrayList<String>();
        for (ExtJsApi.ExtClass extClass : extClasses) {
            if (ExtAsApiGenerator.getActionScriptName(extClass) != null) continue;
            missingMappings.add(extClass.name + " = " + extClass.name.substring(0, 1).toLowerCase() + extClass.name.substring(1) + (extClass.deprecated ? " DEPRECATED" : "") + ("private".equals(extClass.access) ? " (private)" : "") + (extClass.alias != null ? " // " + extClass.alias : ""));
        }
        Collections.sort(missingMappings);
        System.out.println("*****ADD TO JS-AS-NAME-MAPPING:");
        for (String missingMapping : missingMappings) {
            System.out.println(missingMapping);
        }
        System.out.println("*****END ADD TO JS-AS-NAME-MAPPING");
    }

    private static CompilationUnitModel getReferenceDeclaration(String jooClassName) {
        List<CompilationUnitModel> referenceDeclarations = ExtAsApiGenerator.getReferenceDeclarations(jooClassName);
        return referenceDeclarations.isEmpty() ? null : referenceDeclarations.get(0);
    }

    private static List<CompilationUnitModel> getReferenceDeclarations(String jooClassName) {
        return referenceApi.getCompilationUnitModels(jooClassName);
    }

    private static void replaceMixin(ExtJsApi.ExtClass extClass, String mixinImpl, String mixin) {
        int mixinImplIndex = extClass.mixins.indexOf(mixinImpl);
        if (mixinImplIndex != -1) {
            extClass.mixins.set(mixinImplIndex, mixin);
        }
        ExtAsApiGenerator.replaceMixinByExtends(extClass, mixin);
    }

    private static void replaceMixinByExtends(ExtJsApi.ExtClass extClass, String mixin) {
        if ("Ext.Base".equals(extClass.extends_) && extClass.mixins.contains(mixin)) {
            extClass.mixins.remove(mixin);
            extClass.extends_ = mixin;
        }
    }

    private static void markPublic(Set<ExtJsApi.ExtClass> privateClasses, String extClassName) {
        ExtJsApi.ExtClass extClass = extJsApi.getExtClass(extClassName);
        if (extClass == null) {
            System.err.println("*** extends-reference to undeclared class " + extClassName);
            return;
        }
        if (privateClasses.remove(extClass)) {
            // empty if block
        }
        if (extClass.extends_ != null) {
            ExtAsApiGenerator.markPublic(privateClasses, extClass.extends_);
        }
        for (String mixin : extClass.mixins) {
            ExtAsApiGenerator.markPublic(privateClasses, mixin);
        }
    }

    private static String getActionScriptName(ExtJsApi.ExtClass extClass) {
        return ExtAsApiGenerator.getActionScriptName(extClass.name);
    }

    private static String getActionScriptName(String extClass) {
        return jsAsNameMappingProperties.getProperty(extClass);
    }

    private static void annotateBindableConfigProperties() {
        for (CompilationUnitModel compilationUnitModel : compilationUnitModelRegistry.getCompilationUnitModels()) {
            ClassModel classModel = compilationUnitModel.getClassModel();
            if (classModel == null) continue;
            ExtAsApiGenerator.annotateBindableConfigProperties(classModel);
        }
    }

    private static void annotateBindableConfigProperties(ClassModel classModel) {
        List members = classModel.getMembers();
        for (MemberModel member : members) {
            if (!member.isGetter()) continue;
            ExtAsApiGenerator.annotateBindableConfigProperty(classModel, (MethodModel)member);
        }
        for (MemberModel member : members) {
            if (!member.isSetter()) continue;
            ExtAsApiGenerator.annotateBindableConfigProperty(classModel, (MethodModel)member);
        }
    }

    private static void annotateBindableConfigProperty(ClassModel classModel, MethodModel accessor) {
        List annotations = accessor.getAnnotations("ExtConfig");
        if (annotations.isEmpty()) {
            return;
        }
        String prefix = accessor.getMethodType().toString();
        String propertyType = ExtAsApiGenerator.getMethodType(accessor, accessor.getMethodType());
        if (propertyType == null) {
            ExtAsApiGenerator.warnConfigProperty(prefix + " property accessor without type", classModel, accessor);
            return;
        }
        AnnotationPropertyModel annotationPropertyModel = (AnnotationPropertyModel)((AnnotationModel)annotations.get(0)).getPropertiesByName().get(null);
        String propertyName = annotationPropertyModel == null ? accessor.getName() : annotationPropertyModel.getStringValue();
        String methodName = prefix + ExtAsApiGenerator.capitalize(propertyName);
        MethodModel method = compilationUnitModelRegistry.resolveMethod(classModel, null, methodName);
        if (method == null) {
            ExtAsApiGenerator.warnConfigProperty("no matching " + prefix + "ter method", classModel, accessor);
            return;
        }
        List methodParams = method.getParams();
        if (accessor.isSetter() && methodParams.isEmpty()) {
            ExtAsApiGenerator.warnConfigProperty(String.format("matching setter method '%s' without parameters. Still marking property as [Bindable] - assuming it's compatible at runtime.", method.getName()), classModel, accessor);
        } else {
            List moreParams = accessor.isSetter() ? methodParams.subList(1, methodParams.size()) : methodParams;
            for (ParamModel param : moreParams) {
                if (param.isOptional()) continue;
                ExtAsApiGenerator.warnConfigProperty(String.format("matching %ster method '%s' has additional non-optional parameter '%s'", prefix, method.getName(), param.getName()), classModel, accessor);
                return;
            }
            String methodType = ExtAsApiGenerator.getMethodType(method, accessor.getMethodType());
            if (!propertyType.equals(methodType)) {
                boolean probablyCompatible;
                boolean bl = probablyCompatible = "*".equals(propertyType) || "*".equals(methodType) || "Object".equals(propertyType) || "Object".equals(methodType);
                if (!probablyCompatible) {
                    ExtAsApiGenerator.warnConfigProperty(String.format("type '%s' does not match method '%s' with type '%s'", propertyType, method.getName(), methodType), classModel, accessor);
                    return;
                }
                ExtAsApiGenerator.warnConfigProperty(String.format("type '%s' does not quite match method '%s' with type '%s'. Still marking property as [Bindable] - assuming it's compatible at runtime.", propertyType, method.getName(), methodType), classModel, accessor);
            }
        }
        if (accessor.getAnnotations("Bindable").isEmpty()) {
            accessor.addAnnotation(new AnnotationModel("Bindable", new AnnotationPropertyModel[]{new AnnotationPropertyModel("style", "\"methods\"")}));
        }
        MethodModel documentedMethod = null;
        if (accessor.isSetter()) {
            documentedMethod = classModel.getMethod(accessor.isStatic(), MethodType.GET, accessor.getName());
        }
        if (documentedMethod == null) {
            documentedMethod = accessor;
        }
        String asDoc = documentedMethod.getAsdoc();
        documentedMethod.setAsdoc((asDoc == null ? "" : asDoc) + "\n@see #" + methodName + "()");
    }

    private static String getMethodType(MethodModel method, MethodType methodType) {
        if (methodType == MethodType.GET) {
            return method.getType();
        }
        List propertySetterParams = method.getParams();
        if (propertySetterParams.isEmpty()) {
            return null;
        }
        return ((ParamModel)propertySetterParams.get(0)).getType();
    }

    private static void warnConfigProperty(String message, ClassModel classModel, MethodModel propertySetter) {
        System.err.format("!!! Config property %s#%s: %s\n", classModel.getName(), propertySetter.getName(), message);
    }

    static {
        NON_COMPILE_TIME_CONSTANT_INITIALIZERS = Arrays.asList("window", "document", "document.body", "new Date()", "this", "`this`", "10||document.body", "caller", "array.length");
        invalidJsDocReferences = new HashSet<String>();
        aliasGroupToAliasToClass = new TreeMap<String, Map<String, String>>();
    }

    private static class JSDocReference {
        private static final Pattern JSDOC_REF_PATTERN = Pattern.compile("^([A-Z][A-Za-z0-9_$.]*)?(?:#(?:(method|static-method|cfg|property|static-property|event|var|sass-mixin)[!-])?([a-zA-Z0-9_$-]+)(\\(\\))?)?$");
        String url = null;
        String actionScriptClassName = "";
        String jsClassName = "";
        String memberType = "";
        String memberName = "";
        boolean hasParentheses;

        private JSDocReference(String jsDocReference) {
            Matcher jsDocRefMatcher = JSDOC_REF_PATTERN.matcher(jsDocReference);
            if (jsDocRefMatcher.matches()) {
                this.jsClassName = this.nullToEmptyString(jsDocRefMatcher.group(1));
                this.memberType = this.nullToEmptyString(jsDocRefMatcher.group(2));
                this.memberName = this.nullToEmptyString(jsDocRefMatcher.group(3));
                this.hasParentheses = jsDocRefMatcher.group(4) != null;
            } else {
                this.url = jsDocReference;
            }
        }

        boolean linkTextRephrasesLink(String linkText) {
            StringBuilder regExpBuilder = new StringBuilder();
            String packageName = CompilerUtils.packageName((String)this.jsClassName);
            String className = CompilerUtils.className((String)this.jsClassName);
            String asDocQualifiedClassName = this.getAsDocClassName("");
            if (asDocQualifiedClassName == null) {
                asDocQualifiedClassName = this.jsClassName;
            }
            String asDocClassName = CompilerUtils.className((String)asDocQualifiedClassName);
            if (!className.isEmpty()) {
                regExpBuilder.append("(");
                if (!packageName.isEmpty()) {
                    regExpBuilder.append("(").append(packageName.replace(".", "\\.")).append("\\.)?");
                }
                regExpBuilder.append("(");
                regExpBuilder.append(className);
                if (!asDocClassName.equals(className)) {
                    regExpBuilder.append("|").append(asDocClassName);
                }
                regExpBuilder.append(")");
                if (!this.memberName.isEmpty()) {
                    regExpBuilder.append("([#.])");
                }
                regExpBuilder.append(")?");
            } else {
                regExpBuilder.append("(#)?");
            }
            if (!this.memberName.isEmpty()) {
                if (!this.memberType.isEmpty()) {
                    regExpBuilder.append("(").append(this.memberType).append("[-!])?");
                }
                regExpBuilder.append(this.memberName);
                if (this.isMethod()) {
                    regExpBuilder.append("(\\(\\))?");
                }
            }
            Matcher matcher = Pattern.compile(regExpBuilder.toString()).matcher(linkText);
            return matcher.matches();
        }

        private String nullToEmptyString(String group) {
            return group == null ? "" : group;
        }

        boolean isMethod() {
            return this.hasParentheses || this.memberType.contains("method");
        }

        private boolean isEvent() {
            return this.memberType.equals("event");
        }

        void merge(JSDocReference other) {
            if (this.url != null || other.url != null) {
                return;
            }
            if (this.hasParentheses || other.hasParentheses) {
                other.hasParentheses = true;
                this.hasParentheses = true;
            }
            if (this.memberType.isEmpty()) {
                this.memberType = other.memberType;
            } else if (other.memberType.isEmpty()) {
                other.memberType = this.memberType;
            }
        }

        String toAsString(boolean asLinkText) {
            boolean singleton;
            if (this.url != null) {
                return this.url;
            }
            ExtJsApi.ExtClass extClass = extJsApi.getExtClass(this.jsClassName);
            boolean bl = singleton = extClass != null && extClass.singleton;
            String asDocClassName = this.getAsDocClassName(asLinkText ? "" : (this.memberName.isEmpty() ? "#" : "S"));
            if (this.actionScriptClassName == null) {
                return null;
            }
            StringBuilder builder = new StringBuilder();
            builder.append(asDocClassName);
            if (!this.memberName.isEmpty()) {
                builder.append(asLinkText && singleton ? "." : "#");
                if (this.isEvent()) {
                    String flexEventName = "on" + ExtAsApiGenerator.toCamelCase(this.memberName);
                    builder.append("event:").append(flexEventName);
                } else if (this.memberName.startsWith("$")) {
                    builder.append("style:").append(this.memberName);
                } else {
                    builder.append(ExtAsApiGenerator.convertName(this.memberName));
                    if (this.isMethod()) {
                        builder.append("()");
                    }
                }
            }
            return builder.toString();
        }

        private String getAsDocClassName(String singletonPrefix) {
            if (this.jsClassName.isEmpty()) {
                return "";
            }
            ExtJsApi.ExtClass extClass = extJsApi.getExtClass(this.jsClassName);
            if (extClass != null) {
                String actionScriptName = ExtAsApiGenerator.getActionScriptName(extClass);
                if (actionScriptName != null && !actionScriptName.isEmpty()) {
                    if (extClass.singleton) {
                        return CompilerUtils.qName((String)CompilerUtils.packageName((String)actionScriptName), (String)(singletonPrefix + CompilerUtils.className((String)actionScriptName)));
                    }
                    return actionScriptName;
                }
                if (!this.jsClassName.contains(".")) {
                    return this.jsClassName;
                }
            }
            return null;
        }

        public String toString() {
            return this.url != null ? this.url : this.jsClassName + (this.memberName.isEmpty() ? "" : "#" + (this.memberType.isEmpty() ? "" : this.memberType + "!") + this.memberName + (this.isMethod() ? "()" : ""));
        }

        public boolean equals(Object obj) {
            return obj instanceof JSDocReference && this.toString().equals(obj.toString());
        }
    }
}

