/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.tools;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.jangaroo.jooc.CompilerError;
import net.jangaroo.jooc.JangarooParser;
import net.jangaroo.jooc.StdOutCompileLog;
import net.jangaroo.jooc.api.CompileLog;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.backend.ApiModelGenerator;
import net.jangaroo.jooc.config.ParserOptions;
import net.jangaroo.jooc.config.SemicolonInsertionMode;
import net.jangaroo.jooc.input.InputSource;
import net.jangaroo.jooc.input.PathInputSource;
import net.jangaroo.jooc.model.CompilationUnitModel;
import net.jangaroo.jooc.model.CompilationUnitModelRegistry;
import net.jangaroo.jooc.util.MessageFormat;
import net.jangaroo.utils.CompilerUtils;

public class ExtAsApi {
    private Properties extJsNameMappingProperties = new Properties();
    private final ApiModelGenerator apiModelGenerator;
    private JangarooParser jangarooParser;
    private CompilationUnitModelRegistry compilationUnitModelRegistry;

    public ExtAsApi(String jangarooRuntimeVersion, String jangarooLibsVersion) throws IOException {
        this.extJsNameMappingProperties.load(this.getClass().getClassLoader().getResourceAsStream("net/jangaroo/exml/tools/ext-js-3.4-6.0-name-mapping.properties"));
        this.jangarooParser = ExtAsApi.getParser(jangarooRuntimeVersion, jangarooLibsVersion);
        this.compilationUnitModelRegistry = new CompilationUnitModelRegistry();
        this.apiModelGenerator = new ApiModelGenerator(false);
    }

    private static JangarooParser getParser(String jangarooRuntimeVersion, String jangarooLibsVersion) {
        return ExtAsApi.getParser(Arrays.asList(ExtAsApi.getMavenArtifact("net.jangaroo", "jangaroo-runtime", jangarooRuntimeVersion, null), ExtAsApi.getMavenArtifact("net.jangaroo", "jangaroo-browser", jangarooLibsVersion, null)), ExtAsApi.getMavenArtifact("net.jangaroo", "ext-as", jangarooLibsVersion, "sources"), (CompileLog)new StdOutCompileLog());
    }

    public List<CompilationUnitModel> getCompilationUnitModels(String newName) {
        ArrayList<CompilationUnitModel> result = new ArrayList<CompilationUnitModel>();
        for (String qName : this.getReferenceQNames(newName)) {
            CompilationUnit compilationUnit;
            CompilationUnitModel compilationUnitModel = this.compilationUnitModelRegistry.resolveCompilationUnit(qName);
            if (compilationUnitModel == null && (compilationUnit = this.jangarooParser.getCompilationUnit(qName)) != null && compilationUnit.isInSourcePath()) {
                compilationUnit.analyze(null);
                try {
                    compilationUnitModel = this.apiModelGenerator.generateModel(compilationUnit);
                    this.compilationUnitModelRegistry.register(compilationUnitModel);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (compilationUnitModel == null) continue;
            result.add(compilationUnitModel);
        }
        return result;
    }

    private boolean isQualifiedName(String qName) {
        return this.compilationUnitModelRegistry.resolveCompilationUnit(qName) != null || this.jangarooParser.getCompilationUnit(qName) != null;
    }

    public String getMappedQName(String originalQName) {
        return originalQName == null ? null : this.extJsNameMappingProperties.getProperty(originalQName, originalQName);
    }

    public List<String> getReferenceQNames(String newQName) {
        if (newQName == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<Object, Object> entry : this.extJsNameMappingProperties.entrySet()) {
            if (!newQName.equals(entry.getValue())) continue;
            result.add((String)entry.getKey());
        }
        if (result.isEmpty()) {
            result.add(newQName);
        }
        return result;
    }

    public String getMappedMemberName(CompilationUnitModel compilationUnitModel, String originalMemberName) {
        return this.extJsNameMappingProperties.getProperty(compilationUnitModel.getQName() + "#" + originalMemberName, originalMemberName);
    }

    public String resolveQualifiedName(CompilationUnitModel context, String name) {
        String originalQualifiedName = this.resolveOriginalQualifiedName(context, name);
        return this.getMappedQName(originalQualifiedName);
    }

    private String resolveOriginalQualifiedName(CompilationUnitModel context, String name) {
        if (name == null) {
            return null;
        }
        if (name.contains(".")) {
            return name;
        }
        ArrayList<String> imports = new ArrayList<String>(context.getImports());
        if (context.getPackage().length() > 0) {
            imports.add(context.getPackage() + ".*");
        }
        imports.add("*");
        for (String anImport : imports) {
            String unqualified = CompilerUtils.className((String)anImport);
            if (unqualified.equals("*")) {
                String qName = CompilerUtils.qName((String)CompilerUtils.packageName((String)anImport), (String)name);
                if (!this.isQualifiedName(qName)) continue;
                return qName;
            }
            if (!unqualified.equals(name)) continue;
            return anImport;
        }
        return name;
    }

    private static File getMavenArtifact(String groupId, String artifactId, String version, String classifier) {
        String mavenRepository = ExtAsApi.getMavenRepository();
        return new File(mavenRepository + groupId.replace('.', '/') + new MessageFormat("/{0}/{1}/{0}-{2}.jar").format(new Object[]{artifactId, version, classifier == null ? version : version + "-" + classifier}));
    }

    private static String getMavenRepository() {
        return System.getProperty("maven.repo.local", System.getProperty("user.home") + "/.m2/repository/");
    }

    private static JangarooParser getParser(List<File> classPath, File sourceRoot, CompileLog log) {
        PathInputSource classPathInputSource;
        PathInputSource sourcePathInputSource;
        JangarooParser jangarooParser = new JangarooParser(new ParserOptions(){

            public SemicolonInsertionMode getSemicolonInsertionMode() {
                return SemicolonInsertionMode.ERROR;
            }

            public boolean isVerbose() {
                return false;
            }
        }, log);
        try {
            sourcePathInputSource = PathInputSource.fromFiles(Collections.singletonList(sourceRoot), (String[])new String[]{""}, (boolean)true);
            classPathInputSource = PathInputSource.fromFiles(classPath, (String[])new String[]{"", "META-INF/joo-api/"}, (boolean)false);
        }
        catch (IOException e) {
            throw new CompilerError("IO Exception occurred", (Throwable)e);
        }
        jangarooParser.setUp((InputSource)sourcePathInputSource, (InputSource)classPathInputSource);
        return jangarooParser;
    }

    private static void parseDirectory(JangarooParser jangarooParser, InputSource sourcePathInputSource) {
        for (InputSource inputSource : sourcePathInputSource.list()) {
            if (inputSource.isDirectory()) {
                ExtAsApi.parseDirectory(jangarooParser, inputSource);
                continue;
            }
            CompilationUnit compilationUnit = jangarooParser.importSource(inputSource);
            System.out.println("Parsed: " + compilationUnit.getPrimaryDeclaration().getQualifiedNameStr());
        }
    }

    public static void main(String[] argv) {
        ExtAsApi.getParser(argv[0], argv[1]);
    }
}

