/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import net.jangaroo.exml.tools.ExtAsApi;
import net.jangaroo.exml.tools.ExtJsApi;
import net.jangaroo.jooc.backend.ActionScriptCodeGeneratingModelVisitor;
import net.jangaroo.jooc.backend.JsCodeGenerator;
import net.jangaroo.jooc.model.AbstractAnnotatedModel;
import net.jangaroo.jooc.model.AnnotationModel;
import net.jangaroo.jooc.model.AnnotationPropertyModel;
import net.jangaroo.jooc.model.ClassModel;
import net.jangaroo.jooc.model.CompilationUnitModel;
import net.jangaroo.jooc.model.CompilationUnitModelRegistry;
import net.jangaroo.jooc.model.FieldModel;
import net.jangaroo.jooc.model.MemberModel;
import net.jangaroo.jooc.model.MethodModel;
import net.jangaroo.jooc.model.MethodType;
import net.jangaroo.jooc.model.ModelVisitor;
import net.jangaroo.jooc.model.NamedModel;
import net.jangaroo.jooc.model.ParamModel;
import net.jangaroo.jooc.model.PropertyModel;
import net.jangaroo.jooc.model.TypedModel;
import net.jangaroo.utils.AS3Type;
import net.jangaroo.utils.CompilerUtils;

public class ExtAsApiGenerator {
    private static final Pattern SINGLETON_CLASS_NAME_PATTERN = Pattern.compile("^S[A-Z]");
    private static ExtJsApi extJsApi;
    private static Set<ExtJsApi.ExtClass> extClasses;
    private static CompilationUnitModelRegistry compilationUnitModelRegistry;
    private static Set<String> interfaces;
    private static final List<String> NON_COMPILE_TIME_CONSTANT_INITIALIZERS;
    private static ExtAsApi referenceApi;
    private static boolean generateEventClasses;
    private static boolean generateForMxml;
    private static Properties jsAsNameMappingProperties;
    private static Properties jsConfigClassNameMappingProperties;
    private static Properties eventWordsProperties;
    private static final String EXT_3_4_EVENT = "ext.IEventObject";
    private static String EXT_EVENT;
    private static Map<String, Map<String, String>> aliasGroupToAliasToClass;

    public static void main(String[] args) throws IOException {
        File srcDir = new File(args[0]);
        File outputDir = new File(args[1]);
        referenceApi = new ExtAsApi("2.0.14", "2.0.13");
        EXT_EVENT = referenceApi.getMappedQName(EXT_3_4_EVENT);
        if (EXT_EVENT == null) {
            EXT_EVENT = EXT_3_4_EVENT;
        }
        generateEventClasses = args.length <= 2 || Boolean.valueOf(args[2]) != false;
        generateForMxml = args.length <= 3 ? false : Boolean.valueOf(args[3]);
        jsAsNameMappingProperties.load(ExtAsApiGenerator.class.getClassLoader().getResourceAsStream("net/jangaroo/exml/tools/js-as-name-mapping.properties"));
        jsConfigClassNameMappingProperties.load(ExtAsApiGenerator.class.getClassLoader().getResourceAsStream("net/jangaroo/exml/tools/js-config-name-mapping.properties"));
        eventWordsProperties.load(ExtAsApiGenerator.class.getClassLoader().getResourceAsStream("net/jangaroo/exml/tools/event-words.properties"));
        File[] files = srcDir.listFiles();
        if (files != null) {
            compilationUnitModelRegistry = new CompilationUnitModelRegistry();
            interfaces = new HashSet<String>();
            extJsApi = new ExtJsApi(files);
            extClasses = new HashSet<ExtJsApi.ExtClass>(extJsApi.getExtClasses());
            ExtAsApiGenerator.removePrivateApiClasses();
            Set<ExtJsApi.ExtClass> mixins = extJsApi.getMixins();
            for (ExtJsApi.ExtClass mixin : mixins) {
                String mixinName = ExtAsApiGenerator.getActionScriptName(mixin);
                if (mixinName == null) continue;
                interfaces.add(mixinName);
            }
            interfaces.remove("ext.util.Observable");
            interfaces.remove("ext.dom.Element");
            interfaces.remove("ext.Base");
            interfaces.remove("Object");
            interfaces.add("ext.EventObjectImpl");
            for (ExtJsApi.ExtClass extClass : extClasses) {
                ExtAsApiGenerator.generateClassModel(extClass);
            }
            compilationUnitModelRegistry.complementOverrides();
            compilationUnitModelRegistry.complementImports();
            ExtAsApiGenerator.adaptToReferenceApi();
            ExtAsApiGenerator.annotateBindableConfigProperties();
            if (!outputDir.exists()) {
                System.err.println("No output directory specified, skipping code generation.");
                return;
            }
            for (CompilationUnitModel compilationUnitModel : compilationUnitModelRegistry.getCompilationUnitModels()) {
                ExtAsApiGenerator.generateActionScriptCode(compilationUnitModel, outputDir);
            }
        }
        ExtAsApiGenerator.generateManifest(outputDir);
    }

    private static void generateManifest(File outputDir) throws FileNotFoundException, UnsupportedEncodingException {
        File outputFile = new File(outputDir, "manifest.xml");
        System.out.printf("Creating manifest file %s...%n", outputFile.getPath());
        PrintStream out = new PrintStream((OutputStream)new FileOutputStream(outputFile), true, "UTF-8");
        out.println("<?xml version=\"1.0\"?>");
        out.println("<componentPackage>");
        for (String aliasGroup : aliasGroupToAliasToClass.keySet()) {
            String previousId = "";
            for (Map.Entry<String, String> aliasToClass : aliasGroupToAliasToClass.get(aliasGroup).entrySet()) {
                String id;
                String alias = aliasToClass.getKey();
                String classQName = aliasToClass.getValue();
                previousId = id = ExtAsApiGenerator.computeId(alias, classQName + previousId);
                if (!"widget".equals(aliasGroup)) {
                    id = aliasGroup + "_" + id;
                }
                out.printf("  <component id=\"%s\" class=\"%s\"/>%n", id, classQName);
            }
        }
        out.println("</componentPackage>");
        out.close();
    }

    private static String computeId(String alias, String classQName) {
        int dotPos = alias.indexOf(46);
        if (dotPos != -1) {
            return ExtAsApiGenerator.computeId(alias.substring(dotPos + 1), classQName) + ExtAsApiGenerator.capitalize(alias.substring(0, dotPos));
        }
        alias = alias.replaceAll("-", "");
        String className = CompilerUtils.className((String)classQName);
        String[] words = className.split("(?<!^)(?=[A-Z])");
        int index = 0;
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            int wordIndex = alias.indexOf(word.toLowerCase(), index);
            if (wordIndex == -1) continue;
            result.append(ExtAsApiGenerator.capitalize(alias.substring(index, wordIndex)));
            result.append(word);
            index = wordIndex + word.length();
        }
        result.append(ExtAsApiGenerator.capitalize(alias.substring(index)));
        return result.toString();
    }

    private static void adaptToReferenceApi() {
        System.err.printf("Class\tremoved\tchanged\tsame%n", new Object[0]);
        for (CompilationUnitModel compilationUnitModel : compilationUnitModelRegistry.getCompilationUnitModels()) {
            String qName = compilationUnitModel.getQName();
            NamedModel primaryDeclaration = compilationUnitModel.getPrimaryDeclaration();
            if (primaryDeclaration instanceof FieldModel) {
                String singletonType = ((FieldModel)primaryDeclaration).getType();
                compilationUnitModel = compilationUnitModelRegistry.resolveCompilationUnit(singletonType);
                CompilationUnitModel singletonReference = ExtAsApiGenerator.getReferenceDeclaration(qName);
                if (singletonReference == null || !(singletonReference.getPrimaryDeclaration() instanceof FieldModel)) continue;
                qName = CompilerUtils.qName((String)CompilerUtils.packageName((String)qName), (String)((FieldModel)singletonReference.getPrimaryDeclaration()).getType());
            }
            if (!(primaryDeclaration instanceof ClassModel)) continue;
            for (CompilationUnitModel referenceClass : ExtAsApiGenerator.getReferenceDeclarations(qName)) {
                if (!(referenceClass.getPrimaryDeclaration() instanceof ClassModel)) continue;
                ExtAsApiGenerator.adaptToReferenceApi(compilationUnitModel, referenceClass);
            }
        }
    }

    private static void adaptToReferenceApi(CompilationUnitModel compilationUnitModel, CompilationUnitModel referenceCompilationUnitModel) {
        ClassModel referenceClassModel = referenceCompilationUnitModel.getClassModel();
        int removedCount = 0;
        int changedCount = 0;
        for (MemberModel member : referenceClassModel.getMembers()) {
            MemberModel newMember = ExtAsApiGenerator.findMemberModel(compilationUnitModel, member);
            if (newMember == null) {
                if (member.equals((Object)referenceClassModel.getConstructor())) continue;
                ++removedCount;
                continue;
            }
            ExtAsApiGenerator.adaptNamespaceToReferenceApi(newMember, member);
            boolean changed = ExtAsApiGenerator.adaptTypeToReferenceApi(referenceCompilationUnitModel, (TypedModel)newMember, (TypedModel)member);
            if (member instanceof MethodModel) {
                Iterator iterator = ((MethodModel)member).getParams().iterator();
                Iterator newIterator = ((MethodModel)newMember).getParams().iterator();
                while (iterator.hasNext() && newIterator.hasNext()) {
                    ParamModel param = (ParamModel)iterator.next();
                    ParamModel newParam = (ParamModel)newIterator.next();
                    changed |= ExtAsApiGenerator.adaptTypeToReferenceApi(referenceCompilationUnitModel, (TypedModel)newParam, (TypedModel)param);
                }
                if (iterator.hasNext() || newIterator.hasNext()) {
                    changed = true;
                }
            }
            if (!changed) continue;
            ++changedCount;
        }
        int sameCount = referenceClassModel.getMembers().size() - changedCount - removedCount;
        System.err.printf("%s\t%d\t%d\t%d%n", compilationUnitModel.getQName(), removedCount, changedCount, sameCount);
    }

    private static boolean adaptTypeToReferenceApi(CompilationUnitModel referenceCompilationUnitModel, TypedModel newMember, TypedModel member) {
        String oldType = referenceApi.resolveQualifiedName(referenceCompilationUnitModel, member.getType());
        String newType = newMember.getType();
        if (oldType != null && !oldType.equals(newType) && ExtAsApiGenerator.shouldCorrect(oldType, newType)) {
            newMember.setType(oldType);
            return true;
        }
        return false;
    }

    private static void adaptNamespaceToReferenceApi(MemberModel newMember, MemberModel member) {
        String oldNamespace = member.getNamespace();
        String newNamespace = newMember.getNamespace();
        if (oldNamespace != null && !oldNamespace.equals(newNamespace)) {
            newMember.setNamespace(oldNamespace);
        }
    }

    private static boolean shouldCorrect(String oldType, String newType) {
        return newType == null || "void".equals(newType) || "*".equals(newType) || "void".equals(oldType) || "Object".equals(newType) && "*".equals(oldType) || EXT_EVENT.equals(oldType) && newType.contains("Event") || "Function".equals(newType) && "Class".equals(oldType);
    }

    private static MemberModel findMemberModel(CompilationUnitModel compilationUnitModel, MemberModel referenceMemberModel) {
        CompilationUnitModel superclass;
        MemberModel memberModel;
        ClassModel classModel = compilationUnitModel.getClassModel();
        String referenceMemberName = referenceApi.getMappedMemberName(compilationUnitModel, referenceMemberModel.getName());
        Object object = memberModel = referenceMemberModel instanceof MethodModel ? classModel.getMethod(referenceMemberModel.isStatic(), ((MethodModel)referenceMemberModel).getMethodType(), referenceMemberName) : classModel.getMember(referenceMemberModel.isStatic(), referenceMemberName);
        if (memberModel == null && (superclass = compilationUnitModelRegistry.getSuperclassCompilationUnit(classModel)) != null) {
            return ExtAsApiGenerator.findMemberModel(superclass, referenceMemberModel);
        }
        return memberModel;
    }

    private static void generateClassModel(ExtJsApi.ExtClass extClass) {
        String extClassName = ExtAsApiGenerator.getActionScriptName(extClass);
        if (extClassName == null) {
            return;
        }
        CompilationUnitModel extAsClassUnit = ExtAsApiGenerator.createClassModel(ExtAsApiGenerator.convertType(extClass.name));
        ClassModel extAsClass = extAsClassUnit.getClassModel();
        System.out.printf("Generating AS3 API model %s for %s...%n", extAsClassUnit.getQName(), extClassName);
        extAsClass.setAsdoc(ExtAsApiGenerator.toAsDoc(extClass));
        ExtAsApiGenerator.addDeprecation(extClass.deprecated, (AbstractAnnotatedModel)extAsClass);
        CompilationUnitModel extAsInterfaceUnit = null;
        if (interfaces.contains(extClassName)) {
            String superInterface;
            extAsInterfaceUnit = ExtAsApiGenerator.createClassModel(ExtAsApiGenerator.convertToInterface(extClassName));
            System.out.printf("Generating AS3 API model %s for %s...%n", extAsInterfaceUnit.getQName(), extClassName);
            ClassModel extAsInterface = (ClassModel)extAsInterfaceUnit.getPrimaryDeclaration();
            extAsInterface.setInterface(true);
            extAsInterface.setAsdoc(ExtAsApiGenerator.toAsDoc(extClass.doc) + "\n * @see " + extClassName);
            if (extClass.extends_ != null && (superInterface = ExtAsApiGenerator.convertToInterface(ExtAsApiGenerator.getActionScriptName(extClass.extends_))) != null) {
                extAsInterface.addInterface(superInterface);
            }
        }
        AnnotationModel nativeAnnotation = ExtAsApiGenerator.createNativeAnnotation(extClass.name);
        if (ExtJsApi.isSingleton(extClass)) {
            extAsClass.addAnnotation(ExtAsApiGenerator.createNativeAnnotation(null));
            FieldModel singleton = new FieldModel(CompilerUtils.className((String)extAsClass.getName().substring(1)), extAsClassUnit.getQName());
            singleton.setConst(true);
            singleton.setValue("new " + extAsClassUnit.getQName());
            singleton.addAnnotation(nativeAnnotation);
            singleton.setAsdoc(extAsClass.getAsdoc());
            CompilationUnitModel compilationUnitModel = new CompilationUnitModel(extAsClassUnit.getPackage(), (NamedModel)singleton);
            compilationUnitModelRegistry.register(compilationUnitModel);
            extAsClass.setAsdoc(String.format("%s%n<p>Type of singleton %s.</p>%n@see %s %s", extAsClass.getAsdoc(), singleton.getName(), CompilerUtils.qName((String)extAsClassUnit.getPackage(), (String)("#" + singleton.getName())), compilationUnitModel.getQName()));
        } else {
            extAsClass.addAnnotation(nativeAnnotation);
        }
        if (extAsInterfaceUnit != null) {
            extAsInterfaceUnit.getClassModel().addAnnotation(new AnnotationModel("Mixin", new AnnotationPropertyModel[]{new AnnotationPropertyModel(null, CompilerUtils.quote((String)extClassName))}));
        }
        if (extClass.private_) {
            extAsClass.addAnnotation(new AnnotationModel("ExcludeClass"));
        }
        extAsClass.setSuperclass(ExtAsApiGenerator.convertType(extClass.extends_));
        if (extAsInterfaceUnit != null) {
            extAsClass.addInterface(extAsInterfaceUnit.getQName());
        }
        for (String string : extClass.mixins) {
            String superInterface = ExtAsApiGenerator.convertToInterface(ExtAsApiGenerator.getActionScriptName(string));
            if (superInterface == null) continue;
            extAsClass.addInterface(superInterface);
            if (extAsInterfaceUnit == null) continue;
            extAsInterfaceUnit.getClassModel().addInterface(superInterface);
        }
        if (extAsInterfaceUnit != null) {
            ExtAsApiGenerator.addNonStaticMembers(extClass, extAsInterfaceUnit);
        } else {
            ExtAsApiGenerator.addFields(extAsClass, extJsApi.filterByOwner(false, true, extClass, extClass.members, ExtJsApi.Property.class));
            ExtAsApiGenerator.addMethods(extAsClass, extJsApi.filterByOwner(false, true, extClass, extClass.members, ExtJsApi.Method.class));
        }
        ExtAsApiGenerator.addNonStaticMembers(extClass, extAsClassUnit);
        if (ExtAsApiGenerator.getConfigClassQName(extClass) != null) {
            ExtAsApiGenerator.addConfigConstructor(extAsClassUnit);
        }
        for (Map.Entry entry : extClass.aliases.entrySet()) {
            String aliasGroup = (String)entry.getKey();
            Map<String, String> aliasMapping = aliasGroupToAliasToClass.get(aliasGroup);
            if (aliasMapping == null) {
                aliasMapping = new TreeMap<String, String>();
                aliasGroupToAliasToClass.put(aliasGroup, aliasMapping);
            }
            for (String alias : (List)entry.getValue()) {
                aliasMapping.put(alias, extAsClassUnit.getQName());
            }
        }
    }

    private static void addConfigConstructor(CompilationUnitModel extAsClassUnit) {
        ClassModel extAsClass = extAsClassUnit.getClassModel();
        MethodModel targetClassConstructor = extAsClass.getConstructor();
        if (targetClassConstructor == null) {
            targetClassConstructor = extAsClass.createConstructor();
            targetClassConstructor.addParam(new ParamModel("config", extAsClassUnit.getQName(), "null", "@inheritDoc"));
        } else {
            for (ParamModel param : targetClassConstructor.getParams()) {
                if (!"config".equals(param.getName())) continue;
                param.setType(extAsClass.getName());
                param.setOptional(true);
                break;
            }
        }
    }

    private static String getActionScriptName(String extClassName) {
        return ExtAsApiGenerator.getActionScriptName(extJsApi.getExtClass(extClassName));
    }

    private static String getConfigClassQName(ExtJsApi.ExtClass extClass) {
        String extClassName = extClass.name;
        String alias = jsConfigClassNameMappingProperties.getProperty(extClassName);
        if (alias == null) {
            return null;
        }
        String configClassQName = CompilerUtils.qName((String)"ext.config", (String)alias);
        System.err.println("********* derived config class name " + configClassQName + " from Ext class " + extClassName + " with alias " + alias);
        return configClassQName;
    }

    private static String getPreferredAlias(Map.Entry<String, List<String>> aliases) {
        String alias = aliases.getValue().get(aliases.getValue().size() - 1);
        if (aliases.getValue().size() > 1) {
            if ("box".equals(alias)) {
                alias = aliases.getValue().get(0);
            }
            System.err.println("***### multiple aliases: " + aliases.getValue() + ", choosing " + alias);
        }
        return alias;
    }

    private static Map.Entry<String, List<String>> getAlias(ExtJsApi.ExtClass extClass) {
        Map.Entry<String, List<String>> firstEntry;
        Iterator<Map.Entry<String, List<String>>> iterator = extClass.aliases.entrySet().iterator();
        if (iterator.hasNext() && (firstEntry = iterator.next()).getValue().size() > 0) {
            return firstEntry;
        }
        return null;
    }

    private static AnnotationModel createNativeAnnotation(String nativeName) {
        AnnotationModel nativeAnnotation = new AnnotationModel("Native");
        if (nativeName != null) {
            nativeAnnotation.addProperty(new AnnotationPropertyModel(null, CompilerUtils.quote((String)nativeName)));
            nativeAnnotation.addProperty(new AnnotationPropertyModel("require", null));
        }
        return nativeAnnotation;
    }

    private static CompilationUnitModel createClassModel(String qName) {
        CompilationUnitModel oldCompilationUnitModel = compilationUnitModelRegistry.resolveCompilationUnit(qName);
        if (oldCompilationUnitModel != null) {
            System.err.println("[WARN] Redefining class " + qName);
            return oldCompilationUnitModel;
        }
        CompilationUnitModel compilationUnitModel = new CompilationUnitModel(null, (NamedModel)new ClassModel());
        compilationUnitModel.setQName(qName);
        compilationUnitModelRegistry.register(compilationUnitModel);
        return compilationUnitModel;
    }

    private static void addNonStaticMembers(ExtJsApi.ExtClass extClass, CompilationUnitModel extAsClassUnit) {
        ClassModel extAsClass = extAsClassUnit.getClassModel();
        if (!extAsClass.isInterface()) {
            ExtAsApiGenerator.addEvents(extAsClass, extAsClassUnit, extJsApi.filterByOwner(false, false, extClass, extClass.members, ExtJsApi.Event.class));
        }
        ExtAsApiGenerator.addProperties(extAsClass, extJsApi.filterByOwner(extAsClass.isInterface(), false, extClass, extClass.members, ExtJsApi.Property.class), false);
        ExtAsApiGenerator.addMethods(extAsClass, extJsApi.filterByOwner(extAsClass.isInterface(), false, extClass, extClass.members, ExtJsApi.Method.class));
        ExtAsApiGenerator.addProperties(extAsClass, extJsApi.filterByOwner(extAsClass.isInterface(), false, extClass, extClass.members, ExtJsApi.Cfg.class), true);
    }

    private static void generateActionScriptCode(CompilationUnitModel extAsClass, File outputDir) throws IOException {
        File outputFile = CompilerUtils.fileFromQName((String)extAsClass.getQName(), (File)outputDir, (String)".as");
        outputFile.getParentFile().mkdirs();
        System.out.printf("Generating AS3 API for %s into %s ...\n", extAsClass.getQName(), outputFile.getCanonicalPath());
        extAsClass.visit((ModelVisitor)new ActionScriptCodeGeneratingModelVisitor((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8")));
    }

    private static void addDeprecation(ExtJsApi.Deprecation deprecation, AbstractAnnotatedModel model) {
        if (deprecation != null) {
            AnnotationModel deprecated = new AnnotationModel("Deprecated");
            if (deprecation.text != null && !deprecation.text.matches("\\s*")) {
                deprecated.addProperty(new AnnotationPropertyModel("message", CompilerUtils.quote((String)deprecation.text.replace("<p>", "").replace("</p>", ""))));
            }
            if (deprecation.version != null && !deprecation.version.matches("\\s*")) {
                deprecated.addProperty(new AnnotationPropertyModel("since", deprecation.version.startsWith("\"") ? deprecation.version : CompilerUtils.quote((String)deprecation.version)));
            }
            model.addAnnotation(deprecated);
        }
    }

    private static void addEvents(ClassModel classModel, CompilationUnitModel compilationUnitModel, List<ExtJsApi.Event> events) {
        for (ExtJsApi.Event event : events) {
            String eventName = ExtAsApiGenerator.toCamelCase(event.name);
            AnnotationModel annotationModel = new AnnotationModel("Event", new AnnotationPropertyModel[]{new AnnotationPropertyModel("name", "'on" + eventName + "'")});
            String asdoc = ExtAsApiGenerator.toAsDoc(event);
            if (generateEventClasses) {
                String eventTypeQName = ExtAsApiGenerator.generateEventClass(compilationUnitModel, event);
                annotationModel.addProperty(new AnnotationPropertyModel("type", "'" + eventTypeQName + "'"));
                asdoc = asdoc + String.format("%n@eventType %s.%s", eventTypeQName, ExtAsApiGenerator.toConstantName(event.name));
            }
            annotationModel.setAsdoc(asdoc);
            classModel.addAnnotation(annotationModel);
        }
    }

    public static String capitalize(String name) {
        return name == null || name.length() == 0 ? name : Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    private static String generateEventClass(CompilationUnitModel eventClientClass, ExtJsApi.Event event) {
        String eventTypeNamePrefix = eventClientClass.getPrimaryDeclaration().getName();
        if (SINGLETON_CLASS_NAME_PATTERN.matcher(eventTypeNamePrefix).find()) {
            eventTypeNamePrefix = eventTypeNamePrefix.substring(1);
        }
        String eventTypeQName = eventClientClass.getPackage() + ".events." + eventTypeNamePrefix;
        String eventClientClassQName = eventClientClass.getQName();
        for (int i = 0; i < event.params.size(); ++i) {
            ExtJsApi.Param param = event.params.get(i);
            String asType = ExtAsApiGenerator.convertType(param.type);
            if ("eOpts".equals(param.name) || "this".equals(param.name) || i <= 0 && eventClientClassQName.equals(asType)) continue;
            eventTypeQName = eventTypeQName + "_" + param.name;
        }
        eventTypeQName = eventTypeQName + "Event";
        String eventName = ExtAsApiGenerator.toCamelCase(event.name);
        CompilationUnitModel eventType = compilationUnitModelRegistry.resolveCompilationUnit(eventTypeQName);
        if (eventType == null) {
            eventType = ExtAsApiGenerator.createClassModel(eventTypeQName);
            ClassModel extAsClass = eventType.getClassModel();
            extAsClass.setSuperclass("net.jangaroo.ext.FlExtEvent");
            MethodModel constructorModel = extAsClass.createConstructor();
            constructorModel.addParam(new ParamModel("type", "String"));
            constructorModel.addParam(new ParamModel("arguments", "Array"));
            constructorModel.setBody("super(type, arguments);");
            StringBuilder parameterSequence = new StringBuilder();
            String separator = "[";
            for (ExtJsApi.Param param : event.params) {
                String parameterName = ExtAsApiGenerator.convertName(param.name);
                parameterSequence.append(separator).append(CompilerUtils.quote((String)parameterName));
                separator = ", ";
                if ("eOpts".equals(param.name)) continue;
                MethodModel property = new MethodModel(MethodType.GET, parameterName, ExtAsApiGenerator.convertType(param.type));
                property.setAsdoc(ExtAsApiGenerator.toAsDoc(param));
                extAsClass.addMember((MemberModel)property);
            }
            parameterSequence.append("]");
            FieldModel parameterSequenceConstant = new FieldModel("__PARAMETER_SEQUENCE__", "Array", parameterSequence.toString());
            parameterSequenceConstant.setStatic(true);
            parameterSequenceConstant.setConst(true);
            extAsClass.addMember((MemberModel)parameterSequenceConstant);
        }
        FieldModel eventNameConstant = new FieldModel(ExtAsApiGenerator.toConstantName(event.name), "String", CompilerUtils.quote((String)("on" + eventName)));
        eventNameConstant.setStatic(true);
        eventNameConstant.setConst(true);
        eventNameConstant.setAsdoc(String.format("\"%s%n@see %s%n@eventType %s", ExtAsApiGenerator.toAsDoc(event), eventClientClass.getQName(), "on" + eventName));
        eventType.getClassModel().addMember((MemberModel)eventNameConstant);
        return eventTypeQName;
    }

    private static String toCamelCase(String eventName) {
        if (!eventName.toLowerCase().equals(eventName)) {
            return eventName;
        }
        StringBuilder camelCaseName = new StringBuilder();
        for (String word : ExtAsApiGenerator.splitIntoWords(eventName)) {
            camelCaseName.append(ExtAsApiGenerator.capitalize(word));
        }
        assert (camelCaseName.toString().toLowerCase().equals(eventName));
        return camelCaseName.toString();
    }

    private static String toConstantName(String eventName) {
        StringBuilder constantName = new StringBuilder();
        for (String word : ExtAsApiGenerator.splitIntoWords(eventName.toLowerCase())) {
            constantName.append(word.toUpperCase()).append('_');
        }
        constantName.setLength(constantName.length() - 1);
        return constantName.toString();
    }

    private static List<String> splitIntoWords(String mergedWords) {
        ArrayList<String> words = new ArrayList<String>();
        String remaining = mergedWords;
        while (!remaining.isEmpty()) {
            String candidate = "";
            for (Object keyObject : eventWordsProperties.keySet()) {
                String key = (String)keyObject;
                if (key.length() <= candidate.length() || !remaining.startsWith(key)) continue;
                candidate = key;
            }
            if (candidate.isEmpty()) {
                System.err.printf("No word found in dictionary for %s's suffix '%s'.%n", mergedWords, remaining);
                candidate = remaining;
            }
            words.add(candidate);
            remaining = remaining.substring(candidate.length());
        }
        return words;
    }

    private static void addFields(ClassModel classModel, List<? extends ExtJsApi.Member> fields) {
        for (ExtJsApi.Member member : fields) {
            PropertyModel fieldModel = new PropertyModel(ExtAsApiGenerator.convertName(member.name), ExtAsApiGenerator.convertType(member.type));
            ExtAsApiGenerator.setVisibility((MemberModel)fieldModel, member);
            ExtAsApiGenerator.setStatic((MemberModel)fieldModel, member);
            fieldModel.addGetter().setAsdoc(ExtAsApiGenerator.toAsDoc(member));
            if (!ExtJsApi.isConst(member)) {
                fieldModel.addSetter().setAsdoc("@private");
            }
            ExtAsApiGenerator.addDeprecation(member.deprecated, (AbstractAnnotatedModel)fieldModel);
            classModel.addMember((MemberModel)fieldModel);
        }
    }

    private static void addProperties(ClassModel classModel, List<? extends ExtJsApi.Member> properties, boolean isConfig) {
        for (ExtJsApi.Member member : properties) {
            MemberModel priorMember;
            if (extJsApi.inheritsDoc(member)) continue;
            boolean isStatic = extJsApi.isStatic(member);
            String name = ExtAsApiGenerator.convertName(member.name);
            String type = ExtAsApiGenerator.convertType(member.type);
            String asDoc = ExtAsApiGenerator.toAsDoc(member);
            if (type == null || "*".equals(type) || "Object".equals(type)) {
                String string = "cls".equals(member.name) ? "String" : ("useBodyElement".equals(member.name) ? "Boolean" : (type = "items".equals(member.name) || "plugins".equals(member.name) ? "Array" : type));
            }
            if ((priorMember = classModel.getMember(isStatic, name)) != null) {
                String priorMemberType = priorMember.isMethod() && !priorMember.isAccessor() ? "Function" : priorMember.getType();
                if (!priorMemberType.equals(type)) {
                    System.err.println("Duplicate member " + member.name + (isConfig ? " (config)" : "") + " in class " + classModel.getName() + " with deviating type " + type + " instead of " + priorMemberType + ".");
                }
                if ("Array".equals(type) && priorMemberType.contains("Collection")) {
                    String newName = (name.endsWith("s") ? name.substring(0, name.length() - 1) : name) + "Collection";
                    System.out.println("Renaming member " + priorMember.getName() + " to " + newName + " in class " + classModel.getName() + " to avoid name clash with config.");
                    priorMember.setName(newName);
                } else if ("Function".equals(priorMemberType)) {
                    name = name + "_";
                    System.out.println("Renaming config " + member.name + " to " + name + " in class " + classModel.getName() + " to avoid name clash with method.");
                } else {
                    type = priorMemberType;
                    asDoc = priorMember.isProperty() ? ((PropertyModel)priorMember).getGetter().getAsdoc() : priorMember.getAsdoc();
                    System.out.println("Merging member " + priorMember.getName() + " and config " + member.name + " in class " + classModel.getName() + " to avoid name clash.");
                    classModel.removeMember(priorMember);
                }
            }
            PropertyModel propertyModel = new PropertyModel(name, type);
            if (generateForMxml && "items".equals(member.name)) {
                propertyModel.addAnnotation(new AnnotationModel("DefaultProperty"));
            }
            propertyModel.setAsdoc(asDoc);
            ExtAsApiGenerator.addDeprecation(member.deprecated, (AbstractAnnotatedModel)propertyModel);
            ExtAsApiGenerator.setVisibility((MemberModel)propertyModel, member);
            propertyModel.setStatic(isStatic);
            MethodModel getter = propertyModel.addGetter();
            AnnotationModel extConfigAnnotation = null;
            if (isConfig) {
                extConfigAnnotation = new AnnotationModel("ExtConfig");
                if (!name.equals(member.name)) {
                    extConfigAnnotation.addProperty(new AnnotationPropertyModel(null, CompilerUtils.quote((String)member.name)));
                }
                getter.addAnnotation(extConfigAnnotation);
            }
            if (!extJsApi.isReadOnly(member)) {
                MethodModel setter = propertyModel.addSetter();
                if (classModel.isInterface()) {
                    setter.setAsdoc(null);
                }
                if (extConfigAnnotation != null) {
                    setter.addAnnotation(extConfigAnnotation);
                }
            }
            classModel.addMember((MemberModel)propertyModel);
        }
    }

    private static void addMethods(ClassModel classModel, List<ExtJsApi.Method> methods) {
        for (ExtJsApi.Method method : methods) {
            boolean isConstructor;
            String methodName = method.name;
            if (methodName == null || methodName.length() == 0) {
                System.err.printf("methods name missing for method #%d in class %s", methods.indexOf(method) + 1, classModel.getName());
                continue;
            }
            if (classModel.getMember(methodName) != null || !(isConstructor = methodName.equals("constructor")) && extJsApi.inheritsDoc(method)) continue;
            MethodModel methodModel = isConstructor ? new MethodModel(classModel.getName(), null) : new MethodModel(ExtAsApiGenerator.convertName(methodName), method.return_ == null ? "void" : ExtAsApiGenerator.convertType(method.return_.type));
            methodModel.setAsdoc(ExtAsApiGenerator.toAsDoc(method));
            if (method.return_ != null) {
                methodModel.getReturnModel().setAsdoc(ExtAsApiGenerator.toAsDoc(method.return_));
            }
            ExtAsApiGenerator.setVisibility((MemberModel)methodModel, method);
            ExtAsApiGenerator.setStatic((MemberModel)methodModel, method);
            ExtAsApiGenerator.addDeprecation(method.deprecated, (AbstractAnnotatedModel)methodModel);
            for (ExtJsApi.Param param : method.params) {
                String paramName = param.name == null ? "param" + (method.params.indexOf(param) + 1) : ExtAsApiGenerator.convertName(param.name);
                ParamModel paramModel = new ParamModel(paramName, ExtAsApiGenerator.convertType(param.type));
                paramModel.setAsdoc(ExtAsApiGenerator.toAsDoc(param, param.name));
                ExtAsApiGenerator.setDefaultValue(paramModel, param);
                paramModel.setRest(param == method.params.get(method.params.size() - 1) && param.type.endsWith("..."));
                methodModel.addParam(paramModel);
            }
            try {
                classModel.addMember((MemberModel)methodModel);
            }
            catch (IllegalArgumentException e) {
                System.err.println("while adding method " + methodModel + ": " + e);
            }
        }
    }

    private static void setVisibility(MemberModel memberModel, ExtJsApi.Member member) {
        memberModel.setNamespace(extJsApi.isProtected(member) ? "protected" : "public");
    }

    private static void setStatic(MemberModel memberModel, ExtJsApi.Member member) {
        memberModel.setStatic(extJsApi.isStatic(member));
    }

    private static String toAsDoc(ExtJsApi.Tag tag) {
        return ExtAsApiGenerator.toAsDoc(tag, null);
    }

    private static String toAsDoc(ExtJsApi.Tag tag, String paramPrefix) {
        StringBuilder asDoc = new StringBuilder(ExtAsApiGenerator.toAsDoc(tag.doc));
        if (tag instanceof ExtJsApi.Var && ((ExtJsApi.Var)tag).default_ != null) {
            asDoc.append("\n@default ").append(((ExtJsApi.Var)tag).default_);
        }
        if (tag instanceof ExtJsApi.Member && ((ExtJsApi.Member)tag).since != null) {
            asDoc.append("\n@since ").append(((ExtJsApi.Member)tag).since);
        }
        if (tag.properties != null && !tag.properties.isEmpty()) {
            if (paramPrefix != null) {
                for (ExtJsApi.Param property : tag.properties) {
                    asDoc.append("\n   * @param ");
                    String propertyType = ExtAsApiGenerator.convertType(property.type);
                    if (propertyType != null && !"*".equals(propertyType)) {
                        asDoc.append("{").append(propertyType).append("} ");
                    }
                    String qualifiedPropertyName = paramPrefix + "." + property.name;
                    if (property.optional) {
                        asDoc.append("[").append(qualifiedPropertyName).append("]");
                    } else {
                        asDoc.append(qualifiedPropertyName);
                    }
                    asDoc.append(" ");
                    asDoc.append(ExtAsApiGenerator.toAsDoc(property, qualifiedPropertyName));
                }
            } else {
                asDoc.append("\n   * <ul>");
                for (ExtJsApi.Param property : tag.properties) {
                    String propertyAsDoc;
                    asDoc.append("\n   *   <li>");
                    asDoc.append("<code>").append(property.name).append("</code>");
                    String propertyType = ExtAsApiGenerator.convertType(property.type);
                    if (propertyType != null && !"*".equals(propertyType)) {
                        asDoc.append(" : ").append(propertyType);
                    }
                    if (property.optional) {
                        asDoc.append(" (optional)");
                    }
                    if (!(propertyAsDoc = ExtAsApiGenerator.toAsDoc(property)).trim().isEmpty()) {
                        asDoc.append("\n   * ").append(propertyAsDoc).append("\n   *   ");
                    }
                    asDoc.append("</li>");
                }
                asDoc.append("\n   * </ul>");
            }
        }
        String result = asDoc.toString();
        if (tag instanceof ExtJsApi.Param) {
            result = result.replaceAll("\n+", "\n");
        }
        return result;
    }

    private static String toAsDoc(String doc) {
        int closingBracePos;
        int endTagPos;
        String asDoc = doc.replaceAll("</?locale>", "");
        if ((asDoc = asDoc.trim()).startsWith("<p>") && (endTagPos = (asDoc = asDoc.substring(3)).indexOf("</p>")) != -1) {
            asDoc = asDoc.substring(0, endTagPos) + asDoc.substring(endTagPos + 4);
        }
        if (asDoc.startsWith("{") && (closingBracePos = asDoc.indexOf("} ")) != -1) {
            asDoc = asDoc.substring(closingBracePos + 2);
        }
        asDoc = asDoc.replaceAll("(<img[^>]*[^/])>", "$1/>");
        return asDoc;
    }

    private static void setDefaultValue(ParamModel paramModel, ExtJsApi.Param param) {
        String defaultValue = param.default_;
        if (defaultValue != null && NON_COMPILE_TIME_CONSTANT_INITIALIZERS.contains(defaultValue)) {
            paramModel.setAsdoc("(Default " + defaultValue + ") " + paramModel.getAsdoc());
            defaultValue = null;
            param.optional = true;
        }
        if (defaultValue == null && param.optional) {
            defaultValue = AS3Type.getDefaultValue((String)paramModel.getType());
        }
        if (defaultValue != null && "String".equals(param.type) && !defaultValue.equals("null") && !defaultValue.startsWith("'") && !defaultValue.startsWith("\"")) {
            defaultValue = CompilerUtils.quote((String)defaultValue);
        }
        paramModel.setValue(defaultValue);
    }

    private static String convertName(String name) {
        return "is".equals(name = ExtAsApiGenerator.replaceSeparatorByCamelCase(name, '-')) ? "matches" : ("class".equals(name) ? "cls" : ("this".equals(name) ? "source" : ("new".equals(name) ? "new_" : ("default".equals(name) ? "default_" : name))));
    }

    private static String replaceSeparatorByCamelCase(String string, char separator) {
        int separatorPos;
        while ((separatorPos = string.indexOf(separator)) != -1) {
            string = string.substring(0, separatorPos) + string.substring(separatorPos + 1, separatorPos + 2).toUpperCase() + string.substring(separatorPos + 2);
        }
        return string;
    }

    private static String convertToInterface(String className) {
        if (className == null || !interfaces.contains(className)) {
            return null;
        }
        String interfaceName = "I" + CompilerUtils.className((String)className);
        if (interfaceName.endsWith("Impl")) {
            interfaceName = interfaceName.substring(0, interfaceName.length() - 4);
        }
        return CompilerUtils.qName((String)CompilerUtils.packageName((String)className), (String)interfaceName);
    }

    private static String convertType(String extType) {
        if (extType == null) {
            return null;
        }
        if ("undefined".equals(extType) || "null".equals(extType)) {
            return "void";
        }
        if ("number".equals(extType) || "boolean".equals(extType) || "string".equals(extType)) {
            return ExtAsApiGenerator.capitalize(extType);
        }
        if ("HTMLElement".equals(extType) || "Event".equals(extType) || "XMLHttpRequest".equals(extType)) {
            return "js." + extType;
        }
        if ("google.maps.Map".equals(extType) || "CSSStyleSheet".equals(extType) || "CSSStyleRule".equals(extType)) {
            return "Object";
        }
        if (extType.startsWith("Ext.enums.") || extType.matches("(['\"].*['\"]/)*['\"].*['\"]")) {
            return "String";
        }
        if (extType.endsWith("...") || extType.matches("[a-zA-Z0-9._$<>]+\\[\\]")) {
            return "Array";
        }
        if (!extType.matches("[a-zA-Z0-9._$<>]+") || "Mixed".equals(extType)) {
            return "*";
        }
        if (JsCodeGenerator.PRIMITIVES.contains(extType)) {
            return extType;
        }
        ExtJsApi.ExtClass extClass = extJsApi.getExtClass(extType);
        if (extClass == null) {
            System.err.println("Warning: No Ext class '" + extType + "' found, falling back to Object");
            return "Object";
        }
        String qName = ExtAsApiGenerator.getActionScriptName(extClass);
        if (qName == null) {
            return ExtAsApiGenerator.convertType(extClass.extends_);
        }
        if (ExtJsApi.isSingleton(extClass)) {
            qName = CompilerUtils.qName((String)CompilerUtils.packageName((String)qName), (String)("S" + CompilerUtils.className((String)qName)));
        }
        return qName;
    }

    private static void removePrivateApiClasses() {
        HashSet<ExtJsApi.ExtClass> privateClasses = new HashSet<ExtJsApi.ExtClass>();
        for (ExtJsApi.ExtClass extClass : extClasses) {
            ExtAsApiGenerator.replaceMixin(extClass, "Ext.util.Observable", "Ext.mixin.Observable");
            ExtAsApiGenerator.replaceMixinByExtends(extClass, "Ext.dom.Element");
            if (!extClass.private_ && !JsCodeGenerator.PRIMITIVES.contains(extClass.name) && !extClass.name.startsWith("Ext.enums.")) continue;
            privateClasses.add(extClass);
        }
        if (referenceApi != null) {
            for (ExtJsApi.ExtClass extClass : extClasses) {
                List<CompilationUnitModel> referenceDeclarations;
                String jooClassName = ExtAsApiGenerator.getActionScriptName(extClass);
                if (jooClassName == null || (referenceDeclarations = ExtAsApiGenerator.getReferenceDeclarations(jooClassName)) == null || referenceDeclarations.isEmpty()) continue;
                System.out.printf(" (added 'private' API class %s because it appears in Ext 3.4 reference API as %s.)%n", extClass.name, referenceDeclarations.get(0).getQName());
                privateClasses.remove(extClass);
            }
        }
        for (ExtJsApi.ExtClass extClass : extClasses) {
            if (privateClasses.contains(extClass)) continue;
            ExtAsApiGenerator.markPublic(privateClasses, extClass.name);
        }
        extClasses.removeAll(privateClasses);
        System.out.println("*****ADD TO JS-AS-NAME-MAPPING:");
        for (ExtJsApi.ExtClass extClass : extClasses) {
            if (ExtAsApiGenerator.getActionScriptName(extClass) != null) continue;
            System.out.println(extClass.name + " = " + extClass.name.substring(0, 1).toLowerCase() + extClass.name.substring(1));
        }
        System.out.println("*****END ADD TO JS-AS-NAME-MAPPING:");
    }

    private static CompilationUnitModel getReferenceDeclaration(String jooClassName) {
        List<CompilationUnitModel> referenceDeclarations = ExtAsApiGenerator.getReferenceDeclarations(jooClassName);
        return referenceDeclarations.isEmpty() ? null : referenceDeclarations.get(0);
    }

    private static List<CompilationUnitModel> getReferenceDeclarations(String jooClassName) {
        return referenceApi.getCompilationUnitModels(jooClassName);
    }

    private static void replaceMixin(ExtJsApi.ExtClass extClass, String mixinImpl, String mixin) {
        int mixinImplIndex = extClass.mixins.indexOf(mixinImpl);
        if (mixinImplIndex != -1) {
            extClass.mixins.set(mixinImplIndex, mixin);
        }
        ExtAsApiGenerator.replaceMixinByExtends(extClass, mixin);
    }

    private static void replaceMixinByExtends(ExtJsApi.ExtClass extClass, String mixin) {
        if ("Ext.Base".equals(extClass.extends_) && extClass.mixins.contains(mixin)) {
            extClass.mixins.remove(mixin);
            extClass.extends_ = mixin;
        }
    }

    private static void markPublic(Set<ExtJsApi.ExtClass> privateClasses, String extClassName) {
        ExtJsApi.ExtClass extClass = extJsApi.getExtClass(extClassName);
        if (privateClasses.remove(extClass)) {
            // empty if block
        }
        if (extClass.extends_ != null) {
            ExtAsApiGenerator.markPublic(privateClasses, extClass.extends_);
        }
        for (String mixin : extClass.mixins) {
            ExtAsApiGenerator.markPublic(privateClasses, mixin);
        }
    }

    private static String getActionScriptName(ExtJsApi.ExtClass extClass) {
        String normalizedClassName = jsAsNameMappingProperties.getProperty(extClass.name);
        if (normalizedClassName == null) {
            return null;
        }
        return normalizedClassName;
    }

    private static void annotateBindableConfigProperties() {
        for (CompilationUnitModel compilationUnitModel : compilationUnitModelRegistry.getCompilationUnitModels()) {
            ClassModel classModel = compilationUnitModel.getClassModel();
            if (classModel == null) continue;
            ExtAsApiGenerator.annotateBindableConfigProperties(classModel);
        }
    }

    private static void annotateBindableConfigProperties(ClassModel classModel) {
        List members = classModel.getMembers();
        for (MemberModel member : members) {
            if (!member.isGetter()) continue;
            ExtAsApiGenerator.annotateBindableConfigProperty(classModel, (MethodModel)member);
        }
        for (MemberModel member : members) {
            if (!member.isSetter()) continue;
            ExtAsApiGenerator.annotateBindableConfigProperty(classModel, (MethodModel)member);
        }
    }

    private static void annotateBindableConfigProperty(ClassModel classModel, MethodModel accessor) {
        if (accessor.getAnnotations("ExtConfig").isEmpty()) {
            return;
        }
        String prefix = accessor.getMethodType().toString();
        String propertyType = ExtAsApiGenerator.getMethodType(accessor, accessor.getMethodType());
        if (propertyType == null) {
            ExtAsApiGenerator.warnConfigProperty(prefix + " property accessor without type", classModel, accessor);
            return;
        }
        String methodName = prefix + ExtAsApiGenerator.capitalize(accessor.getName());
        MethodModel method = compilationUnitModelRegistry.resolveMethod(classModel, null, methodName);
        if (method == null) {
            ExtAsApiGenerator.warnConfigProperty("no matching " + prefix + "ter method", classModel, accessor);
            return;
        }
        List methodParams = method.getParams();
        if (accessor.isSetter() && methodParams.isEmpty()) {
            ExtAsApiGenerator.warnConfigProperty(String.format("matching setter method '%s' without parameters. Still marking property as [Bindable] - assuming it's compatible at runtime.", method.getName()), classModel, accessor);
        } else {
            List moreParams = accessor.isSetter() ? methodParams.subList(1, methodParams.size()) : methodParams;
            for (ParamModel param : moreParams) {
                if (param.isOptional()) continue;
                ExtAsApiGenerator.warnConfigProperty(String.format("matching %ster method '%s' has additional non-optional parameter '%s'", prefix, method.getName(), param.getName()), classModel, accessor);
                return;
            }
            String methodType = ExtAsApiGenerator.getMethodType(method, accessor.getMethodType());
            if (!propertyType.equals(methodType)) {
                boolean probablyCompatible;
                boolean bl = probablyCompatible = "*".equals(propertyType) || "*".equals(methodType) || "Object".equals(propertyType) || "Object".equals(methodType);
                if (!probablyCompatible) {
                    ExtAsApiGenerator.warnConfigProperty(String.format("type '%s' does not match method '%s' with type '%s'", propertyType, method.getName(), methodType), classModel, accessor);
                    return;
                }
                ExtAsApiGenerator.warnConfigProperty(String.format("type '%s' does not quite match method '%s' with type '%s'. Still marking property as [Bindable] - assuming it's compatible at runtime.", propertyType, method.getName(), methodType), classModel, accessor);
            }
        }
        accessor.addAnnotation(new AnnotationModel("Bindable"));
        MethodModel documentedMethod = null;
        if (accessor.isSetter()) {
            documentedMethod = classModel.getMethod(accessor.isStatic(), MethodType.GET, accessor.getName());
        }
        if (documentedMethod == null) {
            documentedMethod = accessor;
        }
        String asDoc = documentedMethod.getAsdoc();
        documentedMethod.setAsdoc((asDoc == null ? "" : asDoc) + "\n@see #" + methodName + "()");
    }

    private static String getMethodType(MethodModel method, MethodType methodType) {
        if (methodType == MethodType.GET) {
            return method.getType();
        }
        List propertySetterParams = method.getParams();
        if (propertySetterParams.isEmpty()) {
            return null;
        }
        return ((ParamModel)propertySetterParams.get(0)).getType();
    }

    private static void warnConfigProperty(String message, ClassModel classModel, MethodModel propertySetter) {
        System.err.format("!!! Config property %s#%s: %s\n", classModel.getName(), propertySetter.getName(), message);
    }

    static {
        NON_COMPILE_TIME_CONSTANT_INITIALIZERS = Arrays.asList("window", "document", "document.body", "new Date()", "this", "`this`", "10||document.body", "caller", "array.length");
        jsAsNameMappingProperties = new Properties();
        jsConfigClassNameMappingProperties = new Properties();
        eventWordsProperties = new Properties();
        aliasGroupToAliasToClass = new TreeMap<String, Map<String, String>>();
    }
}

