/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.tools;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jangaroo.exml.utils.ExmlUtils;
import net.jangaroo.jooc.backend.ActionScriptCodeGeneratingModelVisitor;
import net.jangaroo.jooc.backend.JsCodeGenerator;
import net.jangaroo.jooc.model.AnnotationModel;
import net.jangaroo.jooc.model.AnnotationPropertyModel;
import net.jangaroo.jooc.model.ClassModel;
import net.jangaroo.jooc.model.CompilationUnitModel;
import net.jangaroo.jooc.model.CompilationUnitModelRegistry;
import net.jangaroo.jooc.model.FieldModel;
import net.jangaroo.jooc.model.MemberModel;
import net.jangaroo.jooc.model.MethodModel;
import net.jangaroo.jooc.model.MethodType;
import net.jangaroo.jooc.model.ModelVisitor;
import net.jangaroo.jooc.model.NamedModel;
import net.jangaroo.jooc.model.ParamModel;
import net.jangaroo.jooc.model.PropertyModel;
import net.jangaroo.utils.AS3Type;
import net.jangaroo.utils.CompilerUtils;

public class ExtAsApiGenerator {
    private static Set<ExtClass> extClasses;
    private static Map<String, ExtClass> extClassByName;
    private static CompilationUnitModelRegistry compilationUnitModelRegistry;
    private static Set<String> mixins;
    private static Set<String> interfaces;
    private static final List<String> NON_COMPILE_TIME_CONSTANT_INITIALIZERS;
    private static String extPackageName;
    private static String extAmdModuleName;
    private static List<String> referenceApiClassNames;
    private static Map<String, String> normalizeExtClassName;
    private static boolean generateEventClasses;

    public static void main(String[] args) throws IOException {
        File referenceApiDir;
        File[] referenceApiFiles;
        File srcDir = new File(args[0]);
        File outputDir = new File(args[1]);
        extPackageName = args[2];
        extAmdModuleName = args[3];
        referenceApiClassNames = new ArrayList<String>();
        if (args.length >= 5 && (referenceApiFiles = (referenceApiDir = new File(args[4])).listFiles()) != null) {
            for (File referenceApiFile : referenceApiFiles) {
                ExtClass referenceApiClass = ExtAsApiGenerator.readExtApiJson(referenceApiFile);
                if (referenceApiClass == null) continue;
                System.out.println("Remembering " + referenceApiClass.name + " for reference.");
                referenceApiClassNames.add(referenceApiClass.name);
            }
        }
        generateEventClasses = args.length < 6 || Boolean.valueOf(args[5]) != false;
        File[] files = srcDir.listFiles();
        if (files != null) {
            compilationUnitModelRegistry = new CompilationUnitModelRegistry();
            interfaces = new HashSet<String>();
            mixins = new HashSet<String>();
            HashSet<String> singletons = new HashSet<String>();
            ExtAsApiGenerator.readExtClasses(files);
            for (ExtClass extClass : extClasses) {
                for (String mixin : extClass.mixins) {
                    String mixinName = ExtAsApiGenerator.getPreferredName(mixin);
                    interfaces.add(mixinName);
                    mixins.add(mixinName);
                }
                if (!ExtAsApiGenerator.isSingleton(extClass)) continue;
                singletons.add(ExtAsApiGenerator.getPreferredName(extClass));
            }
            ExtAsApiGenerator.markTransitiveSupersAsInterfaces(interfaces);
            for (ExtClass extClass : extClasses) {
                ExtAsApiGenerator.generateClassModel(extClass);
            }
            ExtAsApiGenerator.complementMixinConfigClasses();
            compilationUnitModelRegistry.complementOverrides();
            compilationUnitModelRegistry.complementImports();
            for (CompilationUnitModel compilationUnitModel : compilationUnitModelRegistry.getCompilationUnitModels()) {
                ExtAsApiGenerator.generateActionScriptCode(compilationUnitModel, outputDir);
            }
        }
    }

    private static void complementMixinConfigClasses() {
        for (ExtClass extClass : extClasses) {
            ClassModel configClassModel;
            String configClassQName = ExtAsApiGenerator.getConfigClassQName(extClass);
            if (configClassQName == null || (configClassModel = compilationUnitModelRegistry.resolveCompilationUnit(configClassQName).getClassModel()) == null) continue;
            for (String mixin : extClass.mixins) {
                String mixinConfigClassQName;
                ExtClass extMixinClass = ExtAsApiGenerator.getExtClass(mixin);
                if (extMixinClass == null || (mixinConfigClassQName = ExtAsApiGenerator.getConfigClassQName(extMixinClass)) == null) continue;
                ClassModel mixinConfigClassModel = compilationUnitModelRegistry.resolveCompilationUnit(ExtAsApiGenerator.convertType(mixinConfigClassQName)).getClassModel();
                MethodModel mixinConstructor = mixinConfigClassModel.getConstructor();
                for (MemberModel memberModel : mixinConfigClassModel.getMembers()) {
                    if (!(memberModel instanceof MethodModel) || memberModel == mixinConstructor) continue;
                    if (configClassModel.getMember(memberModel.getName()) != null) {
                        System.err.println("*** [WARN] ignoring config option " + memberModel.getName() + " of config mixin " + mixinConfigClassQName + " in  config class " + configClassQName);
                        continue;
                    }
                    configClassModel.addMember((MemberModel)((MethodModel)memberModel).duplicate());
                }
            }
        }
    }

    private static void markTransitiveSupersAsInterfaces(Set<String> extClasses) {
        Set<String> supers = ExtAsApiGenerator.supers(extClasses);
        while (!supers.isEmpty()) {
            interfaces.addAll(supers);
            supers = ExtAsApiGenerator.supers(supers);
        }
    }

    private static Set<String> supers(Set<String> extClasses) {
        HashSet<String> result = new HashSet<String>();
        for (String extClass : extClasses) {
            String superclass = ExtAsApiGenerator.getExtClass((String)extClass).extends_;
            if (superclass == null) continue;
            String preferredName = ExtAsApiGenerator.getPreferredName(superclass);
            result.add(preferredName);
        }
        return result;
    }

    private static ExtClass readExtApiJson(File jsonFile) throws IOException {
        System.out.printf("Reading API from %s...\n", jsonFile.getPath());
        ExtClass extClass = (ExtClass)new ObjectMapper().readValue(jsonFile, ExtClass.class);
        if (JsCodeGenerator.PRIMITIVES.contains(extClass.name)) {
            System.err.println("ignoring built-in class " + extClass.name);
            return null;
        }
        return extClass;
    }

    private static void generateClassModel(ExtClass extClass) {
        String extClassName = ExtAsApiGenerator.getPreferredName(extClass);
        CompilationUnitModel extAsClassUnit = ExtAsApiGenerator.createClassModel(ExtAsApiGenerator.convertType(extClassName));
        ClassModel extAsClass = (ClassModel)extAsClassUnit.getPrimaryDeclaration();
        System.out.printf("Generating AS3 API model %s for %s...%n", extAsClassUnit.getQName(), extClassName);
        extAsClass.setAsdoc(ExtAsApiGenerator.toAsDoc(extClass.doc));
        CompilationUnitModel extAsInterfaceUnit = null;
        if (interfaces.contains(extClassName)) {
            extAsInterfaceUnit = ExtAsApiGenerator.createClassModel(ExtAsApiGenerator.convertToInterface(extClassName));
            System.out.printf("Generating AS3 API model %s for %s...%n", extAsInterfaceUnit.getQName(), extClassName);
            ClassModel extAsInterface = (ClassModel)extAsInterfaceUnit.getPrimaryDeclaration();
            extAsInterface.setInterface(true);
            extAsInterface.setAsdoc(ExtAsApiGenerator.toAsDoc(extClass.doc));
            ExtAsApiGenerator.addInterfaceForSuperclass(extClass, extAsInterface);
        }
        AnnotationModel nativeAnnotation = ExtAsApiGenerator.createNativeAnnotation(extClass.name);
        if (ExtAsApiGenerator.isSingleton(extClass)) {
            extAsClass.addAnnotation(ExtAsApiGenerator.createNativeAnnotation(null));
            FieldModel singleton = new FieldModel(CompilerUtils.className((String)extAsClassUnit.getClassModel().getName().substring(1)), extAsClassUnit.getQName());
            singleton.setConst(true);
            singleton.setValue("new " + extAsClassUnit.getQName());
            singleton.addAnnotation(nativeAnnotation);
            singleton.setAsdoc(extAsClass.getAsdoc());
            CompilationUnitModel singletonUnit = new CompilationUnitModel(extAsClassUnit.getPackage(), (NamedModel)singleton);
            compilationUnitModelRegistry.register(singletonUnit);
            extAsClass.setAsdoc(String.format("%s%n<p>Type of singleton %s.</p>%n@see %s %s", extAsClass.getAsdoc(), singleton.getName(), CompilerUtils.qName((String)extAsClassUnit.getPackage(), (String)("#" + singleton.getName())), singletonUnit.getQName()));
        } else {
            extAsClass.addAnnotation(nativeAnnotation);
        }
        extAsClass.setSuperclass(ExtAsApiGenerator.convertType(extClass.extends_));
        if (extAsInterfaceUnit != null) {
            extAsClass.addInterface(extAsInterfaceUnit.getQName());
        }
        for (String mixin : extClass.mixins) {
            String superInterface = ExtAsApiGenerator.convertToInterface(mixin);
            extAsClass.addInterface(superInterface);
            if (extAsInterfaceUnit == null) continue;
            extAsInterfaceUnit.getClassModel().addInterface(superInterface);
        }
        if (extAsInterfaceUnit != null) {
            ExtAsApiGenerator.addNonStaticMembers(extClass, extAsInterfaceUnit);
        }
        ExtAsApiGenerator.addFields(extAsClass, ExtAsApiGenerator.filterByOwner(false, extClass, extClass.statics.property));
        ExtAsApiGenerator.addMethods(extAsClass, ExtAsApiGenerator.filterByOwner(false, extClass, extClass.statics.method));
        ExtAsApiGenerator.addNonStaticMembers(extClass, extAsClassUnit);
        String configClassQName = ExtAsApiGenerator.getConfigClassQName(extClass);
        if (configClassQName != null) {
            String typeProperty;
            CompilationUnitModel configClassUnit = ExtAsApiGenerator.createClassModel(configClassQName);
            ClassModel configClass = (ClassModel)configClassUnit.getPrimaryDeclaration();
            configClassUnit.getClassModel().setAsdoc(extAsClass.getAsdoc());
            String superConfigClassQName = "joo.JavaScriptObject";
            ExtClass extSuperClass = ExtAsApiGenerator.getExtClass(extClass.extends_);
            while (extSuperClass != null) {
                String checkSuperConfigClassQName = ExtAsApiGenerator.getConfigClassQName(extSuperClass);
                if (checkSuperConfigClassQName != null) {
                    superConfigClassQName = checkSuperConfigClassQName;
                    break;
                }
                extSuperClass = ExtAsApiGenerator.getExtClass(extSuperClass.extends_);
            }
            configClass.setSuperclass(superConfigClassQName);
            MethodModel constructor = configClass.createConstructor();
            constructor.addParam(new ParamModel("config", "Object", "null"));
            constructor.setBody("super(config);");
            AnnotationModel extConfigAnnotation = new AnnotationModel("ExtConfig", new AnnotationPropertyModel[]{new AnnotationPropertyModel("target", CompilerUtils.quote((String)extAsClassUnit.getQName()))});
            Map.Entry<String, List<String>> alias = ExtAsApiGenerator.getAlias(extClass);
            String string = alias == null ? null : (typeProperty = "widget".equals(alias.getKey()) ? "xtype" : "type");
            if (typeProperty != null) {
                String typeValue = CompilerUtils.quote((String)ExtAsApiGenerator.getPreferredAlias(alias));
                extConfigAnnotation.addProperty(new AnnotationPropertyModel(typeProperty, typeValue));
                configClass.addBodyCode(String.format("%n  %s['prototype'].%s = %s;%n", configClassQName, typeProperty, typeValue));
                PropertyModel typePropertyModel = (PropertyModel)extAsClass.getMember(typeProperty);
                if (typePropertyModel == null) {
                    typePropertyModel = new PropertyModel(typeProperty, "String");
                    typePropertyModel.setAsdoc("@inheritDoc");
                    typePropertyModel.addGetter();
                    typePropertyModel.addSetter();
                    extAsClass.addMember((MemberModel)typePropertyModel);
                }
                typePropertyModel.addAnnotation(new AnnotationModel("ConstructorParameter", new AnnotationPropertyModel[]{new AnnotationPropertyModel("value", typeValue)}));
            }
            configClassUnit.getClassModel().addAnnotation(extConfigAnnotation);
            if (generateEventClasses) {
                ExtAsApiGenerator.addEvents(configClass, extAsClassUnit, ExtAsApiGenerator.filterByOwner(false, extClass, extClass.members.event));
            }
            List<Member> configProperties = ExtAsApiGenerator.filterByOwner(false, extClass, extClass.members.cfg);
            ExtAsApiGenerator.addProperties(configClass, configProperties);
            ExtAsApiGenerator.addProperties(extAsClass, configProperties);
            if (extAsInterfaceUnit != null) {
                ExtAsApiGenerator.addProperties(extAsInterfaceUnit.getClassModel(), configProperties);
            }
        }
    }

    private static String getConfigClassQName(ExtClass extClass) {
        String aliasCategory;
        String extClassName = ExtAsApiGenerator.getPreferredName(extClass);
        Map.Entry<String, List<String>> aliases = ExtAsApiGenerator.getAlias(extClass);
        String alias = null;
        if (aliases != null) {
            alias = ExtAsApiGenerator.getPreferredAlias(aliases);
        } else if (ExtAsApiGenerator.hasOwnMember(extClass, extClass.members.cfg) || ExtAsApiGenerator.hasOwnMember(extClass, extClass.members.event)) {
            alias = AliasFactory.INSTANCE.getAlias(extClassName);
        }
        if (alias == null) {
            return null;
        }
        String configClassName = ExtAsApiGenerator.replaceSeparatorByCamelCase(alias, '-');
        configClassName = ExtAsApiGenerator.replaceSeparatorByCamelCase(configClassName, '.');
        configClassName = configClassName.toLowerCase();
        String packageName = extPackageName + ".config";
        if (aliases != null && !"widget".equals(aliasCategory = aliases.getKey()) && !configClassName.contains(aliasCategory)) {
            configClassName = configClassName + aliasCategory;
        }
        String configClassQName = packageName + "." + configClassName;
        System.err.println("********* derived config class name " + configClassQName + " from Ext class " + extClassName + " with alias " + alias);
        return configClassQName;
    }

    private static boolean hasOwnMember(ExtClass extClass, List<? extends Member> members) {
        for (Member member : members) {
            if (!extClass.name.equals(member.owner) || "listeners".equals(member.name)) continue;
            return true;
        }
        return false;
    }

    private static String getPreferredAlias(Map.Entry<String, List<String>> aliases) {
        String alias = aliases.getValue().get(aliases.getValue().size() - 1);
        if (aliases.getValue().size() > 1) {
            if ("box".equals(alias)) {
                alias = aliases.getValue().get(0);
            }
            System.err.println("***### multiple aliases: " + aliases.getValue() + ", choosing " + alias);
        }
        return alias;
    }

    private static Map.Entry<String, List<String>> getAlias(ExtClass extClass) {
        Map.Entry<String, List<String>> firstEntry;
        Iterator<Map.Entry<String, List<String>>> iterator = extClass.aliases.entrySet().iterator();
        if (iterator.hasNext() && (firstEntry = iterator.next()).getValue().size() > 0) {
            return firstEntry;
        }
        return null;
    }

    private static AnnotationModel createNativeAnnotation(String nativeName) {
        AnnotationModel nativeAnnotation = new AnnotationModel("Native");
        if (nativeName != null) {
            nativeAnnotation.addProperty(new AnnotationPropertyModel("amd", CompilerUtils.quote((String)extAmdModuleName)));
            nativeAnnotation.addProperty(new AnnotationPropertyModel(null, CompilerUtils.quote((String)nativeName)));
        }
        return nativeAnnotation;
    }

    private static void addInterfaceForSuperclass(ExtClass extClass, ClassModel extAsInterface) {
        if (extClass.extends_ != null) {
            extAsInterface.addInterface(ExtAsApiGenerator.convertToInterface(extClass.extends_));
        }
    }

    private static CompilationUnitModel createClassModel(String qName) {
        CompilationUnitModel compilationUnitModel = new CompilationUnitModel(null, (NamedModel)new ClassModel());
        compilationUnitModel.setQName(qName);
        compilationUnitModelRegistry.register(compilationUnitModel);
        return compilationUnitModel;
    }

    private static void addNonStaticMembers(ExtClass extClass, CompilationUnitModel extAsClassUnit) {
        ClassModel extAsClass = extAsClassUnit.getClassModel();
        if (!extAsClass.isInterface()) {
            ExtAsApiGenerator.addEvents(extAsClassUnit.getClassModel(), extAsClassUnit, ExtAsApiGenerator.filterByOwner(false, extClass, extClass.members.event));
        }
        ExtAsApiGenerator.addProperties(extAsClass, ExtAsApiGenerator.filterByOwner(extAsClass.isInterface(), extClass, extClass.members.property));
        ExtAsApiGenerator.addMethods(extAsClass, ExtAsApiGenerator.filterByOwner(extAsClass.isInterface(), extClass, extClass.members.method));
    }

    private static void generateActionScriptCode(CompilationUnitModel extAsClass, File outputDir) throws IOException {
        File outputFile = CompilerUtils.fileFromQName((String)extAsClass.getQName(), (File)outputDir, (String)".as");
        outputFile.getParentFile().mkdirs();
        System.out.printf("Generating AS3 API for %s into %s...\n", extAsClass.getQName(), outputFile.getPath());
        extAsClass.visit((ModelVisitor)new ActionScriptCodeGeneratingModelVisitor((Writer)new FileWriter(outputFile)));
    }

    private static <T extends Member> List<T> filterByOwner(boolean isInterface, ExtClass owner, List<T> members) {
        ArrayList<Member> result = new ArrayList<Member>();
        for (Member member : members) {
            if (member.meta.removed != null || "listeners".equals(member.name) || !member.owner.equals(owner.name) || isInterface && !ExtAsApiGenerator.isPublicNonStaticMethodOrProperty(member)) continue;
            result.add(member);
        }
        return result;
    }

    private static boolean isPublicNonStaticMethodOrProperty(Member member) {
        return (member instanceof Method || member instanceof Property) && !member.meta.static_ && !member.meta.private_ && !member.meta.protected_ && !"constructor".equals(member.name);
    }

    private static boolean isConst(Member member) {
        return member.meta.readonly || member.name.equals(member.name.toUpperCase()) && member.default_ != null;
    }

    private static void addEvents(ClassModel classModel, CompilationUnitModel compilationUnitModel, List<Event> events) {
        for (Event event : events) {
            AnnotationModel annotationModel = new AnnotationModel("Event", new AnnotationPropertyModel[]{new AnnotationPropertyModel("name", "'on" + event.name + "'")});
            String asdoc = ExtAsApiGenerator.toAsDoc(event.doc);
            if (generateEventClasses) {
                String eventTypeQName = ExtAsApiGenerator.generateEventClass(compilationUnitModel, event);
                annotationModel.addProperty(new AnnotationPropertyModel("type", "'" + eventTypeQName + "'"));
                asdoc = asdoc + String.format("%n@eventType %s.NAME", eventTypeQName);
            }
            annotationModel.setAsdoc(asdoc);
            classModel.addAnnotation(annotationModel);
            System.err.println("*** adding event " + event.name + " to class " + classModel.getName());
        }
    }

    public static String capitalize(String name) {
        return name == null || name.length() == 0 ? name : Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    private static String generateEventClass(CompilationUnitModel compilationUnitModel, Event event) {
        ClassModel classModel = compilationUnitModel.getClassModel();
        String eventTypeQName = CompilerUtils.qName((String)compilationUnitModel.getPackage(), (String)("events." + classModel.getName() + ExtAsApiGenerator.capitalize(event.name) + "Event"));
        CompilationUnitModel extAsClassUnit = compilationUnitModelRegistry.resolveCompilationUnit(eventTypeQName);
        if (extAsClassUnit == null) {
            extAsClassUnit = ExtAsApiGenerator.createClassModel(eventTypeQName);
            ClassModel extAsClass = (ClassModel)extAsClassUnit.getPrimaryDeclaration();
            extAsClass.setSuperclass("flash.events.Event");
            extAsClass.setAsdoc(String.format("%s%n@see %s", ExtAsApiGenerator.toAsDoc(event.doc), compilationUnitModel.getQName()));
            FieldModel eventNameConstant = new FieldModel("NAME", "String", CompilerUtils.quote((String)("on" + event.name)));
            eventNameConstant.setStatic(true);
            eventNameConstant.setConst(true);
            eventNameConstant.setAsdoc(String.format("This constant defines the value of the <code>type</code> property of the event object%nfor a <code>%s</code> event.%n@eventType %s", "on" + event.name, "on" + event.name));
            extAsClass.addMember((MemberModel)eventNameConstant);
            MethodModel constructorModel = extAsClass.createConstructor();
            constructorModel.addParam(new ParamModel("arguments", "Array"));
            StringBuilder propertyAssignments = new StringBuilder();
            for (int i = 0; i < event.params.size(); ++i) {
                Param param = event.params.get(i);
                propertyAssignments.append(String.format("%n    this['%s'] = arguments[%d];", ExtAsApiGenerator.convertName(param.name), i));
                MethodModel property = new MethodModel(MethodType.GET, ExtAsApiGenerator.convertName(param.name), ExtAsApiGenerator.convertType(param.type));
                property.setAsdoc(ExtAsApiGenerator.toAsDoc(param.doc));
                extAsClass.addMember((MemberModel)property);
            }
            constructorModel.setBody("super(NAME);" + propertyAssignments.toString());
        }
        return eventTypeQName;
    }

    private static void addFields(ClassModel classModel, List<? extends Member> fields) {
        for (Member member : fields) {
            FieldModel fieldModel = new FieldModel(ExtAsApiGenerator.convertName(member.name), ExtAsApiGenerator.convertType(member.type), member.default_);
            fieldModel.setAsdoc(ExtAsApiGenerator.toAsDoc(member.doc));
            ExtAsApiGenerator.setStatic((MemberModel)fieldModel, member);
            fieldModel.setConst(ExtAsApiGenerator.isConst(member));
            classModel.addMember((MemberModel)fieldModel);
        }
    }

    private static void addProperties(ClassModel classModel, List<? extends Member> properties) {
        for (Member member : properties) {
            if (classModel.getMember(member.name) != null) continue;
            String type = ExtAsApiGenerator.convertType(member.type);
            if ("*".equals(type) || "Object".equals(type)) {
                type = "cls".equals(member.name) ? "String" : ("useBodyElement".equals(member.name) ? "Boolean" : ("items".equals(member.name) || "plugins".equals(member.name) ? "Array" : type));
            }
            PropertyModel propertyModel = new PropertyModel(ExtAsApiGenerator.convertName(member.name), type);
            if ("items".equals(member.name)) {
                propertyModel.addAnnotation(new AnnotationModel("DefaultProperty"));
            }
            propertyModel.setAsdoc(ExtAsApiGenerator.toAsDoc(member.doc));
            ExtAsApiGenerator.setStatic((MemberModel)propertyModel, member);
            propertyModel.addGetter();
            if (!member.meta.readonly) {
                propertyModel.addSetter();
            }
            classModel.addMember((MemberModel)propertyModel);
        }
    }

    private static void addMethods(ClassModel classModel, List<Method> methods) {
        for (Method method : methods) {
            String methodName = method.name;
            if (classModel.getMember(methodName) != null) continue;
            boolean isConstructor = methodName.equals("constructor");
            MethodModel methodModel = isConstructor ? new MethodModel(classModel.getName(), null) : new MethodModel(ExtAsApiGenerator.convertName(methodName), ExtAsApiGenerator.convertType(method.return_.type));
            methodModel.setAsdoc(ExtAsApiGenerator.toAsDoc(method.doc));
            methodModel.getReturnModel().setAsdoc(ExtAsApiGenerator.toAsDoc(method.return_.doc));
            ExtAsApiGenerator.setStatic((MemberModel)methodModel, method);
            for (Param param : method.params) {
                ParamModel paramModel = new ParamModel(ExtAsApiGenerator.convertName(param.name), ExtAsApiGenerator.convertType(param.type));
                paramModel.setAsdoc(ExtAsApiGenerator.toAsDoc(param.doc));
                ExtAsApiGenerator.setDefaultValue(paramModel, param);
                paramModel.setRest(param == method.params.get(method.params.size() - 1) && param.type.endsWith("..."));
                methodModel.addParam(paramModel);
            }
            if (isConstructor && method.params.size() == 1) {
                Param theOnlyParam = method.params.get(0);
                if (!theOnlyParam.optional && "config".equals(theOnlyParam.name)) {
                    ParamModel theOnlyParamModel = (ParamModel)methodModel.getParams().get(0);
                    theOnlyParamModel.setOptional(true);
                    theOnlyParamModel.setType("Object");
                }
            }
            try {
                classModel.addMember((MemberModel)methodModel);
            }
            catch (IllegalArgumentException e) {
                System.err.println("while adding method " + methodModel + ": " + e);
            }
        }
    }

    private static void setStatic(MemberModel memberModel, Member member) {
        ExtClass extClass = ExtAsApiGenerator.getExtClass(member.owner);
        memberModel.setStatic(extClass.singleton ? ExtAsApiGenerator.isStaticSingleton(extClass) : member.meta.static_);
    }

    private static String toAsDoc(String doc) {
        int closingBracePos;
        int endTagPos;
        String asDoc = doc.replaceAll("</?locale>", "");
        if ((asDoc = asDoc.trim()).startsWith("<p>") && (endTagPos = (asDoc = asDoc.substring(3)).indexOf("</p>")) != -1) {
            asDoc = asDoc.substring(0, endTagPos) + asDoc.substring(endTagPos + 4);
        }
        if (asDoc.startsWith("{") && (closingBracePos = asDoc.indexOf("} ")) != -1) {
            asDoc = asDoc.substring(closingBracePos + 2);
        }
        asDoc = asDoc.replaceAll("(<img[^>]*[^/])>", "$1/>");
        return asDoc;
    }

    private static void setDefaultValue(ParamModel paramModel, Param param) {
        String defaultValue = param.default_;
        if (defaultValue != null && NON_COMPILE_TIME_CONSTANT_INITIALIZERS.contains(defaultValue)) {
            paramModel.setAsdoc("(Default " + defaultValue + ") " + paramModel.getAsdoc());
            defaultValue = null;
            param.optional = true;
        }
        if (defaultValue == null && param.optional) {
            defaultValue = AS3Type.getDefaultValue((String)paramModel.getType());
        }
        if (defaultValue != null && "String".equals(param.type) && !defaultValue.equals("null") && !defaultValue.startsWith("'") && !defaultValue.startsWith("\"")) {
            defaultValue = CompilerUtils.quote((String)defaultValue);
        }
        paramModel.setValue(defaultValue);
    }

    private static String convertName(String name) {
        return "is".equals(name = ExtAsApiGenerator.replaceSeparatorByCamelCase(name, '-')) ? "matches" : ("class".equals(name) ? "cls" : ("this".equals(name) ? "source" : ("new".equals(name) ? "new_" : ("default".equals(name) ? "default_" : name))));
    }

    private static String replaceSeparatorByCamelCase(String string, char separator) {
        int separatorPos;
        while ((separatorPos = string.indexOf(separator)) != -1) {
            string = string.substring(0, separatorPos) + string.substring(separatorPos + 1, separatorPos + 2).toUpperCase() + string.substring(separatorPos + 2);
        }
        return string;
    }

    private static String convertToInterface(String mixin) {
        mixin = ExtAsApiGenerator.getPreferredName(mixin);
        String packageName = CompilerUtils.packageName((String)mixin).toLowerCase();
        String className = "I" + CompilerUtils.className((String)mixin);
        if (packageName.startsWith("ext")) {
            packageName = extPackageName + packageName.substring(3);
        }
        return CompilerUtils.qName((String)packageName, (String)className);
    }

    private static String convertType(String extType) {
        if (extType == null) {
            return null;
        }
        if ("undefined".equals(extType) || "null".equals(extType)) {
            return "void";
        }
        if ("number".equals(extType) || "boolean".equals(extType)) {
            return Character.toUpperCase(extType.charAt(0)) + extType.substring(1);
        }
        Matcher selectionClassMatcher = Pattern.compile("Ext[.]selection[.](.*)Model").matcher(extType);
        if (selectionClassMatcher.matches()) {
            return "ext.selection." + selectionClassMatcher.group(1) + "SelectionModel";
        }
        if ("Ext.tip.QuickTipManager".equals(extType)) {
            return "ext.IQuickTips";
        }
        if ("HTMLElement".equals(extType) || "Event".equals(extType) || "XMLHttpRequest".equals(extType)) {
            return "js." + extType;
        }
        if ("google.maps.Map".equals(extType) || "CSSStyleSheet".equals(extType) || "CSSStyleRule".equals(extType)) {
            return "Object";
        }
        if (extType.endsWith("...")) {
            return "Array";
        }
        if (!extType.matches("[a-zA-Z0-9._$<>]+") || "Mixed".equals(extType)) {
            return "*";
        }
        ExtClass extClass = ExtAsApiGenerator.getExtClass(extType);
        if (extClass != null) {
            extType = ExtAsApiGenerator.getPreferredName(extClass);
        }
        if ("Ext".equals(extType)) {
            extType = "ext.Ext";
        }
        String packageName = CompilerUtils.packageName((String)extType).toLowerCase();
        String className = CompilerUtils.className((String)extType);
        if (ExtAsApiGenerator.isSingleton(extClass)) {
            className = "I" + className;
        }
        if (JsCodeGenerator.PRIMITIVES.contains(className)) {
            if ("ext".equals(packageName)) {
                if (ExtAsApiGenerator.isStaticSingleton(extClass)) {
                    packageName = "ext.util";
                    className = className + "Util";
                } else {
                    className = "Ext" + className;
                }
            } else {
                className = className + ExmlUtils.createComponentClassName((String)packageName.substring(packageName.lastIndexOf(46) + 1));
            }
        } else if ("is".equals(className)) {
            className = "Is";
        }
        if (packageName.startsWith("ext")) {
            packageName = extPackageName + packageName.substring(3);
        }
        return CompilerUtils.qName((String)packageName, (String)className);
    }

    private static void readExtClasses(File[] files) throws IOException {
        String packageName;
        String extClassName;
        extClassByName = new HashMap<String, ExtClass>();
        extClasses = new LinkedHashSet<ExtClass>();
        for (File jsonFile : files) {
            ExtClass extClass = ExtAsApiGenerator.readExtApiJson(jsonFile);
            if (extClass == null) continue;
            extClasses.add(extClass);
            extClassByName.put(extClass.name, extClass);
            if (extClass.alternateClassNames == null) continue;
            for (String alternateClassName : extClass.alternateClassNames) {
                extClassByName.put(alternateClassName, extClass);
            }
        }
        HashMap<String, String> normalizedPackageName = new HashMap<String, String>();
        if (!referenceApiClassNames.isEmpty()) {
            block2: for (ExtClass extClass : extClasses) {
                if (extClass.alternateClassNames == null) continue;
                extClassName = extClass.name;
                packageName = CompilerUtils.packageName((String)extClassName);
                for (String alternateClassName : extClass.alternateClassNames) {
                    if (referenceApiClassNames.contains(extClassName) || !referenceApiClassNames.contains(alternateClassName)) continue;
                    normalizeExtClassName.put(extClassName, alternateClassName);
                    String alternatePackageName = CompilerUtils.packageName((String)alternateClassName);
                    if (packageName.equals(alternatePackageName)) continue block2;
                    normalizedPackageName.put(packageName, alternatePackageName);
                    continue block2;
                }
            }
        }
        for (ExtClass extClass : extClasses) {
            extClassName = extClass.name;
            if (normalizeExtClassName.containsKey(extClassName)) continue;
            packageName = (String)normalizedPackageName.get(CompilerUtils.packageName((String)extClassName));
            if (packageName != null) {
                for (String alternateClassName : extClass.alternateClassNames) {
                    if (!packageName.equals(CompilerUtils.packageName((String)alternateClassName))) continue;
                    extClassName = alternateClassName;
                    break;
                }
            }
            normalizeExtClassName.put(extClass.name, extClassName);
        }
    }

    private static ExtClass getExtClass(String name) {
        return extClassByName.get(name);
    }

    private static String getPreferredName(String extClassName) {
        return ExtAsApiGenerator.getPreferredName(ExtAsApiGenerator.getExtClass(extClassName));
    }

    private static String getPreferredName(ExtClass extClass) {
        String normalizedClassName = normalizeExtClassName.get(extClass.name);
        if (normalizedClassName == null) {
            throw new IllegalStateException("unmapped class " + extClass.name);
        }
        return normalizedClassName;
    }

    private static boolean isSingleton(ExtClass extClass) {
        return extClass != null && extClass.singleton && !ExtAsApiGenerator.isStaticSingleton(extClass);
    }

    private static boolean isStaticSingleton(ExtClass extClass) {
        return extClass != null && extClass.singleton && (extClass.extends_ == null || extClass.extends_.length() == 0) && extClass.mixins.isEmpty();
    }

    static {
        NON_COMPILE_TIME_CONSTANT_INITIALIZERS = Arrays.asList("window", "document", "document.body", "new Date()", "this");
        normalizeExtClassName = new HashMap<String, String>();
    }

    private static class AliasFactory {
        private static final AliasFactory INSTANCE = new AliasFactory();
        private final Map<String, String> UNIQUE_ALIAS_MAPPING = new LinkedHashMap<String, String>();

        private void add(String constant, String replacement) {
            this.addPattern(constant.replaceAll("\\.", "\\."), replacement);
        }

        private void addPattern(String pattern, String replacement) {
            this.UNIQUE_ALIAS_MAPPING.put(pattern, replacement);
        }

        private AliasFactory() {
            this.add("Ext.data.Field", "datafield");
            this.add("Ext.slider.Tip", "slidertip");
            this.add("Ext.form.Action", "formaction");
            this.add("Ext.Class", "extclass");
            this.add("Ext.state.Provider", "stateprovider");
            this.addPattern("Ext\\.list\\.(.*)Column", "lv$1column");
            this.add("Ext.grid.Column", "gridcolumn");
            this.addPattern("Ext\\.grid\\.(.+)Column", "$1column");
            this.add("Ext.store.Store", "store");
            this.addPattern("Ext\\.(.+)\\.Store", "$1store");
            this.addPattern("Ext\\.chart\\.(.+)", "chart$1");
            this.add("Ext.data.proxy.Proxy", "dataproxy");
            this.add("Ext.panel.Proxy", "panelproxy");
            this.add("Ext.view.DragZone", "viewdragzone");
            this.addPattern("Ext\\.(.+)\\.Controller", "$1controller");
            this.add("Ext.form.field.Field", "fieldmixin");
            this.add("Ext.app.domain.Direct", "appdomaindirect");
            this.add("Ext.layout.boxOverflow.Menu", "boxoverflowmenu");
        }

        public String getAlias(String extClassName) {
            for (Map.Entry<String, String> patternStringEntry : this.UNIQUE_ALIAS_MAPPING.entrySet()) {
                String pattern = patternStringEntry.getKey();
                Matcher matcher = Pattern.compile(pattern).matcher(extClassName);
                if (!matcher.matches()) continue;
                return extClassName.replaceAll(pattern, patternStringEntry.getValue()).toLowerCase();
            }
            return CompilerUtils.className((String)extClassName).toLowerCase();
        }
    }

    @JsonIgnoreProperties(value={"aside", "chainable", "preventable"})
    public static class Meta {
        @JsonProperty(value="protected")
        public boolean protected_;
        @JsonProperty(value="private")
        public boolean private_;
        public boolean readonly;
        @JsonProperty(value="static")
        public boolean static_;
        @JsonProperty(value="abstract")
        public boolean abstract_;
        public boolean markdown;
        public Map<String, String> deprecated;
        public String template;
        public List<String> author;
        public List<String> docauthor;
        public boolean required;
        public Map<String, String> removed;
        public String since;
    }

    public static class Event
    extends Member {
        public List<Param> params;
    }

    @JsonIgnoreProperties(value={"html_type", "html_meta", "linenr", "properties", "autodetected", "throws"})
    public static class Method
    extends Member {
        public List<Param> params;
        @JsonProperty(value="return")
        public Param return_;
    }

    public static class Param
    extends Var {
        public boolean optional;
    }

    public static class Property
    extends Member {
        public String toString() {
            return this.meta + "var " + super.toString();
        }
    }

    public static class Overrides {
        public String name;
        public String owner;
        public String id;
    }

    public static class MemberReference
    extends Tag {
        public String cls;
        public String member;
        public String type;
    }

    @JsonIgnoreProperties(value={"html_type", "html_meta", "linenr", "properties", "autodetected"})
    public static class Member
    extends Var {
        public String owner;
        public String shortDoc;
        public Meta meta;
        public boolean inheritable;
        public String id;
        public List<String> files;
        public boolean accessor;
        public boolean evented;
        public List<Overrides> overrides;
    }

    @JsonIgnoreProperties(value={"html_type", "html_meta", "linenr", "properties"})
    public static abstract class Var
    extends Tag {
        public String type;
        @JsonProperty(value="default")
        public String default_;
    }

    public static class Members {
        public List<Member> cfg;
        public List<Property> property;
        public List<Method> method;
        public List<Event> event;
        public List<Member> css_var;
        public List<Member> css_mixin;
    }

    @JsonIgnoreProperties(value={"html_meta", "html_type", "linenr", "enum", "override"})
    public static class ExtClass
    extends Tag {
        @JsonProperty(value="extends")
        public String extends_;
        public List<String> mixins;
        public List<String> alternateClassNames;
        public Map<String, List<String>> aliases;
        public boolean singleton;
        public List<String> requires;
        public List<String> uses;
        public String code_type;
        public boolean inheritable;
        public Meta meta;
        public String id;
        public Members members;
        public Members statics;
        public List<Object> files;
        public boolean component;
        public List<String> superclasses;
        public List<String> subclasses;
        public List<String> mixedInto;
        public List<String> parentMixins;
        @JsonProperty(value="abstract")
        public boolean abstract_;
    }

    @JsonIgnoreProperties(value={"html_meta", "html_type", "linenr"})
    public static class Tag {
        public String tagname;
        public String name;
        public String doc;
        @JsonProperty(value="private")
        public String private_;
        public MemberReference inheritdoc;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tag tag = (Tag)o;
            return this.name.equals(tag.name) && !(this.tagname == null ? tag.tagname != null : !this.tagname.equals(tag.tagname));
        }

        public int hashCode() {
            int result = this.tagname != null ? this.tagname.hashCode() : 0;
            result = 31 * result + this.name.hashCode();
            return result;
        }
    }
}

