/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.tools;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jangaroo.exml.utils.ExmlUtils;
import net.jangaroo.jooc.backend.ActionScriptCodeGeneratingModelVisitor;
import net.jangaroo.jooc.backend.JsCodeGenerator;
import net.jangaroo.jooc.model.AnnotationModel;
import net.jangaroo.jooc.model.AnnotationPropertyModel;
import net.jangaroo.jooc.model.ClassModel;
import net.jangaroo.jooc.model.CompilationUnitModel;
import net.jangaroo.jooc.model.CompilationUnitModelRegistry;
import net.jangaroo.jooc.model.FieldModel;
import net.jangaroo.jooc.model.MemberModel;
import net.jangaroo.jooc.model.MethodModel;
import net.jangaroo.jooc.model.MethodType;
import net.jangaroo.jooc.model.ModelVisitor;
import net.jangaroo.jooc.model.NamedModel;
import net.jangaroo.jooc.model.ParamModel;
import net.jangaroo.jooc.model.PropertyModel;
import net.jangaroo.utils.AS3Type;
import net.jangaroo.utils.CompilerUtils;

public class ExtAsApiGenerator {
    private static Map<String, ExtClass> extClasses;
    private static CompilationUnitModelRegistry compilationUnitModelRegistry;
    private static Set<String> interfaces;
    public static final List<String> NON_COMPILE_TIME_CONSTANT_INITIALIZERS;

    public static void main(String[] args) throws IOException {
        File srcDir = new File(args[0]);
        File outputDir = new File(args[1]);
        File[] files = srcDir.listFiles();
        if (files != null) {
            extClasses = new HashMap<String, ExtClass>();
            compilationUnitModelRegistry = new CompilationUnitModelRegistry();
            interfaces = new HashSet<String>();
            for (File jsonFile : files) {
                ExtClass extClass = ExtAsApiGenerator.readExtApiJson(jsonFile);
                if (extClass == null) continue;
                extClasses.put(extClass.name, extClass);
                for (String alternateClassName : extClass.alternateClassNames) {
                    extClasses.put(alternateClassName, extClass);
                }
                for (String mixin : extClass.mixins) {
                    interfaces.add(mixin);
                }
            }
            ExtAsApiGenerator.markTransitiveSupersAsInterfaces(interfaces);
            for (ExtClass extClass : new HashSet<ExtClass>(extClasses.values())) {
                ExtAsApiGenerator.generateClassModel(extClass);
            }
            compilationUnitModelRegistry.complementOverrides();
            compilationUnitModelRegistry.complementImports();
            for (CompilationUnitModel compilationUnitModel : compilationUnitModelRegistry.getCompilationUnitModels()) {
                ExtAsApiGenerator.generateActionScriptCode(compilationUnitModel, outputDir);
            }
        }
    }

    private static void markTransitiveSupersAsInterfaces(Set<String> extClasses) {
        Set<String> supers = ExtAsApiGenerator.supers(extClasses);
        while (interfaces.addAll(supers)) {
            supers = ExtAsApiGenerator.supers(supers);
        }
    }

    private static Set<String> supers(Set<String> extClasses) {
        HashSet<String> result = new HashSet<String>();
        for (String extClass : extClasses) {
            String superclass = ExtAsApiGenerator.extClasses.get((Object)extClass).extends_;
            if (superclass == null) continue;
            result.add(superclass);
        }
        return result;
    }

    private static ExtClass readExtApiJson(File jsonFile) throws IOException {
        System.out.printf("Reading API from %s...\n", jsonFile.getPath());
        ExtClass extClass = (ExtClass)new ObjectMapper().readValue(jsonFile, ExtClass.class);
        if (JsCodeGenerator.PRIMITIVES.contains(extClass.name)) {
            System.err.println("ignoring built-in class " + extClass.name);
            return null;
        }
        return extClass;
    }

    private static void generateClassModel(ExtClass extClass) {
        CompilationUnitModel extAsClassUnit = ExtAsApiGenerator.createClassModel(ExtAsApiGenerator.convertType(extClass.name));
        ClassModel extAsClass = (ClassModel)extAsClassUnit.getPrimaryDeclaration();
        System.out.printf("Generating AS3 API model %s for %s...%n", extAsClassUnit.getQName(), extClass.name);
        extAsClass.setAsdoc(ExtAsApiGenerator.toAsDoc(extClass.doc));
        CompilationUnitModel extAsInterfaceUnit = null;
        if (interfaces.contains(extClass.name)) {
            extAsInterfaceUnit = ExtAsApiGenerator.createClassModel(ExtAsApiGenerator.convertToInterface(extClass.name));
            System.out.printf("Generating AS3 API model %s for %s...%n", extAsInterfaceUnit.getQName(), extClass.name);
            ClassModel extAsInterface = (ClassModel)extAsInterfaceUnit.getPrimaryDeclaration();
            extAsInterface.setInterface(true);
            extAsInterface.setAsdoc(ExtAsApiGenerator.toAsDoc(extClass.doc));
            ExtAsApiGenerator.addInterfaceForSuperclass(extClass, extAsInterface);
        }
        if (ExtAsApiGenerator.isSingleton(extClass)) {
            FieldModel singleton = new FieldModel(CompilerUtils.className((String)extClass.name), extAsClassUnit.getQName());
            singleton.setConst(true);
            singleton.setValue("new " + extAsClassUnit.getQName());
            singleton.setAsdoc(extAsClass.getAsdoc());
            CompilationUnitModel singletonUnit = new CompilationUnitModel(extAsClassUnit.getPackage(), (NamedModel)singleton);
            compilationUnitModelRegistry.register(singletonUnit);
            extAsClass.setAsdoc(String.format("%s\n<p>Type of singleton %s.</p>\n * @see %s %s", extAsClass.getAsdoc(), singleton.getName(), CompilerUtils.qName((String)extAsClassUnit.getPackage(), (String)("#" + singleton.getName())), singletonUnit.getQName()));
        }
        extAsClass.setSuperclass(ExtAsApiGenerator.convertType(extClass.extends_));
        if (extAsInterfaceUnit != null) {
            extAsClass.addInterface(extAsInterfaceUnit.getQName());
        }
        for (String mixin : extClass.mixins) {
            String superInterface = ExtAsApiGenerator.convertToInterface(mixin);
            extAsClass.addInterface(superInterface);
            if (extAsInterfaceUnit == null) continue;
            extAsInterfaceUnit.getClassModel().addInterface(superInterface);
        }
        if (extAsInterfaceUnit != null) {
            ExtAsApiGenerator.addNonStaticMembers(extClass, extAsInterfaceUnit);
        }
        if (!extAsClass.isInterface()) {
            ExtAsApiGenerator.addFields(extAsClass, ExtAsApiGenerator.filterByOwner(false, extClass, extClass.statics.property));
            ExtAsApiGenerator.addMethods(extAsClass, ExtAsApiGenerator.filterByOwner(false, extClass, extClass.statics.method));
        }
        ExtAsApiGenerator.addNonStaticMembers(extClass, extAsClassUnit);
    }

    private static void addInterfaceForSuperclass(ExtClass extClass, ClassModel extAsInterface) {
        if (extClass.extends_ != null) {
            extAsInterface.addInterface(ExtAsApiGenerator.convertToInterface(extClass.extends_));
        }
    }

    private static CompilationUnitModel createClassModel(String qName) {
        CompilationUnitModel compilationUnitModel = new CompilationUnitModel(null, (NamedModel)new ClassModel());
        compilationUnitModel.setQName(qName);
        compilationUnitModelRegistry.register(compilationUnitModel);
        return compilationUnitModel;
    }

    private static void addNonStaticMembers(ExtClass extClass, CompilationUnitModel extAsClassUnit) {
        ExtAsApiGenerator.addEvents(extAsClassUnit, ExtAsApiGenerator.filterByOwner(false, extClass, extClass.members.event));
        ClassModel extAsClass = extAsClassUnit.getClassModel();
        ExtAsApiGenerator.addProperties(extAsClass, ExtAsApiGenerator.filterByOwner(extAsClass.isInterface(), extClass, extClass.members.property));
        ExtAsApiGenerator.addMethods(extAsClass, ExtAsApiGenerator.filterByOwner(extAsClass.isInterface(), extClass, extClass.members.method));
        ExtAsApiGenerator.addProperties(extAsClass, ExtAsApiGenerator.filterByOwner(extAsClass.isInterface(), extClass, extClass.members.cfg));
    }

    private static void generateActionScriptCode(CompilationUnitModel extAsClass, File outputDir) throws IOException {
        File outputFile = CompilerUtils.fileFromQName((String)extAsClass.getQName(), (File)outputDir, (String)".as");
        outputFile.getParentFile().mkdirs();
        System.out.printf("Generating AS3 API for %s into %s...\n", extAsClass.getQName(), outputFile.getPath());
        extAsClass.visit((ModelVisitor)new ActionScriptCodeGeneratingModelVisitor((Writer)new FileWriter(outputFile)));
    }

    private static <T extends Member> List<T> filterByOwner(boolean isInterface, ExtClass owner, List<T> members) {
        ArrayList<Member> result = new ArrayList<Member>();
        for (Member member : members) {
            if (!member.owner.equals(owner.name) || isInterface && !ExtAsApiGenerator.isPublicNonStaticMethod(member)) continue;
            result.add(member);
        }
        return result;
    }

    private static boolean isPublicNonStaticMethod(Member member) {
        return member instanceof Method && !member.meta.static_ && !member.meta.private_ && !member.meta.protected_ && !"constructor".equals(member.name);
    }

    private static boolean isConst(Member member) {
        return member.meta.readonly || member.name.equals(member.name.toUpperCase()) && member.default_ != null;
    }

    private static void addEvents(CompilationUnitModel compilationUnitModel, List<Event> events) {
        for (Event event : events) {
            ClassModel classModel = compilationUnitModel.getClassModel();
            String eventTypeQName = ExtAsApiGenerator.generateEventClass(compilationUnitModel, event);
            AnnotationModel annotationModel = new AnnotationModel("Event", new AnnotationPropertyModel[]{new AnnotationPropertyModel("name", "'" + event.name + "'"), new AnnotationPropertyModel("type", "'" + eventTypeQName + "'")});
            annotationModel.setAsdoc(ExtAsApiGenerator.toAsDoc(event.doc) + String.format("\n * @eventType %s.NAME", eventTypeQName));
            classModel.addAnnotation(annotationModel);
            System.err.println("*** adding event " + event.name + " to class " + classModel.getName());
        }
    }

    public static String capitalize(String name) {
        return name == null || name.length() == 0 ? name : Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    private static String generateEventClass(CompilationUnitModel compilationUnitModel, Event event) {
        ClassModel classModel = compilationUnitModel.getClassModel();
        String eventTypeQName = CompilerUtils.qName((String)compilationUnitModel.getPackage(), (String)("events." + classModel.getName() + ExtAsApiGenerator.capitalize(event.name) + "Event"));
        CompilationUnitModel extAsClassUnit = ExtAsApiGenerator.createClassModel(eventTypeQName);
        ClassModel extAsClass = (ClassModel)extAsClassUnit.getPrimaryDeclaration();
        extAsClass.setAsdoc(ExtAsApiGenerator.toAsDoc(event.doc) + "\n * @see " + compilationUnitModel.getQName());
        FieldModel eventNameConstant = new FieldModel("NAME", "String", CompilerUtils.quote((String)event.name));
        eventNameConstant.setStatic(true);
        eventNameConstant.setAsdoc(MessageFormat.format("This constant defines the value of the <code>type</code> property of the event object\nfor a <code>{0}</code> event.\n   * @eventType {0}", event.name));
        extAsClass.addMember((MemberModel)eventNameConstant);
        MethodModel constructorModel = extAsClass.createConstructor();
        constructorModel.addParam(new ParamModel("arguments", "Array"));
        StringBuilder propertyAssignments = new StringBuilder();
        for (int i = 0; i < event.params.size(); ++i) {
            Param param = event.params.get(i);
            if (i > 0) {
                propertyAssignments.append("\n    ");
            }
            propertyAssignments.append(String.format("this['%s'] = arguments[%d];", ExtAsApiGenerator.convertName(param.name), i));
            MethodModel property = new MethodModel(MethodType.GET, ExtAsApiGenerator.convertName(param.name), ExtAsApiGenerator.convertType(param.type));
            property.setAsdoc(ExtAsApiGenerator.toAsDoc(param.doc));
            extAsClass.addMember((MemberModel)property);
        }
        constructorModel.setBody(propertyAssignments.toString());
        return eventTypeQName;
    }

    private static void addFields(ClassModel classModel, List<? extends Member> fields) {
        for (Member member : fields) {
            FieldModel fieldModel = new FieldModel(ExtAsApiGenerator.convertName(member.name), ExtAsApiGenerator.convertType(member.type), member.default_);
            fieldModel.setAsdoc(ExtAsApiGenerator.toAsDoc(member.doc));
            ExtAsApiGenerator.setStatic((MemberModel)fieldModel, member);
            fieldModel.setConst(ExtAsApiGenerator.isConst(member));
            classModel.addMember((MemberModel)fieldModel);
        }
    }

    private static void addProperties(ClassModel classModel, List<? extends Member> properties) {
        for (Member member : properties) {
            if (classModel.getMember(member.name) != null) continue;
            PropertyModel propertyModel = new PropertyModel(ExtAsApiGenerator.convertName(member.name), ExtAsApiGenerator.convertType(member.type));
            propertyModel.setAsdoc(ExtAsApiGenerator.toAsDoc(member.doc));
            ExtAsApiGenerator.setStatic((MemberModel)propertyModel, member);
            propertyModel.addGetter();
            if (!member.meta.readonly) {
                propertyModel.addSetter();
            }
            classModel.addMember((MemberModel)propertyModel);
        }
    }

    private static void addMethods(ClassModel classModel, List<Method> methods) {
        for (Method method : methods) {
            if (classModel.getMember(method.name) != null) continue;
            boolean isConstructor = method.name.equals("constructor");
            MethodModel methodModel = isConstructor ? new MethodModel(classModel.getName(), null) : new MethodModel(ExtAsApiGenerator.convertName(method.name), ExtAsApiGenerator.convertType(method.return_.type));
            methodModel.setAsdoc(ExtAsApiGenerator.toAsDoc(method.doc));
            methodModel.getReturnModel().setAsdoc(ExtAsApiGenerator.toAsDoc(method.return_.doc));
            ExtAsApiGenerator.setStatic((MemberModel)methodModel, method);
            for (Param param : method.params) {
                ParamModel paramModel = new ParamModel(ExtAsApiGenerator.convertName(param.name), ExtAsApiGenerator.convertType(param.type));
                paramModel.setAsdoc(ExtAsApiGenerator.toAsDoc(param.doc));
                ExtAsApiGenerator.setDefaultValue(paramModel, param);
                paramModel.setRest(param == method.params.get(method.params.size() - 1) && param.type.endsWith("..."));
                methodModel.addParam(paramModel);
            }
            classModel.addMember((MemberModel)methodModel);
        }
    }

    private static void setStatic(MemberModel memberModel, Member member) {
        memberModel.setStatic(member.meta.static_ || ExtAsApiGenerator.isStaticSingleton(extClasses.get(member.owner)));
    }

    private static String toAsDoc(String doc) {
        int closingBracePos;
        String asDoc = doc.trim();
        if (asDoc.startsWith("<p>")) {
            int endTagPos = asDoc.indexOf("</p>");
            asDoc = asDoc.substring(3, endTagPos) + asDoc.substring(endTagPos + 4);
        }
        if (asDoc.startsWith("{") && (closingBracePos = asDoc.indexOf("} ")) != -1) {
            asDoc = asDoc.substring(closingBracePos + 2);
        }
        return asDoc;
    }

    private static void setDefaultValue(ParamModel paramModel, Param param) {
        String defaultValue = param.default_;
        if (defaultValue != null && NON_COMPILE_TIME_CONSTANT_INITIALIZERS.contains(defaultValue)) {
            paramModel.setAsdoc("(Default " + defaultValue + ") " + paramModel.getAsdoc());
            defaultValue = null;
            param.optional = true;
        }
        if (defaultValue == null && param.optional) {
            defaultValue = AS3Type.getDefaultValue((String)paramModel.getType());
        }
        paramModel.setValue(defaultValue);
    }

    private static String convertName(String name) {
        return "is".equals(name) ? "matches" : ("class".equals(name) ? "cls" : ("this".equals(name) ? "source" : ("new".equals(name) ? "new_" : name)));
    }

    private static String convertToInterface(String mixin) {
        String packageName = CompilerUtils.packageName((String)mixin).toLowerCase();
        String className = "I" + CompilerUtils.className((String)mixin);
        if (packageName.startsWith("ext")) {
            packageName = "ext4" + packageName.substring(3);
        }
        return CompilerUtils.qName((String)packageName, (String)className);
    }

    private static String convertType(String extType) {
        if (extType == null) {
            return null;
        }
        if ("undefined".equals(extType)) {
            return "void";
        }
        if ("HTMLElement".equals(extType) || "Event".equals(extType)) {
            return "js." + extType;
        }
        if (extType.endsWith("...")) {
            return "Array";
        }
        if (!extType.matches("[a-zA-Z0-9._$<>]+") || "Mixed".equals(extType)) {
            return "*";
        }
        ExtClass extClass = extClasses.get(extType);
        if (extClass != null) {
            extType = extClass.name;
        }
        if ("Ext".equals(extType)) {
            extType = "ext.Ext";
        }
        String packageName = CompilerUtils.packageName((String)extType).toLowerCase();
        String className = CompilerUtils.className((String)extType);
        if (ExtAsApiGenerator.isSingleton(extClass)) {
            className = "S" + className;
        }
        if (JsCodeGenerator.PRIMITIVES.contains(className)) {
            if ("ext".equals(packageName)) {
                if (ExtAsApiGenerator.isStaticSingleton(extClass)) {
                    packageName = "ext.util";
                    className = className + "Util";
                } else {
                    className = "Ext" + className;
                }
            } else {
                className = className + ExmlUtils.createComponentClassName((String)packageName.substring(packageName.lastIndexOf(46) + 1));
            }
        } else if ("is".equals(className)) {
            className = "Is";
        }
        if (packageName.startsWith("ext")) {
            packageName = "ext4" + packageName.substring(3);
        }
        return CompilerUtils.qName((String)packageName, (String)className);
    }

    private static boolean isSingleton(ExtClass extClass) {
        return extClass != null && extClass.singleton && !ExtAsApiGenerator.isStaticSingleton(extClass);
    }

    private static boolean isStaticSingleton(ExtClass extClass) {
        return extClass != null && extClass.singleton && (extClass.extends_ == null || extClass.extends_.length() == 0) && extClass.statics.cfg.isEmpty() && extClass.statics.event.isEmpty() && extClass.statics.method.isEmpty() && extClass.statics.property.isEmpty() && extClass.statics.css_mixin.isEmpty() && extClass.statics.css_var.isEmpty();
    }

    static {
        NON_COMPILE_TIME_CONSTANT_INITIALIZERS = Arrays.asList("window", "document", "document.body");
    }

    public static class Meta {
        @JsonProperty(value="protected")
        public boolean protected_;
        @JsonProperty(value="private")
        public boolean private_;
        public boolean readonly;
        @JsonProperty(value="static")
        public boolean static_;
        @JsonProperty(value="abstract")
        public boolean abstract_;
        public boolean markdown;
        public Map<String, String> deprecated;
        public String template;
        public List<String> author;
        public List<String> docauthor;
        public boolean required;
        public Map<String, String> removed;
    }

    public static class Event
    extends Member {
        public List<Param> params;
    }

    public static class Method
    extends Member {
        public List<Param> params;
        @JsonProperty(value="return")
        public Param return_;
    }

    public static class Param
    extends Var {
        public boolean optional;
    }

    public static class Property
    extends Member {
        public String toString() {
            return this.meta + "var " + super.toString();
        }
    }

    public static class Overrides {
        public String name;
        public String owner;
        public String id;
    }

    public static class MemberReference
    extends Tag {
        public String cls;
        public String member;
        public String type;
    }

    public static class Member
    extends Var {
        public String owner;
        public String shortDoc;
        public Meta meta;
        public boolean inheritable;
        public String id;
        public List<String> files;
        public boolean accessor;
        public boolean evented;
        public List<Overrides> overrides;
    }

    @JsonIgnoreProperties(value={"html_type", "html_meta", "properties"})
    public static abstract class Var
    extends Tag {
        public String type;
        @JsonProperty(value="default")
        public String default_;
    }

    public static class Members {
        public List<Member> cfg;
        public List<Property> property;
        public List<Method> method;
        public List<Event> event;
        public List<Member> css_var;
        public List<Member> css_mixin;
    }

    public static class ExtClass
    extends Tag {
        @JsonProperty(value="extends")
        public String extends_;
        public List<String> mixins;
        public List<String> alternateClassNames;
        public Map<String, List<String>> aliases;
        public boolean singleton;
        public List<String> requires;
        public List<String> uses;
        public String code_type;
        public boolean inheritable;
        public Meta meta;
        public String id;
        public Members members;
        public Members statics;
        public List<Object> files;
        public boolean component;
        public List<String> superclasses;
        public List<String> subclasses;
        public List<String> mixedInto;
        public List<String> parentMixins;
        @JsonProperty(value="abstract")
        public boolean abstract_;
    }

    @JsonIgnoreProperties(value={"html_meta", "html_type"})
    public static class Tag {
        public String tagname;
        public String name;
        public String doc;
        @JsonProperty(value="private")
        public String private_;
        public MemberReference inheritdoc;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tag tag = (Tag)o;
            return this.name.equals(tag.name) && !(this.tagname == null ? tag.tagname != null : !this.tagname.equals(tag.tagname));
        }

        public int hashCode() {
            int result = this.tagname != null ? this.tagname.hashCode() : 0;
            result = 31 * result + this.name.hashCode();
            return result;
        }
    }
}

