/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jangaroo.jooc.JangarooParser;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.Annotation;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.ImportDirective;
import net.jangaroo.jooc.ast.NamespaceDeclaration;
import net.jangaroo.jooc.ast.NodeImplBase;
import net.jangaroo.jooc.ast.PackageDeclaration;
import net.jangaroo.jooc.input.InputSource;
import net.jangaroo.utils.AS3Type;

public class CompilationUnit
extends NodeImplBase {
    private PackageDeclaration packageDeclaration;
    private JooSymbol lBrace;
    private List<AstNode> directives;
    private IdeDeclaration primaryDeclaration;
    private JooSymbol rBrace;
    private boolean hasStaticCode = false;
    private Set<String> dependencies = new LinkedHashSet<String>();
    private Set<CompilationUnit> dependenciesAsCompilationUnits = new LinkedHashSet<CompilationUnit>();
    private Set<String> publicApiDependencies = new HashSet<String>();
    private Set<String> usedBuiltIns = new LinkedHashSet<String>();
    private Scope scope;
    private Map<String, String> auxVarsByPackage = new LinkedHashMap<String, String>();
    private boolean auxVarsRendered;
    private InputSource source;
    private JangarooParser compiler;

    public CompilationUnit(PackageDeclaration packageDeclaration, JooSymbol lBrace, List<AstNode> directives, IdeDeclaration primaryDeclaration, JooSymbol rBrace, List<IdeDeclaration> secondaryDeclarations) {
        this.packageDeclaration = packageDeclaration;
        this.lBrace = lBrace;
        this.directives = directives;
        this.primaryDeclaration = primaryDeclaration;
        if (primaryDeclaration instanceof ClassDeclaration) {
            ((ClassDeclaration)primaryDeclaration).setSecondaryDeclarations(secondaryDeclarations);
        }
        this.rBrace = rBrace;
    }

    @Override
    public List<? extends AstNode> getChildren() {
        ArrayList<AstNode> result = new ArrayList<AstNode>(this.makeChildren(super.getChildren(), this.packageDeclaration, this.directives, this.primaryDeclaration));
        if (this.primaryDeclaration instanceof ClassDeclaration) {
            result.addAll(((ClassDeclaration)this.primaryDeclaration).getSecondaryDeclarations());
        }
        return result;
    }

    public List<AstNode> getDirectives() {
        return this.directives;
    }

    public void addBuiltInUsage(String builtIn) {
        this.usedBuiltIns.add(builtIn);
    }

    public String getAuxVarForPackage(String packageQName) {
        return this.auxVarsByPackage.get(packageQName);
    }

    public String getAuxVarForPackage(Scope lookupScope, String packageQName) {
        if (this.auxVarsRendered) {
            throw new IllegalStateException("aux vars already rendered!");
        }
        String auxVar = this.getAuxVarForPackage(packageQName);
        if (auxVar == null) {
            auxVar = this.scope.createAuxVar(lookupScope).getName();
            this.auxVarsByPackage.put(packageQName, auxVar);
        }
        return auxVar;
    }

    public Map<String, String> getAuxVarDeclarations() {
        this.auxVarsRendered = true;
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String string : this.usedBuiltIns) {
            String value = "joo." + ("$$bound".equals(string) ? "boundMethod" : string);
            result.put(string, value);
        }
        for (Map.Entry entry : this.auxVarsByPackage.entrySet()) {
            result.put((String)entry.getValue(), (String)entry.getKey());
        }
        return result;
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitCompilationUnit(this);
    }

    private void addStarImport(Ide packageIde) {
        ImportDirective importDirective = new ImportDirective(packageIde, AS3Type.ANY.toString());
        this.directives.add(0, importDirective);
    }

    @Override
    public void scope(Scope scope) {
        this.withNewDeclarationScope(this, scope, new NodeImplBase.Scoped(){

            @Override
            public void run(Scope scope) {
                Ide packageIde = CompilationUnit.this.packageDeclaration.getIde();
                CompilationUnit.this.packageDeclaration.scope(scope);
                if (packageIde != null) {
                    CompilationUnit.this.addStarImport(packageIde);
                }
                CompilationUnit.this.addStarImport(null);
                for (AstNode node : CompilationUnit.this.getDirectives()) {
                    node.scope(scope);
                }
                CompilationUnit.this.withNewDeclarationScope(CompilationUnit.this.packageDeclaration, scope, new NodeImplBase.Scoped(){

                    @Override
                    public void run(Scope scope) {
                        CompilationUnit.this.scope = scope;
                        CompilationUnit.this.primaryDeclaration.scope(scope);
                    }
                });
            }
        });
    }

    public PackageDeclaration getPackageDeclaration() {
        return this.packageDeclaration;
    }

    public IdeDeclaration getPrimaryDeclaration() {
        return this.primaryDeclaration;
    }

    public JooSymbol getLBrace() {
        return this.lBrace;
    }

    public JooSymbol getRBrace() {
        return this.rBrace;
    }

    public Set<String> getDependencies() {
        return this.dependencies;
    }

    public Set<String> getPublicApiDependencies() {
        return this.publicApiDependencies;
    }

    public Set<CompilationUnit> getDependenciesAsCompilationUnits() {
        return this.dependenciesAsCompilationUnits;
    }

    public JangarooParser getCompiler() {
        return this.compiler;
    }

    public void setCompiler(JangarooParser compiler) {
        this.compiler = compiler;
    }

    public void setSource(InputSource source) {
        this.source = source;
    }

    public InputSource getSource() {
        return this.source;
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        this.packageDeclaration.analyze(this);
        this.primaryDeclaration.analyze(this);
    }

    public Annotation getAnnotation(String name) {
        List<AstNode> directives = this.getDirectives();
        for (AstNode directive : directives) {
            Annotation annotation;
            if (!(directive instanceof Annotation) || !name.equals((annotation = (Annotation)directive).getMetaName())) continue;
            return annotation;
        }
        return null;
    }

    @Override
    public JooSymbol getSymbol() {
        return this.packageDeclaration.getSymbol();
    }

    public void setHasStaticCode() {
        this.hasStaticCode = true;
    }

    public boolean isHasStaticCode() {
        return this.hasStaticCode;
    }

    public void addDependency(CompilationUnit otherUnit) {
        if (otherUnit != null && otherUnit != this && otherUnit.getAnnotation("Native") == null) {
            String qname = otherUnit.getPrimaryDeclaration().getQualifiedNameStr();
            this.dependencies.add(qname);
            this.dependenciesAsCompilationUnits.add(otherUnit);
        }
    }

    public void addPublicApiDependency(CompilationUnit otherUnit) {
        String qname;
        IdeDeclaration otherUnitPrimaryDeclaration;
        if (otherUnit != null && otherUnit != this && ((otherUnitPrimaryDeclaration = otherUnit.getPrimaryDeclaration()) instanceof ClassDeclaration || otherUnitPrimaryDeclaration instanceof NamespaceDeclaration) && (qname = otherUnitPrimaryDeclaration.getQualifiedNameStr()).indexOf(46) != -1) {
            this.publicApiDependencies.add(qname);
        }
    }

    public String addResourceDependency(String relativePath) {
        String path;
        String string = path = relativePath.startsWith("/") || relativePath.startsWith("\\") ? relativePath : new File(this.source.getParent().getRelativePath(), relativePath).getPath().replace('\\', '/');
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        this.dependencies.add("resource:" + path);
        return path;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getPrimaryDeclaration().getQualifiedNameStr() + ")";
    }
}

