/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import java.util.List;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.Directive;
import net.jangaroo.jooc.ast.Ide;

public class UseNamespaceDirective
extends Directive {
    private JooSymbol useKeyword;
    private JooSymbol namespaceKeyword;
    private Ide namespace;
    private JooSymbol symSemicolon;

    public UseNamespaceDirective(JooSymbol useKeyword, JooSymbol namespaceKeyword, Ide namespace, JooSymbol symSemicolon) {
        this.useKeyword = useKeyword;
        assert ("namespace".equals(namespaceKeyword.getText()));
        this.namespaceKeyword = namespaceKeyword;
        this.namespace = namespace;
        this.symSemicolon = symSemicolon;
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return this.makeChildren(super.getChildren(), this.namespace);
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitUseNamespaceDirective(this);
    }

    @Override
    public void scope(Scope scope) {
        this.getNamespace().scope(scope);
    }

    @Override
    public void analyze(AstNode parentNode) {
        Jooc.warning(this.getNamespace().getSymbol(), "namespaces are not yet implemented, ignoring use namespace " + this.getNamespace().getName());
        this.getNamespace().analyze(this);
        super.analyze(parentNode);
    }

    @Override
    public JooSymbol getSymbol() {
        return this.getUseKeyword();
    }

    public JooSymbol getUseKeyword() {
        return this.useKeyword;
    }

    public JooSymbol getNamespaceKeyword() {
        return this.namespaceKeyword;
    }

    public Ide getNamespace() {
        return this.namespace;
    }

    public JooSymbol getSymSemicolon() {
        return this.symSemicolon;
    }
}

