/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

public class SourceFilesHandler
extends OptionHandler<List<File>> {
    public SourceFilesHandler(CmdLineParser parser2, OptionDef option, Setter<? super List<File>> setter) {
        super(parser2, option, setter);
    }

    @Override
    public int parseArguments(Parameters parameters) throws CmdLineException {
        ArrayList<File> sourceFiles = new ArrayList<File>(parameters.size());
        for (int i = 0; i < parameters.size(); ++i) {
            String sourcePath = parameters.getParameter(i);
            File sourceFile = new File(sourcePath.replace('/', File.separatorChar));
            if (!sourceFile.exists()) {
                throw new CmdLineException(this.owner, "Source file does not exist: " + sourceFile.getAbsolutePath());
            }
            sourceFiles.add(sourceFile);
        }
        this.setter.addValue(sourceFiles);
        return parameters.size();
    }

    @Override
    public String getDefaultMetaVariable() {
        return "SOURCE FILES";
    }
}

