/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import java.util.List;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.TypeRelation;
import net.jangaroo.jooc.ast.TypedIdeDeclaration;
import net.jangaroo.jooc.ast.VariableDeclaration;

public class IdeExpr
extends Expr {
    private Ide ide;

    public IdeExpr(JooSymbol symIde) {
        this(new Ide(symIde));
    }

    public IdeExpr(Ide ide) {
        this.ide = ide;
    }

    public static IdeExpr fromPrefix(JooSymbol symPrefix, JooSymbol symDot, Ide ide) {
        return new IdeExpr(ide.qualify(symPrefix, symDot));
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return this.makeChildren(super.getChildren(), this.ide);
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitIdeExpression(this);
    }

    @Override
    public void scope(Scope scope) {
        this.getIde().scope(scope);
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        this.getIde().analyze(this);
        this.getIde().analyzeAsExpr(parentNode, this);
        IdeDeclaration type = this.getIde().resolveDeclaration();
        if (type instanceof VariableDeclaration) {
            TypeRelation optTypeRelation = ((VariableDeclaration)type).getOptTypeRelation();
            type = optTypeRelation == null ? null : optTypeRelation.getType().getIde().getDeclaration(false);
        }
        this.setType(type);
    }

    @Override
    public JooSymbol getSymbol() {
        return this.getIde().getSymbol();
    }

    @Override
    public boolean isRuntimeConstant() {
        String qualifiedNameStr = this.ide.getQualifiedNameStr();
        return qualifiedNameStr.equals("undefined") || qualifiedNameStr.equals("NaN");
    }

    @Override
    public boolean isCompileTimeConstant() {
        IdeDeclaration qualifierDeclaration;
        if (this.isRuntimeConstant()) {
            return true;
        }
        IdeDeclaration declaration = this.ide.getDeclaration(false);
        if (declaration != null) {
            return declaration.isDeclaringCompileTimeConstant();
        }
        if (this.ide.isQualified() && (qualifierDeclaration = this.ide.getQualifier().getDeclaration(false)) instanceof ClassDeclaration) {
            ClassDeclaration classDeclaration = (ClassDeclaration)qualifierDeclaration;
            TypedIdeDeclaration staticMemberDeclaration = classDeclaration.getStaticMemberDeclaration(this.ide.getName());
            return staticMemberDeclaration.isDeclaringCompileTimeConstant();
        }
        return false;
    }

    public final Ide getIde() {
        return this.ide;
    }
}

