/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.model;

import net.jangaroo.jooc.model.MemberModel;
import net.jangaroo.jooc.model.MethodModel;
import net.jangaroo.jooc.model.MethodType;
import net.jangaroo.jooc.model.ModelVisitor;

public class PropertyModel
extends MemberModel {
    private boolean isFinal = false;
    private MethodModel getter = null;
    private MethodModel setter = null;

    public PropertyModel() {
    }

    public PropertyModel(String name, String type) {
        super(name, type);
    }

    PropertyModel(MethodModel accessor, MethodModel counterpart) {
        super(accessor.getName(), accessor.isGetter() ? accessor.getType() : accessor.getParams().get(0).getType());
        this.isFinal = accessor.isFinal();
        this.setStatic(accessor.isStatic());
        this.getter = accessor.isGetter() ? accessor : counterpart;
        this.setter = accessor.isSetter() ? accessor : counterpart;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
        if (this.getter != null) {
            this.getter.setFinal(isFinal);
        }
        if (this.setter != null) {
            this.setter.setFinal(isFinal);
        }
    }

    @Override
    public boolean isProperty() {
        return true;
    }

    public MethodModel getGetter() {
        return this.getter;
    }

    public MethodModel addGetter() {
        this.getter = new MethodModel(MethodType.GET, this.getName(), this.getType());
        this.getter.setStatic(this.isStatic());
        this.getter.setAsdoc(this.getAsdoc());
        return this.getter;
    }

    public MethodModel getSetter() {
        return this.setter;
    }

    public MethodModel addSetter() {
        this.setter = new MethodModel(MethodType.SET, this.getName(), this.getType());
        this.setter.setStatic(this.isStatic());
        return this.setter;
    }

    public MethodModel getMethod(MethodType methodType) {
        return methodType == MethodType.GET ? this.getter : this.setter;
    }

    public boolean isReadable() {
        return this.getter != null;
    }

    public boolean isWritable() {
        return this.setter != null;
    }

    @Override
    public void setType(String type) {
        super.setType(type);
        if (this.getter != null) {
            this.getter.setType(type);
        }
        if (this.setter != null) {
            this.setter.getParams().get(0).setType(type);
        }
    }

    @Override
    public void setStatic(boolean isStatic) {
        super.setStatic(isStatic);
        if (this.getter != null) {
            this.getter.setStatic(isStatic);
        }
        if (this.setter != null) {
            this.setter.setStatic(isStatic);
        }
    }

    @Override
    public void visit(ModelVisitor visitor) {
        visitor.visitProperty(this);
    }
}

