/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.mojo;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.jangaroo.exml.compiler.Exmlc;
import net.jangaroo.exml.config.ValidationMode;
import net.jangaroo.exml.mojo.ExmlMojo;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProjectHelper;

public class ExmlXsdMojo
extends ExmlMojo {
    private MavenProjectHelper projectHelper;

    @Override
    protected List<File> getSourcePath() {
        ArrayList<File> sourcePath = new ArrayList<File>(super.getSourcePath());
        sourcePath.add(this.getGeneratedSourcesDirectory());
        return Collections.unmodifiableList(sourcePath);
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.useAllSources();
        super.execute();
    }

    @Override
    protected void executeExmlc(Exmlc exmlc) {
        if (exmlc.getConfig().getValidationMode() != ValidationMode.OFF) {
            this.getLog().info((CharSequence)("validating " + exmlc.getConfig().getSourceFiles().size() + " EXML files..."));
        }
        File xsdFile = exmlc.generateXsd();
        this.projectHelper.attachArtifact(this.getProject(), "xsd", xsdFile);
        this.getLog().info((CharSequence)("xsd-file '" + xsdFile + "' generated."));
        Resource generatedResources = new Resource();
        generatedResources.setDirectory(this.getGeneratedResourcesDirectory().getPath());
        this.getProject().addResource(generatedResources);
        this.getLog().info((CharSequence)("added project resource '" + generatedResources + "."));
    }
}

