/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.mojo;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.jangaroo.exml.api.ExmlcException;
import net.jangaroo.exml.compiler.Exmlc;
import net.jangaroo.exml.config.ExmlConfiguration;
import net.jangaroo.jooc.mvnplugin.JangarooMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public abstract class AbstractExmlMojo
extends JangarooMojo {
    private MavenProject project;
    private File sourceDirectory;
    private File generatedSourcesDirectory;
    private File generatedResourcesDirectory;
    private String configClassPackage;
    private Set<String> includes = new HashSet<String>();
    private Set<String> excludes = new HashSet<String>();
    private int staleMillis;

    protected MavenProject getProject() {
        return this.project;
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public File getGeneratedSourcesDirectory() {
        return this.generatedSourcesDirectory;
    }

    public File getGeneratedResourcesDirectory() {
        return this.generatedResourcesDirectory;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        File gSourcesDirectory = this.getGeneratedSourcesDirectory();
        if (!gSourcesDirectory.exists()) {
            this.getLog().info((CharSequence)("generating sources into: " + gSourcesDirectory.getPath()));
            this.getLog().debug((CharSequence)("created " + gSourcesDirectory.mkdirs()));
        }
        if (!this.generatedResourcesDirectory.exists()) {
            this.getLog().info((CharSequence)("generating resources into: " + this.generatedResourcesDirectory.getPath()));
            this.getLog().debug((CharSequence)("created " + this.generatedResourcesDirectory.mkdirs()));
        }
        ExmlConfiguration exmlConfiguration = new ExmlConfiguration();
        exmlConfiguration.setConfigClassPackage(this.configClassPackage);
        exmlConfiguration.setClassPath(this.getActionScriptClassPath());
        exmlConfiguration.setOutputDirectory(gSourcesDirectory);
        exmlConfiguration.setResourceOutputDirectory(this.generatedResourcesDirectory);
        List<File> sourcePath = this.getSourcePath();
        try {
            exmlConfiguration.setSourcePath(sourcePath);
        }
        catch (IOException e) {
            throw new MojoExecutionException("could not determine source directory", (Exception)e);
        }
        exmlConfiguration.setSourceFiles(this.getMavenPluginHelper().computeStaleSources(sourcePath, this.includes, this.excludes, gSourcesDirectory, ".exml", ".as", this.staleMillis));
        try {
            this.getLog().debug((CharSequence)("Exmlc configuration: " + exmlConfiguration));
            Exmlc exmlc = new Exmlc(exmlConfiguration);
            this.executeExmlc(exmlc);
        }
        catch (ExmlcException e) {
            throw new MojoFailureException(e.toString(), (Throwable)e);
        }
        this.getProject().addCompileSourceRoot(gSourcesDirectory.getPath());
    }

    protected abstract void executeExmlc(Exmlc var1);

    protected abstract List<File> getSourcePath();

    protected List<File> getActionScriptClassPath() {
        return this.getMavenPluginHelper().getActionScriptClassPath(false);
    }
}

