/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.generator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.jangaroo.exml.model.ConfigClass;
import net.jangaroo.exml.model.ConfigClassRegistry;

public class MxmlLibraryManifestGenerator {
    private final ConfigClassRegistry configClassRegistry;

    public MxmlLibraryManifestGenerator(ConfigClassRegistry configClassRegistry) {
        this.configClassRegistry = configClassRegistry;
    }

    public File createManifestFile() throws FileNotFoundException, UnsupportedEncodingException {
        File outputFile = new File((File)this.configClassRegistry.getConfig().getSourcePath().get(0), "manifest.xml");
        System.out.printf("Creating manifest file %s...%n", outputFile.getPath());
        PrintStream out = new PrintStream((OutputStream)new FileOutputStream(outputFile), true, "UTF-8");
        Collection<ConfigClass> sourceConfigClasses = this.configClassRegistry.getSourceConfigClasses();
        ArrayList<String> classes = new ArrayList<String>(sourceConfigClasses.size() * 2);
        for (ConfigClass configClass : sourceConfigClasses) {
            classes.add(configClass.getComponentClassName());
        }
        Collections.sort(classes);
        out.println("<?xml version=\"1.0\"?>");
        out.println("<componentPackage>");
        for (String aClass : classes) {
            out.printf("  <component class=\"%s\"/>%n", aClass);
        }
        out.println("</componentPackage>");
        out.close();
        return outputFile;
    }
}

