/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.jangaroo.exml.model.TypedField;
import net.jangaroo.utils.AS3Type;

public final class ConfigAttribute
extends TypedField {
    private static final Set<String> SIMPLE_TYPES = new HashSet<String>(Arrays.asList(AS3Type.BOOLEAN.toString(), AS3Type.NUMBER.toString(), AS3Type.INT.toString(), AS3Type.UINT.toString(), AS3Type.DATE.toString(), AS3Type.STRING.toString()));
    private static final Collection<String> SEQUENCE_TYPES = new HashSet<String>(Arrays.asList(AS3Type.ARRAY.toString(), "MixedCollection", "Mixed"));

    public ConfigAttribute(String name, String type, String description) {
        super(name, type, description);
        if (type == null) {
            throw new IllegalArgumentException("The type should not be null for config attribute: '" + name + "'");
        }
    }

    public String getXsType() {
        return this.isSimple() ? this.getType() : "String";
    }

    public boolean isSimple() {
        return SIMPLE_TYPES.contains(this.getType());
    }

    public boolean isSequence() {
        return SEQUENCE_TYPES.contains(this.getType());
    }

    public boolean isObject() {
        return !SIMPLE_TYPES.contains(this.getType()) && !SEQUENCE_TYPES.contains(this.getType());
    }

    public String toString() {
        return this.getName() + " : " + this.getType();
    }
}

