/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.generator;

import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import net.jangaroo.exml.config.ExmlConfiguration;
import net.jangaroo.exml.generator.ExmlComponentClassModel;
import net.jangaroo.exml.model.ExmlModel;

public final class ExmlComponentClassGenerator {
    private ExmlConfiguration config;

    public ExmlComponentClassGenerator(ExmlConfiguration config) {
        this.config = config;
    }

    public void generateClass(ExmlModel model, Writer output) throws IOException, TemplateException {
        Configuration cfg = new Configuration();
        cfg.setClassForTemplateLoading(ExmlComponentClassModel.class, "/");
        cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        Template template = cfg.getTemplate("/net/jangaroo/exml/templates/exml_component_class.ftl");
        ExmlComponentClassModel exmlComponentClassModel = new ExmlComponentClassModel(model);
        Environment env = template.createProcessingEnvironment((Object)exmlComponentClassModel, output);
        env.setOutputEncoding("UTF-8");
        env.process();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File generateClass(ExmlModel model, File result) throws IOException, TemplateException {
        Writer writer = null;
        try {
            result.getParentFile().mkdirs();
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(result), "UTF-8");
            this.generateClass(model, writer);
            File file = result;
            return file;
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

