/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.ant;

import java.io.File;
import java.util.ArrayList;
import net.jangaroo.exml.compiler.Exmlc;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class ExmlcTask
extends MatchingTask {
    private static final String FAIL_MSG = "Compile failed; see the compiler error output for details.";
    private Path src;
    private File resourceDir;
    private String classpath;
    private String configClassPackage;
    private File destDir;
    private String sourcepath;
    private boolean failOnError = true;
    private File[] compileList = new File[0];

    public String getConfigClassPackage() {
        return this.configClassPackage;
    }

    public void setConfigClassPackage(String configClassPackage) {
        this.configClassPackage = configClassPackage;
    }

    public Path createSrc() {
        if (this.src == null) {
            this.src = new Path(this.getProject());
        }
        return this.src.createPath();
    }

    protected Path recreateSrc() {
        this.src = null;
        return this.createSrc();
    }

    public void setSrcdir(Path srcDir) {
        if (this.src == null) {
            this.src = srcDir;
        } else {
            this.src.append(srcDir);
        }
    }

    public Path getSrcdir() {
        return this.src;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public void setDestdir(File destDir) {
        this.destDir = destDir;
    }

    public File getDestdir() {
        return this.destDir;
    }

    public File getResourceDir() {
        return this.resourceDir;
    }

    public void setResourceDir(File resourceDir) {
        this.resourceDir = resourceDir;
    }

    public void setFailonerror(boolean fail) {
        this.failOnError = fail;
    }

    public boolean getFailonerror() {
        return this.failOnError;
    }

    public void execute() throws BuildException {
        String[] list;
        this.checkParameters();
        this.resetFileLists();
        this.sourcepath = "";
        for (String aList : list = this.src.list()) {
            File srcDir = this.getProject().resolveFile(aList);
            if (!srcDir.exists()) {
                throw new BuildException("srcdir \"" + srcDir.getPath() + "\" does not exist!", this.getLocation());
            }
            if (!this.sourcepath.isEmpty()) {
                this.sourcepath = this.sourcepath + File.pathSeparator;
            }
            this.sourcepath = this.sourcepath + srcDir.getAbsolutePath();
            DirectoryScanner ds = this.getDirectoryScanner(srcDir);
            String[] files = ds.getIncludedFiles();
            this.scanDir(srcDir, this.destDir != null ? this.destDir : srcDir, files);
        }
        this.compile();
    }

    protected void resetFileLists() {
        this.compileList = new File[0];
    }

    protected void scanDir(File srcDir, File destDir, String[] files) {
        GlobPatternMapper m = new GlobPatternMapper();
        m.setFrom("*.exml");
        m.setTo("*.as");
        SourceFileScanner sfs = new SourceFileScanner((Task)this);
        File[] newFiles = sfs.restrictAsFiles(files, srcDir, destDir, (FileNameMapper)m);
        if (newFiles.length > 0) {
            File[] newCompileList = new File[this.compileList.length + newFiles.length];
            System.arraycopy(this.compileList, 0, newCompileList, 0, this.compileList.length);
            System.arraycopy(newFiles, 0, newCompileList, this.compileList.length, newFiles.length);
            this.compileList = newCompileList;
        }
    }

    public File[] getFileList() {
        return (File[])this.compileList.clone();
    }

    protected void checkParameters() throws BuildException {
        if (this.src == null) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        if (this.src.size() == 0) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        if (this.destDir != null && !this.destDir.isDirectory()) {
            throw new BuildException("destination directory \"" + this.destDir + "\" does not exist or is not a directory", this.getLocation());
        }
    }

    protected void compile() {
        if (this.compileList.length > 0) {
            this.log("Compiling " + this.compileList.length + " joo source file" + (this.compileList.length == 1 ? "" : "s") + (this.destDir != null ? " to " + this.destDir : ""));
            String[] joocArgs = this.getExmlcArgs();
            if (Exmlc.run(joocArgs) != 0) {
                if (this.failOnError) {
                    throw new BuildException(FAIL_MSG, this.getLocation());
                }
                this.log(FAIL_MSG, 0);
            }
        } else {
            this.log("no *.exml files to compile");
        }
    }

    protected String[] getExmlcArgs() {
        ArrayList<String> args = new ArrayList<String>(this.compileList.length + 10);
        if (this.configClassPackage != null) {
            args.add("-c");
            args.add(this.configClassPackage);
        }
        if (this.destDir != null) {
            args.add("-d");
            args.add(this.destDir.getAbsolutePath());
        }
        args.add("-sourcepath");
        args.add(this.sourcepath);
        if (this.classpath != null && !this.classpath.isEmpty()) {
            args.add("-classpath");
            args.add(this.classpath);
        }
        for (File aCompileList : this.compileList) {
            String filename = aCompileList.getAbsolutePath();
            args.add(filename);
        }
        return args.toArray(new String[args.size()]);
    }
}

