/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.parser;

import java.util.Deque;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import net.jangaroo.exml.api.ExmlcException;
import net.jangaroo.exml.compiler.Exmlc;
import net.jangaroo.exml.model.AnnotationAt;
import net.jangaroo.exml.model.ConfigAttribute;
import net.jangaroo.exml.model.ConfigClass;
import net.jangaroo.exml.model.ConfigClassType;
import net.jangaroo.exml.model.Declaration;
import net.jangaroo.exml.model.DescriptionHolder;
import net.jangaroo.exml.model.PublicApiMode;
import net.jangaroo.exml.parser.ExmlToModelParser;
import net.jangaroo.exml.utils.ExmlUtils;
import net.jangaroo.jooc.json.JsonObject;
import net.jangaroo.utils.CharacterRecordingHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class ExmlMetadataHandler
extends CharacterRecordingHandler {
    private ConfigClass configClass;
    private Locator locator;
    private Deque<QName> elementPath = new LinkedList<QName>();

    public ExmlMetadataHandler(ConfigClass configClass) {
        this.configClass = configClass;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (ExmlUtils.isExmlNamespace((String)uri)) {
            String importedClassName;
            if (Exmlc.EXML_ROOT_NODE_NAMES.contains(localName)) {
                this.configClass.setType(ConfigClassType.fromExmlRootNodeName(localName));
                for (int i = 0; i < atts.getLength(); ++i) {
                    PublicApiMode publicApiMode;
                    if (!"publicApi".equals(atts.getLocalName(i)) || (publicApiMode = Exmlc.parsePublicApiMode(atts.getValue(i))) == PublicApiMode.FALSE) continue;
                    this.configClass.addAnnotation("PublicApi");
                }
            } else if ("annotation".equals(localName)) {
                AnnotationAt annotationAt = AnnotationAt.BOTH;
                for (int i = 0; i < atts.getLength(); ++i) {
                    if (!"at".equals(atts.getLocalName(i))) continue;
                    annotationAt = Exmlc.parseAnnotationAtValue(atts.getValue(i));
                    break;
                }
                if (annotationAt != AnnotationAt.TARGET) {
                    this.startRecordingCharacters();
                }
            } else if ("cfg".equals(localName)) {
                ConfigAttribute cfg = new ConfigAttribute(atts.getValue("name"), atts.getValue("type"), null);
                if (this.configClass.contains(cfg)) throw new ExmlcException("Config '" + cfg.getName() + "' already defined.", this.locator.getLineNumber(), this.locator.getColumnNumber());
                this.configClass.addCfg(cfg);
            } else if ("description".equals(localName)) {
                if (this.isLastInPathExmlClass() || this.isLastInPathConfig() || this.isLastInPathConstant()) {
                    this.startRecordingCharacters();
                }
            } else if ("value".equals(localName)) {
                if (this.isLastInPathConstant()) {
                    this.startRecordingCharacters();
                }
            } else if ("constant".equals(localName)) {
                String name = atts.getValue("name");
                String type = atts.getValue("type");
                String value = atts.getValue("value");
                Declaration constant = new Declaration(name, ExmlMetadataHandler.formatValue(value, type), type);
                if (this.configClass.getConstants().contains(constant)) throw new ExmlcException("Constant '" + constant.getName() + "' already defined.", this.locator.getLineNumber(), this.locator.getColumnNumber());
                this.configClass.addConstant(constant);
            } else if ("import".equals(localName) && (importedClassName = atts.getValue("class")) != null) {
                this.configClass.addImport(importedClassName);
            }
        } else if (this.elementPath.size() == 1) {
            if (this.configClass.getSuperClassName() != null) {
                throw new ExmlcException("root node of EXML contained more than one component definition", this.locator.getLineNumber(), this.locator.getColumnNumber());
            }
            String thePackage = ExmlUtils.parsePackageFromNamespace((String)uri);
            if (thePackage == null) {
                throw new ExmlcException("namespace '" + uri + "' of superclass element in EXML file does not denote a config package", this.locator.getLineNumber(), this.locator.getColumnNumber());
            }
            this.configClass.setSuperClassName(thePackage + "." + localName);
        }
        this.elementPath.push(new QName(uri, localName));
    }

    private static String formatValue(String value, String type) {
        return value == null ? null : JsonObject.valueToString((Object)ExmlToModelParser.getAttributeValue(value, type), (int)2, (int)4);
    }

    private boolean isLastInPathExmlClass() {
        QName parent = this.elementPath.peek();
        return ExmlUtils.isExmlNamespace((String)parent.getNamespaceURI()) && Exmlc.EXML_ROOT_NODE_NAMES.contains(parent.getLocalPart());
    }

    private boolean isLastInPathConfig() {
        QName parent = this.elementPath.peek();
        return ExmlUtils.isExmlNamespace((String)parent.getNamespaceURI()) && "cfg".equals(parent.getLocalPart());
    }

    private boolean isLastInPathConstant() {
        QName parent = this.elementPath.peek();
        return ExmlUtils.isExmlNamespace((String)parent.getNamespaceURI()) && "constant".equals(parent.getLocalPart());
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.elementPath.pop();
        if (ExmlUtils.isExmlNamespace((String)uri)) {
            String characters;
            if ("description".equals(localName)) {
                String characters2 = this.popRecordedCharacters();
                if (characters2 != null) {
                    ConfigClass descriptionHolder;
                    DescriptionHolder descriptionHolder2 = this.isLastInPathConfig() ? (DescriptionHolder)this.configClass.getCfgs().get(this.configClass.getCfgs().size() - 1) : (this.isLastInPathExmlClass() ? this.configClass : (descriptionHolder = this.isLastInPathConstant() ? this.getLastConstantDeclaration() : null));
                    if (descriptionHolder != null) {
                        descriptionHolder.setDescription(characters2);
                    }
                }
            } else if ("value".equals(localName)) {
                String characters3 = this.popRecordedCharacters();
                if (characters3 != null) {
                    Declaration lastConstantDeclaration = this.getLastConstantDeclaration();
                    lastConstantDeclaration.setValue(ExmlMetadataHandler.formatValue(characters3, lastConstantDeclaration.getType()));
                }
            } else if ("annotation".equals(localName) && (characters = this.popRecordedCharacters()) != null) {
                this.configClass.addAnnotation(characters);
            }
            if (this.elementPath.isEmpty() && this.configClass.getSuperClassName() == null) {
                this.configClass.setSuperClassName(this.configClass.getType().getDefaultSuperConfigClassName());
            }
        }
    }

    private Declaration getLastConstantDeclaration() {
        return this.configClass.getConstants().get(this.configClass.getConstants().size() - 1);
    }
}

