/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import net.jangaroo.exml.config.ExmlConfiguration;
import net.jangaroo.exml.config.ValidationMode;
import net.jangaroo.exml.utils.ExmlUtils;
import net.jangaroo.jooc.api.FilePosition;
import net.jangaroo.utils.CompilerUtils;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ExmlValidator {
    private final ExmlConfiguration config;
    private final Map<String, ExmlSchemaSource> exmlSchemaSourceByNamespace;

    public ExmlValidator(ExmlConfiguration config) {
        this.config = config;
        this.exmlSchemaSourceByNamespace = new HashMap<String, ExmlSchemaSource>();
        this.addClasspathXsdMappings(this.exmlSchemaSourceByNamespace);
        this.addXsdMappingsFromFilesInDirectory(this.exmlSchemaSourceByNamespace, this.config.getResourceOutputDirectory());
    }

    public void validateExmlFile(File exmlFile) throws IOException, SAXException {
        SAXParser parser = this.setupSAXParser();
        this.validateOneExmlfile(parser, exmlFile);
    }

    public void validateAllExmlFiles() throws IOException, SAXException {
        SAXParser parser = this.setupSAXParser();
        for (File exmlFile : this.config.getSourceFiles()) {
            this.validateOneExmlfile(parser, exmlFile);
        }
    }

    private void validateOneExmlfile(SAXParser parser, final File exmlFile) throws SAXException, IOException {
        try {
            parser.parse(exmlFile, new DefaultHandler(){

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    ExmlValidator.this.logSAXParseException(exmlFile, e, true);
                }

                @Override
                public void error(SAXParseException e) throws SAXException {
                    ExmlValidator.this.logSAXParseException(exmlFile, e, ExmlValidator.this.config.getValidationMode() == ValidationMode.ERROR);
                }

                @Override
                public void warning(SAXParseException e) throws SAXException {
                    ExmlValidator.this.logSAXParseException(exmlFile, e, false);
                }
            });
        }
        catch (SAXParseException e) {
            this.logSAXParseException(exmlFile, e, true);
        }
    }

    private void logSAXParseException(File exmlFile, SAXParseException e, boolean isError) {
        SAXParseException2FilePositionAdapter filePosition = new SAXParseException2FilePositionAdapter(exmlFile, e);
        if (isError) {
            this.config.getLog().error((FilePosition)filePosition, e.getMessage());
        } else {
            this.config.getLog().warning((FilePosition)filePosition, e.getMessage());
        }
    }

    private SAXParser setupSAXParser() throws IOException {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            ExmlSchemaResolver exmlSchemaResolver = new ExmlSchemaResolver();
            schemaFactory.setResourceResolver(exmlSchemaResolver);
            ArrayList<StreamSource> schemas = new ArrayList<StreamSource>();
            schemas.add(new StreamSource(this.getClass().getResourceAsStream("/net/jangaroo/exml/schemas/exml.xsd"), "exml"));
            schemas.add(new StreamSource(this.getClass().getResourceAsStream("/net/jangaroo/exml/schemas/untyped.xsd"), "untyped"));
            Collection<ExmlSchemaSource> exmlSchemaSources = this.exmlSchemaSourceByNamespace.values();
            for (ExmlSchemaSource exmlSchemaSource : exmlSchemaSources) {
                schemas.add(exmlSchemaSource.newStreamSource());
            }
            Schema exmlSchema = schemaFactory.newSchema(schemas.toArray(new Source[schemas.size()]));
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            saxFactory.setNamespaceAware(true);
            saxFactory.setSchema(exmlSchema);
            SAXParser saxParser = saxFactory.newSAXParser();
            saxParser.getXMLReader().setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return null;
                }
            });
            return saxParser;
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("A default dom builder should be provided.", e);
        }
        catch (SAXParseException e) {
            this.logSAXParseException(null, e, true);
            throw new IllegalStateException("SAX parser error while parsing EXML schemas.", e);
        }
        catch (SAXException e) {
            throw new IllegalStateException("SAX parser does not support validation.", e);
        }
    }

    private void addClasspathXsdMappings(Map<String, ExmlSchemaSource> schemas) {
        for (File classPathEntry : this.config.getClassPath()) {
            if (this.addXsdMappingsFromFilesInDirectory(schemas, classPathEntry) || this.addXsdMappingsFromEntriesInJar(schemas, classPathEntry)) continue;
            System.err.println("[WARN] ignoring invalid classpath entry " + classPathEntry.getPath());
        }
    }

    private boolean addXsdMappingsFromEntriesInJar(Map<String, ExmlSchemaSource> schemas, File jarFile) {
        if (jarFile == null || !jarFile.exists() || !jarFile.getName().endsWith(".jar")) {
            return false;
        }
        try {
            ZipFile jarZipFile = new ZipFile(jarFile);
            Set xsdZipEntries = ExmlUtils.findXsdJarEntries((ZipFile)jarZipFile);
            for (ZipEntry xsdZipEntry : xsdZipEntries) {
                String xsdZipEntryName = xsdZipEntry.getName();
                String namespace = "exml:" + CompilerUtils.removeExtension((String)xsdZipEntryName);
                schemas.put(namespace, new ExmlSchemaZipEntrySource(jarFile, xsdZipEntry));
            }
            return true;
        }
        catch (IOException e) {
            System.err.println("Cannot read classpath JAR file '" + jarFile.getPath() + "'.");
            e.printStackTrace();
            return false;
        }
    }

    private boolean addXsdMappingsFromFilesInDirectory(Map<String, ExmlSchemaSource> schemas, File xsdsDirectory) {
        if (xsdsDirectory != null && xsdsDirectory.exists() && xsdsDirectory.isDirectory()) {
            File[] xsds;
            for (File xsd : xsds = xsdsDirectory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".xsd");
                }
            })) {
                String namespace = "exml:" + CompilerUtils.removeExtension((String)xsd.getName());
                schemas.put(namespace, new ExmlSchemaFileSource(xsd));
            }
            return true;
        }
        return false;
    }

    private static String constructUrl(File jarFile, ZipEntry xsdEntry) {
        try {
            return "jar:" + jarFile.toURI().toURL() + "!/" + xsdEntry.getName();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("cannot happen");
        }
    }

    private static final class StreamSourceLSInput
    implements LSInput {
        private ExmlSchemaSource exmlSchemaSource;

        private StreamSourceLSInput(ExmlSchemaSource exmlSchemaSource) {
            this.exmlSchemaSource = exmlSchemaSource;
        }

        @Override
        public InputStream getByteStream() {
            return this.exmlSchemaSource.newInputStream();
        }

        @Override
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public String getStringData() {
            return null;
        }

        @Override
        public String getSystemId() {
            return null;
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public String getEncoding() {
            return null;
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
        }

        @Override
        public void setByteStream(InputStream byteStream) {
        }

        @Override
        public void setStringData(String stringData) {
        }

        @Override
        public void setSystemId(String systemId) {
        }

        @Override
        public void setPublicId(String publicId) {
        }

        @Override
        public void setBaseURI(String baseURI) {
        }

        @Override
        public void setEncoding(String encoding) {
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
        }
    }

    private class ExmlSchemaFileSource
    extends ExmlSchemaSource {
        private final File xsd;

        public ExmlSchemaFileSource(File xsd) {
            super(xsd.getPath());
            this.xsd = xsd;
        }

        @Override
        public InputStream newInputStream() {
            try {
                return new FileInputStream(this.xsd);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class ExmlSchemaZipEntrySource
    extends ExmlSchemaSource {
        private File jarFile;
        private ZipEntry xsdEntry;

        private ExmlSchemaZipEntrySource(File jarFile, ZipEntry xsdEntry) {
            super(ExmlValidator.constructUrl(jarFile, xsdEntry));
            this.jarFile = jarFile;
            this.xsdEntry = xsdEntry;
        }

        @Override
        public InputStream newInputStream() {
            try {
                return new ZipFile(this.jarFile).getInputStream(this.xsdEntry);
            }
            catch (IOException e) {
                throw new RuntimeException("cannot create input stream of " + this.getSystemId());
            }
        }
    }

    private abstract class ExmlSchemaSource {
        private String systemId;

        protected ExmlSchemaSource(String systemId) {
            this.systemId = systemId;
        }

        public String getSystemId() {
            return this.systemId;
        }

        public abstract InputStream newInputStream();

        public String toString() {
            return "[ExmlSchemaZipEntrySource " + this.getSystemId() + "]";
        }

        public StreamSource newStreamSource() {
            return new StreamSource(this.newInputStream(), this.getSystemId());
        }
    }

    private static class SAXParseException2FilePositionAdapter
    implements FilePosition {
        private final File exmlFile;
        private final SAXParseException e;

        public SAXParseException2FilePositionAdapter(File exmlFile, SAXParseException e) {
            this.exmlFile = exmlFile;
            this.e = e;
        }

        public String getFileName() {
            return this.exmlFile == null ? "-unknown-" : this.exmlFile.getAbsolutePath();
        }

        public int getLine() {
            return this.e.getLineNumber();
        }

        public int getColumn() {
            return this.e.getColumnNumber();
        }
    }

    private class ExmlSchemaResolver
    implements LSResourceResolver {
        private ExmlSchemaResolver() {
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            if ("http://www.w3.org/2001/XMLSchema".equals(type)) {
                ExmlSchemaSource exmlSchemaSource = (ExmlSchemaSource)ExmlValidator.this.exmlSchemaSourceByNamespace.get(namespaceURI);
                if (exmlSchemaSource != null) {
                    return new StreamSourceLSInput(exmlSchemaSource);
                }
                System.err.println("[WARN] ExmlValidator has been asked for unregistered resource " + namespaceURI);
            }
            return null;
        }
    }
}

