/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.compiler;

import java.io.File;
import java.io.IOException;
import net.jangaroo.exml.api.ExmlcException;
import net.jangaroo.exml.cli.ExmlcCommandLineParser;
import net.jangaroo.exml.config.ExmlConfiguration;
import net.jangaroo.exml.config.ValidationMode;
import net.jangaroo.exml.generator.ExmlComponentClassGenerator;
import net.jangaroo.exml.generator.ExmlConfigClassGenerator;
import net.jangaroo.exml.generator.ExmlConfigPackageXsdGenerator;
import net.jangaroo.exml.model.AnnotationAt;
import net.jangaroo.exml.model.ConfigClass;
import net.jangaroo.exml.model.ConfigClassRegistry;
import net.jangaroo.exml.model.ExmlModel;
import net.jangaroo.exml.model.PublicApiMode;
import net.jangaroo.exml.parser.ExmlToConfigClassParser;
import net.jangaroo.exml.parser.ExmlToModelParser;
import net.jangaroo.exml.parser.ExmlValidator;
import net.jangaroo.jooc.cli.CommandLineParseException;
import net.jangaroo.utils.CompilerUtils;

public final class Exmlc
implements net.jangaroo.exml.api.Exmlc {
    private ConfigClassRegistry configClassRegistry;
    private ExmlToConfigClassParser exmlToConfigClassParser;
    private ExmlConfigClassGenerator exmlConfigClassGenerator;
    private ExmlToModelParser exmlToModelParser;
    private ExmlComponentClassGenerator exmlComponentClassGenerator;
    private ExmlConfigPackageXsdGenerator exmlConfigPackageXsdGenerator;

    public Exmlc() {
    }

    public Exmlc(ExmlConfiguration config) {
        this.setConfig(config);
    }

    public static AnnotationAt parseAnnotationAtValue(String annotationAt) {
        if (annotationAt == null || annotationAt.length() == 0) {
            return null;
        }
        try {
            return AnnotationAt.valueOf(annotationAt.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new ExmlcException("EXML attribute 'at' must have one the values 'config', 'target', or 'both', not '" + annotationAt + "'.");
        }
    }

    public static PublicApiMode parsePublicApiMode(String publicApiMode) {
        if (publicApiMode == null || publicApiMode.length() == 0) {
            return null;
        }
        try {
            return PublicApiMode.valueOf(publicApiMode.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new ExmlcException("EXML attribute 'publicApi' must have one the values 'false', 'config', or 'true', not '" + publicApiMode + "'.");
        }
    }

    public void setConfig(ExmlConfiguration config) {
        try {
            this.configClassRegistry = new ConfigClassRegistry(config);
        }
        catch (IOException e) {
            throw new ExmlcException("unable to build config class registry: " + e.getMessage(), (Throwable)e);
        }
        this.exmlToConfigClassParser = new ExmlToConfigClassParser(config);
        this.exmlConfigClassGenerator = new ExmlConfigClassGenerator();
        this.exmlToModelParser = new ExmlToModelParser(this.configClassRegistry);
        this.exmlComponentClassGenerator = new ExmlComponentClassGenerator(config);
        this.exmlConfigPackageXsdGenerator = new ExmlConfigPackageXsdGenerator(config);
    }

    public ExmlConfiguration getConfig() {
        return this.configClassRegistry.getConfig();
    }

    public ExmlConfigPackageXsdGenerator getExmlConfigPackageXsdGenerator() {
        return this.exmlConfigPackageXsdGenerator;
    }

    public ExmlComponentClassGenerator getExmlComponentClassGenerator() {
        return this.exmlComponentClassGenerator;
    }

    public ConfigClassRegistry getConfigClassRegistry() {
        return this.configClassRegistry;
    }

    public void generateAllConfigClasses() {
        for (File sourceFile : this.getConfig().getSourceFiles()) {
            this.generateConfigClass(sourceFile);
        }
    }

    public File generateConfigClass(File source) {
        ConfigClass configClass;
        try {
            configClass = this.exmlToConfigClassParser.parseExmlToConfigClass(source);
            this.configClassRegistry.evaluateSuperClass(configClass);
        }
        catch (IOException e) {
            throw new ExmlcException("unable to parse EXML classes: " + e.getMessage(), source, (Exception)e);
        }
        File targetFile = this.getConfig().computeConfigClassTarget(configClass.getName());
        if (this.exmlConfigClassGenerator.mustGenerateConfigClass(source, targetFile)) {
            try {
                this.exmlConfigClassGenerator.generateClass(configClass, targetFile);
            }
            catch (Exception e) {
                throw new ExmlcException("unable to generate config class: " + e.getMessage(), targetFile, e);
            }
        }
        return targetFile;
    }

    public File generateComponentClass(File exmlSourceFile) {
        try {
            ExmlModel exmlModel = this.exmlToModelParser.parse(exmlSourceFile);
            File classFile = CompilerUtils.fileFromQName((String)exmlModel.getPackageName(), (String)exmlModel.getClassName(), (File)this.getConfig().findSourceDir(exmlSourceFile), (String)".as");
            return classFile.exists() ? null : this.exmlComponentClassGenerator.generateClass(exmlModel);
        }
        catch (Exception e) {
            throw new ExmlcException("unable to generate component class: " + e.getMessage(), exmlSourceFile, e);
        }
    }

    public void generateAllComponentClasses() {
        for (File sourceFile : this.getConfig().getSourceFiles()) {
            if (!sourceFile.getName().endsWith(".exml")) continue;
            this.generateComponentClass(sourceFile);
        }
    }

    public File generateXsd() {
        File xsdFile;
        try {
            xsdFile = this.exmlConfigPackageXsdGenerator.generateXsdFile(this.configClassRegistry);
        }
        catch (Exception e) {
            throw new ExmlcException("unable to generate xsd file: " + e.getMessage(), (Throwable)e);
        }
        if (this.getConfig().getValidationMode() != ValidationMode.OFF) {
            try {
                new ExmlValidator(this.getConfig()).validateAllExmlFiles();
            }
            catch (Exception e) {
                throw new ExmlcException("unable to start validation", (Throwable)e);
            }
        }
        return xsdFile;
    }

    public static int run(String[] argv) {
        ExmlConfiguration exmlConfiguration;
        ExmlcCommandLineParser parser = new ExmlcCommandLineParser();
        try {
            exmlConfiguration = parser.parse(argv);
        }
        catch (CommandLineParseException e) {
            System.err.println(e.getMessage());
            return e.getExitCode();
        }
        if (exmlConfiguration != null) {
            Exmlc exmlc = new Exmlc(exmlConfiguration);
            exmlc.generateAllConfigClasses();
            exmlc.generateAllComponentClasses();
            exmlc.generateXsd();
        }
        return 0;
    }

    public static void main(String[] argv) {
        int result = Exmlc.run(argv);
        if (result != 0) {
            System.exit(result);
        }
    }
}

