/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.jangaroo.exml.api.ExmlcException;
import net.jangaroo.exml.as.ConfigClassBuilder;
import net.jangaroo.exml.config.ExmlConfiguration;
import net.jangaroo.exml.model.ConfigClass;
import net.jangaroo.exml.parser.ExmlToConfigClassParser;
import net.jangaroo.jooc.JangarooParser;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.StdOutCompileLog;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.config.ParserOptions;
import net.jangaroo.jooc.config.SemicolonInsertionMode;
import net.jangaroo.jooc.input.FileInputSource;
import net.jangaroo.jooc.input.InputSource;
import net.jangaroo.jooc.input.PathInputSource;
import net.jangaroo.utils.CompilerUtils;

public final class ConfigClassRegistry {
    private Map<String, ConfigClass> configClassesByName = new HashMap<String, ConfigClass>();
    private Set<File> scannedExmlFiles = new HashSet<File>();
    private ExmlConfiguration config;
    private InputSource sourcePathInputSource;
    private JangarooParser jangarooParser;
    private ExmlToConfigClassParser exmlToConfigClassParser;

    public ConfigClassRegistry(final ExmlConfiguration config) throws IOException {
        this.config = config;
        this.sourcePathInputSource = PathInputSource.fromFiles(config.getSourcePath(), new String[0], true);
        PathInputSource classPathInputSource = PathInputSource.fromFiles(config.getClassPath(), new String[]{"", "META-INF/joo-api/"}, false);
        CCRParserOptions parserOptions = new CCRParserOptions();
        this.jangarooParser = new JangarooParser(parserOptions, new StdOutCompileLog()){

            @Override
            protected InputSource findSource(String qname) {
                InputSource inputSource = super.findSource(qname);
                if (inputSource instanceof FileInputSource && !((FileInputSource)inputSource).getSourceDir().equals(config.getOutputDirectory())) {
                    return inputSource;
                }
                ConfigClassRegistry.this.tryBuildConfigClassFromExml(qname);
                return super.findSource(qname);
            }
        };
        ArrayList<File> fullSourcePath = new ArrayList<File>(config.getSourcePath());
        fullSourcePath.add(config.getOutputDirectory());
        this.jangarooParser.setUp(PathInputSource.fromFiles(fullSourcePath, new String[0], true), classPathInputSource);
        this.exmlToConfigClassParser = new ExmlToConfigClassParser(config);
    }

    public ExmlConfiguration getConfig() {
        return this.config;
    }

    public Collection<ConfigClass> getRegisteredConfigClasses() {
        return this.configClassesByName.values();
    }

    public Map<String, Collection<ConfigClass>> getRegisteredConfigClassesByTargetClassPackage() {
        HashMap<String, HashSet<ConfigClass>> result = new HashMap<String, HashSet<ConfigClass>>();
        for (ConfigClass configClass : this.configClassesByName.values()) {
            String packageName = CompilerUtils.packageName(configClass.getComponentClassName());
            HashSet<ConfigClass> configClasses = (HashSet<ConfigClass>)result.get(packageName);
            if (configClasses == null) {
                configClasses = new HashSet<ConfigClass>();
                result.put(packageName, configClasses);
            }
            configClasses.add(configClass);
        }
        return Collections.unmodifiableMap(result);
    }

    public void scanAllAsFiles() {
        InputSource configPackage = this.sourcePathInputSource.getChild(this.config.getConfigClassPackage().replace('.', File.separatorChar));
        if (configPackage != null) {
            this.scanAsFiles(configPackage);
        }
    }

    private void scanAsFiles(InputSource inputSource) {
        for (InputSource inputSource2 : inputSource.list()) {
            File file = ((FileInputSource)inputSource2).getFile();
            if (file.isFile()) {
                String qName;
                if (!file.getName().endsWith(".as")) continue;
                try {
                    qName = CompilerUtils.qNameFromFile(this.getConfig().findSourceDir(file), file);
                }
                catch (IOException e) {
                    throw new ExmlcException("could not read AS file", e);
                }
                ConfigClass configClass = this.findActionScriptConfigClass(qName);
                this.addConfigClass(configClass);
                continue;
            }
            this.scanAsFiles(inputSource2);
        }
    }

    public void scanAllExmlFiles() {
        HashSet<ConfigClass> addedConfigClasses = new HashSet<ConfigClass>();
        this.scanExmlFiles(this.sourcePathInputSource, addedConfigClasses);
        for (ConfigClass configClass : addedConfigClasses) {
            this.evaluateSuperClass(configClass);
        }
    }

    private void scanExmlFiles(InputSource inputSource, Set<ConfigClass> addedConfigClasses) {
        for (InputSource inputSource2 : inputSource.list()) {
            File exmlFile = ((FileInputSource)inputSource2).getFile();
            if (exmlFile.isFile()) {
                if (!exmlFile.getName().endsWith(".exml") || this.scannedExmlFiles.contains(exmlFile)) continue;
                this.scannedExmlFiles.add(exmlFile);
                try {
                    ConfigClass configClass = this.exmlToConfigClassParser.parseExmlToConfigClass(exmlFile);
                    this.addConfigClass(configClass);
                    addedConfigClasses.add(configClass);
                    continue;
                }
                catch (IOException e) {
                    throw new ExmlcException("could not read EXML file", e);
                }
            }
            this.scanExmlFiles(inputSource2, addedConfigClasses);
        }
    }

    public ConfigClass getConfigClassByName(String name) {
        return this.getConfigClassByName(name, new HashSet<String>());
    }

    private ConfigClass getConfigClassByName(String name, Set<String> visited) {
        ConfigClass configClass = this.configClassesByName.get(name);
        if (configClass != null) {
            return configClass;
        }
        this.tryBuildConfigClassFromExml(name);
        configClass = this.configClassesByName.get(name);
        if (configClass != null) {
            return configClass;
        }
        configClass = this.findActionScriptConfigClass(name);
        this.addConfigClass(configClass);
        return configClass;
    }

    public ConfigClass getConfigClassOfTargetClass(String targetClassName) {
        for (ConfigClass configClass : this.configClassesByName.values()) {
            if (!targetClassName.equals(configClass.getComponentClassName())) continue;
            return configClass;
        }
        return null;
    }

    private void addConfigClass(ConfigClass configClass) {
        if (configClass != null) {
            String name = configClass.getFullName();
            ConfigClass existingConfigClass = this.configClassesByName.get(name);
            if (existingConfigClass != null) {
                if (!existingConfigClass.equals(configClass)) {
                    throw new ExmlcException(String.format("config class '%s' declared in '%s' and '%s'.", name, configClass.getComponentClassName(), existingConfigClass.getComponentClassName()));
                }
            } else {
                this.configClassesByName.put(name, configClass);
            }
        }
    }

    private ConfigClass tryBuildConfigClassFromExml(String name) {
        FileInputSource exmlInputSource = (FileInputSource)this.sourcePathInputSource.getChild(JangarooParser.getInputSourceFileName(name, this.sourcePathInputSource, ".exml"));
        if (exmlInputSource != null) {
            return this.buildFromExml(exmlInputSource);
        }
        if (name.startsWith(this.config.getConfigClassPackage() + ".")) {
            FileInputSource outputDirInputSource = new FileInputSource(this.config.getOutputDirectory(), true);
            FileInputSource generatedConfigAsFile = outputDirInputSource.getChild(JangarooParser.getInputSourceFileName(name, outputDirInputSource, ".as"));
            if (generatedConfigAsFile != null) {
                CompilationUnit compilationUnit = Jooc.doParse(generatedConfigAsFile, new StdOutCompileLog(), SemicolonInsertionMode.QUIRKS);
                if (compilationUnit == null) {
                    return null;
                }
                ConfigClass generatedAsConfigClass = this.buildConfigClass(compilationUnit);
                if (generatedAsConfigClass != null) {
                    String componentName = generatedAsConfigClass.getComponentClassName();
                    exmlInputSource = (FileInputSource)this.sourcePathInputSource.getChild(JangarooParser.getInputSourceFileName(componentName, this.sourcePathInputSource, ".exml"));
                    if (exmlInputSource == null) {
                        String lowerCaseComponentClassName = CompilerUtils.qName(CompilerUtils.packageName(componentName), CompilerUtils.uncapitalize(CompilerUtils.className(componentName)));
                        exmlInputSource = (FileInputSource)this.sourcePathInputSource.getChild(JangarooParser.getInputSourceFileName(lowerCaseComponentClassName, this.sourcePathInputSource, ".exml"));
                    }
                    if (exmlInputSource != null) {
                        return this.buildFromExml(exmlInputSource);
                    }
                }
            }
            this.scanAllExmlFiles();
            return this.configClassesByName.get(name);
        }
        return null;
    }

    private ConfigClass buildFromExml(FileInputSource exmlInputSource) {
        ConfigClass configClass;
        this.scannedExmlFiles.add(exmlInputSource.getFile());
        try {
            configClass = new ExmlToConfigClassParser(this.config).parseExmlToConfigClass(exmlInputSource.getFile());
            this.evaluateSuperClass(configClass);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.addConfigClass(configClass);
        return configClass;
    }

    private ConfigClass findActionScriptConfigClass(String name) {
        return this.findActionScriptConfigClass(name, new LinkedHashSet<String>());
    }

    private ConfigClass findActionScriptConfigClass(String name, Set<String> visited) {
        if (visited.contains(name)) {
            throw new ExmlcException("cyclic inheritance: " + Arrays.toString(visited.toArray()));
        }
        visited.add(name);
        CompilationUnit compilationsUnit = this.jangarooParser.getCompilationsUnit(name);
        ConfigClass configClass = null;
        if (compilationsUnit != null) {
            try {
                configClass = this.buildConfigClass(compilationsUnit);
                if (configClass != null && configClass.getComponentClassName() == null) {
                    return this.findActionScriptConfigClass(configClass.getFullName(), visited);
                }
                this.evaluateSuperClass(configClass, visited);
            }
            catch (RuntimeException e) {
                throw new ExmlcException("while building config class '" + name + "': " + e.getMessage(), e);
            }
        }
        return configClass;
    }

    public void evaluateSuperClass(ConfigClass configClass) {
        this.evaluateSuperClass(configClass, new LinkedHashSet<String>());
    }

    private void evaluateSuperClass(ConfigClass configClass, Set<String> visited) {
        String superClassName;
        if (configClass != null && (superClassName = configClass.getSuperClassName()) != null && !"joo.JavaScriptObject".equals(superClassName)) {
            ConfigClass configClassOfTargetClass = this.findConfigClassOfTargetClass(superClassName);
            if (configClassOfTargetClass != null) {
                superClassName = configClassOfTargetClass.getFullName();
            }
            if (configClass.getFullName().equals(superClassName)) {
                throw new ExmlcException(String.format("Cyclic inheritance error: superclass '%s' of config class '%s' are the same!", superClassName, configClass.getFullName()));
            }
            ConfigClass superClass = this.findActionScriptConfigClass(superClassName, visited);
            if (superClass == null && (superClass = this.tryBuildConfigClassFromExml(superClassName)) == null) {
                throw new ExmlcException(String.format("Superclass '%s' of class '%s' not found!", superClassName, configClass.getFullName()));
            }
            if (!configClass.getSuperClassName().equals(superClass.getFullName())) {
                configClass.setSuperClassName(superClass.getFullName());
            }
            configClass.setSuperClass(superClass);
        }
    }

    private ConfigClass findConfigClassOfTargetClass(String targetClassName) {
        for (ConfigClass configClass : this.configClassesByName.values()) {
            if (!targetClassName.equals(configClass.getComponentClassName())) continue;
            return configClass;
        }
        return null;
    }

    private ConfigClass buildConfigClass(CompilationUnit compilationUnit) {
        ConfigClassBuilder configClassBuilder = new ConfigClassBuilder(compilationUnit);
        return configClassBuilder.buildConfigClass();
    }

    private static class CCRParserOptions
    implements ParserOptions {
        private CCRParserOptions() {
        }

        @Override
        public SemicolonInsertionMode getSemicolonInsertionMode() {
            return SemicolonInsertionMode.QUIRKS;
        }

        @Override
        public boolean isVerbose() {
            return false;
        }
    }
}

