/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.jangaroo.exml.api.ExmlcException;
import net.jangaroo.exml.model.ConfigClass;
import net.jangaroo.exml.parser.ExmlMetadataHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ExmlToConfigClassParser {
    public ConfigClass parseExmlToConfigClass(File source) throws IOException {
        ConfigClass configClass = new ConfigClass();
        ExmlMetadataHandler metadataHandler = new ExmlMetadataHandler(configClass);
        ExmlToConfigClassParser.parseFileWithHandler(source, metadataHandler);
        return configClass;
    }

    public static void parseFileWithHandler(File source, ContentHandler handler) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(source);
            XMLReader xr = XMLReaderFactory.createXMLReader();
            xr.setContentHandler(handler);
            if (handler instanceof LexicalHandler) {
                xr.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            }
            xr.parse(new InputSource(inputStream));
        }
        catch (ExmlcException e) {
            e.setFile(source);
            throw e;
        }
        catch (Exception e) {
            throw new ExmlcException("could not parse EXML file", source, e);
        }
        finally {
            try {
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

