/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.compiler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import net.jangaroo.exml.api.ExmlcException;
import net.jangaroo.exml.cli.ExmlcCommandLineParser;
import net.jangaroo.exml.compiler.ExmlToMxml;
import net.jangaroo.exml.config.ExmlConfiguration;
import net.jangaroo.exml.model.AnnotationAt;
import net.jangaroo.exml.model.ConfigClassRegistry;
import net.jangaroo.exml.model.PublicApiMode;
import net.jangaroo.jooc.cli.CommandLineParseException;

public final class Exmlc
implements net.jangaroo.exml.api.Exmlc {
    private ConfigClassRegistry configClassRegistry;

    public Exmlc() {
    }

    public Exmlc(ExmlConfiguration config) {
        this.setConfig(config);
    }

    public static AnnotationAt parseAnnotationAtValue(String annotationAt) {
        if (annotationAt == null || annotationAt.length() == 0) {
            return null;
        }
        try {
            return AnnotationAt.valueOf(annotationAt.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new ExmlcException("EXML attribute 'at' must have one the values 'config', 'target', or 'both', not '" + annotationAt + "'.");
        }
    }

    public static PublicApiMode parsePublicApiMode(String publicApiMode) {
        if (publicApiMode == null || publicApiMode.length() == 0) {
            return null;
        }
        try {
            return PublicApiMode.valueOf(publicApiMode.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new ExmlcException("EXML attribute 'publicApi' must have one the values 'false', 'config', or 'true', not '" + publicApiMode + "'.");
        }
    }

    public void setConfig(ExmlConfiguration config) {
        try {
            this.configClassRegistry = new ConfigClassRegistry(config);
        }
        catch (IOException e) {
            throw new ExmlcException("unable to build config class registry: " + e.getMessage(), (Throwable)e);
        }
    }

    public ExmlConfiguration getConfig() {
        return this.configClassRegistry.getConfig();
    }

    public ConfigClassRegistry getConfigClassRegistry() {
        return this.configClassRegistry;
    }

    public void generateAllConfigClasses() {
        for (File sourceFile : this.getConfig().getSourceFiles()) {
            this.generateConfigClass(sourceFile);
        }
    }

    public File generateConfigClass(File source) {
        return this.configClassRegistry.generateConfigClass(source);
    }

    public File generateComponentClass(File exmlSourceFile) {
        return this.configClassRegistry.generateTargetClass(exmlSourceFile);
    }

    public void generateAllComponentClasses() {
        for (File sourceFile : this.getConfig().getSourceFiles()) {
            if (!sourceFile.getName().endsWith(".exml")) continue;
            this.generateComponentClass(sourceFile);
        }
    }

    public File generateXsd() {
        File targetPackageFolder = this.getConfig().getResourceOutputDirectory();
        if (!targetPackageFolder.exists()) {
            targetPackageFolder.mkdirs();
        }
        File result = new File(targetPackageFolder, this.getConfig().getConfigClassPackage() + ".xsd");
        Writer writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(result), "UTF-8");
            this.configClassRegistry.generateXsd(writer);
        }
        catch (Exception e) {
            throw new ExmlcException("unable to generate xsd file: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {}
        }
        return result;
    }

    public File[] convertAllExmlToMxml() {
        return new ExmlToMxml(this.configClassRegistry).convert();
    }

    public static int run(String[] argv) {
        ExmlConfiguration exmlConfiguration;
        ExmlcCommandLineParser parser = new ExmlcCommandLineParser();
        try {
            exmlConfiguration = parser.parse(argv);
        }
        catch (CommandLineParseException e) {
            System.err.println(e.getMessage());
            return e.getExitCode();
        }
        if (exmlConfiguration != null) {
            Exmlc exmlc = new Exmlc(exmlConfiguration);
            if (exmlConfiguration.isConvertToMxml()) {
                exmlc.convertAllExmlToMxml();
            } else {
                exmlc.generateAllConfigClasses();
                exmlc.generateAllComponentClasses();
                exmlc.generateXsd();
            }
        }
        return 0;
    }

    public static void main(String[] argv) {
        int result = Exmlc.run(argv);
        if (result != 0) {
            System.exit(result);
        }
    }
}

