/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.model;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.jangaroo.exml.json.JsonObject;
import net.jangaroo.exml.model.ConfigClass;
import net.jangaroo.exml.model.Declaration;
import net.jangaroo.exml.model.DescriptionHolder;
import net.jangaroo.exml.utils.ExmlUtils;

public class ExmlModel
extends DescriptionHolder {
    private String packageName;
    private String className;
    private String superClassName;
    private Set<String> imports = new LinkedHashSet<String>();
    private List<String> annotations = new ArrayList<String>();
    private List<Declaration> vars = new ArrayList<Declaration>();
    private JsonObject jsonObject = new JsonObject(new Object[0]);
    private ConfigClass configClass;
    private JsonObject cfgDefaults = new JsonObject(new Object[0]);

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getFullClassName() {
        return this.packageName.length() > 0 ? this.packageName + "." + this.className : this.className;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public Set<String> getImports() {
        return this.imports;
    }

    public List<String> getAnnotations() {
        return this.annotations;
    }

    public List<Declaration> getVars() {
        return this.vars;
    }

    public void addVar(Declaration var) {
        this.vars.add(var);
        this.addImport(var.getType());
    }

    public JsonObject getJsonObject() {
        return this.jsonObject;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setSuperClassName(String superClassName) {
        this.superClassName = superClassName;
    }

    public void addImport(String importedClassName) {
        ExmlUtils.addImport(this.imports, importedClassName);
    }

    public void addAnnotation(String annotation) {
        this.annotations.add(annotation);
    }

    public ConfigClass getConfigClass() {
        return this.configClass;
    }

    public void setConfigClass(ConfigClass configClass) {
        this.configClass = configClass;
        this.addImport(configClass.getFullName());
    }

    public JsonObject getCfgDefaults() {
        return this.cfgDefaults;
    }
}

