/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.compiler;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import net.jangaroo.exml.api.ExmlcException;
import net.jangaroo.exml.compiler.Exmlc;
import net.jangaroo.exml.generator.MxmlLibraryManifestGenerator;
import net.jangaroo.exml.json.JsonObject;
import net.jangaroo.exml.model.ConfigClass;
import net.jangaroo.exml.model.ConfigClassRegistry;
import net.jangaroo.exml.model.ConfigClassType;
import net.jangaroo.exml.model.Declaration;
import net.jangaroo.exml.model.ExmlModel;
import net.jangaroo.exml.model.ExmlSourceFile;
import net.jangaroo.exml.model.PublicApiMode;
import net.jangaroo.exml.parser.ExmlToConfigClassParser;
import net.jangaroo.exml.parser.ExmlToModelParser;
import net.jangaroo.exml.utils.ExmlUtils;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.ImportDirective;
import net.jangaroo.jooc.backend.ApiModelGenerator;
import net.jangaroo.jooc.model.CompilationUnitModel;
import net.jangaroo.jooc.model.MethodModel;
import net.jangaroo.jooc.model.ParamModel;
import net.jangaroo.jooc.mxml.CatalogComponentsParser;
import net.jangaroo.jooc.mxml.MxmlComponentRegistry;
import net.jangaroo.jooc.mxml.MxmlUtils;
import net.jangaroo.utils.AS3Type;
import net.jangaroo.utils.CharacterRecordingHandler;
import net.jangaroo.utils.CompilerUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class ExmlToMxml {
    private static final String LOCAL_NAMESPACE = "local";
    private ConfigClassRegistry configClassRegistry;
    private Properties migrationMap = new Properties();
    private ClassLoader resourceClassLoader = ExmlToMxml.class.getClassLoader();
    private MxmlComponentRegistry mxmlComponentRegistry = new MxmlComponentRegistry();

    public ExmlToMxml(ConfigClassRegistry configClassRegistry) {
        this.configClassRegistry = configClassRegistry;
        if (configClassRegistry.getConfig().getExtAsJar() != null) {
            try {
                this.resourceClassLoader = new URLClassLoader(new URL[]{new URL("jar:" + configClassRegistry.getConfig().getExtAsJar().toURI().toString() + "!/")});
            }
            catch (IOException e) {
                throw new ExmlcException("Unable to configure resource class loader", e);
            }
        }
    }

    public File[] convert() {
        Collection<ExmlSourceFile> exmlSourceFiles;
        InputStream migrationMapStream = this.resourceClassLoader.getResourceAsStream("ext-as-3.4-migration-map.properties");
        if (migrationMapStream == null) {
            throw new ExmlcException("Could not find migration map 'ext-as-3.4-migration-map.properties' in classpath.");
        }
        try {
            this.migrationMap.load(migrationMapStream);
        }
        catch (IOException e) {
            throw new ExmlcException("Unable to load migration map", e);
        }
        new CatalogComponentsParser(this.mxmlComponentRegistry).parse(this.resourceClassLoader.getResourceAsStream("catalog.xml"));
        try {
            new MxmlLibraryManifestGenerator(this.configClassRegistry).createManifestFile();
        }
        catch (IOException e) {
            throw new ExmlcException("Unable to create manifest.xml file: " + e.getMessage(), e);
        }
        Map<String, ExmlSourceFile> exmlSourceFilesByConfigClassName = this.configClassRegistry.getExmlSourceFilesByConfigClassName();
        ArrayList<File> mxmlFiles = new ArrayList<File>();
        List<File> sourceFiles = this.configClassRegistry.getConfig().getSourceFiles();
        if (sourceFiles.isEmpty()) {
            exmlSourceFiles = exmlSourceFilesByConfigClassName.values();
        } else {
            exmlSourceFiles = new ArrayList<ExmlSourceFile>();
            for (File exmlFile : sourceFiles) {
                exmlSourceFiles.add(this.configClassRegistry.getExmlSourceFile(exmlFile));
            }
        }
        for (ExmlSourceFile exmlSourceFile : exmlSourceFiles) {
            System.out.printf("Converting EXML file %s...%n", exmlSourceFile.getSourceFile());
            if (exmlSourceFile.hasSourceTargetClass()) {
                System.out.printf("  Target class %s is implemented in ActionScript: no need to generate MXML target class.", exmlSourceFile.getTargetClassName());
                continue;
            }
            try {
                File mxmlFile = this.exmlToMxml(exmlSourceFile);
                mxmlFiles.add(mxmlFile);
                System.out.printf("  Generated MXML target class %s into file %s.%n", exmlSourceFile.getTargetClassName(), mxmlFile.getPath());
            }
            catch (Exception e) {
                throw new ExmlcException("Unable to convert to MXML: " + e.getMessage(), exmlSourceFile.getSourceFile(), e);
            }
        }
        if (!this.configClassRegistry.getConfig().isKeepExmlFiles()) {
            for (ExmlSourceFile exmlSourceFile : exmlSourceFiles) {
                if (exmlSourceFile.getSourceFile().delete()) continue;
                System.err.println("Failed to delete EXML source file " + exmlSourceFile.getSourceFile().getPath());
            }
        }
        return mxmlFiles.toArray(new File[mxmlFiles.size()]);
    }

    private File exmlToMxml(ExmlSourceFile exmlSourceFile) throws IOException, SAXException {
        ExmlModel exmlModel = new ExmlToModelParser(this.configClassRegistry).parse(exmlSourceFile.getSourceFile());
        File sourceFile = exmlSourceFile.getSourceFile();
        File outputFile = CompilerUtils.fileFromQName(exmlSourceFile.getTargetClassName(), this.configClassRegistry.getConfig().getSourcePath().get(0), ".mxml");
        FileUtils.forceMkdir(outputFile.getParentFile());
        PrintStream writer = new PrintStream((OutputStream)new FileOutputStream(outputFile), true, "UTF-8");
        ExmlToConfigClassParser.parseFileWithHandler(sourceFile, new ExmlToMxmlHandler(exmlSourceFile, exmlModel, writer));
        return outputFile;
    }

    private static String convertNewLines(String output) {
        return output.replaceAll("\n", System.getProperty("line.separator"));
    }

    private static String[] parsePrefixAndLocalName(String qName) {
        int colonPos = qName.indexOf(58);
        String prefix = colonPos == -1 ? "" : qName.substring(0, colonPos);
        String localName = qName.substring(colonPos + 1);
        return new String[]{prefix, localName};
    }

    private static String formatQName(String prefix, String localName) {
        return prefix == null || prefix.isEmpty() ? localName : String.format("%s:%s", prefix, localName);
    }

    public static boolean isNotEmptyText(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (!Character.isLetterOrDigit(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static class PathElement {
        String originalName;
        String newName;

        public PathElement(String originalName, String newName) {
            this.originalName = originalName;
            this.newName = newName;
        }
    }

    private class ExmlToMxmlHandler
    extends CharacterRecordingHandler
    implements LexicalHandler {
        private static final String OPEN_FX_SCRIPT = "%n  <fx:Script><![CDATA[%n";
        private static final String CLOSE_FX_SCRIPT = "  ]]></fx:Script>";
        private static final String PUBLIC_STATIC_CONST_DECLARATION_FORMAT = "    public static const %s:%s = %s;%n%n";
        private final PrintStream out;
        private PrintStream currentOut;
        private boolean insideCdata;
        private boolean insideExmlObject;
        private ByteArrayOutputStream elementRecorder;
        private int lastColumn = 1;
        private Locator locator;
        private Map<String, String> prefixMappings = new LinkedHashMap<String, String>();
        private List<String> metaData = new ArrayList<String>();
        private boolean inMetaData;
        private boolean inConfigDescription;
        private boolean inConfigDefault;
        private String originalRootName;
        private String originalRootUri;
        private String exmlPrefix;
        private final Map<String, String> configDefaultSubElements = new LinkedHashMap<String, String>();
        private final Map<String, String> configDefaultTypes = new LinkedHashMap<String, String>();
        private boolean pendingTagClose = false;
        private Set<String> imports;
        private List<Declaration> vars;
        private LinkedList<Declaration> configs;
        private Set<String> varsWithXmlValue;
        private final Deque<PathElement> elementPath = new LinkedList<PathElement>();
        private final ExmlSourceFile exmlSourceFile;
        private final ExmlModel exmlModel;
        private String currentConfigName;
        private String currentVarName;
        private boolean isPublicApi;
        private String baseClass;
        private int nsCount = 0;
        private boolean printedRootElement;

        public ExmlToMxmlHandler(ExmlSourceFile exmlSourceFile, ExmlModel exmlModel, PrintStream out) {
            this.exmlSourceFile = exmlSourceFile;
            this.exmlModel = exmlModel;
            this.currentOut = this.out = out;
        }

        @Override
        public void startDocument() throws SAXException {
            this.currentOut.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.imports = new LinkedHashSet<String>();
            this.vars = new ArrayList<Declaration>();
            this.varsWithXmlValue = new HashSet<String>();
            this.configs = new LinkedList();
            this.startRecordingCharacters();
            this.prefixMappings.put(ExmlToMxml.LOCAL_NAMESPACE, this.createPackageNamespace(this.exmlModel.getPackageName()));
            super.startDocument();
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        @Override
        public void startPrefixMapping(String key, String uriValue) throws SAXException {
            this.prefixMappings.put(key, uriValue);
        }

        @Override
        public void startElement(String uri, String localName, String originalQName, Attributes atts) throws SAXException {
            boolean isPropertyElement;
            String qName = originalQName;
            LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
            if (ExmlUtils.isExmlNamespace(uri)) {
                if (Exmlc.EXML_ROOT_NODE_NAMES.contains(localName)) {
                    this.handleRootNode(atts);
                    this.originalRootName = originalQName;
                    this.originalRootUri = uri;
                    qName = null;
                } else if ("annotation".equals(localName)) {
                    this.inMetaData = true;
                    qName = null;
                } else if ("cfg".equals(localName)) {
                    qName = this.handleCfg(atts);
                } else if ("constant".equals(localName)) {
                    qName = null;
                } else if ("var".equals(localName)) {
                    qName = this.handleVar(atts);
                } else if ("value".equals(localName)) {
                    qName = this.handleInnerElement();
                } else if ("import".equals(localName)) {
                    qName = this.handleImport(atts);
                } else if ("default".equals(localName)) {
                    this.inConfigDefault = true;
                    qName = this.handleInnerElement();
                } else if ("description".equals(localName)) {
                    this.inConfigDescription = this.currentConfigName != null;
                    qName = null;
                } else if ("object".equals(localName)) {
                    if (atts.getLength() == 0 && this.printedRootElement) {
                        qName = null;
                    }
                    this.insideExmlObject = true;
                }
            }
            boolean isSubElement = this.elementPath.size() > 1;
            boolean bl = isPropertyElement = isSubElement && this.elementPath.size() % 2 == 0;
            if (isPropertyElement) {
                String lastQName = this.elementPath.peek().newName;
                if (lastQName != null) {
                    String prefix = ExmlToMxml.parsePrefixAndLocalName(lastQName)[0];
                    String targetName = this.getTargetClassAttributeName(uri, this.elementPath.peek().originalName, localName);
                    qName = targetName.length() > 0 ? this.qName(prefix, targetName) : null;
                }
            } else if (this.elementPath.size() > 0 && !ExmlUtils.isExmlNamespace(uri)) {
                qName = this.getTargetClassElementQName(uri, qName);
            }
            if (this.isNewRoot(uri, originalQName)) {
                this.addNamespaceMappings(attributes);
            }
            if (qName != null && this.currentVarName != null) {
                attributes.put("id", this.currentVarName);
                this.currentVarName = null;
            }
            boolean indentAttributes = true;
            if (qName != null && this.currentConfigName != null && !"Array".equals(this.configs.getLast().getType())) {
                attributes.put("id", this.currentConfigName);
                indentAttributes = false;
            }
            if (this.inConfigDefault && qName != null && !this.configDefaultTypes.containsKey(this.currentConfigName)) {
                this.configDefaultTypes.put(this.currentConfigName, originalQName);
            }
            for (int i = 0; i < atts.getLength(); ++i) {
                String attributeName = atts.getQName(i);
                if ("baseClass".equals(attributeName) || "publicApi".equals(attributeName)) continue;
                if (isPropertyElement && "mode".equals(attributeName)) {
                    attributeName = this.qName(this.exmlPrefix, "mode");
                } else if (!isPropertyElement) {
                    attributeName = this.getTargetClassAttributeName(uri, originalQName, attributeName);
                }
                if ("id".equals(attributeName)) {
                    attributeName = "id_";
                }
                if (attributeName.length() <= 0) continue;
                attributes.put(attributeName, atts.getValue(i));
            }
            if (!this.elementPath.isEmpty() && this.elementPath.peek().newName == null && (!this.inConfigDefault || ExmlUtils.isExmlNamespace(uri) && "default".equals(localName))) {
                this.popRecordedCharacters();
            }
            if (this.inConfigDescription || this.inMetaData) {
                this.startRecordingCharacters();
            }
            if ("exml:object".equals(qName)) {
                qName = "fx:Object";
            }
            if (this.isObjectLevel() && qName != null) {
                qName = this.getMappedComponentName(uri, qName, originalQName);
            }
            if (qName != null) {
                if (this.isNewRoot(uri, originalQName) && this.baseClass != null) {
                    qName = this.baseClass;
                }
                this.printStartTag(uri, originalQName, qName, attributes, indentAttributes);
            }
            if (this.isNewRoot(uri, originalQName)) {
                this.flushPendingTagClose();
                this.imports.add(this.exmlSourceFile.getConfigClassName());
                this.addImportsForConfigs();
                this.addImportsForConstants();
                this.printHeader();
                this.printedRootElement = true;
            }
            this.elementPath.push(new PathElement(originalQName, qName));
            this.lastColumn = this.locator.getColumnNumber();
        }

        private void addNamespaceMappings(Map<String, String> attributes) {
            LinkedHashMap<String, String> mxmlPrefixMappings = new LinkedHashMap<String, String>();
            mxmlPrefixMappings.put("fx", "http://ns.adobe.com/mxml/2009");
            this.exmlPrefix = this.findPrefix("http://www.jangaroo.net/exml/0.8");
            if (this.exmlPrefix == null) {
                System.err.println("[WARN] ExmlToMxml: no EXML namespace found!");
                this.exmlPrefix = "exml";
                mxmlPrefixMappings.put("exml", "http://www.jangaroo.net/exml/0.8");
            }
            mxmlPrefixMappings.putAll(this.prefixMappings);
            for (Map.Entry prefixMapping : mxmlPrefixMappings.entrySet()) {
                String key = (String)prefixMapping.getKey();
                attributes.put(key.isEmpty() ? "xmlns" : "xmlns:" + key, (String)prefixMapping.getValue());
            }
        }

        private boolean isObjectLevel() {
            return this.elementPath.size() % 2 == 1;
        }

        private void printStartTag(String uri, String originalQName, String qName, Map<String, String> attributes, boolean indentAttributes) {
            this.flush();
            String originalName = this.isNewRoot(uri, originalQName) ? this.originalRootName : originalQName;
            int column = this.isNewRoot(uri, originalQName) ? 1 : this.lastColumn;
            int indent = column + originalName.length();
            int qNameLengthDelta = originalName.length() - qName.length();
            String firstIndent = qNameLengthDelta == 0 || attributes.size() <= 1 ? "" : (qNameLengthDelta > 0 ? StringUtils.repeat(" ", qNameLengthDelta) : String.format("%n%s", StringUtils.repeat(" ", indent)));
            this.currentOut.printf("<%s%s", qName, firstIndent);
            this.printAttributes(attributes, indentAttributes ? indent + 1 : 0);
            this.pendingTagClose = true;
        }

        private void printHeader() throws SAXException {
            this.printMetadata();
            this.printOpenScript();
            this.printImports();
            this.printConstants();
            this.printVars();
            this.printInitializer();
            this.printConstructor();
            this.printConfigVars();
            this.printCloseScript();
            this.printDeclarations();
        }

        private void printImports() {
            for (String anImport : this.imports) {
                this.currentOut.printf("    import %s;%n", anImport);
            }
            if (!this.imports.isEmpty()) {
                this.currentOut.println();
            }
        }

        private void printConstants() {
            if ("component".equals(ExmlToMxml.parsePrefixAndLocalName(this.originalRootName)[1])) {
                this.currentOut.printf(PUBLIC_STATIC_CONST_DECLARATION_FORMAT, "xtype", "String", CompilerUtils.quote(this.exmlModel.getConfigClass().getFullName()));
            }
            for (Declaration constant : this.exmlModel.getConfigClass().getConstants()) {
                this.printASDoc(constant.getDescription());
                this.currentOut.printf(PUBLIC_STATIC_CONST_DECLARATION_FORMAT, constant.getName(), constant.getType(), constant.getValue());
            }
        }

        private void addImportsForConfigs() throws SAXException {
            for (Declaration config : this.configs) {
                String defaultType = this.configDefaultTypes.get(config.getName());
                if (defaultType != null && !config.getType().equals(defaultType)) {
                    this.addImport(config.getType());
                }
                if (this.hasDefaultConstructor(config.getType())) continue;
                this.addImport(config.getType());
            }
        }

        private void addImportsForConstants() throws SAXException {
            for (Declaration constant : this.exmlModel.getConfigClass().getConstants()) {
                this.addImport(constant.getType());
            }
        }

        private boolean hasDefaultConstructor(String name) throws SAXException {
            String qname = this.resolveQName(name);
            if (AS3Type.typeByName(qname) != null) {
                return true;
            }
            CompilationUnit compilationUnit = ExmlToMxml.this.configClassRegistry.getJangarooParser().getCompilationUnit(qname);
            if (compilationUnit != null) {
                try {
                    CompilationUnitModel compilationUnitModel = new ApiModelGenerator(false).generateModel(compilationUnit);
                    if (compilationUnitModel.getClassModel().isInterface()) {
                        return false;
                    }
                    MethodModel constructor = compilationUnitModel.getClassModel().getConstructor();
                    if (constructor != null) {
                        List<ParamModel> params = constructor.getParams();
                        return params.size() == 0 || params.get(0).isOptional() || params.get(0).isRest() || params.get(0).getName().equals("config");
                    }
                }
                catch (IOException e) {
                    throw new SAXException(e);
                }
            }
            return true;
        }

        private String getConfigClassFromTargetClass(String name) throws SAXException {
            CompilationUnit compilationUnit = ExmlToMxml.this.configClassRegistry.getJangarooParser().getCompilationUnit(this.resolveQName(name));
            if (compilationUnit != null) {
                try {
                    CompilationUnitModel compilationUnitModel = new ApiModelGenerator(false).generateModel(compilationUnit);
                    MethodModel constructor = compilationUnitModel.getClassModel().getConstructor();
                    if (constructor != null && constructor.getParams().size() > 0) {
                        String type = constructor.getParams().get(0).getType();
                        if (type != null && CompilerUtils.packageName(type).isEmpty()) {
                            for (AstNode astNode : compilationUnit.getDirectives()) {
                                ImportDirective importDirective;
                                if (!(astNode instanceof ImportDirective) || !CompilerUtils.className((importDirective = (ImportDirective)astNode).getQualifiedName()).equals(type)) continue;
                                return importDirective.getQualifiedName();
                            }
                        }
                        return type;
                    }
                }
                catch (IOException e) {
                    throw new SAXException(e);
                }
            }
            return null;
        }

        private String resolveQName(String name) {
            if (!name.contains(".")) {
                for (String anImport : this.imports) {
                    if (!CompilerUtils.className(anImport).equals(name)) continue;
                    return anImport;
                }
            }
            return name;
        }

        private String resolveQNameFromModel(String name) {
            if (!name.contains(".")) {
                for (String anImport : this.exmlModel.getImports()) {
                    if (!CompilerUtils.className(anImport).equals(name)) continue;
                    return anImport;
                }
                String localQName = CompilerUtils.qName(this.exmlModel.getPackageName(), name);
                if (ExmlToMxml.this.configClassRegistry.getJangarooParser().getCompilationUnit(localQName) != null) {
                    return localQName;
                }
            }
            return name;
        }

        private boolean isNewRoot(String uri, String qName) {
            if (qName == null || this.elementPath.size() != 1) {
                return false;
            }
            String localName = ExmlToMxml.parsePrefixAndLocalName(qName)[1];
            return !ExmlUtils.isExmlNamespace(uri) || "object".equals(localName);
        }

        private void printConfigVars() throws SAXException {
            for (Declaration config : this.configs) {
                String defaultType = this.configDefaultTypes.get(config.getName());
                if ("Array".equals(config.getType()) || this.hasDefaultConstructor(config.getType()) && (defaultType == null || config.getType().equals(defaultType))) continue;
                this.currentOut.printf("%n", new Object[0]);
                if (!this.hasDefaultConstructor(config.getType())) {
                    this.printASDoc(config.getDescription());
                }
                this.currentOut.printf("    [Bindable]%n", new Object[0]);
                this.currentOut.printf("    public var %s:%s", config.getName(), config.getType());
                if (config.getValue() != null) {
                    this.currentOut.printf(" = %s", MxmlUtils.getBindingExpression(config.getValue()).trim());
                }
                this.currentOut.printf(";%n", new Object[0]);
            }
        }

        private void printConstructor() {
            String configClassName = CompilerUtils.className(this.exmlSourceFile.getConfigClassName());
            this.currentOut.printf("    public native function %s(config:%s = null);%n", this.exmlModel.getClassName(), configClassName);
        }

        private void printInitializer() {
            String configClassName = CompilerUtils.className(this.exmlSourceFile.getConfigClassName());
            if (this.varsWithXmlValue.size() != this.vars.size()) {
                this.currentOut.printf("    // called by generated constructor code%n", new Object[0]);
                this.currentOut.printf("    private function __initialize__(config:%s):void {%n", configClassName);
                for (Declaration var : this.vars) {
                    if (this.varsWithXmlValue.contains(var.getName())) continue;
                    this.currentOut.printf("      %s = %s;%n", var.getName(), this.formatValue(var.getValue(), var.getType()));
                }
                this.currentOut.printf("    }%n%n", new Object[0]);
            }
        }

        private void printVars() {
            String configClassName = CompilerUtils.className(this.exmlSourceFile.getConfigClassName());
            this.currentOut.printf("    private var config:%s;%n", configClassName);
            for (Declaration var : this.vars) {
                String type = var.getType();
                if (type == null || type.isEmpty()) {
                    type = "*";
                }
                this.currentOut.printf("    private var %s:%s;%n", var.getName(), type);
            }
            this.currentOut.println();
        }

        private void printDeclarations() throws SAXException {
            boolean hasDeclarations = false;
            String targetClassQName = this.exmlSourceFile.getTargetClassName();
            String targetClassName = CompilerUtils.className(targetClassQName);
            for (Declaration var : this.vars) {
                if (!this.varsWithXmlValue.contains(var.getName()) || "".equals(var.getValue())) continue;
                if (!hasDeclarations) {
                    this.printOpenDeclarations();
                    hasDeclarations = true;
                }
                this.currentOut.printf("%n    %s", var.getValue());
            }
            for (Declaration config : this.configs) {
                if (!this.hasDefaultConstructor(config.getType())) continue;
                QName qName = this.findTypeAndPrefix(config.getType());
                String type = qName.getLocalPart();
                String prefix = qName.getPrefix();
                if (!hasDeclarations) {
                    this.printOpenDeclarations();
                    hasDeclarations = true;
                } else {
                    this.currentOut.printf("%n", new Object[0]);
                }
                if (config.getDescription() != null) {
                    this.currentOut.printf("%n    ", new Object[0]);
                    this.printComment(config.getDescription());
                }
                this.currentOut.printf("%n    ", new Object[0]);
                if (this.configDefaultSubElements.containsKey(config.getName()) && !"Array".equals(config.getType())) {
                    this.currentOut.printf(this.configDefaultSubElements.get(config.getName()), new Object[0]);
                    continue;
                }
                this.currentOut.printf("<%s id=\"%s\"", this.qName(prefix, type), config.getName());
                String value = config.getValue();
                if (value != null) {
                    this.currentOut.printf(">%s</%s>", value, this.qName(prefix, type));
                    continue;
                }
                if (this.configDefaultSubElements.containsKey(config.getName())) {
                    this.currentOut.printf(">%n      ", new Object[0]);
                    this.currentOut.printf(this.configDefaultSubElements.get(config.getName()), new Object[0]);
                    this.currentOut.printf("%n    </%s>", this.qName(prefix, type));
                    continue;
                }
                this.currentOut.printf("/>", new Object[0]);
            }
            if (hasDeclarations) {
                this.printCloseDeclarations();
            } else {
                this.currentOut.println();
            }
        }

        private void printOpenDeclarations() {
            this.currentOut.printf("%n  <fx:Declarations>", new Object[0]);
        }

        private void printCloseDeclarations() {
            this.currentOut.printf("%n  </fx:Declarations>%n", new Object[0]);
        }

        private QName findTypeAndPrefix(String type) throws SAXException {
            String prefix;
            type = "*".equals(type) ? "Object" : type;
            List<QName> qNames = ExmlToMxml.this.mxmlComponentRegistry.getQNamesByClassName(this.resolveQName(type));
            if (qNames != null) {
                QName qName = this.findQName(CompilerUtils.className(type), qNames);
                prefix = this.findPrefix(qName.getNamespaceURI());
                type = qName.getLocalPart();
            } else {
                prefix = this.findPrefixForType(type);
                type = CompilerUtils.className(type);
            }
            return new QName(null, type, prefix == null ? "" : prefix);
        }

        private void printASDoc(String text) {
            if (text != null) {
                this.currentOut.printf("    /**%n", new Object[0]);
                for (String line : text.trim().split("[\n\r]")) {
                    this.currentOut.printf("     * %s%n", line.trim());
                }
                this.currentOut.printf("     */%n", new Object[0]);
            }
        }

        private void printMetadata() {
            if (this.isPublicApi) {
                this.currentOut.printf("%n  <fx:Metadata>[%s]</fx:Metadata>", "PublicApi");
            }
            for (String md : this.metaData) {
                this.currentOut.printf("%n  <fx:Metadata>[%s]</fx:Metadata>", md);
            }
        }

        private void printOpenScript() {
            this.currentOut.printf(OPEN_FX_SCRIPT, new Object[0]);
        }

        private void printCloseScript() {
            this.currentOut.printf(CLOSE_FX_SCRIPT, new Object[0]);
        }

        private String getMappedComponentName(String uri, String qName, String originalQName) {
            ConfigClass configClass = this.getConfigClass(uri, originalQName);
            if (configClass != null) {
                String componentClassName = configClass.getComponentClassName();
                String mappedClassName = (String)ExmlToMxml.this.migrationMap.get(componentClassName);
                List<QName> qNames = ExmlToMxml.this.mxmlComponentRegistry.getQNamesByClassName(mappedClassName != null ? mappedClassName : componentClassName);
                if (qNames != null) {
                    return this.findQName(originalQName, qNames).getLocalPart();
                }
            }
            return qName;
        }

        private QName findQName(String originalQName, List<QName> qNames) {
            for (QName name : qNames) {
                if (!name.getLocalPart().toLowerCase().equals(originalQName.toLowerCase())) continue;
                return name;
            }
            return qNames.get(qNames.size() - 1);
        }

        private String findPrefixForPackage(String packageName, boolean configUriOnly) {
            if (packageName.isEmpty()) {
                return "fx";
            }
            String prefix = this.findPrefix("exml:" + packageName);
            return prefix == null && !configUriOnly ? this.findPrefix(this.createPackageNamespace(packageName)) : prefix;
        }

        private String findPrefix(String namespace) {
            for (Map.Entry<String, String> prefixMapping : this.prefixMappings.entrySet()) {
                if (!namespace.equals(prefixMapping.getValue())) continue;
                return prefixMapping.getKey();
            }
            return null;
        }

        private String createPackageNamespace(String packageName) {
            return CompilerUtils.qName(packageName, "*");
        }

        private void printAttributes(Map<String, String> attributes, int indent) {
            String whitespace = " ";
            for (Map.Entry<String, String> attribute : attributes.entrySet()) {
                String quotes;
                String value = attribute.getValue();
                if (!ExmlUtils.isCodeExpression(value = ExmlToMxml.convertNewLines(CompilerUtils.denormalizeAttributeValue(value)))) {
                    value = value.replaceAll("\\{", "\\\\{");
                }
                if ((value = this.escapeXml(value)).contains("\"") && !value.contains("'")) {
                    quotes = "'";
                } else {
                    quotes = "\"";
                    value = value.replaceAll("\"", "&quot;");
                }
                this.currentOut.printf("%s%s=%s%s%s", whitespace, attribute.getKey(), quotes, value, quotes);
                if (indent <= 0) continue;
                whitespace = String.format("%n%s", StringUtils.repeat(" ", indent));
            }
        }

        private String escapeXml(String xmlString) {
            return xmlString.replaceAll("&", "&amp;").replaceAll("<", "&lt;");
        }

        private String handleInnerElement() {
            Declaration currentVar;
            this.elementRecorder = new ByteArrayOutputStream();
            try {
                this.currentOut = new PrintStream((OutputStream)this.elementRecorder, false, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            if (this.currentVarName != null && "Array".equals((currentVar = this.vars.get(this.vars.size() - 1)).getType())) {
                return "fx:Array";
            }
            return null;
        }

        private String handleImport(Attributes atts) {
            String importedClassName = atts.getValue("class");
            if (importedClassName != null) {
                this.imports.add(importedClassName);
            }
            return null;
        }

        private Declaration createDeclaration(Attributes atts) {
            String name = atts.getValue("name");
            String type = atts.getValue("type");
            String value = atts.getValue("value");
            return new Declaration(name, value, type);
        }

        private void addImport(String type) {
            String packageName = CompilerUtils.packageName(type);
            if (!packageName.isEmpty() && this.findPrefixForPackage(packageName, true) == null) {
                this.imports.add(type);
            }
        }

        private String handleVar(Attributes atts) {
            Declaration declaration = this.createDeclaration(atts);
            this.vars.add(declaration);
            this.addImport(declaration.getType());
            this.currentVarName = declaration.getName();
            return null;
        }

        private String handleCfg(Attributes atts) throws SAXException {
            String configDefault;
            Declaration declaration = this.createDeclaration(atts);
            this.currentConfigName = declaration.getName();
            if (declaration.getType() != null) {
                this.addImport(declaration.getType());
                String mappedClassName = this.getMappedClassName(declaration.getType());
                if (mappedClassName != null) {
                    declaration = new Declaration(declaration.getName(), declaration.getValue(), mappedClassName);
                }
            }
            this.configs.add(declaration);
            if (this.hasDefaultConstructor(declaration.getType())) {
                this.addPrefixMapping(declaration.getType());
            }
            if ((configDefault = atts.getValue("default")) != null && !configDefault.isEmpty()) {
                declaration.setValue(configDefault);
            }
            return null;
        }

        private String addPrefixMapping(String type) throws SAXException {
            String prefix = this.findPrefixForType(type);
            if (prefix == null) {
                prefix = this.createPrefixMapping(this.createPackageNamespace(CompilerUtils.packageName(this.resolveQName(type))));
            }
            return prefix;
        }

        private String createPrefixMapping(String namespace) throws SAXException {
            String prefix = "ns" + ++this.nsCount;
            this.prefixMappings.put(prefix, namespace);
            return prefix;
        }

        private String findPrefixForType(String type) throws SAXException {
            String qName = this.resolveQName(type);
            String packageName = CompilerUtils.packageName(qName);
            String prefix = this.findPrefixForPackage(packageName, false);
            if (prefix == null) {
                ConfigClass configClass = ExmlToMxml.this.configClassRegistry.getConfigClassByName(qName);
                if (configClass != null) {
                    qName = configClass.getComponentClassName();
                    packageName = CompilerUtils.packageName(qName);
                    prefix = this.findPrefixForPackage(packageName, false);
                } else {
                    String guessedConfigClassName = this.getConfigClassFromTargetClass(qName);
                    if (guessedConfigClassName != null && (configClass = ExmlToMxml.this.configClassRegistry.getConfigClassByName(guessedConfigClassName)) != null && configClass.getComponentClassName().equals(qName)) {
                        packageName = CompilerUtils.packageName(guessedConfigClassName);
                        prefix = this.findPrefixForPackage(packageName, false);
                    }
                }
            }
            return prefix;
        }

        private void handleRootNode(Attributes atts) throws SAXException {
            PublicApiMode publicApiMode;
            String publicApiValue;
            String asDoc = this.exmlModel.getDescription();
            if (asDoc != null && !asDoc.trim().isEmpty()) {
                this.printComment(asDoc);
                this.currentOut.println();
            }
            this.baseClass = atts.getValue("baseClass");
            if (this.baseClass != null && !this.baseClass.isEmpty()) {
                this.baseClass = this.qName(this.addPrefixMapping(this.resolveQNameFromModel(this.baseClass)), CompilerUtils.className(this.baseClass));
            }
            if ((publicApiValue = atts.getValue("publicApi")) != null && !publicApiValue.isEmpty() && (publicApiMode = Exmlc.parsePublicApiMode(publicApiValue)) != PublicApiMode.FALSE) {
                this.isPublicApi = true;
            }
        }

        private void printComment(String text) {
            this.currentOut.print("<!--- " + ExmlToMxml.convertNewLines(text).replaceAll("--", "&#45;&#45;") + " -->");
        }

        private String formatValue(String value, String type) {
            return value == null ? null : JsonObject.valueToString(ExmlToModelParser.getAttributeValue(value, type), 2, 4);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.flushPendingTagClose();
            String cdata = new String(ch, start, length);
            if (this.elementPath.size() != 2 || this.elementPath.peek().newName != null || !ExmlToMxml.isNotEmptyText(cdata.trim()) || this.inMetaData) {
                if (this.insideCdata) {
                    cdata = this.escapeXml(cdata);
                }
                super.characters(cdata.toCharArray(), 0, cdata.length());
            }
            this.lastColumn = this.locator.getColumnNumber();
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.elementPath.size() == 1) {
                return;
            }
            qName = this.elementPath.pop().newName;
            if (this.inMetaData) {
                this.inMetaData = false;
                this.metaData.add(this.popRecordedCharacters());
            } else if (this.inConfigDescription) {
                this.inConfigDescription = false;
                this.configs.getLast().setDescription(this.popRecordedCharacters());
            }
            if (qName != null) {
                if (this.pendingTagClose) {
                    this.currentOut.print("/>");
                    this.pendingTagClose = false;
                } else {
                    this.flush();
                    if (this.elementPath.size() == 1) {
                        this.currentOut.printf("%n", new Object[0]);
                    }
                    this.currentOut.printf("</%s>", qName);
                }
            } else if (this.insideExmlObject) {
                this.flush();
            }
            this.insideExmlObject = false;
            this.startRecordingCharacters();
            if (ExmlUtils.isExmlNamespace(uri)) {
                if ("default".equals(localName) || "value".equals(localName)) {
                    String value = this.elementRecorder.toString();
                    if (this.currentConfigName != null) {
                        this.configDefaultSubElements.put(this.currentConfigName, value);
                    } else if (!this.vars.isEmpty()) {
                        Declaration varDeclaration = this.vars.get(this.vars.size() - 1);
                        varDeclaration.setValue(value);
                        this.varsWithXmlValue.add(varDeclaration.getName());
                    }
                    this.currentOut.close();
                    this.currentOut = this.out;
                    this.elementRecorder = null;
                    this.inConfigDefault = false;
                } else if ("cfg".equals(localName)) {
                    this.currentConfigName = null;
                } else if ("var".equals(localName)) {
                    this.currentVarName = null;
                }
            }
            this.lastColumn = this.locator.getColumnNumber();
        }

        private String getTargetClassElementQName(String uri, String qName) {
            String targetClassName;
            ConfigClass configClass = this.getConfigClass(uri, qName);
            if (configClass != null && (targetClassName = configClass.getComponentClassName()) != null) {
                if (ExmlToMxml.this.migrationMap.containsKey(targetClassName)) {
                    targetClassName = (String)ExmlToMxml.this.migrationMap.get(targetClassName);
                }
                return ExmlToMxml.formatQName(ExmlToMxml.parsePrefixAndLocalName(qName)[0], CompilerUtils.className(targetClassName));
            }
            return null;
        }

        private String getTargetClassAttributeName(String uri, String qName, String attributeName) {
            for (ConfigClass configClass = this.getConfigClass(uri, qName); configClass != null; configClass = configClass.getSuperClass()) {
                String classAndAttribute = configClass.getFullName() + "#" + attributeName;
                if (!ExmlToMxml.this.migrationMap.containsKey(classAndAttribute)) continue;
                String targetName = (String)ExmlToMxml.this.migrationMap.get(classAndAttribute);
                return targetName.substring(targetName.indexOf(35) + 1);
            }
            return attributeName;
        }

        private String getMappedClassName(String type) {
            String mappedClassName = null;
            ConfigClass configClass = ExmlToMxml.this.configClassRegistry.getConfigClassByName(this.resolveQName(type));
            if (configClass != null) {
                mappedClassName = configClass.getComponentClassName();
                if (ExmlToMxml.this.migrationMap.containsKey(mappedClassName)) {
                    mappedClassName = (String)ExmlToMxml.this.migrationMap.get(mappedClassName);
                }
            }
            return mappedClassName;
        }

        private ConfigClass getConfigClass(String uri, String qName) {
            String configClassName = this.getClassName(uri, qName);
            return configClassName == null ? null : ExmlToMxml.this.configClassRegistry.getConfigClassByName(configClassName);
        }

        private String getClassName(String uri, String qName) {
            String packageName = ExmlUtils.parsePackageFromNamespace(uri);
            return packageName == null ? null : CompilerUtils.qName(packageName, ExmlToMxml.parsePrefixAndLocalName(qName)[1]);
        }

        @Override
        public void endDocument() throws SAXException {
            if (!this.printedRootElement && ExmlUtils.isExmlNamespace(this.originalRootUri)) {
                String prefix;
                ConfigClassType configClassType = ConfigClassType.fromExmlRootNodeName(ExmlToMxml.parsePrefixAndLocalName(this.originalRootName)[1]);
                String superClassName = configClassType.getDefaultSuperConfigClassName();
                String localName = configClassType == ConfigClassType.CLASS ? "object" : CompilerUtils.className(superClassName);
                String string = prefix = configClassType == ConfigClassType.CLASS ? this.findPrefix(this.originalRootUri) : this.findPrefixForType(superClassName);
                if (prefix == null) {
                    prefix = this.createPrefixMapping("exml:ext.config");
                }
                String namespace = this.prefixMappings.get(prefix);
                this.startElement(namespace, localName, this.qName(prefix, localName), new AttributesImpl());
                this.endElement(namespace, localName, this.qName(prefix, localName));
            }
            this.currentOut.println();
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
            this.insideCdata = true;
            this.lastColumn = this.locator.getColumnNumber();
        }

        @Override
        public void endCDATA() throws SAXException {
            this.insideCdata = false;
            this.lastColumn = this.locator.getColumnNumber();
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            this.flush();
            this.currentOut.print("<!--" + ExmlToMxml.convertNewLines(new String(ch, start, length)) + "-->");
            this.lastColumn = this.locator.getColumnNumber();
        }

        private void flushPendingTagClose() {
            if (this.pendingTagClose) {
                this.currentOut.print(">");
                this.pendingTagClose = false;
            }
        }

        private String qName(String prefix, String localName) {
            return prefix + (prefix.isEmpty() ? "" : ":") + localName;
        }

        private void flush() {
            this.flushPendingTagClose();
            String recordedCharacters = this.popRecordedCharacters();
            if (recordedCharacters != null) {
                String output = ExmlToMxml.convertNewLines(recordedCharacters);
                if (this.insideExmlObject && !output.trim().isEmpty()) {
                    output = MxmlUtils.createBindingExpression(output);
                }
                this.currentOut.print(output);
            }
            this.startRecordingCharacters();
        }
    }
}

