/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.parser;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.jangaroo.exml.api.ExmlcException;
import net.jangaroo.exml.compiler.Exmlc;
import net.jangaroo.exml.json.JsonArray;
import net.jangaroo.exml.json.JsonObject;
import net.jangaroo.exml.model.AnnotationAt;
import net.jangaroo.exml.model.ConfigAttribute;
import net.jangaroo.exml.model.ConfigClass;
import net.jangaroo.exml.model.ConfigClassRegistry;
import net.jangaroo.exml.model.ConfigClassType;
import net.jangaroo.exml.model.Declaration;
import net.jangaroo.exml.model.ExmlModel;
import net.jangaroo.exml.model.PublicApiMode;
import net.jangaroo.exml.utils.ExmlUtils;
import net.jangaroo.exml.xml.PreserveLineNumberHandler;
import net.jangaroo.jooc.ast.ApplyExpr;
import net.jangaroo.utils.AS3Type;
import net.jangaroo.utils.CompilerUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class ExmlToModelParser {
    private static final String EXT_CONFIG_PACKAGE = "ext.config";
    private static final String CONFIG_MODE_AT_SUFFIX = "$at";
    private static final String CONFIG_MODE_ATTRIBUTE_NAME = "mode";
    private static final String EXT_CONTAINER_CONFIG_QNAME = "ext.config.container";
    private static final String EXT_CONTAINER_DEFAULTS_PROPERTY = "defaults";
    private static final String EXT_CONTAINER_DEFAULT_TYPE_PROPERTY = "defaultType";
    private final ConfigClassRegistry registry;
    private static final Map<String, String> CONFIG_MODE_TO_AT_VALUE = new HashMap<String, String>();

    public ExmlToModelParser(ConfigClassRegistry registry) {
        this.registry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExmlModel parse(File file) throws IOException, SAXException {
        ExmlModel model = new ExmlModel();
        String qName = CompilerUtils.qNameFromFile((File)this.registry.getConfig().findSourceDir(file), (File)file);
        String className = CompilerUtils.className((String)qName);
        model.setClassName(ExmlUtils.createComponentClassName((String)className));
        ConfigClass configClassByName = this.registry.getConfigClassByName(this.registry.getConfig().getConfigClassPackage() + "." + ConfigClass.createConfigClassName(className));
        model.setConfigClass(configClassByName);
        model.setPackageName(CompilerUtils.packageName((String)qName));
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            this.parse(inputStream, model);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return model;
    }

    private void parse(InputStream inputStream, ExmlModel model) throws IOException, SAXException {
        Document document = this.buildDom(inputStream);
        Node root = document.getFirstChild();
        this.validateRootNode(root);
        NamedNodeMap attributes = root.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            if ("baseClass".equals(attribute.getLocalName())) {
                model.setSuperClassName(attribute.getValue());
                continue;
            }
            if (!"publicApi".equals(attribute.getLocalName())) continue;
            PublicApiMode publicApiMode = Exmlc.parsePublicApiMode(attribute.getValue());
            switch (publicApiMode) {
                case TRUE: {
                    model.addAnnotation("PublicApi");
                }
                case CONFIG: {
                    model.getConfigClass().addAnnotation("PublicApi");
                }
            }
        }
        NodeList childNodes = root.getChildNodes();
        Element componentNode = null;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            if (ExmlUtils.isExmlNamespace((String)node.getNamespaceURI())) {
                Element element = (Element)node;
                if ("import".equals(node.getLocalName())) {
                    String importedClassName = element.getAttribute("class");
                    if (importedClassName == null || importedClassName.equals("")) {
                        int lineNumber = PreserveLineNumberHandler.getLineNumber(componentNode);
                        throw new ExmlcException("<exml:import> element must contain a non-empty class attribute", lineNumber);
                    }
                    model.addImport(importedClassName);
                    continue;
                }
                if ("annotation".equals(node.getLocalName())) {
                    AnnotationAt annotationAt = Exmlc.parseAnnotationAtValue(element.getAttribute("at"));
                    if (annotationAt == AnnotationAt.CONFIG) continue;
                    model.addAnnotation(element.getTextContent());
                    continue;
                }
                if ("constant".equals(node.getLocalName())) {
                    String constantTypeName = element.getAttribute("type");
                    model.addImport(constantTypeName);
                    continue;
                }
                if ("description".equals(node.getLocalName())) {
                    model.setDescription(node.getTextContent());
                    continue;
                }
                if ("var".equals(node.getLocalName())) {
                    Declaration var = this.createDeclaration(element, model);
                    if (model.getVars().contains(var)) continue;
                    model.addVar(var);
                    continue;
                }
                if (!"cfg".equals(node.getLocalName())) continue;
                String cfgName = element.getAttribute("name");
                String cfgType = element.getAttribute("type");
                String cfgDefault = element.getAttribute("default");
                Element defaultValueElement = ExmlToModelParser.findChildElement(element, "http://www.jangaroo.net/exml/0.8", "default");
                if (cfgDefault.length() != 0 && defaultValueElement != null) {
                    throw new ExmlcException("<exml:cfg> default value must be specified as either an attribute or a sub-element, not both for config '" + cfgName + "'.", PreserveLineNumberHandler.getLineNumber(element));
                }
                if (cfgDefault.length() > 0) {
                    model.getCfgDefaults().set(cfgName, cfgDefault);
                    model.addImport(cfgType);
                    continue;
                }
                if (defaultValueElement == null) continue;
                model.getCfgDefaults().set(cfgName, this.parseValue(model, "Array".equals(cfgType), ExmlToModelParser.getChildElements(defaultValueElement)));
                continue;
            }
            if (componentNode != null) {
                int lineNumber = PreserveLineNumberHandler.getLineNumber(componentNode);
                throw new ExmlcException("root node of EXML contained more than one component definition", lineNumber);
            }
            componentNode = (Element)node;
        }
        if (componentNode == null) {
            return;
        }
        String superFullClassName = this.createFullConfigClassNameFromNode(componentNode);
        if (superFullClassName.equals(model.getConfigClass().getFullName())) {
            int lineNumber = PreserveLineNumberHandler.getLineNumber(componentNode);
            throw new ExmlcException("Cyclic inheritance error: super class and this component are the same!. There is something wrong!", lineNumber);
        }
        ConfigClass superConfigClass = this.getConfigClassByName(superFullClassName, componentNode);
        String superComponentClassName = superConfigClass.getComponentClassName();
        if (model.getSuperClassName() == null) {
            model.setSuperClassName(superComponentClassName);
        }
        model.addImport(superComponentClassName);
        this.fillModelAttributes(model, model.getJsonObject(), componentNode, superConfigClass);
    }

    private Declaration createDeclaration(Element element, ExmlModel model) {
        Object valueObject;
        String name = element.getAttribute("name");
        String type = element.getAttribute("type");
        if (type == null || type.isEmpty()) {
            type = AS3Type.ANY.toString();
        }
        NodeList valueElements = element.getElementsByTagNameNS("http://www.jangaroo.net/exml/0.8", "value");
        boolean addTypeCast = false;
        if (valueElements.getLength() > 0) {
            if (element.hasAttribute("value")) {
                throw new ExmlcException("The value of <exml:var> or <exml:const> '\" + name + \"' must be specified as either an attribute or a sub-element, not both.", PreserveLineNumberHandler.getLineNumber(element));
            }
            Element valueElement = (Element)valueElements.item(0);
            List<Element> valueChildElements = ExmlToModelParser.getChildElements(valueElement);
            if (valueChildElements.isEmpty()) {
                valueObject = ExmlToModelParser.getAttributeValue(valueElement.getTextContent(), type);
            } else {
                valueObject = this.parseValue(model, "Array".equals(type), valueChildElements);
                addTypeCast = !AS3Type.ANY.toString().equals(type) && !ApplyExpr.isCoerceFunction((String)type);
            }
        } else {
            valueObject = ExmlToModelParser.getAttributeValue(element.getAttribute("value"), type);
        }
        String value = JsonObject.valueToString(valueObject, 2, 4);
        if (addTypeCast) {
            value = type + "(" + value + ")";
        }
        return new Declaration(name, value, type);
    }

    private String createFullConfigClassNameFromNode(Node componentNode) {
        String packageName;
        String name = componentNode.getLocalName();
        String uri = componentNode.getNamespaceURI();
        String string = packageName = uri == null ? null : ExmlUtils.parsePackageFromNamespace((String)uri);
        if (packageName == null) {
            int lineNumber = PreserveLineNumberHandler.getLineNumber(componentNode);
            throw new ExmlcException("namespace '" + uri + "' of element '" + name + "' in EXML file does not denote a config package", lineNumber);
        }
        return packageName + "." + name;
    }

    private void fillModelAttributes(ExmlModel model, JsonObject jsonObject, Element componentNode, ConfigClass configClass) {
        NamedNodeMap attributes = componentNode.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String attributeName = attribute.getLocalName();
            String attributeValue = attribute.getValue();
            ConfigAttribute configAttribute = this.getCfgByName(configClass, attributeName);
            jsonObject.set(attributeName, ExmlToModelParser.getAttributeValue(attributeValue, configAttribute == null ? null : configAttribute.getType()));
        }
        this.fillModelAttributesFromSubElements(model, jsonObject, componentNode, configClass);
    }

    public static Object getAttributeValue(String attributeValue, String type) {
        if (!ExmlUtils.isCodeExpression((String)attributeValue)) {
            AS3Type as3Type;
            AS3Type aS3Type = as3Type = type == null ? AS3Type.ANY : AS3Type.typeByName((String)type);
            if (AS3Type.ANY.equals((Object)as3Type)) {
                as3Type = CompilerUtils.guessType((String)attributeValue);
            }
            if (as3Type != null) {
                switch (as3Type) {
                    case BOOLEAN: {
                        return Boolean.parseBoolean(attributeValue);
                    }
                    case NUMBER: {
                        return Double.parseDouble(attributeValue);
                    }
                    case UINT: 
                    case INT: {
                        return Long.parseLong(attributeValue);
                    }
                    case ARRAY: {
                        return new JsonArray(attributeValue);
                    }
                }
            }
        }
        return attributeValue;
    }

    private void fillModelAttributesFromSubElements(ExmlModel model, JsonObject jsonObject, Element componentNode, ConfigClass configClass) {
        List<Element> childNodes = ExmlToModelParser.getChildElements(componentNode);
        for (Element element : childNodes) {
            String directTextContent;
            String elementName = element.getLocalName();
            if (ExmlUtils.isExmlNamespace((String)element.getNamespaceURI()) && "mixins".equals(elementName)) {
                for (Element mixinElement : ExmlToModelParser.getChildElements(element)) {
                    String mixinClassName = this.createFullConfigClassNameFromNode(mixinElement);
                    ConfigClass mixinConfigClass = this.getConfigClassByName(mixinClassName, mixinElement);
                    this.fillModelAttributes(model, jsonObject, mixinElement, mixinConfigClass);
                }
                continue;
            }
            boolean isConfigTypeArray = this.isConfigTypeArray(configClass, elementName);
            String configMode = isConfigTypeArray ? element.getAttribute(CONFIG_MODE_ATTRIBUTE_NAME) : "";
            int attributeCount = element.getAttributes().getLength();
            if (attributeCount > 1 || attributeCount == 1 && configMode.length() == 0) {
                this.parseJavaScriptObjectProperty(jsonObject, element);
                continue;
            }
            String atValue = CONFIG_MODE_TO_AT_VALUE.get(configMode);
            if (atValue != null) {
                isConfigTypeArray = true;
                if (!configClass.isExmlGenerated()) {
                    throw new ExmlcException("Non-EXML class " + configClass.getComponentClassName() + " does not support config modes.", PreserveLineNumberHandler.getLineNumber(element));
                }
            }
            if ((directTextContent = ExmlToModelParser.getDirectTextContent(element)) != null) {
                ConfigAttribute configAttribute = this.getCfgByName(configClass, elementName);
                Object attributeValue = ExmlToModelParser.getAttributeValue(directTextContent, configAttribute == null ? null : configAttribute.getType());
                jsonObject.set(elementName, attributeValue);
            } else {
                this.fillJsonObjectProperty(model, jsonObject, elementName, isConfigTypeArray, ExmlToModelParser.getChildElements(element));
                this.ifContainerDefaultsThenExtractXtype(jsonObject, configClass, elementName);
            }
            if (atValue == null) continue;
            jsonObject.set(elementName + CONFIG_MODE_AT_SUFFIX, atValue);
        }
    }

    private static String getDirectTextContent(Element element) {
        NodeList innerChildNodes = element.getChildNodes();
        for (int i = 0; i < innerChildNodes.getLength(); ++i) {
            String directTextContent;
            Node innerChildNode = innerChildNodes.item(i);
            if (innerChildNode.getNodeType() != 3 || (directTextContent = ((Text)innerChildNode).getWholeText()).trim().length() <= 0) continue;
            return directTextContent;
        }
        return null;
    }

    private void ifContainerDefaultsThenExtractXtype(JsonObject jsonObject, ConfigClass configClass, String elementName) {
        Object value;
        if (EXT_CONTAINER_DEFAULTS_PROPERTY.equals(elementName) && this.isContainerConfig(configClass) && (value = jsonObject.get(elementName)) instanceof JsonObject) {
            JsonObject jsonObjectValue = (JsonObject)value;
            String xtype = jsonObjectValue.getWrapperClass();
            if (xtype != null) {
                jsonObjectValue.settingWrapperClass(null);
            } else {
                xtype = (String)jsonObjectValue.remove(ConfigClassType.COMPONENT.getType());
            }
            if (xtype != null) {
                jsonObject.set(EXT_CONTAINER_DEFAULT_TYPE_PROPERTY, xtype);
            }
        }
    }

    private boolean isContainerConfig(ConfigClass configClass) {
        return configClass != null && (EXT_CONTAINER_CONFIG_QNAME.equals(configClass.getFullName()) || this.isContainerConfig(configClass.getSuperClass()));
    }

    private boolean isConfigTypeArray(ConfigClass configClass, String propertyName) {
        ConfigAttribute configAttribute = this.getCfgByName(configClass, propertyName);
        return configAttribute != null && "Array".equals(configAttribute.getType());
    }

    private void fillJsonObjectProperty(ExmlModel model, JsonObject jsonObject, String propertyName, boolean configTypeArray, List<Element> childElements) {
        Object value = this.parseValue(model, configTypeArray, childElements);
        jsonObject.set(propertyName, value);
    }

    private Object parseValue(ExmlModel model, boolean configTypeArray, List<Element> childElements) {
        List<Object> childObjects = this.parseChildObjects(model, childElements);
        Object value = childObjects.size() > 1 || configTypeArray ? new JsonArray(childObjects.toArray()) : (childObjects.size() == 1 ? childObjects.get(0) : null);
        return value;
    }

    private ConfigClass getConfigClassByName(String className, Node errorNode) {
        ConfigClass configClass = this.registry.getConfigClassByName(className);
        if (configClass == null) {
            int lineNumber = PreserveLineNumberHandler.getLineNumber(errorNode);
            throw new ExmlcException("unknown type '" + className + "'", lineNumber);
        }
        return configClass;
    }

    private void parseJavaScriptObjectProperty(JsonObject jsonObject, Element propertyElement) {
        JsonObject propertyObject = new JsonObject(new Object[0]);
        this.setUntypedAttributes(propertyElement, propertyObject);
        for (Element child : ExmlToModelParser.getChildElements(propertyElement)) {
            this.parseJavaScriptObjectProperty(propertyObject, child);
        }
        jsonObject.set(propertyElement.getLocalName(), propertyObject);
    }

    private static Element findChildElement(Element element, String namespace, String nodeName) {
        for (Element child : ExmlToModelParser.getChildElements(element)) {
            if (!namespace.equals(child.getNamespaceURI()) || !nodeName.equals(child.getLocalName())) continue;
            return child;
        }
        return null;
    }

    private static List<Element> getChildElements(Element element) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList propertyChildNotes = element.getChildNodes();
        for (int j = 0; j < propertyChildNotes.getLength(); ++j) {
            Node childNode = propertyChildNotes.item(j);
            if (childNode.getNodeType() != 1) continue;
            result.add((Element)childNode);
        }
        return result;
    }

    private ConfigAttribute getCfgByName(ConfigClass configClass, String attributeName) {
        ConfigClass current = configClass;
        while (current != null) {
            ConfigAttribute configAttribute = current.getCfgByName(attributeName);
            if (configAttribute != null) {
                return configAttribute;
            }
            String superClassName = current.getSuperClassName();
            if (superClassName == null || superClassName.equals("Object")) break;
            current = this.registry.getConfigClassByName(superClassName);
        }
        return null;
    }

    private List<Object> parseChildObjects(ExmlModel model, List<Element> elements) {
        ArrayList<Object> childObjects = new ArrayList<Object>();
        for (Element arrayItemNode : elements) {
            Object value;
            if (ExmlUtils.isExmlNamespace((String)arrayItemNode.getNamespaceURI()) && "object".equals(arrayItemNode.getLocalName())) {
                value = this.parseExmlObjectNode(arrayItemNode);
            } else {
                String arrayItemClassName = this.createFullConfigClassNameFromNode(arrayItemNode);
                ConfigClass configClass = this.getConfigClassByName(arrayItemClassName, arrayItemNode);
                JsonObject arrayItemJsonObject = new JsonObject(new Object[0]);
                if (configClass.getType().getExtTypeAttribute() != null && EXT_CONFIG_PACKAGE.equals(configClass.getPackageName())) {
                    arrayItemJsonObject.set(configClass.getType().getExtTypeAttribute(), configClass.getTypeValue());
                } else if (configClass.getType().isCreatedViaConfigObject()) {
                    arrayItemJsonObject.settingWrapperClass(configClass.getFullName());
                    model.addImport(configClass.getFullName());
                    model.addImport(configClass.getComponentClassName());
                } else {
                    arrayItemJsonObject.settingConfigClass(configClass.getFullName());
                    model.addImport(configClass.getFullName());
                    model.addImport(configClass.getComponentClassName());
                    model.addImport("net.jangaroo.ext.create");
                }
                this.fillModelAttributes(model, arrayItemJsonObject, arrayItemNode, configClass);
                value = arrayItemJsonObject;
            }
            if (value == null) continue;
            childObjects.add(value);
        }
        return childObjects;
    }

    private Object parseExmlObjectNode(Node exmlObjectNode) {
        String textContent = exmlObjectNode.getTextContent();
        if (textContent != null && textContent.length() > 0) {
            return "{" + textContent.trim() + "}";
        }
        if (!exmlObjectNode.hasAttributes()) {
            return null;
        }
        JsonObject object = new JsonObject(new Object[0]);
        this.setUntypedAttributes(exmlObjectNode, object);
        return object;
    }

    private void setUntypedAttributes(Node exmlObjectNode, JsonObject object) {
        NamedNodeMap attributes = exmlObjectNode.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String attributeName = attribute.getLocalName();
            String attributeValue = attribute.getValue();
            object.set(attributeName, ExmlToModelParser.getAttributeValue(attributeValue, null));
        }
    }

    private void validateRootNode(Node root) {
        int lineNumber = PreserveLineNumberHandler.getLineNumber(root);
        if (!ExmlUtils.isExmlNamespace((String)root.getNamespaceURI())) {
            throw new ExmlcException("root node of EXML file must belong to namespace 'http://www.jangaroo.net/exml/0.8', but was '" + root.getNamespaceURI() + "'", lineNumber);
        }
        if (!Exmlc.EXML_ROOT_NODE_NAMES.contains(root.getLocalName())) {
            throw new ExmlcException("Root node of EXML file must be one of " + Arrays.toString(Exmlc.EXML_ROOT_NODE_NAMES.toArray()) + ", but was " + root.getLocalName() + ".", lineNumber);
        }
    }

    private Document buildDom(InputStream inputStream) throws SAXException, IOException {
        Document doc;
        SAXParser parser;
        try {
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            saxFactory.setNamespaceAware(true);
            parser = saxFactory.newSAXParser();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            doc = factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("a default dom builder should be provided", e);
        }
        PreserveLineNumberHandler handler = new PreserveLineNumberHandler(doc);
        parser.parse(inputStream, (DefaultHandler)handler);
        return doc;
    }

    static {
        CONFIG_MODE_TO_AT_VALUE.put("append", "{net.jangaroo.ext.Exml.APPEND}");
        CONFIG_MODE_TO_AT_VALUE.put("prepend", "{net.jangaroo.ext.Exml.PREPEND}");
    }
}

