/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jangaroo.exml.model.ConfigAttribute;
import net.jangaroo.exml.model.ConfigClassRegistry;
import net.jangaroo.exml.model.ConfigClassType;
import net.jangaroo.exml.model.Declaration;
import net.jangaroo.exml.model.DescriptionHolder;
import net.jangaroo.exml.utils.ExmlUtils;
import net.jangaroo.utils.CompilerUtils;

public final class ConfigClass
extends DescriptionHolder {
    private ConfigClassRegistry configClassRegistry;
    private List<ConfigAttribute> cfgs = new ArrayList<ConfigAttribute>();
    private Map<String, ConfigAttribute> cfgsByName = new HashMap<String, ConfigAttribute>();
    private List<Declaration> constants = new ArrayList<Declaration>();
    private List<String> annotations = new ArrayList<String>();
    private String name;
    private String packageName;
    private String superClassName;
    private String componentClassName;
    private ConfigClassType type;
    private String typeValue;
    private Set<String> imports = new LinkedHashSet<String>();

    public void addCfg(ConfigAttribute cfg) {
        this.cfgs.add(cfg);
        this.cfgsByName.put(cfg.getName(), cfg);
    }

    public boolean contains(ConfigAttribute cfg) {
        return this.cfgsByName.containsKey(cfg.getName());
    }

    public ConfigClass getSuperClass() {
        return this.superClassName == null ? null : this.configClassRegistry.getConfigClassByName(this.superClassName);
    }

    void setConfigClassRegistry(ConfigClassRegistry configClassRegistry) {
        this.configClassRegistry = configClassRegistry;
    }

    public List<ConfigAttribute> getCfgs() {
        return this.cfgs;
    }

    public List<Declaration> getConstants() {
        return this.constants;
    }

    public List<String> getAnnotations() {
        return this.annotations;
    }

    public List<ConfigAttribute> getDirectCfgs() {
        ConfigClass cc = this.getSuperClass();
        if (cc != null) {
            ArrayList<ConfigAttribute> directCfgs = new ArrayList<ConfigAttribute>(this.cfgs);
            do {
                directCfgs.removeAll(cc.getCfgs());
            } while ((cc = cc.getSuperClass()) != null);
            return directCfgs;
        }
        return this.cfgs;
    }

    public ConfigAttribute getCfgByName(String name) {
        return this.cfgsByName.get(name);
    }

    public void addConstant(Declaration constant) {
        this.constants.add(constant);
    }

    public void addAnnotation(String annotation) {
        this.annotations.add(annotation);
    }

    public static String createConfigClassName(String name) {
        return CompilerUtils.uncapitalize((String)name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ConfigClassType getType() {
        return this.type;
    }

    public void setType(ConfigClassType type) {
        this.type = type;
    }

    public String getTypeValue() {
        return this.typeValue;
    }

    public void setTypeValue(String typeValue) {
        this.typeValue = typeValue;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getNs() {
        return ConfigClass.computeShortNamespace(this.packageName);
    }

    private static String computeShortNamespace(String packageName) {
        String[] parts = packageName.split("\\.");
        StringBuilder ns = new StringBuilder();
        for (String part : parts) {
            ns.append(part.charAt(0));
        }
        return ns.toString();
    }

    public void setFullName(String fullName) {
        this.packageName = CompilerUtils.packageName((String)fullName);
        this.name = CompilerUtils.className((String)fullName);
    }

    public String getFullName() {
        return this.packageName + "." + this.name;
    }

    public void setComponentClassName(String componentClassName) {
        this.componentClassName = componentClassName;
    }

    public String getComponentClassName() {
        return this.componentClassName;
    }

    public void setSuperClassName(String superClassName) {
        this.superClassName = superClassName;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public void addImport(String importedClassName) {
        if (importedClassName.contains(".")) {
            this.imports.add(importedClassName);
        }
    }

    public List<String> getImports() {
        HashSet<String> imports = new HashSet<String>();
        ExmlUtils.addImport(imports, (String)this.getSuperClassName());
        for (ConfigAttribute cfg : this.cfgs) {
            ExmlUtils.addImport(imports, (String)cfg.getType());
        }
        for (Declaration constant : this.constants) {
            ExmlUtils.addImport(imports, (String)constant.getType());
        }
        imports.addAll(this.imports);
        ArrayList<String> results = new ArrayList<String>(imports);
        Collections.sort(results);
        return results;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigClass that = (ConfigClass)o;
        return this.name.equals(that.name) && this.packageName.equals(that.packageName);
    }

    public int hashCode() {
        return 31 * this.name.hashCode() + this.packageName.hashCode();
    }

    public boolean isExmlGenerated() {
        return this.getTypeValue() == null || this.getTypeValue().equals(this.getFullName());
    }
}

