/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import org.w3c.tidy.AttVal;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.Node;
import org.w3c.tidy.Parser;
import org.w3c.tidy.Report;
import org.w3c.tidy.TagTable;

public class ParserImpl {
    private static Parser _parseHTML = new ParseHTML();
    private static Parser _parseHead = new ParseHead();
    private static Parser _parseTitle = new ParseTitle();
    private static Parser _parseScript = new ParseScript();
    private static Parser _parseBody = new ParseBody();
    private static Parser _parseFrameSet = new ParseFrameSet();
    private static Parser _parseInline = new ParseInline();
    private static Parser _parseList = new ParseList();
    private static Parser _parseDefList = new ParseDefList();
    private static Parser _parsePre = new ParsePre();
    private static Parser _parseBlock = new ParseBlock();
    private static Parser _parseTableTag = new ParseTableTag();
    private static Parser _parseColGroup = new ParseColGroup();
    private static Parser _parseRowGroup = new ParseRowGroup();
    private static Parser _parseRow = new ParseRow();
    private static Parser _parseNoFrames = new ParseNoFrames();
    private static Parser _parseSelect = new ParseSelect();
    private static Parser _parseText = new ParseText();
    private static Parser _parseOptGroup = new ParseOptGroup();

    public static boolean XMLPreserveWhiteSpace(Node node, TagTable tagTable) {
        AttVal attVal = node.attributes;
        while (attVal != null) {
            if (attVal.attribute.equals("xml:space")) {
                return attVal.value.equals("preserve");
            }
            attVal = attVal.next;
        }
        if (Lexer.wstrcasecmp(node.element, "pre") == 0 || Lexer.wstrcasecmp(node.element, "script") == 0 || Lexer.wstrcasecmp(node.element, "style") == 0) {
            return true;
        }
        if (tagTable != null && tagTable.findParser(node) == ParserImpl.getParsePre()) {
            return true;
        }
        return Lexer.wstrcasecmp(node.element, "xsl:text") == 0;
    }

    public static Parser getParseBlock() {
        return _parseBlock;
    }

    public static Parser getParseBody() {
        return _parseBody;
    }

    public static Parser getParseColGroup() {
        return _parseColGroup;
    }

    public static Parser getParseDefList() {
        return _parseDefList;
    }

    public static Parser getParseFrameSet() {
        return _parseFrameSet;
    }

    public static Parser getParseHTML() {
        return _parseHTML;
    }

    public static Parser getParseHead() {
        return _parseHead;
    }

    public static Parser getParseInline() {
        return _parseInline;
    }

    public static Parser getParseList() {
        return _parseList;
    }

    public static Parser getParseNoFrames() {
        return _parseNoFrames;
    }

    public static Parser getParseOptGroup() {
        return _parseOptGroup;
    }

    public static Parser getParsePre() {
        return _parsePre;
    }

    public static Parser getParseRow() {
        return _parseRow;
    }

    public static Parser getParseRowGroup() {
        return _parseRowGroup;
    }

    public static Parser getParseScript() {
        return _parseScript;
    }

    public static Parser getParseSelect() {
        return _parseSelect;
    }

    public static Parser getParseTableTag() {
        return _parseTableTag;
    }

    public static Parser getParseText() {
        return _parseText;
    }

    public static Parser getParseTitle() {
        return _parseTitle;
    }

    public static boolean isJavaScript(Node node) {
        boolean bl = false;
        if (node.attributes == null) {
            return true;
        }
        AttVal attVal = node.attributes;
        while (attVal != null) {
            if ((Lexer.wstrcasecmp(attVal.attribute, "language") == 0 || Lexer.wstrcasecmp(attVal.attribute, "type") == 0) && Lexer.wsubstr(attVal.value, "javascript")) {
                bl = true;
            }
            attVal = attVal.next;
        }
        return bl;
    }

    private static void moveToHead(Lexer lexer2, Node node, Node node2) {
        TagTable tagTable = lexer2.configuration.tt;
        if (node2.type == 5 || node2.type == 7) {
            Report.warning(lexer2, node, node2, (short)6);
            while (node.tag != tagTable.tagHtml) {
                node = node.parent;
            }
            Node node3 = node.content;
            while (node3 != null) {
                if (node3.tag == tagTable.tagHead) {
                    Node.insertNodeAtEnd(node3, node2);
                    break;
                }
                node3 = node3.next;
            }
            if (node2.tag.parser != null) {
                ParserImpl.parseTag(lexer2, node2, (short)0);
            }
        } else {
            Report.warning(lexer2, node, node2, (short)3);
        }
    }

    public static Node parseDocument(Lexer lexer2) {
        Node node;
        Node node2 = null;
        TagTable tagTable = lexer2.configuration.tt;
        Node node3 = lexer2.newNode();
        node3.type = 0;
        while ((node = lexer2.getToken((short)0)) != null) {
            Node node4;
            if (Node.insertMisc(node3, node)) continue;
            if (node.type == 1) {
                if (node2 == null) {
                    Node.insertNodeAtEnd(node3, node);
                    node2 = node;
                    continue;
                }
                Report.warning(lexer2, node3, node, (short)3);
                continue;
            }
            if (node.type == 6) {
                Report.warning(lexer2, node3, node, (short)3);
                continue;
            }
            if (node.type != 5 || node.tag != tagTable.tagHtml) {
                lexer2.ungetToken();
                node4 = lexer2.inferredTag("html");
            } else {
                node4 = node;
            }
            Node.insertNodeAtEnd(node3, node4);
            ParserImpl.getParseHTML().parse(lexer2, node4, (short)0);
            break;
        }
        return node3;
    }

    private static void parseTag(Lexer lexer2, Node node, short s) {
        if ((node.tag.model & 0x10) == 0) {
            lexer2.insertspace = false;
        }
        if ((node.tag.model & 1) != 0) {
            lexer2.waswhite = false;
            return;
        }
        if (node.tag.parser == null || node.type == 7) {
            return;
        }
        node.tag.parser.parse(lexer2, node, s);
    }

    public static Node parseXMLDocument(Lexer lexer2) {
        Node node;
        Node node2 = lexer2.newNode();
        node2.type = 0;
        Node node3 = null;
        lexer2.configuration.XmlTags = true;
        while ((node = lexer2.getToken((short)0)) != null) {
            if (node.type == 6) {
                Report.warning(lexer2, null, node, (short)8);
                continue;
            }
            if (Node.insertMisc(node2, node)) continue;
            if (node.type == 1) {
                if (node3 == null) {
                    Node.insertNodeAtEnd(node2, node);
                    node3 = node;
                    continue;
                }
                Report.warning(lexer2, node2, node, (short)3);
                continue;
            }
            if (node.type != 5) continue;
            Node.insertNodeAtEnd(node2, node);
            ParserImpl.parseXMLElement(lexer2, node, (short)0);
        }
        if (node3 != null && !lexer2.checkDocTypeKeyWords(node3)) {
            Report.warning(lexer2, node3, null, (short)32);
        }
        if (lexer2.configuration.XmlPi) {
            lexer2.fixXMLPI(node2);
        }
        return node2;
    }

    public static void parseXMLElement(Lexer lexer2, Node node, short s) {
        Node node2;
        if (Lexer.wstrcasecmp(node.element, "xsl:text") == 0) {
            return;
        }
        if (ParserImpl.XMLPreserveWhiteSpace(node, lexer2.configuration.tt)) {
            s = (short)2;
        }
        while ((node2 = lexer2.getToken(s)) != null) {
            if (node2.type == 6 && node2.element.equals(node.element)) {
                node.closed = true;
                break;
            }
            if (node2.type == 6) {
                Report.error(lexer2, node, node2, (short)8);
                continue;
            }
            if (node2.type == 5) {
                ParserImpl.parseXMLElement(lexer2, node2, s);
            }
            Node.insertNodeAtEnd(node, node2);
        }
        if ((node2 = node.content) != null && node2.type == 4 && s != 2 && node2.textarray[node2.start] == 32) {
            ++node2.start;
            if (node2.start >= node2.end) {
                Node.discardElement(node2);
            }
        }
        if ((node2 = node.last) != null && node2.type == 4 && s != 2 && node2.textarray[node2.end - 1] == 32) {
            --node2.end;
            if (node2.start >= node2.end) {
                Node.discardElement(node2);
            }
        }
    }

    public static class ParseHTML
    implements Parser {
        public void parse(Lexer lexer2, Node node, short s) {
            Node node2;
            block25: {
                TagTable tagTable;
                Node node3;
                Node node4;
                block24: {
                    node4 = null;
                    node3 = null;
                    lexer2.configuration.XmlTags = false;
                    lexer2.seenBodyEndTag = 0;
                    tagTable = lexer2.configuration.tt;
                    while (true) {
                        if ((node2 = lexer2.getToken((short)0)) == null) {
                            node2 = lexer2.inferredTag("head");
                            break block24;
                        }
                        if (node2.tag == tagTable.tagHead) break block24;
                        if (node2.tag == node.tag && node2.type == 6) {
                            Report.warning(lexer2, node, node2, (short)3);
                            continue;
                        }
                        if (!Node.insertMisc(node, node2)) break;
                    }
                    lexer2.ungetToken();
                    node2 = lexer2.inferredTag("head");
                }
                Node node5 = node2;
                Node.insertNodeAtEnd(node, node5);
                ParserImpl.getParseHead().parse(lexer2, node5, s);
                block1: while (true) {
                    if ((node2 = lexer2.getToken((short)0)) == null) {
                        if (node4 == null) {
                            node2 = lexer2.inferredTag("body");
                        }
                        return;
                    }
                    if (node2.tag == node.tag) {
                        if (node2.type == 5 || node4 != null) continue;
                        Report.warning(lexer2, node, node2, (short)3);
                        continue;
                    }
                    if (Node.insertMisc(node, node2)) continue;
                    if (node2.tag == tagTable.tagBody) {
                        if (node2.type != 5) {
                            Report.warning(lexer2, node, node2, (short)3);
                            continue;
                        }
                        if (node4 != null) {
                            lexer2.ungetToken();
                            if (node3 == null) {
                                node3 = lexer2.inferredTag("noframes");
                                Node.insertNodeAtEnd(node4, node3);
                                Report.warning(lexer2, node, node3, (short)10);
                            }
                            ParserImpl.parseTag(lexer2, node3, s);
                            continue;
                        }
                        break block25;
                    }
                    if (node2.tag == tagTable.tagFrameset) {
                        if (node2.type != 5) {
                            Report.warning(lexer2, node, node2, (short)3);
                            continue;
                        }
                        if (node4 != null) {
                            Report.error(lexer2, node, node2, (short)13);
                        } else {
                            node4 = node2;
                        }
                        Node.insertNodeAtEnd(node, node2);
                        ParserImpl.parseTag(lexer2, node2, s);
                        node2 = node4.content;
                        while (true) {
                            if (node2 == null) continue block1;
                            if (node2.tag == tagTable.tagNoframes) {
                                node3 = node2;
                            }
                            node2 = node2.next;
                        }
                    }
                    if (node2.tag == tagTable.tagNoframes) {
                        if (node2.type != 5) {
                            Report.warning(lexer2, node, node2, (short)3);
                            continue;
                        }
                        if (node4 == null) {
                            Report.warning(lexer2, node, node2, (short)3);
                            node2 = lexer2.inferredTag("body");
                            break block25;
                        }
                        if (node3 == null) {
                            node3 = node2;
                            Node.insertNodeAtEnd(node4, node3);
                        }
                        ParserImpl.parseTag(lexer2, node3, s);
                        continue;
                    }
                    if ((node2.type == 5 || node2.type == 7) && node2.tag != null && (node2.tag.model & 4) != 0) {
                        ParserImpl.moveToHead(lexer2, node, node2);
                        continue;
                    }
                    lexer2.ungetToken();
                    if (node4 == null) break;
                    if (node3 == null) {
                        node3 = lexer2.inferredTag("noframes");
                        Node.insertNodeAtEnd(node4, node3);
                    } else {
                        Report.warning(lexer2, node, node2, (short)21);
                    }
                    ParserImpl.parseTag(lexer2, node3, s);
                }
                node2 = lexer2.inferredTag("body");
            }
            Node.insertNodeAtEnd(node, node2);
            ParserImpl.parseTag(lexer2, node2, s);
        }
    }

    public static class ParseHead
    implements Parser {
        public void parse(Lexer lexer2, Node node, short s) {
            Node node2;
            int n = 0;
            int n2 = 0;
            TagTable tagTable = lexer2.configuration.tt;
            while ((node2 = lexer2.getToken((short)0)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    node.closed = true;
                    break;
                }
                if (node2.type == 4) {
                    lexer2.ungetToken();
                    break;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.type == 1) {
                    Node.insertDocType(lexer2, node, node2);
                    continue;
                }
                if (node2.tag == null) {
                    Report.warning(lexer2, node, node2, (short)3);
                    continue;
                }
                if ((node2.tag.model & 4) == 0) {
                    lexer2.ungetToken();
                    break;
                }
                if (node2.type == 5 || node2.type == 7) {
                    if (node2.tag == tagTable.tagTitle) {
                        if (++n > 1) {
                            Report.warning(lexer2, node, node2, (short)33);
                        }
                    } else if (node2.tag == tagTable.tagBase) {
                        if (++n2 > 1) {
                            Report.warning(lexer2, node, node2, (short)33);
                        }
                    } else if (node2.tag == tagTable.tagNoscript) {
                        Report.warning(lexer2, node, node2, (short)6);
                    }
                    Node.insertNodeAtEnd(node, node2);
                    ParserImpl.parseTag(lexer2, node2, (short)0);
                    continue;
                }
                Report.warning(lexer2, node, node2, (short)3);
            }
            if (n == 0) {
                Report.warning(lexer2, node, null, (short)12);
                Node.insertNodeAtEnd(node, lexer2.inferredTag("title"));
            }
        }
    }

    public static class ParseTitle
    implements Parser {
        public void parse(Lexer lexer2, Node node, short s) {
            Node node2;
            while ((node2 = lexer2.getToken((short)1)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    node.closed = true;
                    Node.trimSpaces(lexer2, node);
                    return;
                }
                if (node2.type == 4) {
                    if (node.content == null) {
                        Node.trimInitialSpace(lexer2, node, node2);
                    }
                    if (node2.start >= node2.end) continue;
                    Node.insertNodeAtEnd(node, node2);
                    continue;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.tag == null) {
                    Report.warning(lexer2, node, node2, (short)3);
                    continue;
                }
                Report.warning(lexer2, node, node2, (short)2);
                lexer2.ungetToken();
                Node.trimSpaces(lexer2, node);
                return;
            }
            Report.warning(lexer2, node, node2, (short)1);
        }
    }

    public static class ParseScript
    implements Parser {
        public void parse(Lexer lexer2, Node node, short s) {
            Node node2 = lexer2.getCDATA(node);
            if (node2 != null) {
                Node.insertNodeAtEnd(node, node2);
            }
        }
    }

    public static class ParseBody
    implements Parser {
        public void parse(Lexer lexer2, Node node, short s) {
            Node node2;
            s = 0;
            boolean bl = true;
            TagTable tagTable = lexer2.configuration.tt;
            while ((node2 = lexer2.getToken(s)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    node.closed = true;
                    Node.trimSpaces(lexer2, node);
                    lexer2.seenBodyEndTag = 1;
                    s = 0;
                    if (node.parent.tag != tagTable.tagNoframes) continue;
                    break;
                }
                if (node2.tag == tagTable.tagNoframes) {
                    if (node2.type == 5) {
                        Node.insertNodeAtEnd(node, node2);
                        ParserImpl.getParseBlock().parse(lexer2, node2, s);
                        continue;
                    }
                    if (node2.type == 6 && node.parent.tag == tagTable.tagNoframes) {
                        Node.trimSpaces(lexer2, node);
                        lexer2.ungetToken();
                        break;
                    }
                }
                if ((node2.tag == tagTable.tagFrame || node2.tag == tagTable.tagFrameset) && node.parent.tag == tagTable.tagNoframes) {
                    Node.trimSpaces(lexer2, node);
                    lexer2.ungetToken();
                    break;
                }
                if (node2.tag == tagTable.tagHtml) {
                    if (node2.type != 5 && node2.type != 7) continue;
                    Report.warning(lexer2, node, node2, (short)3);
                    continue;
                }
                boolean bl2 = false;
                if (node2.type == 4 && node2.end <= node2.start + 1 && node2.textarray[node2.start] == 32) {
                    bl2 = true;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (lexer2.seenBodyEndTag == 1 && !bl2) {
                    ++lexer2.seenBodyEndTag;
                    Report.warning(lexer2, node, node2, (short)22);
                }
                if (node2.type == 4) {
                    if (bl2 && s == 0) continue;
                    if (lexer2.configuration.EncloseBodyText && !bl2) {
                        lexer2.ungetToken();
                        Node node3 = lexer2.inferredTag("p");
                        Node.insertNodeAtEnd(node, node3);
                        ParserImpl.parseTag(lexer2, node3, s);
                        s = 1;
                        continue;
                    }
                    lexer2.versions = (short)(lexer2.versions & 0xFFFFFFFA);
                    if (bl) {
                        bl = false;
                        if (lexer2.inlineDup(node2) > 0) continue;
                    }
                    Node.insertNodeAtEnd(node, node2);
                    s = 1;
                    continue;
                }
                if (node2.type == 1) {
                    Node.insertDocType(lexer2, node, node2);
                    continue;
                }
                if (node2.tag == null || node2.tag == tagTable.tagParam) {
                    Report.warning(lexer2, node, node2, (short)3);
                    continue;
                }
                lexer2.excludeBlocks = false;
                if ((node2.tag.model & 8) == 0 && (node2.tag.model & 0x10) == 0) {
                    if ((node2.tag.model & 4) == 0) {
                        Report.warning(lexer2, node, node2, (short)6);
                    }
                    if ((node2.tag.model & 2) != 0) {
                        if (node2.tag != tagTable.tagBody || !node.implicit || node.attributes != null) continue;
                        node.attributes = node2.attributes;
                        node2.attributes = null;
                        continue;
                    }
                    if ((node2.tag.model & 4) != 0) {
                        ParserImpl.moveToHead(lexer2, node, node2);
                        continue;
                    }
                    if ((node2.tag.model & 0x20) != 0) {
                        lexer2.ungetToken();
                        node2 = lexer2.inferredTag("ul");
                        Node.addClass(node2, "noindent");
                        lexer2.excludeBlocks = true;
                    } else if ((node2.tag.model & 0x40) != 0) {
                        lexer2.ungetToken();
                        node2 = lexer2.inferredTag("dl");
                        lexer2.excludeBlocks = true;
                    } else if ((node2.tag.model & 0x380) != 0) {
                        lexer2.ungetToken();
                        node2 = lexer2.inferredTag("table");
                        lexer2.excludeBlocks = true;
                    } else {
                        if ((node2.tag.model & 0x600) != 0) continue;
                        lexer2.ungetToken();
                        return;
                    }
                }
                if (node2.type == 6) {
                    if (node2.tag == tagTable.tagBr) {
                        node2.type = (short)5;
                    } else if (node2.tag == tagTable.tagP) {
                        Node.coerceNode(lexer2, node2, tagTable.tagBr);
                        Node.insertNodeAtEnd(node, node2);
                        node2 = lexer2.inferredTag("br");
                    } else if ((node2.tag.model & 0x10) != 0) {
                        lexer2.popInline(node2);
                    }
                }
                if (node2.type == 5 || node2.type == 7) {
                    if ((node2.tag.model & 0x10) != 0 && (node2.tag.model & 0x20000) == 0) {
                        lexer2.versions = node2.tag == tagTable.tagImg ? (short)(lexer2.versions & 0xFFFFFFFB) : (short)(lexer2.versions & 0xFFFFFFFA);
                        if (bl && !node2.implicit) {
                            bl = false;
                            if (lexer2.inlineDup(node2) > 0) continue;
                        }
                        s = 1;
                    } else {
                        bl = true;
                        s = 0;
                    }
                    if (node2.implicit) {
                        Report.warning(lexer2, node, node2, (short)10);
                    }
                    Node.insertNodeAtEnd(node, node2);
                    ParserImpl.parseTag(lexer2, node2, s);
                    continue;
                }
                Report.warning(lexer2, node, node2, (short)3);
            }
        }
    }

    public static class ParseFrameSet
    implements Parser {
        public void parse(Lexer lexer2, Node node, short s) {
            Node node2;
            TagTable tagTable = lexer2.configuration.tt;
            lexer2.badAccess = (short)(lexer2.badAccess | 0x10);
            while ((node2 = lexer2.getToken((short)0)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    node.closed = true;
                    Node.trimSpaces(lexer2, node);
                    return;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.tag == null) {
                    Report.warning(lexer2, node, node2, (short)3);
                    continue;
                }
                if ((node2.type == 5 || node2.type == 7) && node2.tag != null && (node2.tag.model & 4) != 0) {
                    ParserImpl.moveToHead(lexer2, node, node2);
                    continue;
                }
                if (node2.tag == tagTable.tagBody) {
                    lexer2.ungetToken();
                    node2 = lexer2.inferredTag("noframes");
                    Report.warning(lexer2, node, node2, (short)10);
                }
                if (node2.type == 5 && (node2.tag.model & 0x2000) != 0) {
                    Node.insertNodeAtEnd(node, node2);
                    lexer2.excludeBlocks = false;
                    ParserImpl.parseTag(lexer2, node2, (short)1);
                    continue;
                }
                if (node2.type == 7 && (node2.tag.model & 0x2000) != 0) {
                    Node.insertNodeAtEnd(node, node2);
                    continue;
                }
                Report.warning(lexer2, node, node2, (short)3);
            }
            Report.warning(lexer2, node, node2, (short)1);
        }
    }

    public static class ParseInline
    implements Parser {
        public void parse(Lexer lexer2, Node node, short s) {
            Node node2;
            TagTable tagTable = lexer2.configuration.tt;
            if ((node.tag.model & 1) != 0) {
                return;
            }
            if (node.tag == tagTable.tagA && node.attributes == null) {
                Report.warning(lexer2, node.parent, node, (short)3);
                Node.discardElement(node);
                return;
            }
            if ((node.tag.model & 8) != 0 || node.tag == tagTable.tagDt) {
                lexer2.inlineDup(null);
            } else if ((node.tag.model & 0x10) != 0 && node.tag != tagTable.tagA && node.tag != tagTable.tagSpan) {
                lexer2.pushInline(node);
            }
            if (node.tag == tagTable.tagNobr) {
                lexer2.badLayout = (short)(lexer2.badLayout | 4);
            } else if (node.tag == tagTable.tagFont) {
                lexer2.badLayout = (short)(lexer2.badLayout | 8);
            }
            if (s != 2) {
                s = 1;
            }
            while ((node2 = lexer2.getToken(s)) != null) {
                Node node3;
                if (node2.tag == node.tag && node2.type == 6) {
                    if ((node.tag.model & 0x10) != 0 && node.tag != tagTable.tagA) {
                        lexer2.popInline(node2);
                    }
                    if ((s & 2) == 0) {
                        Node.trimSpaces(lexer2, node);
                    }
                    if (node.tag == tagTable.tagFont && node.content != null && node.content == node.last) {
                        node3 = node.content;
                        if (node3.tag == tagTable.tagA) {
                            node3.parent = node.parent;
                            node3.next = node.next;
                            node3.prev = node.prev;
                            if (node3.prev != null) {
                                node3.prev.next = node3;
                            } else {
                                node3.parent.content = node3;
                            }
                            if (node3.next != null) {
                                node3.next.prev = node3;
                            } else {
                                node3.parent.last = node3;
                            }
                            node.next = null;
                            node.prev = null;
                            node.parent = node3;
                            node.content = node3.content;
                            node.last = node3.last;
                            node3.content = node;
                            node3.last = node;
                            node3 = node.content;
                            while (node3 != null) {
                                node3.parent = node;
                                node3 = node3.next;
                            }
                        }
                    }
                    node.closed = true;
                    Node.trimSpaces(lexer2, node);
                    Node.trimEmptyElement(lexer2, node);
                    return;
                }
                if (node2.type == 5 && node2.tag == node.tag && lexer2.isPushed(node2) && !node2.implicit && !node.implicit && node2.tag != null && (node2.tag.model & 0x10) != 0 && node2.tag != tagTable.tagA && node2.tag != tagTable.tagFont && node2.tag != tagTable.tagBig && node2.tag != tagTable.tagSmall) {
                    if (node.content != null && node2.attributes == null) {
                        Report.warning(lexer2, node, node2, (short)19);
                        node2.type = (short)6;
                        lexer2.ungetToken();
                        continue;
                    }
                    Report.warning(lexer2, node, node2, (short)4);
                }
                if (node2.type == 4) {
                    if (node.content == null && (s & 2) == 0) {
                        Node.trimSpaces(lexer2, node);
                    }
                    if (node2.start >= node2.end) continue;
                    Node.insertNodeAtEnd(node, node2);
                    continue;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.tag == tagTable.tagHtml) {
                    if (node2.type == 5 || node2.type == 7) {
                        Report.warning(lexer2, node, node2, (short)3);
                        continue;
                    }
                    lexer2.ungetToken();
                    if ((s & 2) == 0) {
                        Node.trimSpaces(lexer2, node);
                    }
                    Node.trimEmptyElement(lexer2, node);
                    return;
                }
                if (node2.tag == tagTable.tagP && node2.type == 5 && ((s & 2) != 0 || node.tag == tagTable.tagDt || node.isDescendantOf(tagTable.tagDt))) {
                    node2.tag = tagTable.tagBr;
                    node2.element = "br";
                    Node.trimSpaces(lexer2, node);
                    Node.insertNodeAtEnd(node, node2);
                    continue;
                }
                if (node2.tag == null || node2.tag == tagTable.tagParam) {
                    Report.warning(lexer2, node, node2, (short)3);
                    continue;
                }
                if (node2.tag == tagTable.tagBr && node2.type == 6) {
                    node2.type = (short)5;
                }
                if (node2.type == 6) {
                    if (node2.tag == tagTable.tagBr) {
                        node2.type = (short)5;
                    } else if (node2.tag == tagTable.tagP) {
                        if (!node.isDescendantOf(tagTable.tagP)) {
                            Node.coerceNode(lexer2, node2, tagTable.tagBr);
                            Node.trimSpaces(lexer2, node);
                            Node.insertNodeAtEnd(node, node2);
                            node2 = lexer2.inferredTag("br");
                            continue;
                        }
                    } else {
                        if ((node2.tag.model & 0x10) != 0 && node2.tag != tagTable.tagA && (node2.tag.model & 0x800) == 0 && (node.tag.model & 0x10) != 0) {
                            lexer2.popInline(node);
                            if (node.tag != tagTable.tagA) {
                                if (node2.tag == tagTable.tagA && node2.tag != node.tag) {
                                    Report.warning(lexer2, node, node2, (short)2);
                                    lexer2.ungetToken();
                                } else {
                                    Report.warning(lexer2, node, node2, (short)5);
                                }
                                if ((s & 2) == 0) {
                                    Node.trimSpaces(lexer2, node);
                                }
                                Node.trimEmptyElement(lexer2, node);
                                return;
                            }
                            Report.warning(lexer2, node, node2, (short)3);
                            continue;
                        }
                        if (lexer2.exiled && node2.tag.model != 0 && (node2.tag.model & 0x80) != 0) {
                            lexer2.ungetToken();
                            Node.trimSpaces(lexer2, node);
                            Node.trimEmptyElement(lexer2, node);
                            return;
                        }
                    }
                }
                if ((node2.tag.model & 0x4000) != 0 && (node.tag.model & 0x4000) != 0) {
                    if (node2.tag == node.tag) {
                        Report.warning(lexer2, node, node2, (short)5);
                    } else {
                        Report.warning(lexer2, node, node2, (short)2);
                        lexer2.ungetToken();
                    }
                    if ((s & 2) == 0) {
                        Node.trimSpaces(lexer2, node);
                    }
                    Node.trimEmptyElement(lexer2, node);
                    return;
                }
                if (node2.tag == tagTable.tagA && !node2.implicit && lexer2.isPushed(node2)) {
                    if (node2.attributes == null) {
                        node2.type = (short)6;
                        Report.warning(lexer2, node, node2, (short)19);
                        lexer2.popInline(node2);
                        lexer2.ungetToken();
                        continue;
                    }
                    lexer2.ungetToken();
                    Report.warning(lexer2, node, node2, (short)2);
                    lexer2.popInline(node);
                    if ((s & 2) == 0) {
                        Node.trimSpaces(lexer2, node);
                    }
                    Node.trimEmptyElement(lexer2, node);
                    return;
                }
                if ((node.tag.model & 0x4000) != 0) {
                    if (node2.tag == tagTable.tagCenter || node2.tag == tagTable.tagDiv) {
                        if (node2.type != 5 && node2.type != 7) {
                            Report.warning(lexer2, node, node2, (short)3);
                            continue;
                        }
                        Report.warning(lexer2, node, node2, (short)6);
                        if (node.content == null) {
                            Node.insertNodeAsParent(node, node2);
                            continue;
                        }
                        Node.insertNodeAfterElement(node, node2);
                        if ((s & 2) == 0) {
                            Node.trimSpaces(lexer2, node);
                        }
                        node = lexer2.cloneNode(node);
                        node.start = lexer2.lexsize;
                        node.end = lexer2.lexsize;
                        Node.insertNodeAtEnd(node2, node);
                        continue;
                    }
                    if (node2.tag == tagTable.tagHr) {
                        if (node2.type != 5 && node2.type != 7) {
                            Report.warning(lexer2, node, node2, (short)3);
                            continue;
                        }
                        Report.warning(lexer2, node, node2, (short)6);
                        if (node.content == null) {
                            Node.insertNodeBeforeElement(node, node2);
                            continue;
                        }
                        Node.insertNodeAfterElement(node, node2);
                        if ((s & 2) == 0) {
                            Node.trimSpaces(lexer2, node);
                        }
                        node = lexer2.cloneNode(node);
                        node.start = lexer2.lexsize;
                        node.end = lexer2.lexsize;
                        Node.insertNodeAfterElement(node2, node);
                        continue;
                    }
                }
                if (node.tag == tagTable.tagDt && node2.tag == tagTable.tagHr) {
                    if (node2.type != 5 && node2.type != 7) {
                        Report.warning(lexer2, node, node2, (short)3);
                        continue;
                    }
                    Report.warning(lexer2, node, node2, (short)6);
                    node3 = lexer2.inferredTag("dd");
                    if (node.content == null) {
                        Node.insertNodeBeforeElement(node, node3);
                        Node.insertNodeAtEnd(node3, node2);
                        continue;
                    }
                    Node.insertNodeAfterElement(node, node3);
                    Node.insertNodeAtEnd(node3, node2);
                    if ((s & 2) == 0) {
                        Node.trimSpaces(lexer2, node);
                    }
                    node = lexer2.cloneNode(node);
                    node.start = lexer2.lexsize;
                    node.end = lexer2.lexsize;
                    Node.insertNodeAfterElement(node3, node);
                    continue;
                }
                if (node2.type == 6) {
                    Node node4 = node.parent;
                    while (node4 != null) {
                        if (node2.tag == node4.tag) {
                            if ((node.tag.model & 0x8000) == 0 && !node.implicit) {
                                Report.warning(lexer2, node, node2, (short)2);
                            }
                            if (node.tag == tagTable.tagA) {
                                lexer2.popInline(node);
                            }
                            lexer2.ungetToken();
                            if ((s & 2) == 0) {
                                Node.trimSpaces(lexer2, node);
                            }
                            Node.trimEmptyElement(lexer2, node);
                            return;
                        }
                        node4 = node4.parent;
                    }
                }
                if ((node2.tag.model & 0x10) == 0) {
                    if (node2.type != 5) {
                        Report.warning(lexer2, node, node2, (short)3);
                        continue;
                    }
                    if ((node.tag.model & 0x8000) == 0) {
                        Report.warning(lexer2, node, node2, (short)2);
                    }
                    if ((node2.tag.model & 4) != 0 && (node2.tag.model & 8) == 0) {
                        ParserImpl.moveToHead(lexer2, node, node2);
                        continue;
                    }
                    if (node.tag == tagTable.tagA) {
                        if (node2.tag != null && (node2.tag.model & 0x4000) == 0) {
                            lexer2.popInline(node);
                        } else if (node.content == null) {
                            Node.discardElement(node);
                            lexer2.ungetToken();
                            return;
                        }
                    }
                    lexer2.ungetToken();
                    if ((s & 2) == 0) {
                        Node.trimSpaces(lexer2, node);
                    }
                    Node.trimEmptyElement(lexer2, node);
                    return;
                }
                if (node2.type == 5 || node2.type == 7) {
                    if (node2.implicit) {
                        Report.warning(lexer2, node, node2, (short)10);
                    }
                    if (node2.tag == tagTable.tagBr) {
                        Node.trimSpaces(lexer2, node);
                    }
                    Node.insertNodeAtEnd(node, node2);
                    ParserImpl.parseTag(lexer2, node2, s);
                    continue;
                }
                Report.warning(lexer2, node, node2, (short)3);
            }
            if ((node.tag.model & 0x8000) == 0) {
                Report.warning(lexer2, node, node2, (short)1);
            }
            Node.trimEmptyElement(lexer2, node);
        }
    }

    public static class ParseList
    implements Parser {
        public void parse(Lexer lexer2, Node node, short s) {
            Node node2;
            TagTable tagTable = lexer2.configuration.tt;
            if ((node.tag.model & 1) != 0) {
                return;
            }
            lexer2.insert = -1;
            while ((node2 = lexer2.getToken((short)0)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    if ((node.tag.model & 0x80000) != 0) {
                        Node.coerceNode(lexer2, node, tagTable.tagUl);
                    }
                    node.closed = true;
                    Node.trimEmptyElement(lexer2, node);
                    return;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.type != 4 && node2.tag == null) {
                    Report.warning(lexer2, node, node2, (short)3);
                    continue;
                }
                if (node2.type == 6) {
                    if (node2.tag == tagTable.tagForm) {
                        lexer2.badForm = 1;
                        Report.warning(lexer2, node, node2, (short)3);
                        continue;
                    }
                    if (node2.tag != null && (node2.tag.model & 0x10) != 0) {
                        Report.warning(lexer2, node, node2, (short)3);
                        lexer2.popInline(node2);
                        continue;
                    }
                    Node node3 = node.parent;
                    while (node3 != null) {
                        if (node2.tag == node3.tag) {
                            Report.warning(lexer2, node, node2, (short)2);
                            lexer2.ungetToken();
                            if ((node.tag.model & 0x80000) != 0) {
                                Node.coerceNode(lexer2, node, tagTable.tagUl);
                            }
                            Node.trimEmptyElement(lexer2, node);
                            return;
                        }
                        node3 = node3.parent;
                    }
                    Report.warning(lexer2, node, node2, (short)3);
                    continue;
                }
                if (node2.tag != tagTable.tagLi) {
                    lexer2.ungetToken();
                    if (node2.tag != null && (node2.tag.model & 8) != 0 && lexer2.excludeBlocks) {
                        Report.warning(lexer2, node, node2, (short)2);
                        Node.trimEmptyElement(lexer2, node);
                        return;
                    }
                    node2 = lexer2.inferredTag("li");
                    node2.addAttribute("style", "list-style: none");
                    Report.warning(lexer2, node, node2, (short)7);
                }
                Node.insertNodeAtEnd(node, node2);
                ParserImpl.parseTag(lexer2, node2, (short)0);
            }
            if ((node.tag.model & 0x80000) != 0) {
                Node.coerceNode(lexer2, node, tagTable.tagUl);
            }
            Report.warning(lexer2, node, node2, (short)1);
            Node.trimEmptyElement(lexer2, node);
        }
    }

    public static class ParseDefList
    implements Parser {
        public void parse(Lexer lexer2, Node node, short s) {
            Node node2;
            TagTable tagTable = lexer2.configuration.tt;
            if ((node.tag.model & 1) != 0) {
                return;
            }
            lexer2.insert = -1;
            while ((node2 = lexer2.getToken((short)0)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    node.closed = true;
                    Node.trimEmptyElement(lexer2, node);
                    return;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.type == 4) {
                    lexer2.ungetToken();
                    node2 = lexer2.inferredTag("dt");
                    Report.warning(lexer2, node, node2, (short)7);
                }
                if (node2.tag == null) {
                    Report.warning(lexer2, node, node2, (short)3);
                    continue;
                }
                if (node2.type == 6) {
                    if (node2.tag == tagTable.tagForm) {
                        lexer2.badForm = 1;
                        Report.warning(lexer2, node, node2, (short)3);
                        continue;
                    }
                    Node node3 = node.parent;
                    while (node3 != null) {
                        if (node2.tag == node3.tag) {
                            Report.warning(lexer2, node, node2, (short)2);
                            lexer2.ungetToken();
                            Node.trimEmptyElement(lexer2, node);
                            return;
                        }
                        node3 = node3.parent;
                    }
                }
                if (node2.tag == tagTable.tagCenter) {
                    if (node.content != null) {
                        Node.insertNodeAfterElement(node, node2);
                    } else {
                        Node.insertNodeBeforeElement(node, node2);
                        Node.discardElement(node);
                    }
                    ParserImpl.parseTag(lexer2, node2, s);
                    node = lexer2.inferredTag("dl");
                    Node.insertNodeAfterElement(node2, node);
                    continue;
                }
                if (node2.tag != tagTable.tagDt && node2.tag != tagTable.tagDd) {
                    lexer2.ungetToken();
                    if ((node2.tag.model & 0x18) == 0) {
                        Report.warning(lexer2, node, node2, (short)6);
                        Node.trimEmptyElement(lexer2, node);
                        return;
                    }
                    if ((node2.tag.model & 0x10) == 0 && lexer2.excludeBlocks) {
                        Node.trimEmptyElement(lexer2, node);
                        return;
                    }
                    node2 = lexer2.inferredTag("dd");
                    Report.warning(lexer2, node, node2, (short)7);
                }
                if (node2.type == 6) {
                    Report.warning(lexer2, node, node2, (short)3);
                    continue;
                }
                Node.insertNodeAtEnd(node, node2);
                ParserImpl.parseTag(lexer2, node2, (short)0);
            }
            Report.warning(lexer2, node, node2, (short)1);
            Node.trimEmptyElement(lexer2, node);
        }
    }

    public static class ParsePre
    implements Parser {
        public void parse(Lexer lexer2, Node node, short s) {
            Node node2;
            TagTable tagTable = lexer2.configuration.tt;
            if ((node.tag.model & 1) != 0) {
                return;
            }
            if ((node.tag.model & 0x80000) != 0) {
                Node.coerceNode(lexer2, node, tagTable.tagPre);
            }
            lexer2.inlineDup(null);
            while ((node2 = lexer2.getToken((short)2)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    Node.trimSpaces(lexer2, node);
                    node.closed = true;
                    Node.trimEmptyElement(lexer2, node);
                    return;
                }
                if (node2.tag == tagTable.tagHtml) {
                    if (node2.type != 5 && node2.type != 7) continue;
                    Report.warning(lexer2, node, node2, (short)3);
                    continue;
                }
                if (node2.type == 4) {
                    if (node.content == null) {
                        if (node2.textarray[node2.start] == 10) {
                            ++node2.start;
                        }
                        if (node2.start >= node2.end) continue;
                    }
                    Node.insertNodeAtEnd(node, node2);
                    continue;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.tag == null || node2.tag == tagTable.tagParam) {
                    Report.warning(lexer2, node, node2, (short)3);
                    continue;
                }
                if (node2.tag == tagTable.tagP) {
                    if (node2.type == 5) {
                        Report.warning(lexer2, node, node2, (short)9);
                        Node.trimSpaces(lexer2, node);
                        Node.coerceNode(lexer2, node2, tagTable.tagBr);
                        Node.insertNodeAtEnd(node, node2);
                        continue;
                    }
                    Report.warning(lexer2, node, node2, (short)3);
                    continue;
                }
                if ((node2.tag.model & 4) != 0 && (node2.tag.model & 8) == 0) {
                    ParserImpl.moveToHead(lexer2, node, node2);
                    continue;
                }
                if (node2.type == 6) {
                    if (node2.tag == tagTable.tagForm) {
                        lexer2.badForm = 1;
                        Report.warning(lexer2, node, node2, (short)3);
                        continue;
                    }
                    Node node3 = node.parent;
                    while (node3 != null) {
                        if (node2.tag == node3.tag) {
                            Report.warning(lexer2, node, node2, (short)2);
                            lexer2.ungetToken();
                            Node.trimSpaces(lexer2, node);
                            Node.trimEmptyElement(lexer2, node);
                            return;
                        }
                        node3 = node3.parent;
                    }
                }
                if ((node2.tag.model & 0x10) == 0) {
                    if (node2.type != 5) {
                        Report.warning(lexer2, node, node2, (short)3);
                        continue;
                    }
                    Report.warning(lexer2, node, node2, (short)2);
                    lexer2.excludeBlocks = true;
                    if ((node2.tag.model & 0x20) != 0) {
                        lexer2.ungetToken();
                        node2 = lexer2.inferredTag("ul");
                        Node.addClass(node2, "noindent");
                    } else if ((node2.tag.model & 0x40) != 0) {
                        lexer2.ungetToken();
                        node2 = lexer2.inferredTag("dl");
                    } else if ((node2.tag.model & 0x80) != 0) {
                        lexer2.ungetToken();
                        node2 = lexer2.inferredTag("table");
                    }
                    Node.insertNodeAfterElement(node, node2);
                    node = lexer2.inferredTag("pre");
                    Node.insertNodeAfterElement(node2, node);
                    ParserImpl.parseTag(lexer2, node2, (short)0);
                    lexer2.excludeBlocks = false;
                    continue;
                }
                if (node2.type == 5 || node2.type == 7) {
                    if (node2.tag == tagTable.tagBr) {
                        Node.trimSpaces(lexer2, node);
                    }
                    Node.insertNodeAtEnd(node, node2);
                    ParserImpl.parseTag(lexer2, node2, (short)2);
                    continue;
                }
                Report.warning(lexer2, node, node2, (short)3);
            }
            Report.warning(lexer2, node, node2, (short)1);
            Node.trimEmptyElement(lexer2, node);
        }
    }

    public static class ParseBlock
    implements Parser {
        public void parse(Lexer lexer2, Node node, short s) {
            Node node2;
            int n = 0;
            TagTable tagTable = lexer2.configuration.tt;
            boolean bl = true;
            if ((node.tag.model & 1) != 0) {
                return;
            }
            if (node.tag == tagTable.tagForm && node.isDescendantOf(tagTable.tagForm)) {
                Report.warning(lexer2, node, null, (short)20);
            }
            if ((node.tag.model & 0x800) != 0) {
                n = lexer2.istackbase;
                lexer2.istackbase = lexer2.istack.size();
            }
            if ((node.tag.model & 0x20000) == 0) {
                lexer2.inlineDup(null);
            }
            s = 0;
            while ((node2 = lexer2.getToken(s)) != null) {
                if (node2.type == 6 && node2.tag != null && (node2.tag == node.tag || node.was == node2.tag)) {
                    if ((node.tag.model & 0x800) != 0) {
                        while (lexer2.istack.size() > lexer2.istackbase) {
                            lexer2.popInline(null);
                        }
                        lexer2.istackbase = n;
                    }
                    node.closed = true;
                    Node.trimSpaces(lexer2, node);
                    Node.trimEmptyElement(lexer2, node);
                    return;
                }
                if (node2.tag == tagTable.tagHtml || node2.tag == tagTable.tagHead || node2.tag == tagTable.tagBody) {
                    if (node2.type != 5 && node2.type != 7) continue;
                    Report.warning(lexer2, node, node2, (short)3);
                    continue;
                }
                if (node2.type == 6) {
                    if (node2.tag == null) {
                        Report.warning(lexer2, node, node2, (short)3);
                        continue;
                    }
                    if (node2.tag == tagTable.tagBr) {
                        node2.type = (short)5;
                    } else if (node2.tag == tagTable.tagP) {
                        Node.coerceNode(lexer2, node2, tagTable.tagBr);
                        Node.insertNodeAtEnd(node, node2);
                        node2 = lexer2.inferredTag("br");
                    } else {
                        Node node3 = node.parent;
                        while (node3 != null) {
                            if (node2.tag == node3.tag) {
                                if ((node.tag.model & 0x8000) == 0) {
                                    Report.warning(lexer2, node, node2, (short)2);
                                }
                                lexer2.ungetToken();
                                if ((node.tag.model & 0x800) != 0) {
                                    while (lexer2.istack.size() > lexer2.istackbase) {
                                        lexer2.popInline(null);
                                    }
                                    lexer2.istackbase = n;
                                }
                                Node.trimSpaces(lexer2, node);
                                Node.trimEmptyElement(lexer2, node);
                                return;
                            }
                            node3 = node3.parent;
                        }
                        if (lexer2.exiled && node2.tag.model != 0 && (node2.tag.model & 0x80) != 0) {
                            lexer2.ungetToken();
                            Node.trimSpaces(lexer2, node);
                            Node.trimEmptyElement(lexer2, node);
                            return;
                        }
                    }
                }
                if (node2.type == 4) {
                    boolean bl2 = false;
                    if (node2.type == 4 && node2.end <= node2.start + 1 && lexer2.lexbuf[node2.start] == 32) {
                        bl2 = true;
                    }
                    if (lexer2.configuration.EncloseBlockText && !bl2) {
                        lexer2.ungetToken();
                        node2 = lexer2.inferredTag("p");
                        Node.insertNodeAtEnd(node, node2);
                        ParserImpl.parseTag(lexer2, node2, (short)1);
                        continue;
                    }
                    if (bl) {
                        bl = false;
                        if ((node.tag.model & 0x20000) == 0 && lexer2.inlineDup(node2) > 0) continue;
                    }
                    Node.insertNodeAtEnd(node, node2);
                    s = 1;
                    lexer2.versions = (short)(lexer2.versions & 0xFFFFFFFB);
                    continue;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.tag == tagTable.tagParam) {
                    if ((node.tag.model & 0x1000) != 0 && (node2.type == 5 || node2.type == 7)) {
                        Node.insertNodeAtEnd(node, node2);
                        continue;
                    }
                    Report.warning(lexer2, node, node2, (short)3);
                    continue;
                }
                if (node2.tag == tagTable.tagArea) {
                    if (node.tag == tagTable.tagMap && (node2.type == 5 || node2.type == 7)) {
                        Node.insertNodeAtEnd(node, node2);
                        continue;
                    }
                    Report.warning(lexer2, node, node2, (short)3);
                    continue;
                }
                if (node2.tag == null) {
                    Report.warning(lexer2, node, node2, (short)3);
                    continue;
                }
                if ((node2.tag.model & 0x10) == 0) {
                    if (node2.type != 5 && node2.type != 7) {
                        Report.warning(lexer2, node, node2, (short)3);
                        continue;
                    }
                    if (node.tag == tagTable.tagTd || node.tag == tagTable.tagTh) {
                        if ((node2.tag.model & 4) != 0) {
                            ParserImpl.moveToHead(lexer2, node, node2);
                            continue;
                        }
                        if ((node2.tag.model & 0x20) != 0) {
                            lexer2.ungetToken();
                            node2 = lexer2.inferredTag("ul");
                            Node.addClass(node2, "noindent");
                            lexer2.excludeBlocks = true;
                        } else if ((node2.tag.model & 0x40) != 0) {
                            lexer2.ungetToken();
                            node2 = lexer2.inferredTag("dl");
                            lexer2.excludeBlocks = true;
                        }
                        if ((node2.tag.model & 8) == 0) {
                            lexer2.ungetToken();
                            Node.trimSpaces(lexer2, node);
                            Node.trimEmptyElement(lexer2, node);
                            return;
                        }
                    } else if ((node2.tag.model & 8) != 0) {
                        if (lexer2.excludeBlocks) {
                            if ((node.tag.model & 0x8000) == 0) {
                                Report.warning(lexer2, node, node2, (short)2);
                            }
                            lexer2.ungetToken();
                            if ((node.tag.model & 0x800) != 0) {
                                lexer2.istackbase = n;
                            }
                            Node.trimSpaces(lexer2, node);
                            Node.trimEmptyElement(lexer2, node);
                            return;
                        }
                    } else {
                        if ((node.tag.model & 0x8000) == 0 && !node.implicit) {
                            Report.warning(lexer2, node, node2, (short)2);
                        }
                        if ((node2.tag.model & 4) != 0) {
                            ParserImpl.moveToHead(lexer2, node, node2);
                            continue;
                        }
                        lexer2.ungetToken();
                        if ((node2.tag.model & 0x20) != 0) {
                            if (node.parent != null && node.parent.tag != null && node.parent.tag.parser == ParserImpl.getParseList()) {
                                Node.trimSpaces(lexer2, node);
                                Node.trimEmptyElement(lexer2, node);
                                return;
                            }
                            node2 = lexer2.inferredTag("ul");
                            Node.addClass(node2, "noindent");
                        } else if ((node2.tag.model & 0x40) != 0) {
                            if (node.parent.tag == tagTable.tagDl) {
                                Node.trimSpaces(lexer2, node);
                                Node.trimEmptyElement(lexer2, node);
                                return;
                            }
                            node2 = lexer2.inferredTag("dl");
                        } else if ((node2.tag.model & 0x80) != 0 || (node2.tag.model & 0x200) != 0) {
                            node2 = lexer2.inferredTag("table");
                        } else {
                            if ((node.tag.model & 0x800) != 0) {
                                while (lexer2.istack.size() > lexer2.istackbase) {
                                    lexer2.popInline(null);
                                }
                                lexer2.istackbase = n;
                                Node.trimSpaces(lexer2, node);
                                Node.trimEmptyElement(lexer2, node);
                                return;
                            }
                            Node.trimSpaces(lexer2, node);
                            Node.trimEmptyElement(lexer2, node);
                            return;
                        }
                    }
                }
                if (node2.type == 5 || node2.type == 7) {
                    if ((node2.tag.model & 0x10) != 0) {
                        if (bl && !node2.implicit) {
                            bl = false;
                            if (lexer2.inlineDup(node2) > 0) continue;
                        }
                        s = 1;
                    } else {
                        bl = true;
                        s = 0;
                    }
                    if (node2.tag == tagTable.tagBr) {
                        Node.trimSpaces(lexer2, node);
                    }
                    Node.insertNodeAtEnd(node, node2);
                    if (node2.implicit) {
                        Report.warning(lexer2, node, node2, (short)10);
                    }
                    ParserImpl.parseTag(lexer2, node2, (short)0);
                    continue;
                }
                if (node2.type == 6) {
                    lexer2.popInline(node2);
                }
                Report.warning(lexer2, node, node2, (short)3);
            }
            if ((node.tag.model & 0x8000) == 0) {
                Report.warning(lexer2, node, node2, (short)1);
            }
            if ((node.tag.model & 0x800) != 0) {
                while (lexer2.istack.size() > lexer2.istackbase) {
                    lexer2.popInline(null);
                }
                lexer2.istackbase = n;
            }
            Node.trimSpaces(lexer2, node);
            Node.trimEmptyElement(lexer2, node);
        }
    }

    public static class ParseTableTag
    implements Parser {
        public void parse(Lexer lexer2, Node node, short s) {
            Node node2;
            TagTable tagTable = lexer2.configuration.tt;
            lexer2.deferDup();
            int n = lexer2.istackbase;
            lexer2.istackbase = lexer2.istack.size();
            while ((node2 = lexer2.getToken((short)0)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    lexer2.istackbase = n;
                    node.closed = true;
                    Node.trimEmptyElement(lexer2, node);
                    return;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.tag == null && node2.type != 4) {
                    Report.warning(lexer2, node, node2, (short)3);
                    continue;
                }
                if (node2.type != 6) {
                    if (node2.tag == tagTable.tagTd || node2.tag == tagTable.tagTh || node2.tag == tagTable.tagTable) {
                        lexer2.ungetToken();
                        node2 = lexer2.inferredTag("tr");
                        Report.warning(lexer2, node, node2, (short)7);
                    } else {
                        if (node2.type == 4 || (node2.tag.model & 0x18) != 0) {
                            Node.insertNodeBeforeElement(node, node2);
                            Report.warning(lexer2, node, node2, (short)6);
                            lexer2.exiled = true;
                            lexer2.exiled = false;
                            continue;
                        }
                        if ((node2.tag.model & 4) != 0) {
                            ParserImpl.moveToHead(lexer2, node, node2);
                            continue;
                        }
                    }
                }
                if (node2.type == 6) {
                    if (node2.tag == tagTable.tagForm) {
                        lexer2.badForm = 1;
                        Report.warning(lexer2, node, node2, (short)3);
                        continue;
                    }
                    if (node2.tag != null && (node2.tag.model & 0x280) != 0) {
                        Report.warning(lexer2, node, node2, (short)3);
                        continue;
                    }
                    Node node3 = node.parent;
                    while (node3 != null) {
                        if (node2.tag == node3.tag) {
                            Report.warning(lexer2, node, node2, (short)2);
                            lexer2.ungetToken();
                            lexer2.istackbase = n;
                            Node.trimEmptyElement(lexer2, node);
                            return;
                        }
                        node3 = node3.parent;
                    }
                }
                if ((node2.tag.model & 0x80) == 0) {
                    lexer2.ungetToken();
                    Report.warning(lexer2, node, node2, (short)6);
                    lexer2.istackbase = n;
                    Node.trimEmptyElement(lexer2, node);
                    return;
                }
                if (node2.type == 5 || node2.type == 7) {
                    Node.insertNodeAtEnd(node, node2);
                    ParserImpl.parseTag(lexer2, node2, (short)0);
                    continue;
                }
                Report.warning(lexer2, node, node2, (short)3);
            }
            Report.warning(lexer2, node, node2, (short)1);
            Node.trimEmptyElement(lexer2, node);
            lexer2.istackbase = n;
        }
    }

    public static class ParseColGroup
    implements Parser {
        public void parse(Lexer lexer2, Node node, short s) {
            Node node2;
            TagTable tagTable = lexer2.configuration.tt;
            if ((node.tag.model & 1) != 0) {
                return;
            }
            while ((node2 = lexer2.getToken((short)0)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    node.closed = true;
                    return;
                }
                if (node2.type == 6) {
                    if (node2.tag == tagTable.tagForm) {
                        lexer2.badForm = 1;
                        Report.warning(lexer2, node, node2, (short)3);
                        continue;
                    }
                    Node node3 = node.parent;
                    while (node3 != null) {
                        if (node2.tag == node3.tag) {
                            lexer2.ungetToken();
                            return;
                        }
                        node3 = node3.parent;
                    }
                }
                if (node2.type == 4) {
                    lexer2.ungetToken();
                    return;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.tag == null) {
                    Report.warning(lexer2, node, node2, (short)3);
                    continue;
                }
                if (node2.tag != tagTable.tagCol) {
                    lexer2.ungetToken();
                    return;
                }
                if (node2.type == 6) {
                    Report.warning(lexer2, node, node2, (short)3);
                    continue;
                }
                Node.insertNodeAtEnd(node, node2);
                ParserImpl.parseTag(lexer2, node2, (short)0);
            }
        }
    }

    public static class ParseRowGroup
    implements Parser {
        public void parse(Lexer lexer2, Node node, short s) {
            Node node2;
            TagTable tagTable = lexer2.configuration.tt;
            if ((node.tag.model & 1) != 0) {
                return;
            }
            while ((node2 = lexer2.getToken((short)0)) != null) {
                if (node2.tag == node.tag) {
                    if (node2.type == 6) {
                        node.closed = true;
                        Node.trimEmptyElement(lexer2, node);
                        return;
                    }
                    lexer2.ungetToken();
                    return;
                }
                if (node2.tag == tagTable.tagTable && node2.type == 6) {
                    lexer2.ungetToken();
                    Node.trimEmptyElement(lexer2, node);
                    return;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.tag == null && node2.type != 4) {
                    Report.warning(lexer2, node, node2, (short)3);
                    continue;
                }
                if (node2.type != 6) {
                    if (node2.tag == tagTable.tagTd || node2.tag == tagTable.tagTh) {
                        lexer2.ungetToken();
                        node2 = lexer2.inferredTag("tr");
                        Report.warning(lexer2, node, node2, (short)7);
                    } else {
                        if (node2.type == 4 || (node2.tag.model & 0x18) != 0) {
                            Node.moveBeforeTable(node, node2, tagTable);
                            Report.warning(lexer2, node, node2, (short)6);
                            lexer2.exiled = true;
                            if (node2.type != 4) {
                                ParserImpl.parseTag(lexer2, node2, (short)0);
                            }
                            lexer2.exiled = false;
                            continue;
                        }
                        if ((node2.tag.model & 4) != 0) {
                            Report.warning(lexer2, node, node2, (short)6);
                            ParserImpl.moveToHead(lexer2, node, node2);
                            continue;
                        }
                    }
                }
                if (node2.type == 6) {
                    if (node2.tag == tagTable.tagForm) {
                        lexer2.badForm = 1;
                        Report.warning(lexer2, node, node2, (short)3);
                        continue;
                    }
                    if (node2.tag == tagTable.tagTr || node2.tag == tagTable.tagTd || node2.tag == tagTable.tagTh) {
                        Report.warning(lexer2, node, node2, (short)3);
                        continue;
                    }
                    Node node3 = node.parent;
                    while (node3 != null) {
                        if (node2.tag == node3.tag) {
                            lexer2.ungetToken();
                            Node.trimEmptyElement(lexer2, node);
                            return;
                        }
                        node3 = node3.parent;
                    }
                }
                if ((node2.tag.model & 0x100) != 0) {
                    if (node2.type != 6) {
                        lexer2.ungetToken();
                    }
                    Node.trimEmptyElement(lexer2, node);
                    return;
                }
                if (node2.type == 6) {
                    Report.warning(lexer2, node, node2, (short)3);
                    continue;
                }
                if (node2.tag != tagTable.tagTr) {
                    node2 = lexer2.inferredTag("tr");
                    Report.warning(lexer2, node, node2, (short)7);
                    lexer2.ungetToken();
                }
                Node.insertNodeAtEnd(node, node2);
                ParserImpl.parseTag(lexer2, node2, (short)0);
            }
            Node.trimEmptyElement(lexer2, node);
        }
    }

    public static class ParseRow
    implements Parser {
        public void parse(Lexer lexer2, Node node, short s) {
            Node node2;
            TagTable tagTable = lexer2.configuration.tt;
            if ((node.tag.model & 1) != 0) {
                return;
            }
            while ((node2 = lexer2.getToken((short)0)) != null) {
                if (node2.tag == node.tag) {
                    if (node2.type == 6) {
                        node.closed = true;
                        Node.fixEmptyRow(lexer2, node);
                        return;
                    }
                    lexer2.ungetToken();
                    Node.fixEmptyRow(lexer2, node);
                    return;
                }
                if (node2.type == 6) {
                    if (node2.tag == tagTable.tagForm) {
                        lexer2.badForm = 1;
                        Report.warning(lexer2, node, node2, (short)3);
                        continue;
                    }
                    if (node2.tag == tagTable.tagTd || node2.tag == tagTable.tagTh) {
                        Report.warning(lexer2, node, node2, (short)3);
                        continue;
                    }
                    Node node3 = node.parent;
                    while (node3 != null) {
                        if (node2.tag == node3.tag) {
                            lexer2.ungetToken();
                            Node.trimEmptyElement(lexer2, node);
                            return;
                        }
                        node3 = node3.parent;
                    }
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.tag == null && node2.type != 4) {
                    Report.warning(lexer2, node, node2, (short)3);
                    continue;
                }
                if (node2.tag == tagTable.tagTable) {
                    Report.warning(lexer2, node, node2, (short)3);
                    continue;
                }
                if (node2.tag != null && (node2.tag.model & 0x100) != 0) {
                    lexer2.ungetToken();
                    Node.trimEmptyElement(lexer2, node);
                    return;
                }
                if (node2.type == 6) {
                    Report.warning(lexer2, node, node2, (short)3);
                    continue;
                }
                if (node2.type != 6) {
                    if (node2.tag == tagTable.tagForm) {
                        lexer2.ungetToken();
                        node2 = lexer2.inferredTag("td");
                        Report.warning(lexer2, node, node2, (short)7);
                    } else {
                        if (node2.type == 4 || (node2.tag.model & 0x18) != 0) {
                            Node.moveBeforeTable(node, node2, tagTable);
                            Report.warning(lexer2, node, node2, (short)6);
                            lexer2.exiled = true;
                            if (node2.type != 4) {
                                ParserImpl.parseTag(lexer2, node2, (short)0);
                            }
                            lexer2.exiled = false;
                            continue;
                        }
                        if ((node2.tag.model & 4) != 0) {
                            Report.warning(lexer2, node, node2, (short)6);
                            ParserImpl.moveToHead(lexer2, node, node2);
                            continue;
                        }
                    }
                }
                if (node2.tag != tagTable.tagTd && node2.tag != tagTable.tagTh) {
                    Report.warning(lexer2, node, node2, (short)6);
                    continue;
                }
                Node.insertNodeAtEnd(node, node2);
                boolean bl = lexer2.excludeBlocks;
                lexer2.excludeBlocks = false;
                ParserImpl.parseTag(lexer2, node2, (short)0);
                lexer2.excludeBlocks = bl;
                while (lexer2.istack.size() > lexer2.istackbase) {
                    lexer2.popInline(null);
                }
            }
            Node.trimEmptyElement(lexer2, node);
        }
    }

    public static class ParseNoFrames
    implements Parser {
        public void parse(Lexer lexer2, Node node, short s) {
            Node node2;
            TagTable tagTable = lexer2.configuration.tt;
            lexer2.badAccess = (short)(lexer2.badAccess | 0x20);
            s = 0;
            boolean bl = true;
            while ((node2 = lexer2.getToken(s)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    node.closed = true;
                    Node.trimSpaces(lexer2, node);
                    return;
                }
                if (node2.tag == tagTable.tagFrame || node2.tag == tagTable.tagFrameset) {
                    Report.warning(lexer2, node, node2, (short)2);
                    Node.trimSpaces(lexer2, node);
                    lexer2.ungetToken();
                    return;
                }
                if (node2.tag == tagTable.tagHtml) {
                    if (node2.type != 5 && node2.type != 7) continue;
                    Report.warning(lexer2, node, node2, (short)3);
                    continue;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.tag == tagTable.tagBody && node2.type == 5) {
                    Node.insertNodeAtEnd(node, node2);
                    ParserImpl.parseTag(lexer2, node2, (short)0);
                    continue;
                }
                if (node2.type == 4 || node2.tag != null) {
                    lexer2.ungetToken();
                    node2 = lexer2.inferredTag("body");
                    if (lexer2.configuration.XmlOut) {
                        Report.warning(lexer2, node, node2, (short)10);
                    }
                    Node.insertNodeAtEnd(node, node2);
                    ParserImpl.parseTag(lexer2, node2, (short)0);
                    continue;
                }
                Report.warning(lexer2, node, node2, (short)3);
            }
            Report.warning(lexer2, node, node2, (short)1);
        }
    }

    public static class ParseSelect
    implements Parser {
        public void parse(Lexer lexer2, Node node, short s) {
            Node node2;
            TagTable tagTable = lexer2.configuration.tt;
            lexer2.insert = -1;
            while ((node2 = lexer2.getToken((short)0)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    node.closed = true;
                    Node.trimSpaces(lexer2, node);
                    return;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.type == 5 && (node2.tag == tagTable.tagOption || node2.tag == tagTable.tagOptgroup || node2.tag == tagTable.tagScript)) {
                    Node.insertNodeAtEnd(node, node2);
                    ParserImpl.parseTag(lexer2, node2, (short)0);
                    continue;
                }
                Report.warning(lexer2, node, node2, (short)3);
            }
            Report.warning(lexer2, node, node2, (short)1);
        }
    }

    public static class ParseText
    implements Parser {
        public void parse(Lexer lexer2, Node node, short s) {
            Node node2;
            TagTable tagTable = lexer2.configuration.tt;
            lexer2.insert = -1;
            if (node.tag == tagTable.tagTextarea) {
                s = (short)2;
            }
            while ((node2 = lexer2.getToken(s)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    node.closed = true;
                    Node.trimSpaces(lexer2, node);
                    return;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.type == 4) {
                    if (node.content == null && (s & 2) == 0) {
                        Node.trimSpaces(lexer2, node);
                    }
                    if (node2.start >= node2.end) continue;
                    Node.insertNodeAtEnd(node, node2);
                    continue;
                }
                if (node2.tag == tagTable.tagFont) {
                    Report.warning(lexer2, node, node2, (short)3);
                    continue;
                }
                if ((node.tag.model & 0x8000) == 0) {
                    Report.warning(lexer2, node, node2, (short)2);
                }
                lexer2.ungetToken();
                Node.trimSpaces(lexer2, node);
                return;
            }
            if ((node.tag.model & 0x8000) == 0) {
                Report.warning(lexer2, node, node2, (short)1);
            }
        }
    }

    public static class ParseOptGroup
    implements Parser {
        public void parse(Lexer lexer2, Node node, short s) {
            Node node2;
            TagTable tagTable = lexer2.configuration.tt;
            lexer2.insert = -1;
            while ((node2 = lexer2.getToken((short)0)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    node.closed = true;
                    Node.trimSpaces(lexer2, node);
                    return;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.type == 5 && (node2.tag == tagTable.tagOption || node2.tag == tagTable.tagOptgroup)) {
                    if (node2.tag == tagTable.tagOptgroup) {
                        Report.warning(lexer2, node, node2, (short)14);
                    }
                    Node.insertNodeAtEnd(node, node2);
                    ParserImpl.parseTag(lexer2, node2, (short)1);
                    continue;
                }
                Report.warning(lexer2, node, node2, (short)3);
            }
        }
    }
}

