/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.generator;

import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import net.jangaroo.exml.config.ExmlConfiguration;
import net.jangaroo.exml.generator.ExmlConfigPackage;
import net.jangaroo.exml.model.ConfigClass;
import net.jangaroo.exml.model.ConfigClassRegistry;

public class ExmlConfigPackageXsdGenerator {
    private ExmlConfiguration config;

    public ExmlConfigPackageXsdGenerator(ExmlConfiguration config) {
        this.config = config;
    }

    public File generateXsdFile(ConfigClassRegistry registry) throws IOException, TemplateException {
        registry.scanAllAsFiles();
        Map<String, Collection<ConfigClass>> configClassesByTargetClassPackage = registry.getRegisteredConfigClassesByTargetClassPackage();
        for (Map.Entry<String, Collection<ConfigClass>> entry : configClassesByTargetClassPackage.entrySet()) {
            ExmlConfigPackage suite = new ExmlConfigPackage(entry.getValue(), entry.getKey());
            this.generateXsdFile(suite);
        }
        Collection<ConfigClass> configClasses = registry.getRegisteredConfigClasses();
        String packageName = this.config.getConfigClassPackage();
        return this.generateXsdFile(new ExmlConfigPackage(configClasses, packageName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File generateXsdFile(ExmlConfigPackage suite) throws IOException, TemplateException {
        File targetPackageFolder = this.config.getResourceOutputDirectory();
        if (!targetPackageFolder.exists()) {
            targetPackageFolder.mkdirs();
        }
        File result = new File(targetPackageFolder, suite.getPackageName() + ".xsd");
        Writer writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(result), "UTF-8");
            this.generateXsdFile(suite, writer);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {}
        }
        return result;
    }

    public void generateXsdFile(ConfigClassRegistry registry, Writer output) throws IOException, TemplateException {
        registry.scanAllAsFiles();
        this.generateXsdFile(new ExmlConfigPackage(registry.getRegisteredConfigClasses(), this.config.getConfigClassPackage()), output);
    }

    private void generateXsdFile(ExmlConfigPackage suite, Writer output) throws IOException, TemplateException {
        Configuration cfg = new Configuration();
        cfg.setClassForTemplateLoading(ExmlConfigPackage.class, "/");
        cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        Template template = cfg.getTemplate("/net/jangaroo/exml/templates/exml_config_package_xsd.ftl");
        Environment env = template.createProcessingEnvironment((Object)suite, output);
        env.setOutputEncoding("UTF-8");
        env.process();
    }
}

