/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.jangaroo.jooc.model.AbstractAnnotatedModel;
import net.jangaroo.jooc.model.MemberModel;
import net.jangaroo.jooc.model.MethodModel;
import net.jangaroo.jooc.model.MethodType;
import net.jangaroo.jooc.model.ModelVisitor;
import net.jangaroo.jooc.model.NamespacedModel;
import net.jangaroo.jooc.model.PropertyModel;

public class ClassModel
extends AbstractAnnotatedModel
implements NamespacedModel {
    private boolean isInterface = false;
    private boolean isFinal = false;
    private boolean isDynamic = false;
    private String namespace = "public";
    private String superclass = null;
    private List<String> interfaces = new ArrayList<String>();
    private List<MemberModel> members = new ArrayList<MemberModel>();

    public ClassModel() {
    }

    public ClassModel(String name) {
        super(name);
    }

    public ClassModel(String name, String superclass) {
        super(name);
        this.superclass = superclass;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean aFinal) {
        this.isFinal = aFinal;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.isDynamic = dynamic;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public void setInterface(boolean value) {
        this.isInterface = value;
    }

    public String getSuperclass() {
        return this.superclass;
    }

    public void setSuperclass(String superclass) {
        this.superclass = superclass;
    }

    public List<String> getInterfaces() {
        return Collections.unmodifiableList(this.interfaces);
    }

    public void setInterfaces(List<String> interfaces) {
        this.interfaces = interfaces;
    }

    public void addInterface(String interfaceName) {
        this.interfaces.add(interfaceName);
    }

    public List<MemberModel> getMembers() {
        return Collections.unmodifiableList(this.members);
    }

    public void setMembers(List<MemberModel> members) {
        this.members = members;
    }

    public void addMember(MemberModel member) {
        MemberModel oldMember = this.getMember(member.isStatic(), member.getName());
        if (oldMember != null) {
            if (oldMember.isProperty()) {
                PropertyModel oldPropertyModel = (PropertyModel)oldMember;
                if (member.isGetter()) {
                    oldMember = oldPropertyModel.getGetter();
                } else if (member.isSetter()) {
                    oldMember = oldPropertyModel.getSetter();
                }
            }
            if (oldMember != null) {
                if (oldMember.equals(member)) {
                    return;
                }
                throw new IllegalArgumentException("Someone tried to add a different " + (member.isStatic() ? "static " : "") + "member called " + member.getName() + ": " + oldMember + " -> " + member);
            }
        }
        if (member.isProperty()) {
            PropertyModel propertyModel = (PropertyModel)member;
            this.addIfNotNull(propertyModel.getGetter());
            this.addIfNotNull(propertyModel.getSetter());
        } else {
            this.members.add(member);
        }
    }

    private void addIfNotNull(MethodModel method) {
        if (method != null) {
            this.members.add(method);
        }
    }

    public PropertyModel getProperty(boolean isStatic, String name) {
        MemberModel member = this.getMember(isStatic, name);
        return member != null && member.isProperty() ? (PropertyModel)member : null;
    }

    public MemberModel getMember(String name) {
        return this.getMember(false, name);
    }

    public MemberModel getStaticMember(String name) {
        return this.getMember(true, name);
    }

    private MemberModel getMember(boolean isStatic, String name) {
        MemberModel member = this.getMethodOrField(isStatic, name);
        if (member != null && member.isAccessor()) {
            MethodModel counterpart = this.getMethod(isStatic, member.isGetter() ? MethodType.SET : MethodType.GET, name);
            return new PropertyModel((MethodModel)member, counterpart);
        }
        return member;
    }

    private MemberModel getMethodOrField(boolean isStatic, String name) {
        for (MemberModel memberModel : this.members) {
            if (memberModel.isStatic() != isStatic || !name.equals(memberModel.getName())) continue;
            return memberModel;
        }
        return null;
    }

    public boolean removeMember(MemberModel memberModel) {
        return this.members.remove(memberModel);
    }

    public MethodModel getConstructor() {
        return this.getMethod(this.getName());
    }

    public MethodModel getStaticMethod(String name) {
        return this.getStaticMethod(null, name);
    }

    public MethodModel getStaticMethod(MethodType methodType, String name) {
        return this.getMethod(false, methodType, name);
    }

    public MethodModel getMethod(String name) {
        return this.getMethod(false, name);
    }

    public MethodModel getMethod(MethodType methodType, String name) {
        return this.getMethod(false, methodType, name);
    }

    private MethodModel getMethod(boolean isStatic, String name) {
        return this.getMethod(isStatic, null, name);
    }

    private MethodModel getMethod(boolean isStatic, MethodType methodType, String name) {
        MemberModel member = this.getMethodOrField(isStatic, name);
        if (member != null) {
            if (methodType == null) {
                if (member.isMethod()) {
                    return (MethodModel)member;
                }
            } else if (member.isProperty()) {
                return methodType == MethodType.GET ? ((PropertyModel)member).getGetter() : ((PropertyModel)member).getSetter();
            }
        }
        return null;
    }

    public MethodModel createConstructor() {
        MethodModel constructor = new MethodModel(this.getName(), null);
        this.addMember(constructor);
        return constructor;
    }

    @Override
    public void visit(ModelVisitor visitor) {
        visitor.visitClass(this);
    }
}

