/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import org.w3c.tidy.AttVal;
import org.w3c.tidy.AttributeTable;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.MutableInteger;
import org.w3c.tidy.MutableObject;
import org.w3c.tidy.Node;
import org.w3c.tidy.PPrint;
import org.w3c.tidy.ParserImpl;
import org.w3c.tidy.Style;
import org.w3c.tidy.StyleProp;
import org.w3c.tidy.TagTable;

public class Clean {
    private int classNum = 1;
    private TagTable tt;

    public Clean(TagTable tagTable) {
        this.tt = tagTable;
    }

    private void addAlign(Node node, String string) {
        this.addStyleProperty(node, "text-align: " + string.toLowerCase());
    }

    private void addColorRule(Lexer lexer2, String string, String string2) {
        if (string2 != null) {
            lexer2.addStringLiteral(string);
            lexer2.addStringLiteral(" { color: ");
            lexer2.addStringLiteral(string2);
            lexer2.addStringLiteral(" }\n");
        }
    }

    private void addFontColor(Node node, String string) {
        this.addStyleProperty(node, "color: " + string);
    }

    private void addFontFace(Node node, String string) {
        this.addStyleProperty(node, "font-family: " + string);
    }

    private void addFontSize(Node node, String string) {
        if (string.equals("6") && node.tag == this.tt.tagP) {
            node.element = "h1";
            this.tt.findTag(node);
            return;
        }
        if (string.equals("5") && node.tag == this.tt.tagP) {
            node.element = "h2";
            this.tt.findTag(node);
            return;
        }
        if (string.equals("4") && node.tag == this.tt.tagP) {
            node.element = "h3";
            this.tt.findTag(node);
            return;
        }
        String string2 = this.fontSize2Name(string);
        if (string2 != null) {
            this.addStyleProperty(node, "font-size: " + string2);
        }
    }

    private void addFontStyles(Node node, AttVal attVal) {
        while (attVal != null) {
            if (attVal.attribute.equals("face")) {
                this.addFontFace(node, attVal.value);
            } else if (attVal.attribute.equals("size")) {
                this.addFontSize(node, attVal.value);
            } else if (attVal.attribute.equals("color")) {
                this.addFontColor(node, attVal.value);
            }
            attVal = attVal.next;
        }
    }

    private String addProperty(String string, String string2) {
        StyleProp styleProp = this.createProps(null, string);
        styleProp = this.createProps(styleProp, string2);
        string = this.createPropString(styleProp);
        return string;
    }

    private void addStyleProperty(Node node, String string) {
        AttVal attVal = node.attributes;
        while (attVal != null) {
            if (attVal.attribute.equals("style")) break;
            attVal = attVal.next;
        }
        if (attVal != null) {
            String string2;
            attVal.value = string2 = this.addProperty(attVal.value, string);
        } else {
            attVal = new AttVal(node.attributes, null, 34, "style", string);
            attVal.dict = AttributeTable.getDefaultAttributeTable().findAttribute(attVal);
            node.attributes = attVal;
        }
    }

    public void bQ2Div(Node node) {
        while (node != null) {
            if (node.tag == this.tt.tagBlockquote && node.implicit) {
                int n = 1;
                while (node.hasOneChild() && node.content.tag == this.tt.tagBlockquote && node.implicit) {
                    ++n;
                    this.stripOnlyChild(node);
                }
                if (node.content != null) {
                    this.bQ2Div(node.content);
                }
                String string = "margin-left: " + new Integer(2 * n).toString() + "em";
                node.element = this.tt.tagDiv.name;
                node.tag = this.tt.tagDiv;
                node.addAttribute("style", string);
            } else if (node.content != null) {
                this.bQ2Div(node.content);
            }
            node = node.next;
        }
    }

    private boolean blockStyle(Lexer lexer2, Node node, MutableObject mutableObject) {
        if ((node.tag.model & 0xE8) != 0 && node.tag != this.tt.tagTable && node.tag != this.tt.tagTr && node.tag != this.tt.tagLi) {
            Node node2;
            if (node.tag != this.tt.tagCaption) {
                this.textAlign(lexer2, node);
            }
            if ((node2 = node.content) == null) {
                return false;
            }
            if (node2.next != null) {
                return false;
            }
            if (node2.tag == this.tt.tagB) {
                this.mergeStyles(node, node2);
                this.addStyleProperty(node, "font-weight: bold");
                this.stripOnlyChild(node);
                return true;
            }
            if (node2.tag == this.tt.tagI) {
                this.mergeStyles(node, node2);
                this.addStyleProperty(node, "font-style: italic");
                this.stripOnlyChild(node);
                return true;
            }
            if (node2.tag == this.tt.tagFont) {
                this.mergeStyles(node, node2);
                this.addFontStyles(node, node2.attributes);
                this.stripOnlyChild(node);
                return true;
            }
        }
        return false;
    }

    private boolean center2Div(Lexer lexer2, Node node, MutableObject mutableObject) {
        if (node.tag == this.tt.tagCenter) {
            if (lexer2.configuration.DropFontTags) {
                if (node.content != null) {
                    Node node2 = node.last;
                    Node node3 = node.parent;
                    this.discardContainer(node, mutableObject);
                    node = lexer2.inferredTag("br");
                    if (node2.next != null) {
                        node2.next.prev = node;
                    }
                    node.next = node2.next;
                    node2.next = node;
                    node.prev = node2;
                    if (node3.last == node2) {
                        node3.last = node;
                    }
                    node.parent = node3;
                } else {
                    Node node4 = node.prev;
                    Node node5 = node.next;
                    Node node6 = node.parent;
                    this.discardContainer(node, mutableObject);
                    node = lexer2.inferredTag("br");
                    node.next = node5;
                    node.prev = node4;
                    node.parent = node6;
                    if (node5 != null) {
                        node5.prev = node;
                    } else {
                        node6.last = node;
                    }
                    if (node4 != null) {
                        node4.next = node;
                    } else {
                        node6.content = node;
                    }
                }
                return true;
            }
            node.tag = this.tt.tagDiv;
            node.element = "div";
            this.addStyleProperty(node, "text-align: center");
            return true;
        }
        return false;
    }

    private void cleanBodyAttrs(Lexer lexer2, Node node) {
        String string = null;
        String string2 = null;
        String string3 = null;
        AttVal attVal = node.getAttrByName("background");
        if (attVal != null) {
            string = attVal.value;
            attVal.value = null;
            node.removeAttribute(attVal);
        }
        if ((attVal = node.getAttrByName("bgcolor")) != null) {
            string2 = attVal.value;
            attVal.value = null;
            node.removeAttribute(attVal);
        }
        if ((attVal = node.getAttrByName("text")) != null) {
            string3 = attVal.value;
            attVal.value = null;
            node.removeAttribute(attVal);
        }
        if (string != null || string2 != null || string3 != null) {
            lexer2.addStringLiteral(" body {\n");
            if (string != null) {
                lexer2.addStringLiteral("  background-image: url(");
                lexer2.addStringLiteral(string);
                lexer2.addStringLiteral(");\n");
            }
            if (string2 != null) {
                lexer2.addStringLiteral("  background-color: ");
                lexer2.addStringLiteral(string2);
                lexer2.addStringLiteral(";\n");
            }
            if (string3 != null) {
                lexer2.addStringLiteral("  color: ");
                lexer2.addStringLiteral(string3);
                lexer2.addStringLiteral(";\n");
            }
            lexer2.addStringLiteral(" }\n");
        }
        if ((attVal = node.getAttrByName("link")) != null) {
            this.addColorRule(lexer2, " :link", attVal.value);
            node.removeAttribute(attVal);
        }
        if ((attVal = node.getAttrByName("vlink")) != null) {
            this.addColorRule(lexer2, " :visited", attVal.value);
            node.removeAttribute(attVal);
        }
        if ((attVal = node.getAttrByName("alink")) != null) {
            this.addColorRule(lexer2, " :active", attVal.value);
            node.removeAttribute(attVal);
        }
    }

    private Node cleanNode(Lexer lexer2, Node node) {
        Node node2 = null;
        MutableObject mutableObject = new MutableObject();
        boolean bl = false;
        node2 = node;
        while (node.isElement()) {
            mutableObject.setObject(node2);
            bl = this.dir2Div(lexer2, node, mutableObject);
            node2 = (Node)mutableObject.getObject();
            if (!bl) {
                bl = this.nestedList(lexer2, node, mutableObject);
                node2 = (Node)mutableObject.getObject();
                if (!bl) {
                    bl = this.center2Div(lexer2, node, mutableObject);
                    node2 = (Node)mutableObject.getObject();
                    if (!bl) {
                        bl = this.mergeDivs(lexer2, node, mutableObject);
                        node2 = (Node)mutableObject.getObject();
                        if (!bl) {
                            bl = this.blockStyle(lexer2, node, mutableObject);
                            node2 = (Node)mutableObject.getObject();
                            if (!bl) {
                                bl = this.inlineStyle(lexer2, node, mutableObject);
                                node2 = (Node)mutableObject.getObject();
                                if (!bl) {
                                    bl = this.font2Span(lexer2, node, mutableObject);
                                    node2 = (Node)mutableObject.getObject();
                                    if (!bl) break;
                                }
                            }
                        }
                    }
                }
            }
            node = node2;
        }
        return node2;
    }

    public void cleanTree(Lexer lexer2, Node node) {
        node = this.createStyleProperties(lexer2, node);
        if (!lexer2.configuration.MakeClean) {
            this.defineStyleRules(lexer2, node);
            this.createStyleElement(lexer2, node);
        }
    }

    public void cleanWord2000(Lexer lexer2, Node node) {
        Node node2 = null;
        while (node != null) {
            AttVal attVal;
            if (node.tag == this.tt.tagStyle || node.tag == this.tt.tagMeta || node.type == 2) {
                node = Node.discardElement(node);
                continue;
            }
            if (node.tag == this.tt.tagSpan) {
                node = this.stripSpan(lexer2, node);
                continue;
            }
            if (node.tag == this.tt.tagHtml && node.getAttrByName("xmlns:o") == null) {
                return;
            }
            if (node.tag == this.tt.tagLink && (attVal = node.getAttrByName("rel")) != null && attVal.value != null && attVal.value.equals("File-List")) {
                node = Node.discardElement(node);
                continue;
            }
            if (node.content == null && node.tag == this.tt.tagP) {
                node = Node.discardElement(node);
                continue;
            }
            if (node.tag == this.tt.tagP) {
                attVal = node.getAttrByName("class");
                if (attVal != null && attVal.value != null && attVal.value.equals("MsoListBullet")) {
                    Node.coerceNode(lexer2, node, this.tt.tagLi);
                    if (node2 == null || node2.tag != this.tt.tagUl) {
                        node2 = lexer2.inferredTag("ul");
                        Node.insertNodeBeforeElement(node, node2);
                    }
                    this.purgeAttributes(node);
                    if (node.content != null) {
                        this.cleanWord2000(lexer2, node.content);
                    }
                    Node.removeNode(node);
                    Node.insertNodeAtEnd(node2, node);
                    node = node2.next;
                } else if (attVal != null && attVal.value != null && attVal.value.equals("Code")) {
                    Node node3 = lexer2.newLineNode();
                    this.normalizeSpaces(lexer2, node);
                    if (node2 == null || node2.tag != this.tt.tagPre) {
                        node2 = lexer2.inferredTag("pre");
                        Node.insertNodeBeforeElement(node, node2);
                    }
                    Node.removeNode(node);
                    Node.insertNodeAtEnd(node2, node);
                    this.stripSpan(lexer2, node);
                    Node.insertNodeAtEnd(node2, node3);
                    node = node2.next;
                } else {
                    node2 = null;
                }
            } else {
                node2 = null;
            }
            if (node.type == 5 || node.type == 7) {
                this.purgeAttributes(node);
            }
            if (node.content != null) {
                this.cleanWord2000(lexer2, node.content);
            }
            node = node.next;
        }
    }

    private String createPropString(StyleProp styleProp) {
        String string = "";
        int n = 0;
        StyleProp styleProp2 = styleProp;
        while (styleProp2 != null) {
            n += styleProp2.name.length() + 2;
            n += styleProp2.value.length() + 2;
            styleProp2 = styleProp2.next;
        }
        styleProp2 = styleProp;
        while (styleProp2 != null) {
            string = string.concat(styleProp2.name);
            string = string.concat(": ");
            string = string.concat(styleProp2.value);
            if (styleProp2.next == null) break;
            string = string.concat("; ");
            styleProp2 = styleProp2.next;
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    private StyleProp createProps(StyleProp var1_1, String var2_2) {
        var5_3 = 0;
        var6_4 = 0;
        var6_4 = 0;
        ** GOTO lbl30
        {
            ++var6_4;
            do {
                if (var6_4 < var2_2.length() && var2_2.charAt(var6_4) == ' ') continue block0;
                var3_5 = var6_4;
                while (var3_5 < var2_2.length()) {
                    if (var2_2.charAt(var3_5) == ':') {
                        var5_3 = var3_5 + 1;
                        break;
                    }
                    ++var3_5;
                }
                if (var3_5 < var2_2.length() && var2_2.charAt(var3_5) == ':') ** GOTO lbl18
                break block0;
lbl-1000:
                // 1 sources

                {
                    ++var5_3;
lbl18:
                    // 2 sources

                    ** while (var5_3 < var2_2.length() && var2_2.charAt((int)var5_3) == ' ')
                }
lbl19:
                // 1 sources

                var4_6 = var5_3;
                var7_7 = false;
                while (var4_6 < var2_2.length()) {
                    if (var2_2.charAt(var4_6) == ';') {
                        var7_7 = true;
                        break;
                    }
                    ++var4_6;
                }
                var1_1 = this.insertProperty(var1_1, var2_2.substring(var6_4, var3_5), var2_2.substring(var5_3, var4_6));
                if (!var7_7) break block0;
                var6_4 = var4_6 + 1;
lbl30:
                // 2 sources

            } while (var6_4 < var2_2.length());
        }
        return var1_1;
    }

    private void createStyleElement(Lexer lexer2, Node node) {
        if (lexer2.styles == null && this.niceBody(lexer2, node)) {
            return;
        }
        Node node2 = lexer2.newNode((short)5, null, 0, 0, "style");
        node2.implicit = true;
        AttVal attVal = new AttVal(null, null, 34, "type", "text/css");
        attVal.dict = AttributeTable.getDefaultAttributeTable().findAttribute(attVal);
        node2.attributes = attVal;
        Node node3 = node.findBody(lexer2.configuration.tt);
        lexer2.txtstart = lexer2.lexsize;
        if (node3 != null) {
            this.cleanBodyAttrs(lexer2, node3);
        }
        Style style = lexer2.styles;
        while (style != null) {
            lexer2.addCharToLexer(32);
            lexer2.addStringLiteral(style.tag);
            lexer2.addCharToLexer(46);
            lexer2.addStringLiteral(style.tagClass);
            lexer2.addCharToLexer(32);
            lexer2.addCharToLexer(123);
            lexer2.addStringLiteral(style.properties);
            lexer2.addCharToLexer(125);
            lexer2.addCharToLexer(10);
            style = style.next;
        }
        lexer2.txtend = lexer2.lexsize;
        Node.insertNodeAtEnd(node2, lexer2.newNode((short)4, lexer2.lexbuf, lexer2.txtstart, lexer2.txtend));
        Node node4 = node.findHEAD(lexer2.configuration.tt);
        if (node4 != null) {
            Node.insertNodeAtEnd(node4, node2);
        }
    }

    private Node createStyleProperties(Lexer lexer2, Node node) {
        if (node.content != null) {
            Node node2 = node.content;
            while (node2 != null) {
                node2 = this.createStyleProperties(lexer2, node2);
                node2 = node2.next;
            }
        }
        return this.cleanNode(lexer2, node);
    }

    private void defineStyleRules(Lexer lexer2, Node node) {
        if (node.content != null) {
            Node node2 = node.content;
            while (node2 != null) {
                this.defineStyleRules(lexer2, node2);
                node2 = node2.next;
            }
        }
        this.style2Rule(lexer2, node);
    }

    private boolean dir2Div(Lexer lexer2, Node node, MutableObject mutableObject) {
        if (node.tag == this.tt.tagDir || node.tag == this.tt.tagUl || node.tag == this.tt.tagOl) {
            Node node2 = node.content;
            if (node2 == null) {
                return false;
            }
            if (node2.next != null) {
                return false;
            }
            if (node2.tag != this.tt.tagLi) {
                return false;
            }
            if (!node2.implicit) {
                return false;
            }
            node.tag = this.tt.tagDiv;
            node.element = "div";
            this.addStyleProperty(node, "margin-left: 2em");
            this.stripOnlyChild(node);
            return true;
        }
        return false;
    }

    private void discardContainer(Node node, MutableObject mutableObject) {
        Node node2 = node.parent;
        if (node.content != null) {
            node.last.next = node.next;
            if (node.next != null) {
                node.next.prev = node.last;
                node.last.next = node.next;
            } else {
                node2.last = node.last;
            }
            if (node.prev != null) {
                node.content.prev = node.prev;
                node.prev.next = node.content;
            } else {
                node2.content = node.content;
            }
            Node node3 = node.content;
            while (node3 != null) {
                node3.parent = node2;
                node3 = node3.next;
            }
            mutableObject.setObject(node.content);
        } else {
            if (node.next != null) {
                node.next.prev = node.prev;
            } else {
                node2.last = node.prev;
            }
            if (node.prev != null) {
                node.prev.next = node.next;
            } else {
                node2.content = node.next;
            }
            mutableObject.setObject(node.next);
        }
        node.next = null;
        node.content = null;
    }

    public void dropSections(Lexer lexer2, Node node) {
        while (node != null) {
            if (node.type == 9) {
                if (Lexer.getString(node.textarray, node.start, 2).equals("if")) {
                    node = this.pruneSection(lexer2, node);
                    continue;
                }
                node = Node.discardElement(node);
                continue;
            }
            if (node.content != null) {
                this.dropSections(lexer2, node.content);
            }
            node = node.next;
        }
    }

    public void emFromI(Node node) {
        while (node != null) {
            if (node.tag == this.tt.tagI) {
                node.element = this.tt.tagEm.name;
                node.tag = this.tt.tagEm;
            } else if (node.tag == this.tt.tagB) {
                node.element = this.tt.tagStrong.name;
                node.tag = this.tt.tagStrong;
            }
            if (node.content != null) {
                this.emFromI(node.content);
            }
            node = node.next;
        }
    }

    private String findStyle(Lexer lexer2, String string, String string2) {
        Style style = lexer2.styles;
        while (style != null) {
            if (style.tag.equals(string) && style.properties.equals(string2)) {
                return style.tagClass;
            }
            style = style.next;
        }
        lexer2.styles = style = new Style(string, this.gensymClass(string), string2, lexer2.styles);
        return style.tagClass;
    }

    private void fixNodeLinks(Node node) {
        if (node.prev != null) {
            node.prev.next = node;
        } else {
            node.parent.content = node;
        }
        if (node.next != null) {
            node.next.prev = node;
        } else {
            node.parent.last = node;
        }
        Node node2 = node.content;
        while (node2 != null) {
            node2.parent = node;
            node2 = node2.next;
        }
    }

    private boolean font2Span(Lexer lexer2, Node node, MutableObject mutableObject) {
        if (node.tag == this.tt.tagFont) {
            if (lexer2.configuration.DropFontTags) {
                this.discardContainer(node, mutableObject);
                return false;
            }
            if (node.parent.content == node && node.next == null) {
                return false;
            }
            this.addFontStyles(node, node.attributes);
            AttVal attVal = node.attributes;
            AttVal attVal2 = null;
            while (attVal != null) {
                AttVal attVal3 = attVal.next;
                if (attVal.attribute.equals("style")) {
                    attVal.next = null;
                    attVal2 = attVal;
                }
                attVal = attVal3;
            }
            node.attributes = attVal2;
            node.tag = this.tt.tagSpan;
            node.element = "span";
            return true;
        }
        return false;
    }

    private String fontSize2Name(String string) {
        String[] stringArray = new String[]{"60%", "70%", "80%", null, "120%", "150%", "200%"};
        if (string.length() > 0 && string.charAt(0) >= '0' && string.charAt(0) <= '6') {
            int n = string.charAt(0) - 48;
            return stringArray[n];
        }
        if (string.length() > 0 && string.charAt(0) == '-') {
            if (string.length() > 1 && string.charAt(1) >= '0' && string.charAt(1) <= '6') {
                int n = string.charAt(1) - 48;
                double d = 1.0;
                while (n > 0) {
                    d *= 0.8;
                    --n;
                }
                String string2 = (int)(d *= 100.0) + "%";
                return string2;
            }
            return "smaller";
        }
        if (string.length() > 1 && string.charAt(1) >= '0' && string.charAt(1) <= '6') {
            int n = string.charAt(1) - 48;
            double d = 1.0;
            while (n > 0) {
                d *= 1.2;
                --n;
            }
            String string3 = (int)(d *= 100.0) + "%";
            return string3;
        }
        return "larger";
    }

    private String gensymClass(String string) {
        String string2 = "c" + this.classNum;
        ++this.classNum;
        return string2;
    }

    private boolean inlineStyle(Lexer lexer2, Node node, MutableObject mutableObject) {
        if (node.tag != this.tt.tagFont && (node.tag.model & 0x210) != 0) {
            Node node2 = node.content;
            if (node2 == null) {
                return false;
            }
            if (node2.next != null) {
                return false;
            }
            if (node2.tag == this.tt.tagB && lexer2.configuration.LogicalEmphasis) {
                this.mergeStyles(node, node2);
                this.addStyleProperty(node, "font-weight: bold");
                this.stripOnlyChild(node);
                return true;
            }
            if (node2.tag == this.tt.tagI && lexer2.configuration.LogicalEmphasis) {
                this.mergeStyles(node, node2);
                this.addStyleProperty(node, "font-style: italic");
                this.stripOnlyChild(node);
                return true;
            }
            if (node2.tag == this.tt.tagFont) {
                this.mergeStyles(node, node2);
                this.addFontStyles(node, node2.attributes);
                this.stripOnlyChild(node);
                return true;
            }
        }
        return false;
    }

    private StyleProp insertProperty(StyleProp styleProp, String string, String string2) {
        StyleProp styleProp2 = null;
        StyleProp styleProp3 = styleProp;
        while (styleProp != null) {
            int n = styleProp.name.compareTo(string);
            if (n == 0) {
                return styleProp3;
            }
            if (n > 0) {
                StyleProp styleProp4 = new StyleProp(string, string2, styleProp);
                if (styleProp2 != null) {
                    styleProp2.next = styleProp4;
                } else {
                    styleProp3 = styleProp4;
                }
                return styleProp3;
            }
            styleProp2 = styleProp;
            styleProp = styleProp.next;
        }
        StyleProp styleProp5 = new StyleProp(string, string2);
        if (styleProp2 != null) {
            styleProp2.next = styleProp5;
        } else {
            styleProp3 = styleProp5;
        }
        return styleProp3;
    }

    public boolean isWord2000(Node node, TagTable tagTable) {
        Node node2 = node.findHTML(tagTable);
        return node2 != null && node2.getAttrByName("xmlns:o") != null;
    }

    public void list2BQ(Node node) {
        while (node != null) {
            if (node.content != null) {
                this.list2BQ(node.content);
            }
            if (node.tag != null && node.tag.parser == ParserImpl.getParseList() && node.hasOneChild() && node.content.implicit) {
                this.stripOnlyChild(node);
                node.element = this.tt.tagBlockquote.name;
                node.tag = this.tt.tagBlockquote;
                node.implicit = true;
            }
            node = node.next;
        }
    }

    private boolean mergeDivs(Lexer lexer2, Node node, MutableObject mutableObject) {
        if (node.tag != this.tt.tagDiv) {
            return false;
        }
        Node node2 = node.content;
        if (node2 == null) {
            return false;
        }
        if (node2.tag != this.tt.tagDiv) {
            return false;
        }
        if (node2.next != null) {
            return false;
        }
        this.mergeStyles(node, node2);
        this.stripOnlyChild(node);
        return true;
    }

    private String mergeProperties(String string, String string2) {
        StyleProp styleProp = this.createProps(null, string);
        styleProp = this.createProps(styleProp, string2);
        String string3 = this.createPropString(styleProp);
        return string3;
    }

    private void mergeStyles(Node node, Node node2) {
        String string = null;
        AttVal attVal = node2.attributes;
        while (attVal != null) {
            if (attVal.attribute.equals("style")) {
                string = attVal.value;
                break;
            }
            attVal = attVal.next;
        }
        String string2 = null;
        attVal = node.attributes;
        while (attVal != null) {
            if (attVal.attribute.equals("style")) {
                string2 = attVal.value;
                break;
            }
            attVal = attVal.next;
        }
        if (string2 != null) {
            if (string != null) {
                String string3;
                attVal.value = string3 = this.mergeProperties(string2, string);
            }
        } else if (string != null) {
            attVal = new AttVal(node.attributes, null, 34, "style", string);
            attVal.dict = AttributeTable.getDefaultAttributeTable().findAttribute(attVal);
            node.attributes = attVal;
        }
    }

    public void nestedEmphasis(Node node) {
        MutableObject mutableObject = new MutableObject();
        while (node != null) {
            Node node2 = node.next;
            if ((node.tag == this.tt.tagB || node.tag == this.tt.tagI) && node.parent != null && node.parent.tag == node.tag) {
                mutableObject.setObject(node2);
                this.discardContainer(node, mutableObject);
                node = node2 = (Node)mutableObject.getObject();
                continue;
            }
            if (node.content != null) {
                this.nestedEmphasis(node.content);
            }
            node = node2;
        }
    }

    private boolean nestedList(Lexer lexer2, Node node, MutableObject mutableObject) {
        if (node.tag == this.tt.tagUl || node.tag == this.tt.tagOl) {
            Node node2 = node.content;
            if (node2 == null) {
                return false;
            }
            if (node2.next != null) {
                return false;
            }
            Node node3 = node2.content;
            if (node3 == null) {
                return false;
            }
            if (node3.tag != node.tag) {
                return false;
            }
            mutableObject.setObject(node.next);
            node3.prev = node.prev;
            node3.next = node.next;
            node3.parent = node.parent;
            this.fixNodeLinks(node3);
            node2.content = null;
            node.content = null;
            node.next = null;
            if (node3.prev != null) {
                node = node3;
                node3 = node.prev;
                if (node3.tag == this.tt.tagUl || node3.tag == this.tt.tagOl) {
                    node3.next = node.next;
                    if (node3.next != null) {
                        node3.next.prev = node3;
                    }
                    node.parent = node2 = node3.last;
                    node.next = null;
                    node.prev = node2.last;
                    this.fixNodeLinks(node);
                }
            }
            this.cleanNode(lexer2, node);
            return true;
        }
        return false;
    }

    private boolean niceBody(Lexer lexer2, Node node) {
        Node node2 = node.findBody(lexer2.configuration.tt);
        if (node2 != null && (node2.getAttrByName("background") != null || node2.getAttrByName("bgcolor") != null || node2.getAttrByName("text") != null || node2.getAttrByName("link") != null || node2.getAttrByName("vlink") != null || node2.getAttrByName("alink") != null)) {
            lexer2.badLayout = (short)(lexer2.badLayout | 0x10);
            return false;
        }
        return true;
    }

    private void normalizeSpaces(Lexer lexer2, Node node) {
        while (node != null) {
            if (node.content != null) {
                this.normalizeSpaces(lexer2, node.content);
            }
            if (node.type == 4) {
                MutableInteger mutableInteger = new MutableInteger();
                int n = node.start;
                int n2 = node.start;
                while (n2 < node.end) {
                    mutableInteger.value = node.textarray[n2];
                    if (mutableInteger.value > 127) {
                        n2 += PPrint.getUTF8(node.textarray, n2, mutableInteger);
                    }
                    if (mutableInteger.value == 160) {
                        mutableInteger.value = 32;
                    }
                    n = PPrint.putUTF8(node.textarray, n, mutableInteger.value);
                    ++n2;
                }
            }
            node = node.next;
        }
    }

    public Node pruneSection(Lexer lexer2, Node node) {
        while (true) {
            if ((node = Node.discardElement(node)) == null) {
                return null;
            }
            if (node.type != 9) continue;
            if (Lexer.getString(node.textarray, node.start, 2).equals("if")) {
                node = this.pruneSection(lexer2, node);
                continue;
            }
            if (Lexer.getString(node.textarray, node.start, 5).equals("endif")) break;
        }
        node = Node.discardElement(node);
        return node;
    }

    public void purgeAttributes(Node node) {
        AttVal attVal = node.attributes;
        AttVal attVal2 = null;
        AttVal attVal3 = null;
        while (attVal != null) {
            attVal2 = attVal.next;
            if (attVal.attribute != null && attVal.value != null && attVal.attribute.equals("class") && attVal.value.equals("Code")) {
                attVal3 = attVal;
            } else if (attVal.attribute != null && (attVal.attribute.equals("class") || attVal.attribute.equals("style") || attVal.attribute.equals("lang") || attVal.attribute.startsWith("x:") || (attVal.attribute.equals("height") || attVal.attribute.equals("width")) && (node.tag == this.tt.tagTd || node.tag == this.tt.tagTr || node.tag == this.tt.tagTh))) {
                if (attVal3 != null) {
                    attVal3.next = attVal2;
                } else {
                    node.attributes = attVal2;
                }
            } else {
                attVal3 = attVal;
            }
            attVal = attVal2;
        }
    }

    private void stripOnlyChild(Node node) {
        Node node2 = node.content;
        node.content = node2.content;
        node.last = node2.last;
        node2.content = null;
        node2 = node.content;
        while (node2 != null) {
            node2.parent = node;
            node2 = node2.next;
        }
    }

    public Node stripSpan(Lexer lexer2, Node node) {
        Node node2;
        Node node3 = null;
        this.cleanWord2000(lexer2, node.content);
        Node node4 = node.content;
        if (node.prev != null) {
            node3 = node.prev;
        } else if (node4 != null) {
            node2 = node4;
            node4 = node4.next;
            Node.removeNode(node2);
            Node.insertNodeBeforeElement(node, node2);
            node3 = node2;
        }
        while (node4 != null) {
            node2 = node4;
            node4 = node4.next;
            Node.removeNode(node2);
            Node.insertNodeAfterElement(node3, node2);
            node3 = node2;
        }
        if (node.next == null) {
            node.parent.last = node3;
        }
        node2 = node.next;
        node.content = null;
        Node.discardElement(node);
        return node2;
    }

    private void style2Rule(Lexer lexer2, Node node) {
        AttVal attVal = node.getAttrByName("style");
        if (attVal != null) {
            String string = this.findStyle(lexer2, node.element, attVal.value);
            AttVal attVal2 = node.getAttrByName("class");
            if (attVal2 != null) {
                attVal2.value = String.valueOf(attVal2.value) + " " + string;
                node.removeAttribute(attVal);
            } else {
                attVal.attribute = "class";
                attVal.value = string;
            }
        }
    }

    private void textAlign(Lexer lexer2, Node node) {
        AttVal attVal = null;
        AttVal attVal2 = node.attributes;
        while (attVal2 != null) {
            if (attVal2.attribute.equals("align")) {
                if (attVal != null) {
                    attVal.next = attVal2.next;
                } else {
                    node.attributes = attVal2.next;
                }
                if (attVal2.value == null) break;
                this.addAlign(node, attVal2.value);
                break;
            }
            attVal = attVal2;
            attVal2 = attVal2.next;
        }
    }
}

