/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.parser;

import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.namespace.QName;
import net.jangaroo.exml.api.ExmlcException;
import net.jangaroo.exml.compiler.Exmlc;
import net.jangaroo.exml.model.ConfigAttribute;
import net.jangaroo.exml.model.ConfigClass;
import net.jangaroo.exml.model.ConfigClassType;
import net.jangaroo.exml.model.Constant;
import net.jangaroo.utils.CharacterRecordingHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class ExmlMetadataHandler
extends CharacterRecordingHandler {
    private static final Map<String, ConfigClassType> EXML_ROOT_NODE_TO_CONFIG_CLASS_TYPE = Collections.unmodifiableMap(new HashMap<String, ConfigClassType>(){
        {
            this.put("component", ConfigClassType.XTYPE);
            this.put("plugin", ConfigClassType.PTYPE);
            this.put("layout", ConfigClassType.TYPE);
            this.put("gridColumn", ConfigClassType.GCTYPE);
        }
    });
    private ConfigClass configClass;
    private Locator locator;
    private Deque<QName> elementPath = new LinkedList<QName>();

    public ExmlMetadataHandler(ConfigClass configClass) {
        this.configClass = configClass;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (Exmlc.isExmlNamespace(uri)) {
            if (Exmlc.EXML_ROOT_NODE_NAMES.contains(localName)) {
                this.configClass.setType(EXML_ROOT_NODE_TO_CONFIG_CLASS_TYPE.get(localName));
            } else if ("cfg".equals(localName)) {
                ConfigAttribute cfg = new ConfigAttribute(atts.getValue("name"), atts.getValue("type"), null);
                if (this.configClass.contains(cfg)) throw new ExmlcException("Config '" + cfg.getName() + "' already defined.", this.locator.getLineNumber(), this.locator.getColumnNumber());
                this.configClass.addCfg(cfg);
            } else if ("description".equals(localName)) {
                if (this.isLastInPathExmlClass() || this.isLastInPathConfig() || this.isLastInPathConstant()) {
                    this.startRecordingCharacters();
                }
            } else if ("constant".equals(localName)) {
                Constant constant = new Constant(atts.getValue("name"), atts.getValue("value"));
                if (this.configClass.getConstants().contains(constant)) throw new ExmlcException("Constant '" + constant.getName() + "' already defined.", this.locator.getLineNumber(), this.locator.getColumnNumber());
                this.configClass.addConstant(constant);
            }
        } else if (this.elementPath.size() == 1) {
            if (this.configClass.getSuperClassName() != null) {
                throw new ExmlcException("root node of EXML contained more than one component definition", this.locator.getLineNumber(), this.locator.getColumnNumber());
            }
            String thePackage = Exmlc.parsePackageFromNamespace(uri);
            if (thePackage == null) {
                throw new ExmlcException("namespace '" + uri + "' of superclass element in EXML file does not denote a config package", this.locator.getLineNumber(), this.locator.getColumnNumber());
            }
            this.configClass.setSuperClassName(thePackage + "." + localName);
        }
        this.elementPath.push(new QName(uri, localName));
    }

    private boolean isLastInPathExmlClass() {
        QName parent = this.elementPath.peek();
        return Exmlc.isExmlNamespace(parent.getNamespaceURI()) && Exmlc.EXML_ROOT_NODE_NAMES.contains(parent.getLocalPart());
    }

    private boolean isLastInPathConfig() {
        QName parent = this.elementPath.peek();
        return Exmlc.isExmlNamespace(parent.getNamespaceURI()) && "cfg".equals(parent.getLocalPart());
    }

    private boolean isLastInPathConstant() {
        QName parent = this.elementPath.peek();
        return Exmlc.isExmlNamespace(parent.getNamespaceURI()) && "constant".equals(parent.getLocalPart());
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (Exmlc.isExmlNamespace(uri)) {
            String characters;
            this.elementPath.pop();
            if ("description".equals(localName) && (characters = this.popRecordedCharacters()) != null) {
                if (this.isLastInPathConfig()) {
                    this.configClass.getCfgs().get(this.configClass.getCfgs().size() - 1).setDescription(characters.trim());
                } else if (this.isLastInPathExmlClass()) {
                    this.configClass.setDescription(characters.trim());
                } else if (this.isLastInPathConstant()) {
                    this.configClass.getConstants().get(this.configClass.getConstants().size() - 1).setDescription(characters.trim());
                }
            }
        }
    }
}

