/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.BlockStatement;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.FunctionDeclaration;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.NodeImplBase;
import net.jangaroo.jooc.ast.Parameter;
import net.jangaroo.jooc.ast.Parameters;
import net.jangaroo.jooc.ast.Type;
import net.jangaroo.jooc.ast.TypeRelation;
import net.jangaroo.jooc.ast.VariableDeclaration;
import net.jangaroo.utils.AS3Type;

public class FunctionExpr
extends Expr {
    public static final Ide ARGUMENTS_IDE = new Ide(new JooSymbol("arguments"));
    public static final Type ANY_TYPE = new Type(new JooSymbol(50, "", -1, -1, "", AS3Type.ANY.toString()));
    private JooSymbol symFunction;
    private Ide ide;
    private JooSymbol lParen;
    private TypeRelation optTypeRelation;
    private Parameters params;
    private JooSymbol rParen;
    private BlockStatement optBody;
    private List<Parameter> implicitParams = new LinkedList<Parameter>();
    private FunctionDeclaration functionDeclaration;
    private boolean thisDefined = false;
    private IdeDeclaration classDeclaration;

    public FunctionExpr(FunctionDeclaration functionDeclaration, JooSymbol symFunction, Ide ide, JooSymbol lParen, Parameters params, JooSymbol rParen, TypeRelation optTypeRelation, BlockStatement optBody) {
        this.functionDeclaration = functionDeclaration;
        this.ide = ide;
        this.optTypeRelation = optTypeRelation;
        this.symFunction = symFunction;
        this.lParen = lParen;
        this.params = params;
        this.rParen = rParen;
        this.optBody = optBody;
        this.implicitParams.add(new Parameter(null, ARGUMENTS_IDE, null, null));
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return this.makeChildren(super.getChildren(), this.functionDeclaration, this.ide, this.params, this.optTypeRelation, this.optBody);
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitFunctionExpr(this);
    }

    public FunctionDeclaration getFunctionDeclaration() {
        return this.functionDeclaration;
    }

    public Parameters getParams() {
        return this.params;
    }

    public BlockStatement getBody() {
        return this.optBody;
    }

    @Override
    public JooSymbol getSymbol() {
        return this.symFunction;
    }

    public IdeDeclaration getClassDeclaration() {
        return this.classDeclaration;
    }

    @Override
    public void scope(Scope scope) {
        this.classDeclaration = scope.getClassDeclaration();
        if (!this.thisDefined) {
            this.addImplicitParam(new Parameter(null, new Ide("this"), new TypeRelation(null, ANY_TYPE), null));
        }
        this.withNewDeclarationScope(this.functionDeclaration == null ? this : this.functionDeclaration, scope, new NodeImplBase.Scoped(){

            @Override
            public void run(Scope scope) {
                if (!(FunctionExpr.this.functionDeclaration != null && FunctionExpr.this.functionDeclaration.isMethod() || FunctionExpr.this.ide == null || FunctionExpr.this.ide.getScope() != null)) {
                    VariableDeclaration decl = new VariableDeclaration(null, FunctionExpr.this.ide, null, null);
                    ((IdeDeclaration)decl).scope(scope);
                }
                FunctionExpr.this.scope(FunctionExpr.this.implicitParams, scope);
                FunctionExpr.this.withNewDeclarationScope(FunctionExpr.this, scope, new NodeImplBase.Scoped(){

                    @Override
                    public void run(Scope scope) {
                        if (FunctionExpr.this.params != null) {
                            FunctionExpr.this.params.scope(scope);
                        }
                        if (FunctionExpr.this.optTypeRelation != null) {
                            FunctionExpr.this.optTypeRelation.scope(scope);
                        }
                        if (FunctionExpr.this.optBody != null) {
                            FunctionExpr.this.optBody.scope(scope);
                        }
                    }
                });
            }
        });
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        if (this.params != null) {
            this.params.analyze(this);
        }
        if (this.optTypeRelation != null) {
            this.optTypeRelation.analyze(this);
        }
        if (this.optBody != null) {
            this.optBody.analyze(this);
        }
    }

    public void addImplicitParam(Parameter parameter) {
        this.implicitParams.add(parameter);
        this.thisDefined = this.thisDefined || parameter.getIde().getName().equals("this");
    }

    public boolean hasBody() {
        return this.getBody() != null;
    }

    public Ide getIde() {
        return this.ide;
    }

    public JooSymbol getSymFunction() {
        return this.symFunction;
    }

    public JooSymbol getLParen() {
        return this.lParen;
    }

    public TypeRelation getOptTypeRelation() {
        return this.optTypeRelation;
    }

    public JooSymbol getRParen() {
        return this.rParen;
    }

    public JooSymbol getFunSymbol() {
        return this.symFunction;
    }

    boolean notifyThisUsed(Scope scope) {
        FunctionDeclaration methodDeclaration;
        if (!(this.functionDeclaration != null && this.functionDeclaration.isClassMember() || (methodDeclaration = scope.getMethodDeclaration()) == null || methodDeclaration.isStatic())) {
            methodDeclaration.aliasThis();
            return true;
        }
        return false;
    }
}

