/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.api;

import java.io.File;
import net.jangaroo.jooc.api.FilePosition;

public final class ExmlcException
extends RuntimeException
implements FilePosition {
    private File file;
    private int line = 0;
    private int column = -1;

    public ExmlcException(String message) {
        super(message);
    }

    public ExmlcException(String message, int line) {
        this(message);
        this.line = line;
    }

    public ExmlcException(String message, int line, int column) {
        this(message, line);
        this.column = column;
    }

    public ExmlcException(String message, Throwable t) {
        super(message, t);
        if (t instanceof ExmlcException) {
            ExmlcException exmlcException = (ExmlcException)t;
            this.file = exmlcException.getFile();
            this.line = exmlcException.getLine();
            this.column = exmlcException.getColumn();
        }
    }

    public ExmlcException(String message, File file, Exception e) {
        this(message, e);
        this.file = file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public File getFile() {
        return this.file;
    }

    public String getFileName() {
        return this.file == null ? null : this.file.getAbsolutePath();
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.file != null) {
            builder.append('[');
            builder.append(this.file);
            if (this.line > 0) {
                builder.append(":");
                builder.append(this.line);
                if (this.column != -1) {
                    builder.append(";");
                    builder.append(this.column);
                }
            }
            builder.append("] ");
        }
        builder.append(super.toString());
        return builder.toString();
    }
}

