/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.utils;

import java.io.IOException;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.jangaroo.utils.CompilerUtils;

public class ExmlUtils {
    public static String parsePackageFromNamespace(String uri) {
        return uri.startsWith("exml:") ? uri.substring("exml:".length()) : null;
    }

    public static boolean isExmlNamespace(String uri) {
        return "http://www.jangaroo.net/exml/0.8".equals(uri);
    }

    public static boolean isCodeExpression(String attributeValue) {
        return CompilerUtils.isCodeExpression((String)attributeValue);
    }

    public static String getCodeExpression(String attributeValue) {
        return CompilerUtils.getCodeExpression((String)attributeValue);
    }

    public static void addImport(Set<String> imports, String importedClassName) {
        if (importedClassName != null && importedClassName.contains(".")) {
            imports.add(importedClassName);
        }
    }

    public static String createComponentClassName(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static Set<ZipEntry> findXsdJarEntries(ZipFile jarFile) throws IOException {
        Enumeration<? extends ZipEntry> enumeration = jarFile.entries();
        LinkedHashSet<ZipEntry> result = new LinkedHashSet<ZipEntry>();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || zipEntry.getName().indexOf(47) != -1 || !zipEntry.getName().endsWith(".xsd")) continue;
            result.add(zipEntry);
        }
        return result;
    }
}

