/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.config;

import java.io.File;
import java.io.IOException;
import net.jangaroo.utils.CompilerUtils;
import net.jangaroo.utils.FileLocations;
import org.kohsuke.args4j.Option;

public class ExmlConfiguration
extends FileLocations {
    private String configClassPackage;
    private File resourceOutputDirectory;

    public String getConfigClassPackage() {
        return this.configClassPackage;
    }

    @Option(name="-c", aliases={"--config-package"}, metaVar="NAME", usage="Name of the config class package", required=true)
    public void setConfigClassPackage(String configClassPackage) {
        this.configClassPackage = configClassPackage;
    }

    public File getResourceOutputDirectory() {
        return this.resourceOutputDirectory;
    }

    @Option(name="-r", metaVar="RES_DIR", usage="output directory for generated xsd files, default is DEST_DIR")
    public void setResourceOutputDirectory(File resourceOutputDirectory) {
        this.resourceOutputDirectory = resourceOutputDirectory;
    }

    public File computeConfigClassTarget(String configClassName) {
        return CompilerUtils.fileFromQName((String)this.getConfigClassPackage(), (String)configClassName, (File)this.getOutputDirectory(), (String)".as");
    }

    public File computeGeneratedConfigClassFile(File exmlFile) {
        return this.computeConfigClassTarget(CompilerUtils.uncapitalize((String)CompilerUtils.removeExtension((String)exmlFile.getName())));
    }

    public File computeGeneratedComponentClassFile(File exmlFile) throws IOException {
        String qName = CompilerUtils.qNameFromFile((File)this.findSourceDir(exmlFile), (File)exmlFile);
        return CompilerUtils.fileFromQName((String)qName, (File)this.getOutputDirectory(), (String)".as");
    }

    public String toString() {
        return "ExmlConfiguration{configClassPackage='" + this.configClassPackage + '\'' + '}' + super.toString();
    }
}

