/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.jdbc.conn;

import com.alibaba.druid.pool.DruidDataSource;
import java.sql.SQLException;
import javax.sql.DataSource;
import net.jahhan.jdbc.conn.DataSourceWrapper;
import net.jahhan.jdbc.conn.PoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DruidDataSourceWrapper
extends DataSourceWrapper {
    private static final Logger log = LoggerFactory.getLogger(DruidDataSourceWrapper.class);

    public DruidDataSourceWrapper(PoolConfig conf, boolean readOnly, int type) {
        super(conf, readOnly, type);
    }

    protected DataSource createDataPool(PoolConfig conf) {
        if (!conf.isValid()) {
            throw new RuntimeException("\u6570\u636e\u5e93\u9a71\u52a8\u4e3a\u7a7a\u6216\u8005\u6570\u636e\u5e93\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u6216\u8005\u8fde\u63a5\u5b57\u7b26\u4e32\u4e3a\u7a7a");
        }
        log.info("db config:{}", (Object)conf.toString());
        DruidDataSource cpds = new DruidDataSource();
        cpds.setUrl(conf.jdbcUrl);
        cpds.setUsername(conf.userName);
        cpds.setPassword(conf.password);
        cpds.setDriverClassName(conf.driverClass);
        cpds.setValidationQueryTimeout(60);
        try {
            cpds.setFilters("stat");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (conf.initialPoolSize != null && !conf.initialPoolSize.isEmpty()) {
            cpds.setInitialSize(Integer.parseInt(conf.initialPoolSize));
        }
        if (conf.maxPoolSize != null && !conf.maxPoolSize.isEmpty()) {
            cpds.setMaxActive(Integer.parseInt(conf.maxPoolSize));
        }
        if (conf.minPoolSize != null && !conf.minPoolSize.isEmpty()) {
            cpds.setMinIdle(Integer.parseInt(conf.minPoolSize));
        }
        if (conf.unreturnedConnectionTimeout != null && !conf.unreturnedConnectionTimeout.isEmpty()) {
            cpds.setLogAbandoned(true);
            cpds.setRemoveAbandonedTimeout(Integer.parseInt(conf.unreturnedConnectionTimeout));
        } else {
            cpds.setLogAbandoned(false);
        }
        return cpds;
    }

    public void close() throws SQLException {
        ((DruidDataSourceWrapper)((Object)this.dataSource)).close();
    }

    public String getStatus() throws SQLException {
        StringBuilder sb = new StringBuilder(20);
        sb.append(this.url);
        return sb.toString();
    }

    public void reset() {
        ((DruidDataSource)this.dataSource).resetStat();
    }
}

