/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.extension.dataSourcePoolInit;

import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.inject.Singleton;
import net.jahhan.common.extension.annotation.Extension;
import net.jahhan.jdbc.conn.DataSourceConnectionPool;
import net.jahhan.jdbc.conn.DataSourcePool;
import net.jahhan.jdbc.conn.DataSourceWrapper;
import net.jahhan.jdbc.conn.DruidDataSourceWrapper;
import net.jahhan.jdbc.conn.PoolConfig;
import net.jahhan.jdbc.constant.enumeration.DBConnectLevel;

@Singleton
@Extension(value="druid")
public class DruidDataSourcePool
extends DataSourcePool {
    public void initDataSource(String dataSource, Properties property) throws PropertyVetoException {
        DataSourceConnectionPool dataSourceConnectionPool = (DataSourceConnectionPool)this.dataSourceConnectionMap.get(dataSource);
        PoolConfig batch = dataSourceConnectionPool.createBatchConf(property);
        batch.jdbcUrl = batch.jdbcUrl.contains("?") ? batch.jdbcUrl + "&rewriteBatchedStatements=true" : batch.jdbcUrl + "?rewriteBatchedStatements=true";
        dataSourceConnectionPool.setBatchDS((DataSourceWrapper)new DruidDataSourceWrapper(batch, false, DBConnectLevel.BATCH.getLevel()));
        PoolConfig write = dataSourceConnectionPool.createWriteConf(property);
        dataSourceConnectionPool.setWriteDS((DataSourceWrapper)new DruidDataSourceWrapper(write, false, DBConnectLevel.WRITE.getLevel()));
        PoolConfig hold = dataSourceConnectionPool.createHoldConf(property);
        dataSourceConnectionPool.setHoldDS((DataSourceWrapper)new DruidDataSourceWrapper(hold, false, DBConnectLevel.WRITE.getLevel()));
        List readConfs = dataSourceConnectionPool.createReadConfs(property);
        ArrayList<DruidDataSourceWrapper> readDSList = new ArrayList<DruidDataSourceWrapper>();
        for (PoolConfig conf : readConfs) {
            DruidDataSourceWrapper ds = new DruidDataSourceWrapper(conf, true, DBConnectLevel.READ.getLevel());
            for (int i = 0; i < conf.weight; ++i) {
                readDSList.add(ds);
            }
        }
        dataSourceConnectionPool.setReadDSList(readDSList);
    }
}

