/*
 * Decompiled with CFR 0.152.
 */
package net.jahhan.extension.protocol;

import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.rpc.ServiceClassHolder;
import com.alibaba.dubbo.rpc.protocol.AbstractProxyProtocol;
import com.alibaba.dubbo.rpc.protocol.rest.RestServer;
import com.alibaba.dubbo.rpc.protocol.rest.RestServerFactory;
import com.frameworkx.annotation.Adaptive;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletContext;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import net.jahhan.common.extension.annotation.Extension;
import net.jahhan.common.extension.utils.ClassScaner;
import net.jahhan.common.extension.utils.PackageUtil;
import net.jahhan.common.extension.utils.StringUtils;
import net.jahhan.context.Node;
import net.jahhan.exception.JahhanException;
import net.jahhan.spi.HttpBinder;
import org.apache.http.HeaderElement;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;
import org.jboss.resteasy.util.GetRestful;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension(value="rest")
@Singleton
public class RestProtocol
extends AbstractProxyProtocol {
    private static final Logger log = LoggerFactory.getLogger(RestProtocol.class);
    private static final int DEFAULT_PORT = 80;
    private final Map<String, RestServer> servers = new ConcurrentHashMap<String, RestServer>();
    private final RestServerFactory serverFactory = new RestServerFactory();
    private final List<ResteasyClient> clients = Collections.synchronizedList(new LinkedList());
    private volatile ConnectionMonitor connectionMonitor;
    @Inject
    @Adaptive
    private HttpBinder httpBinder;

    public RestProtocol() {
        super(new Class[]{WebApplicationException.class, ProcessingException.class});
    }

    public int getDefaultPort() {
        return 80;
    }

    protected <T> Runnable doExport(T impl, Class<T> type, URL url) throws JahhanException {
        String addr = url.getIp() + ":" + url.getPort();
        Class<T> implClass = ServiceClassHolder.getInstance().popServiceClass();
        RestServer server = this.servers.get(addr);
        if (server == null) {
            this.serverFactory.setHttpBinder(this.httpBinder);
            server = this.serverFactory.createServer(url.getParameter("server", "jetty"));
            server.start(url);
            this.servers.put(addr, server);
        }
        String contextPath = this.getContextPath(url);
        if ("servlet".equalsIgnoreCase(url.getParameter("server", "jetty"))) {
            ServletContext servletContext = Node.getInstance().getServletContext(url.getPort());
            if (servletContext == null) {
                throw new JahhanException("No servlet context found. Since you are using server='servlet', make sure that you've configured in web.xml");
            }
            String webappPath = servletContext.getContextPath();
            if (StringUtils.isNotEmpty((String)webappPath)) {
                if (!contextPath.startsWith(webappPath = webappPath.substring(1))) {
                    throw new JahhanException("Since you are using server='servlet', make sure that the 'contextpath' property starts with the path of external webapp");
                }
                if ((contextPath = contextPath.substring(webappPath.length())).startsWith("/")) {
                    contextPath = contextPath.substring(1);
                }
            }
        }
        final Class<T> resourceDef = GetRestful.getRootResourceClass((Class)implClass) != null ? implClass : type;
        server.deploy(resourceDef, impl, contextPath);
        final RestServer s = server;
        return new Runnable(){

            @Override
            public void run() {
                s.undeploy(resourceDef);
            }
        };
    }

    protected <T> T doRefer(Class<T> serviceType, URL url) throws JahhanException {
        if (this.connectionMonitor == null) {
            this.connectionMonitor = new ConnectionMonitor();
        }
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager();
        connectionManager.setMaxTotal(url.getParameter("connections", 20));
        connectionManager.setDefaultMaxPerRoute(url.getParameter("connections", 20));
        this.connectionMonitor.addConnectionManager((ClientConnectionManager)connectionManager);
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)connectionManager);
        httpClient.setKeepAliveStrategy(new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
                while (it.hasNext()) {
                    HeaderElement he = it.nextElement();
                    String param = he.getName();
                    String value = he.getValue();
                    if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                    return Long.parseLong(value) * 1000L;
                }
                return 30000L;
            }
        });
        HttpParams params = httpClient.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)url.getParameter("timeout", 1000));
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)url.getParameter("timeout", 1000));
        HttpConnectionParams.setTcpNoDelay((HttpParams)params, (boolean)true);
        HttpConnectionParams.setSoKeepalive((HttpParams)params, (boolean)true);
        ApacheHttpClient4Engine engine = new ApacheHttpClient4Engine((HttpClient)httpClient);
        ResteasyClient client = new ResteasyClientBuilder().httpEngine((ClientHttpEngine)engine).build();
        this.clients.add(client);
        String[] packages = PackageUtil.packages((String[])new String[]{"rest.filter"});
        List classNameList = new ClassScaner().parse(packages);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        for (String className : classNameList) {
            if (!className.endsWith("Filter")) continue;
            try {
                Class<?> clazz = classLoader.loadClass(className);
                client.register(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        for (String clazz : Constants.COMMA_SPLIT_PATTERN.split(url.getParameter("extension", ""))) {
            if (StringUtils.isEmpty((String)clazz)) continue;
            try {
                client.register(Thread.currentThread().getContextClassLoader().loadClass(clazz.trim()));
            }
            catch (ClassNotFoundException e) {
                throw new JahhanException("Error loading JAX-RS extension class: " + clazz.trim(), (Throwable)e);
            }
        }
        ResteasyWebTarget target = client.target("http://" + url.getHost() + ":" + url.getPort() + "/" + this.getContextPath(url));
        return (T)target.proxy(serviceType);
    }

    protected int getErrorCode(Throwable e) {
        return super.getErrorCode(e);
    }

    public void destroy() {
        super.destroy();
        if (this.connectionMonitor != null) {
            this.connectionMonitor.shutdown();
        }
        for (Map.Entry<String, RestServer> entry : this.servers.entrySet()) {
            try {
                if (log.isInfoEnabled()) {
                    log.info("Closing the rest server at " + entry.getKey());
                }
                entry.getValue().stop();
            }
            catch (Throwable t) {
                log.warn("Error closing rest server", t);
            }
        }
        this.servers.clear();
        if (log.isInfoEnabled()) {
            log.info("Closing rest clients");
        }
        for (ResteasyClient client : this.clients) {
            try {
                client.close();
            }
            catch (Throwable t) {
                log.warn("Error closing rest client", t);
            }
        }
        this.clients.clear();
    }

    protected String getContextPath(URL url) {
        int pos = url.getPath().lastIndexOf("/");
        return pos > 0 ? url.getPath().substring(0, pos) : "";
    }

    protected class ConnectionMonitor
    extends Thread {
        private volatile boolean shutdown;
        private final List<ClientConnectionManager> connectionManagers = Collections.synchronizedList(new LinkedList());

        protected ConnectionMonitor() {
        }

        public void addConnectionManager(ClientConnectionManager connectionManager) {
            this.connectionManagers.add(connectionManager);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    ConnectionMonitor connectionMonitor = this;
                    synchronized (connectionMonitor) {
                        this.wait(1000L);
                        for (ClientConnectionManager connectionManager : this.connectionManagers) {
                            connectionManager.closeExpiredConnections();
                            connectionManager.closeIdleConnections(30L, TimeUnit.SECONDS);
                        }
                    }
                }
                return;
            }
            catch (InterruptedException ex) {
                this.shutdown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            this.connectionManagers.clear();
            ConnectionMonitor connectionMonitor = this;
            synchronized (connectionMonitor) {
                this.notifyAll();
            }
        }
    }
}

