/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.protocol.rest;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.remoting.http.HttpHandler;
import com.alibaba.dubbo.remoting.http.HttpServer;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.protocol.rest.BaseRestServer;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jahhan.context.Node;
import net.jahhan.exception.JahhanException;
import net.jahhan.spi.HttpBinder;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.jboss.resteasy.spi.ResteasyDeployment;

public class DubboHttpServer
extends BaseRestServer {
    private final HttpServletDispatcher dispatcher = new HttpServletDispatcher();
    private final ResteasyDeployment deployment = new ResteasyDeployment();
    private HttpBinder httpBinder;
    private HttpServer httpServer;

    public DubboHttpServer(HttpBinder httpBinder) {
        this.httpBinder = httpBinder;
    }

    @Override
    protected void doStart(URL url) {
        this.httpServer = this.httpBinder.bind(url, (HttpHandler)new RestHandler());
        ServletContext servletContext = Node.getInstance().getServletContext(url.getPort());
        if (servletContext == null) {
            throw new JahhanException("No servlet context found. If you are using server='servlet', make sure that you've configured  in web.xml");
        }
        servletContext.setAttribute(ResteasyDeployment.class.getName(), (Object)this.deployment);
        try {
            this.dispatcher.init((ServletConfig)new SimpleServletConfig(servletContext));
        }
        catch (ServletException e) {
            throw new JahhanException((Throwable)e);
        }
    }

    @Override
    public void stop() {
        this.httpServer.close();
    }

    @Override
    protected ResteasyDeployment getDeployment() {
        return this.deployment;
    }

    private static class SimpleServletConfig
    implements ServletConfig {
        private final ServletContext servletContext;

        public SimpleServletConfig(ServletContext servletContext) {
            this.servletContext = servletContext;
        }

        public String getServletName() {
            return "DispatcherServlet";
        }

        public ServletContext getServletContext() {
            return this.servletContext;
        }

        public String getInitParameter(String s) {
            return null;
        }

        public Enumeration getInitParameterNames() {
            return new Enumeration(){

                @Override
                public boolean hasMoreElements() {
                    return false;
                }

                public Object nextElement() {
                    return null;
                }
            };
        }
    }

    private class RestHandler
    implements HttpHandler {
        private RestHandler() {
        }

        public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            RpcContext.getContext().setRemoteAddress(request.getRemoteAddr(), request.getRemotePort());
            DubboHttpServer.this.dispatcher.service((ServletRequest)request, (ServletResponse)response);
        }
    }
}

